/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableMap;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import java.math.BigDecimal;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSqlToRowExpressionTranslator {
    @Test
    @Timeout(value=10L)
    public void testPossibleExponentialOptimizationTime() {
        Constant expression = new Constant((Type)BigintType.BIGINT, (Object)1L);
        for (int i = 0; i < 100; ++i) {
            expression = new Coalesce((Expression)expression, (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L), new Expression[0]);
        }
        this.translateAndOptimize((Expression)expression);
    }

    @Test
    public void testOptimizeDecimalLiteral() {
        Assertions.assertThat((Object)this.translateAndOptimize((Expression)new Constant((Type)DecimalType.createDecimalType((int)7, (int)2), null))).isEqualTo((Object)Expressions.constant(null, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assertions.assertThat((Object)this.translateAndOptimize((Expression)new Constant((Type)DecimalType.createDecimalType((int)2), (Object)Decimals.valueOf((long)42L)))).isEqualTo((Object)Expressions.constant((Object)42L, (Type)DecimalType.createDecimalType((int)2, (int)0)));
        Assertions.assertThat((Object)this.translateAndOptimize(this.simplifyExpression((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)42L), (Type)DecimalType.createDecimalType((int)7, (int)2))))).isEqualTo((Object)Expressions.constant((Object)4200L, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assertions.assertThat((Object)this.translateAndOptimize((Expression)new Constant((Type)DecimalType.createDecimalType((int)35, (int)2), null))).isEqualTo((Object)Expressions.constant(null, (Type)DecimalType.createDecimalType((int)35, (int)2)));
        Assertions.assertThat((Object)this.translateAndOptimize((Expression)new Constant((Type)DecimalType.createDecimalType((int)30), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("123456789012345678901234567890"))))).isEqualTo((Object)Expressions.constant((Object)Decimals.valueOf((BigDecimal)new BigDecimal("123456789012345678901234567890")), (Type)DecimalType.createDecimalType((int)30, (int)0)));
        Assertions.assertThat((Object)this.translateAndOptimize(this.simplifyExpression((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)30), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("123456789012345678901234567890"))), (Type)DecimalType.createDecimalType((int)35, (int)2))))).isEqualTo((Object)Expressions.constant((Object)Decimals.valueOf((BigDecimal)new BigDecimal("123456789012345678901234567890.00")), (Type)DecimalType.createDecimalType((int)35, (int)2)));
    }

    private RowExpression translateAndOptimize(Expression expression) {
        return SqlToRowExpressionTranslator.translate((Expression)expression, (Map)ImmutableMap.of(), (Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (TypeManager)TestingPlannerContext.PLANNER_CONTEXT.getTypeManager());
    }

    private Expression simplifyExpression(Expression expression) {
        return new IrExpressionInterpreter(expression, TestingPlannerContext.PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION).optimize();
    }
}

