/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.ColorType;
import io.trino.type.LikePattern;
import io.trino.type.LikePatternType;
import io.trino.type.Reals;
import io.trino.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDomainTranslator {
    private static final Symbol C_BIGINT = new Symbol((Type)BigintType.BIGINT, "c_bigint");
    private static final Symbol C_DOUBLE = new Symbol((Type)DoubleType.DOUBLE, "c_double");
    private static final Symbol C_VARCHAR = new Symbol((Type)VarcharType.VARCHAR, "c_varchar");
    private static final Symbol C_BOOLEAN = new Symbol((Type)BooleanType.BOOLEAN, "c_boolean");
    private static final Symbol C_BIGINT_1 = new Symbol((Type)BigintType.BIGINT, "c_bigint_1");
    private static final Symbol C_DOUBLE_1 = new Symbol((Type)DoubleType.DOUBLE, "c_double_1");
    private static final Symbol C_VARCHAR_1 = new Symbol((Type)VarcharType.VARCHAR, "c_varchar_1");
    private static final Symbol C_BOOLEAN_1 = new Symbol((Type)BooleanType.BOOLEAN, "c_boolean_1");
    private static final Symbol C_TIMESTAMP = new Symbol((Type)TimestampType.createTimestampType((int)3), "c_timestamp");
    private static final Symbol C_DATE = new Symbol((Type)DateType.DATE, "c_date");
    private static final Symbol C_COLOR = new Symbol((Type)ColorType.COLOR, "c_color");
    private static final Symbol C_HYPER_LOG_LOG = new Symbol((Type)HyperLogLogType.HYPER_LOG_LOG, "c_hyper_log_log");
    private static final Symbol C_INTEGER = new Symbol((Type)IntegerType.INTEGER, "c_integer");
    private static final Symbol C_INTEGER_1 = new Symbol((Type)IntegerType.INTEGER, "c_integer_1");
    private static final Symbol C_CHAR = new Symbol((Type)CharType.createCharType((int)10), "c_char");
    private static final Symbol C_DECIMAL_21_3 = new Symbol((Type)DecimalType.createDecimalType((int)21, (int)3), "c_decimal_21_3");
    private static final Symbol C_DECIMAL_21_3_1 = new Symbol((Type)DecimalType.createDecimalType((int)21, (int)3), "c_decimal_21_3_1");
    private static final Symbol C_DECIMAL_12_2 = new Symbol((Type)DecimalType.createDecimalType((int)12, (int)2), "c_decimal_12_2");
    private static final Symbol C_DECIMAL_6_1 = new Symbol((Type)DecimalType.createDecimalType((int)6, (int)1), "c_decimal_6_1");
    private static final Symbol C_DECIMAL_6_1_1 = new Symbol((Type)DecimalType.createDecimalType((int)6, (int)1), "c_decimal_6_1_1");
    private static final Symbol C_SMALLINT = new Symbol((Type)SmallintType.SMALLINT, "c_smallint");
    private static final Symbol C_TINYINT = new Symbol((Type)TinyintType.TINYINT, "c_tinyint");
    private static final Symbol C_REAL = new Symbol((Type)RealType.REAL, "c_real");
    private static final Symbol C_REAL_1 = new Symbol((Type)RealType.REAL, "c_real_1");
    private static final long TIMESTAMP_VALUE = new DateTime(2013, 3, 30, 1, 5, 0, 0, DateTimeZone.UTC).getMillis();
    private static final long DATE_VALUE = TimeUnit.MILLISECONDS.toDays(new DateTime(2001, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC).getMillis());
    private static final long COLOR_VALUE_1 = 1L;
    private static final long COLOR_VALUE_2 = 2L;
    private TestingFunctionResolution functionResolution;

    @BeforeAll
    public void setup() {
        this.functionResolution = new TestingFunctionResolution();
    }

    @AfterAll
    public void tearDown() {
        this.functionResolution = null;
    }

    @Test
    public void testNoneRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.none();
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<Symbol>)tupleDomain));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)Booleans.TRUE);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo((Object)tupleDomain);
    }

    @Test
    public void testAllRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.all();
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<Symbol>)tupleDomain));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)Booleans.TRUE);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo((Object)tupleDomain);
    }

    @Test
    public void testRoundTrip() {
        TupleDomain tupleDomain = TestDomainTranslator.tupleDomain(ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)true)).put((Object)C_BIGINT_1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)C_DOUBLE_1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)1.1), (Range[])new Range[]{Range.equal((Type)DoubleType.DOUBLE, (Object)2.0), Range.range((Type)DoubleType.DOUBLE, (Object)3.0, (boolean)false, (Object)3.5, (boolean)true)}), (boolean)true)).put((Object)C_VARCHAR_1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-01-01")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-10-01"))}), (boolean)false)).put((Object)C_TIMESTAMP, (Object)Domain.singleValue((Type)TimestampType.TIMESTAMP_MILLIS, (Object)TIMESTAMP_VALUE)).put((Object)C_DATE, (Object)Domain.singleValue((Type)DateType.DATE, (Object)DATE_VALUE)).put((Object)C_COLOR, (Object)Domain.singleValue((Type)ColorType.COLOR, (Object)1L)).put((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)).buildOrThrow());
        this.assertPredicateTranslates(this.toPredicate(tupleDomain), tupleDomain);
    }

    @Test
    public void testInOptimization() {
        Domain testDomain = Domain.create((ValueSet)ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)})), (boolean)false);
        TupleDomain<Symbol> tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, testDomain);
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))), (boolean)false);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, testDomain);
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(4L)), TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)5L, (boolean)true, (Object)7L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)true)}), (boolean)false);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, testDomain);
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), (Expression)TestDomainTranslator.bigintLiteral(3L)), TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L), (Expression)TestDomainTranslator.bigintLiteral(7L)), TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(9L), (Expression)TestDomainTranslator.bigintLiteral(11L))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))).union(ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)true, (Object)9L, (boolean)true), (Range[])new Range[0])), (boolean)false);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, testDomain);
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(4L)), TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}), TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(7L), (Expression)TestDomainTranslator.bigintLiteral(9L))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))).union(ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)false, (Object)9L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)11L, (boolean)false, (Object)13L, (boolean)false)})), (boolean)false);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, testDomain);
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(4L)), TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(7L)), TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(9L))}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(11L)), TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(13L))})}));
    }

    @Test
    public void testToPredicateNone() {
        TupleDomain tupleDomain = TestDomainTranslator.tupleDomain(ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.none((Type)BooleanType.BOOLEAN)).buildOrThrow());
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)Booleans.FALSE);
    }

    @Test
    public void testToPredicateAllIgnored() {
        TupleDomain tupleDomain = TestDomainTranslator.tupleDomain(ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.all((Type)BooleanType.BOOLEAN)).buildOrThrow());
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate(tupleDomain));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)Booleans.TRUE);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).buildOrThrow()));
    }

    @Test
    public void testToPredicate() {
        TupleDomain<Symbol> tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.isNotNull(C_BIGINT));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.onlyNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.isNull(C_BIGINT));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)Booleans.FALSE);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.all((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)Booleans.TRUE);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(0L)), TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.singleValue((Type)BigintType.BIGINT, (Object)1L));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.isNull(C_BIGINT), TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)true));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.isNull(C_COLOR), TestDomainTranslator.equal(C_COLOR, this.colorLiteral(1L))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.isNull(C_COLOR), TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_COLOR, this.colorLiteral(1L)))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.isNull(C_HYPER_LOG_LOG));
        tupleDomain = TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.isNotNull(C_HYPER_LOG_LOG));
    }

    @Test
    public void testToPredicateWithRangeOptimisation() {
        TupleDomain<Symbol> tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)1L)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.notEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)false), Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)0L, (Object)1L))));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)false), Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.notEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(0L))}), TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_REAL, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)RealType.REAL, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)RealType.REAL, (Object)0L)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral(0.0f)), TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral(0.0f))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_REAL, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)RealType.REAL, (Object)0L), (Range[])new Range[]{Range.range((Type)RealType.REAL, (Object)0L, (boolean)false, (Object)Reals.toReal((float)1.0f), (boolean)false), Range.greaterThan((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f))}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral(0.0f)), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral(0.0f)), TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral(1.0f))}), TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral(1.0f))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_REAL, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)RealType.REAL, (Object)0L), (Range[])new Range[]{Range.range((Type)RealType.REAL, (Object)0L, (boolean)false, (Object)Reals.toReal((float)1.0f), (boolean)false), Range.greaterThan((Type)RealType.REAL, (Object)Reals.toReal((float)2.0f))}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral(1.0f)), TestDomainTranslator.notEqual(C_REAL, TestDomainTranslator.realLiteral(0.0f))}), TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral(2.0f))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[]{Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)false, (Object)1.0, (boolean)false), Range.range((Type)DoubleType.DOUBLE, (Object)2.0, (boolean)false, (Object)3.0, (boolean)false), Range.greaterThan((Type)DoubleType.DOUBLE, (Object)3.0)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(1.0)), TestDomainTranslator.notEqual(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(0.0))}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.notEqual(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(3.0))})}));
    }

    @Test
    public void testFromUnknownPredicate() {
        this.assertUnsupportedPredicate(TestDomainTranslator.unprocessableExpression1(C_BIGINT));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(TestDomainTranslator.unprocessableExpression1(C_BIGINT)));
    }

    @Test
    public void testFromAndPredicate() {
        Expression originalPredicate = IrUtils.and((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        DomainTranslator.ExtractionResult result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}));
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]), (boolean)false)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})})));
        originalPredicate = TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
    }

    @Test
    public void testFromOrPredicate() {
        Expression originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        DomainTranslator.ExtractionResult result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(20L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(10L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.all((Type)BigintType.BIGINT), (boolean)false)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)TestDomainTranslator.unprocessableExpression1(C_BIGINT));
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        this.assertUnsupportedPredicate(IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})}));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.lessThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(5.0))});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral(2.0f)), TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral(5.0f)), TestDomainTranslator.isNull(C_REAL)});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo((Object)TupleDomain.all());
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.unprocessableExpression1(C_DOUBLE)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(5.0)), TestDomainTranslator.unprocessableExpression1(C_DOUBLE)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral(2.0f)), TestDomainTranslator.unprocessableExpression1(C_REAL)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral(5.0f)), TestDomainTranslator.unprocessableExpression1(C_REAL)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(1.0)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)TestDomainTranslator.unprocessableExpression1(C_BIGINT));
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false), C_DOUBLE, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)1.0), (Range[])new Range[0]), (boolean)false)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), this.randPredicate(C_BIGINT, (Type)BigintType.BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), this.randPredicate(C_BIGINT, (Type)BigintType.BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        originalPredicate = TestDomainTranslator.not(IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})}));
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        Assertions.assertThat((boolean)result.getTupleDomain().isAll()).isTrue();
        originalPredicate = TestDomainTranslator.not(IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}));
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]), (boolean)false)));
    }

    @Test
    public void testFromSingleBooleanReference() {
        Reference originalPredicate = C_BOOLEAN.toSymbolReference();
        DomainTranslator.ExtractionResult result = this.fromPredicate((Expression)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BOOLEAN, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[0]), (boolean)false)));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)Booleans.TRUE);
        originalPredicate = TestDomainTranslator.not((Expression)C_BOOLEAN.toSymbolReference());
        result = this.fromPredicate((Expression)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BOOLEAN, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[0]).complement(), (boolean)false)));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)Booleans.TRUE);
        originalPredicate = IrUtils.and((Expression[])new Expression[]{C_BOOLEAN.toSymbolReference(), C_BOOLEAN_1.toSymbolReference()});
        result = this.fromPredicate((Expression)originalPredicate);
        Domain domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[0]), (boolean)false);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BOOLEAN, domain, C_BOOLEAN_1, domain));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)Booleans.TRUE);
        originalPredicate = IrUtils.or((Expression[])new Expression[]{C_BOOLEAN.toSymbolReference(), C_BOOLEAN_1.toSymbolReference()});
        result = this.fromPredicate((Expression)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo((Object)TupleDomain.all());
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        originalPredicate = TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{C_BOOLEAN.toSymbolReference(), C_BOOLEAN_1.toSymbolReference()}));
        result = this.fromPredicate((Expression)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo((Object)TupleDomain.all());
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
    }

    @Test
    public void testFromNotPredicate() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(TestDomainTranslator.unprocessableExpression1(C_BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)Booleans.TRUE));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}), (boolean)false)));
    }

    @Test
    public void testFromUnprocessableComparison() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT))));
    }

    @Test
    public void testFromBasicComparisons() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.equal(C_COLOR, this.colorLiteral(1L)), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, this.colorLiteral(1L)), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_COLOR, this.colorLiteral(1L))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L)))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}).complement(), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, this.colorLiteral(1L))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false)));
    }

    @Test
    public void testFromFlippedBasicComparisons() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.LESS_THAN, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.EQUAL, this.colorLiteral(1L), (Expression)C_COLOR.toSymbolReference()), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.NOT_EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.NOT_EQUAL, this.colorLiteral(1L), (Expression)C_COLOR.toSymbolReference()), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.IS_DISTINCT_FROM, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.IS_DISTINCT_FROM, this.colorLiteral(1L), (Expression)C_COLOR.toSymbolReference()), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.IS_DISTINCT_FROM, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
    }

    @Test
    public void testFromBasicComparisonsWithNulls() {
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_VARCHAR, TestDomainTranslator.nullLiteral((Type)VarcharType.VARCHAR)), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.none((Type)VarcharType.VARCHAR), (boolean)false)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.notEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.notEqual(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR)), TestDomainTranslator.tupleDomain(C_COLOR, Domain.notNull((Type)ColorType.COLOR)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.onlyNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.onlyNull((Type)ColorType.COLOR)));
    }

    @Test
    public void testFromBasicComparisonsWithNaN() {
        Constant nanDouble = new Constant((Type)DoubleType.DOUBLE, (Object)Double.NaN);
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(C_DOUBLE, (Expression)nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThanOrEqual(C_DOUBLE, (Expression)nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThan(C_DOUBLE, (Expression)nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThanOrEqual(C_DOUBLE, (Expression)nanDouble));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(C_DOUBLE, (Expression)nanDouble), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.isDistinctFrom(C_DOUBLE, (Expression)nanDouble));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_DOUBLE, (Expression)nanDouble)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)nanDouble)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(C_DOUBLE, (Expression)nanDouble)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(C_DOUBLE, (Expression)nanDouble)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(C_DOUBLE, (Expression)nanDouble)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_DOUBLE, (Expression)nanDouble)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_DOUBLE, (Expression)nanDouble)));
        Constant nanReal = new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.NaN));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(C_REAL, (Expression)nanReal));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThan(C_REAL, (Expression)nanReal));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThanOrEqual(C_REAL, (Expression)nanReal));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThan(C_REAL, (Expression)nanReal));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThanOrEqual(C_REAL, (Expression)nanReal));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(C_REAL, (Expression)nanReal), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.isDistinctFrom(C_REAL, (Expression)nanReal));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_REAL, (Expression)nanReal)), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_REAL, (Expression)nanReal)), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(C_REAL, (Expression)nanReal)), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(C_REAL, (Expression)nanReal)), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(C_REAL, (Expression)nanReal)), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_REAL, (Expression)nanReal)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_REAL, (Expression)nanReal)));
    }

    @Test
    public void testFromCoercionComparisonsWithNaN() {
        Constant nanDouble = new Constant((Type)DoubleType.DOUBLE, (Object)Double.NaN);
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_TINYINT, (Type)DoubleType.DOUBLE), (Expression)nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_SMALLINT, (Type)DoubleType.DOUBLE), (Expression)nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)nanDouble));
    }

    @Test
    public void testNonImplicitCastOnSymbolSide() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_TIMESTAMP, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DATE_VALUE)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_DECIMAL_12_2, (Type)BigintType.BIGINT), (Expression)TestDomainTranslator.bigintLiteral(135L)));
    }

    @Test
    public void testNoSaturatedFloorCastFromUnsupportedApproximateDomain() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_DECIMAL_12_2, (Type)DoubleType.DOUBLE), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)12345.56)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_BIGINT, (Type)DoubleType.DOUBLE), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)12345.56)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_BIGINT, (Type)RealType.REAL), (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)12345.56f))));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)RealType.REAL), (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)12345.56f))));
    }

    @Test
    public void testPredicateWithVarcharCastToDate() {
        this.assertPredicateDerives((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-9-10"))), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-10"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-09-11"), (boolean)false), Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-10"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-11"), (boolean)false), Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)));
        this.assertPredicateDerives((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-09-09"))), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-09"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-09-0:"), (boolean)false), Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-9"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-09-:"), (boolean)false), Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-09"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-0:"), (boolean)false), Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-9"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-:"), (boolean)false), Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)));
        this.assertPredicateDerives((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-09-19"))), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-19"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-09-1:"), (boolean)false), Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-19"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-1:"), (boolean)false), Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)));
        this.assertPredicateDerives((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-9-10"))), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-10")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-11"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-10"), (boolean)false), Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-11"))}), (boolean)false)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-9-2"))));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-09-09"))));
        this.assertPredicateDerives((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-09-19"))), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-19")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-1:"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-19"), (boolean)false), Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-1:"))}), (boolean)false)));
        this.assertPredicateDerives((Expression)TestDomainTranslator.lessThan(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-9-10"))), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2006")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)));
        this.assertPredicateDerives((Expression)TestDomainTranslator.greaterThan(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-9-10"))), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2004"))}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2001-01-31")), TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE)), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2002")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)), (Expression)TestDomainTranslator.greaterThan((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2001-01-31")), TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.between(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2001-01-31")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-09-10"))), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2000"), (boolean)false, (Object)Slices.utf8Slice((String)"2006"), (boolean)false), Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThanOrEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2001-01-31"))), TestDomainTranslator.lessThanOrEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2005-09-10")))}));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.between((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2001-01-31")), TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), TestDomainTranslator.cast(C_VARCHAR_1, (Type)DateType.DATE)), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2002")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false), C_VARCHAR_1, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2000"))}), (boolean)false)), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThanOrEqual((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2001-01-31")), TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE)), TestDomainTranslator.lessThanOrEqual((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2001-01-31")), TestDomainTranslator.cast(C_VARCHAR_1, (Type)DateType.DATE))}));
    }

    @Test
    public void testFromUnprocessableInPredicate() {
        this.assertUnsupportedPredicate((Expression)new In(TestDomainTranslator.unprocessableExpression1(C_BIGINT), (List)ImmutableList.of((Object)Booleans.TRUE)));
        this.assertUnsupportedPredicate((Expression)new In((Expression)C_BOOLEAN.toSymbolReference(), (List)ImmutableList.of((Object)TestDomainTranslator.unprocessableExpression1(C_BOOLEAN))));
        this.assertUnsupportedPredicate((Expression)new In((Expression)C_BOOLEAN.toSymbolReference(), (List)ImmutableList.of((Object)Booleans.TRUE, (Object)TestDomainTranslator.unprocessableExpression1(C_BOOLEAN))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)new In((Expression)C_BOOLEAN.toSymbolReference(), (List)ImmutableList.of((Object)TestDomainTranslator.unprocessableExpression1(C_BOOLEAN)))), TestDomainTranslator.tupleDomain(C_BOOLEAN, Domain.notNull((Type)BooleanType.BOOLEAN)), (Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BOOLEAN, TestDomainTranslator.unprocessableExpression1(C_BOOLEAN))));
    }

    @Test
    public void testInPredicateWithBoolean() {
        this.testInPredicate(C_BOOLEAN, C_BOOLEAN_1, (Type)BooleanType.BOOLEAN, false, true);
    }

    @Test
    public void testInPredicateWithInteger() {
        this.testInPredicate(C_INTEGER, C_INTEGER_1, (Type)IntegerType.INTEGER, 1L, 2L);
    }

    @Test
    public void testInPredicateWithBigint() {
        this.testInPredicate(C_BIGINT, C_BIGINT_1, (Type)BigintType.BIGINT, 1L, 2L);
    }

    @Test
    public void testInPredicateWithReal() {
        this.testInPredicateWithFloatingPoint(C_REAL, C_REAL_1, (Type)RealType.REAL, Reals.toReal((float)1.0f), Reals.toReal((float)2.0f), Reals.toReal((float)Float.NaN));
    }

    @Test
    public void testInPredicateWithDouble() {
        this.testInPredicateWithFloatingPoint(C_DOUBLE, C_DOUBLE_1, (Type)DoubleType.DOUBLE, 1.0, 2.0, Double.NaN);
    }

    @Test
    public void testInPredicateWithShortDecimal() {
        this.testInPredicate(C_DECIMAL_6_1, C_DECIMAL_6_1_1, (Type)DecimalType.createDecimalType((int)6, (int)1), 10L, 20L);
    }

    @Test
    public void testInPredicateWithLongDecimal() {
        this.testInPredicate(C_DECIMAL_21_3, C_DECIMAL_21_3_1, (Type)DecimalType.createDecimalType((int)21, (int)3), Decimals.encodeScaledValue((BigDecimal)BigDecimal.ONE, (int)3), Decimals.encodeScaledValue((BigDecimal)BigDecimal.TWO, (int)3));
    }

    @Test
    public void testInPredicateWithVarchar() {
        this.testInPredicate(C_VARCHAR, C_VARCHAR_1, (Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"first"), Slices.utf8Slice((String)"second"));
    }

    private void testInPredicate(Symbol symbol, Symbol symbol2, Type type, Object one, Object two) {
        Constant oneExpression = new Constant(type, one);
        Constant twoExpression = new Constant(type, two);
        Constant nullExpression = new Constant(type, null);
        Reference otherSymbol = symbol2.toSymbolReference();
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.singleValue((Type)type, (Object)one)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, twoExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertPredicateIsAlwaysFalse((Expression)this.in(symbol, List.of(nullExpression)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, nullExpression, twoExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(otherSymbol)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nullExpression)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)one), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)one)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, twoExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)one), (Range[])new Range[]{Range.range((Type)type, (Object)one, (boolean)false, (Object)two, (boolean)false), Range.greaterThan((Type)type, (Object)two)}), (boolean)false)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(nullExpression))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, nullExpression, twoExpression))), (TupleDomain<Symbol>)TupleDomain.none(), (Expression)Booleans.TRUE);
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(otherSymbol))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(symbol, (Expression)otherSymbol)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)one), (Range[])new Range[]{Range.range((Type)type, (Object)one, (boolean)false, (Object)two, (boolean)false), Range.greaterThan((Type)type, (Object)two)}), (boolean)false)), (Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(symbol, (Expression)otherSymbol)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nullExpression))));
    }

    private void testInPredicateWithFloatingPoint(Symbol symbol, Symbol symbol2, Type type, Object one, Object two, Object nan) {
        Constant oneExpression = new Constant(type, one);
        Constant twoExpression = new Constant(type, two);
        Constant nanExpression = new Constant(type, nan);
        Constant nullExpression = new Constant(type, null);
        Reference otherSymbol = symbol2.toSymbolReference();
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.singleValue((Type)type, (Object)one)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, twoExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertPredicateIsAlwaysFalse((Expression)this.in(symbol, List.of(nullExpression)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, nullExpression, twoExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertPredicateIsAlwaysFalse((Expression)this.in(symbol, List.of(nanExpression)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, nanExpression, twoExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertPredicateIsAlwaysFalse((Expression)this.in(symbol, List.of(nanExpression, nullExpression)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, nanExpression, twoExpression, nullExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(otherSymbol)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nanExpression)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nullExpression)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, nanExpression, twoExpression, nullExpression)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(symbol, (Expression)oneExpression)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, twoExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, twoExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(nullExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, nullExpression, twoExpression))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(nanExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, nanExpression, twoExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, twoExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(nanExpression, nullExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, nanExpression, twoExpression, nullExpression))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(otherSymbol))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(symbol, (Expression)otherSymbol)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nanExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nullExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, nanExpression, twoExpression, nullExpression))));
    }

    @Test
    public void testInPredicateWithEquitableType() {
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)this.colorLiteral(1L))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.singleValue((Type)ColorType.COLOR, (Object)1L)));
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L)))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}).complement(), (boolean)false)));
    }

    @Test
    public void testFromInPredicateWithCastsAndNulls() {
        this.assertPredicateIsAlwaysFalse((Expression)new In((Expression)C_BIGINT.toSymbolReference(), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null))));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)new In(TestDomainTranslator.cast(C_SMALLINT, (Type)BigintType.BIGINT), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)))));
    }

    @Test
    public void testFromBetweenPredicate() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
    }

    @Test
    public void testFromIsNullPredicate() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isNull(C_BIGINT), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.onlyNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isNull(C_HYPER_LOG_LOG), TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isNull(C_BIGINT)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isNull(C_HYPER_LOG_LOG)), TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
    }

    @Test
    public void testFromIsNotNullPredicate() {
        this.assertPredicateTranslates(TestDomainTranslator.isNotNull(C_BIGINT), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates(TestDomainTranslator.isNotNull(C_HYPER_LOG_LOG), TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not(TestDomainTranslator.isNotNull(C_BIGINT)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.onlyNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not(TestDomainTranslator.isNotNull(C_HYPER_LOG_LOG)), TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
    }

    @Test
    public void testFromBooleanLiteralPredicate() {
        this.assertPredicateIsAlwaysTrue((Expression)Booleans.TRUE);
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)Booleans.TRUE));
        this.assertPredicateIsAlwaysFalse((Expression)Booleans.FALSE);
        this.assertPredicateIsAlwaysTrue((Expression)TestDomainTranslator.not((Expression)Booleans.FALSE));
    }

    @Test
    public void testFromNullLiteralPredicate() {
        this.assertPredicateIsAlwaysFalse(TestDomainTranslator.nullLiteral((Type)BooleanType.BOOLEAN));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not(TestDomainTranslator.nullLiteral((Type)BooleanType.BOOLEAN)));
    }

    @Test
    public void testConjunctExpression() {
        Expression expression = IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, (Expression)C_DOUBLE.toSymbolReference(), (Expression)TestDomainTranslator.doubleLiteral(0.0)), TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, (Expression)C_BIGINT.toSymbolReference(), (Expression)TestDomainTranslator.bigintLiteral(0L))});
        this.assertPredicateTranslates(expression, TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)false), C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)false)));
        Assertions.assertThat((Object)this.toPredicate((TupleDomain<Symbol>)this.fromPredicate(expression).getTupleDomain())).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, (Expression)C_BIGINT.toSymbolReference(), (Expression)TestDomainTranslator.bigintLiteral(0L)), TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, (Expression)C_DOUBLE.toSymbolReference(), (Expression)TestDomainTranslator.doubleLiteral(0.0))}));
    }

    @Test
    public void testMultipleCoercionsOnSymbolSide() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, TestDomainTranslator.cast(TestDomainTranslator.cast(C_SMALLINT, (Type)RealType.REAL), (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(3.7)), TestDomainTranslator.tupleDomain(C_SMALLINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)SmallintType.SMALLINT, (Object)3L), (Range[])new Range[0]), (boolean)false)));
    }

    @Test
    public void testLikePredicate() {
        VarcharType varcharType = VarcharType.createUnboundedVarcharType();
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc"), C_VARCHAR, Domain.multipleValues((Type)varcharType, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"abc"))));
        this.assertUnsupportedPredicate((Expression)this.like(C_VARCHAR, "_def"));
        this.assertUnsupportedPredicate((Expression)this.like(C_VARCHAR, "%def"));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc_def"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc_def"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc"), (boolean)true, (Object)Slices.utf8Slice((String)"abd"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\_def"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc\\_def"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc\\"), (boolean)true, (Object)Slices.utf8Slice((String)"abc]"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\_def", Character.valueOf('\\')), C_VARCHAR, Domain.multipleValues((Type)varcharType, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"abc_def"))));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\_def_", Character.valueOf('\\')), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc\\_def_", Character.valueOf('\\')), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc_def"), (boolean)true, (Object)Slices.utf8Slice((String)"abc_deg"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc^_def_", Character.valueOf('^')), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc^_def_", Character.valueOf('^')), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc_def"), (boolean)true, (Object)Slices.utf8Slice((String)"abc_deg"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc%"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc%"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc"), (boolean)true, (Object)Slices.utf8Slice((String)"abd"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc%def"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc%def"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc"), (boolean)true, (Object)Slices.utf8Slice((String)"abd"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\%def"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc\\%def"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc\\"), (boolean)true, (Object)Slices.utf8Slice((String)"abc]"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\%def", Character.valueOf('\\')), C_VARCHAR, Domain.multipleValues((Type)varcharType, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"abc%def"))));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\%def_", Character.valueOf('\\')), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc\\%def_", Character.valueOf('\\')), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc%def"), (boolean)true, (Object)Slices.utf8Slice((String)"abc%deg"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc^%def_", Character.valueOf('^')), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc^%def_", Character.valueOf('^')), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc%def"), (boolean)true, (Object)Slices.utf8Slice((String)"abc%deg"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\u007f\u0123\udbfe"), C_VARCHAR, Domain.multipleValues((Type)varcharType, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"abc\u007f\u0123\udbfe"))));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0%"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0%"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0"), (boolean)true, (Object)Slices.utf8Slice((String)"abc\u0123\ud83d\ude80def\u007f"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.assertUnsupportedPredicate((Expression)this.like(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc\\_def"), (Expression)C_VARCHAR_1.toSymbolReference()));
        this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)this.like(C_VARCHAR, "abcdef")), C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)varcharType, (Object)Slices.utf8Slice((String)"abcdef")), (Range[])new Range[]{Range.greaterThan((Type)varcharType, (Object)Slices.utf8Slice((String)"abcdef"))}), (boolean)false));
        this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)this.like(C_VARCHAR, "abc\\_def", Character.valueOf('\\'))), C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)varcharType, (Object)Slices.utf8Slice((String)"abc_def")), (Range[])new Range[]{Range.greaterThan((Type)varcharType, (Object)Slices.utf8Slice((String)"abc_def"))}), (boolean)false));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)this.like(C_VARCHAR, "abc\\_def")));
    }

    @Test
    public void testStartsWithFunction() {
        VarcharType varcharType = VarcharType.createUnboundedVarcharType();
        this.testSimpleComparison((Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc")), C_VARCHAR, (Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc")), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc"), (boolean)true, (Object)Slices.utf8Slice((String)"abd"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("_abc")), C_VARCHAR, (Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("_abc")), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"_abc"), (boolean)true, (Object)Slices.utf8Slice((String)"_abd"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.assertUnsupportedPredicate((Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("")));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc"))));
        this.testSimpleComparison((Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0")), C_VARCHAR, (Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0")), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0"), (boolean)true, (Object)Slices.utf8Slice((String)"abc\u0123\ud83d\ude80def\u007f"), (boolean)false), (Range[])new Range[0]), (boolean)false));
    }

    @Test
    public void testUnsupportedFunctions() {
        this.assertUnsupportedPredicate((Expression)new Call(this.functionResolution.resolveFunction("length", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})), (List)ImmutableList.of((Object)C_VARCHAR.toSymbolReference())));
        this.assertUnsupportedPredicate((Expression)new Call(this.functionResolution.resolveFunction("replace", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})), (List)ImmutableList.of((Object)C_VARCHAR.toSymbolReference(), (Object)TestDomainTranslator.stringLiteral("abc"))));
    }

    @Test
    public void testCharComparedToVarcharExpression() {
        CharType charType = CharType.createCharType((int)10);
        this.testSimpleComparison((Expression)TestDomainTranslator.equal(C_CHAR, (Expression)new Constant((Type)charType, (Object)Slices.utf8Slice((String)"abc"))), C_CHAR, Range.equal((Type)charType, (Object)Slices.utf8Slice((String)"abc")));
        charType = CharType.createCharType((int)11);
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_CHAR, (Type)charType), TestDomainTranslator.cast((Expression)TestDomainTranslator.stringLiteral("abc12345678"), (Type)charType)));
    }

    private void assertPredicateIsAlwaysTrue(Expression expression) {
        this.assertPredicateTranslates(expression, (TupleDomain<Symbol>)TupleDomain.all(), (Expression)Booleans.TRUE);
    }

    private void assertPredicateIsAlwaysFalse(Expression expression) {
        this.assertPredicateTranslates(expression, (TupleDomain<Symbol>)TupleDomain.none(), (Expression)Booleans.TRUE);
    }

    private void assertUnsupportedPredicate(Expression expression) {
        this.assertPredicateTranslates(expression, (TupleDomain<Symbol>)TupleDomain.all(), expression);
    }

    private void assertPredicateTranslates(Expression expression, TupleDomain<Symbol> tupleDomain) {
        this.assertPredicateTranslates(expression, tupleDomain, (Expression)Booleans.TRUE);
    }

    private void assertPredicateDerives(Expression expression, TupleDomain<Symbol> tupleDomain) {
        this.assertPredicateTranslates(expression, tupleDomain, expression);
    }

    private void assertPredicateTranslates(Expression expression, TupleDomain<Symbol> tupleDomain, Expression remainingExpression) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(tupleDomain);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)remainingExpression);
    }

    private void assertNoFullPushdown(Expression expression) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assertions.assertThat((Object)result.getRemainingExpression()).isNotEqualTo((Object)Booleans.TRUE);
    }

    private DomainTranslator.ExtractionResult fromPredicate(Expression originalPredicate) {
        return DomainTranslator.getExtractionResult((PlannerContext)this.functionResolution.getPlannerContext(), (Session)SessionTestUtils.TEST_SESSION, (Expression)originalPredicate);
    }

    private Expression toPredicate(TupleDomain<Symbol> tupleDomain) {
        return DomainTranslator.toPredicate(tupleDomain);
    }

    private static Expression unprocessableExpression1(Symbol symbol) {
        return TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, (Expression)symbol.toSymbolReference(), (Expression)symbol.toSymbolReference());
    }

    private static Expression unprocessableExpression2(Symbol symbol) {
        return TestDomainTranslator.comparison(Comparison.Operator.LESS_THAN, (Expression)symbol.toSymbolReference(), (Expression)symbol.toSymbolReference());
    }

    private Expression randPredicate(Symbol symbol, Type type) {
        Call rand = this.functionResolution.functionCallBuilder("rand").build();
        return TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, (Expression)symbol.toSymbolReference(), TestDomainTranslator.cast((Expression)rand, type));
    }

    private static Comparison equal(Symbol symbol, Expression expression) {
        return TestDomainTranslator.equal((Expression)symbol.toSymbolReference(), expression);
    }

    private static Comparison notEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.notEqual((Expression)symbol.toSymbolReference(), expression);
    }

    private static Comparison greaterThan(Symbol symbol, Expression expression) {
        return TestDomainTranslator.greaterThan((Expression)symbol.toSymbolReference(), expression);
    }

    private static Comparison greaterThanOrEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.greaterThanOrEqual((Expression)symbol.toSymbolReference(), expression);
    }

    private static Comparison lessThan(Symbol symbol, Expression expression) {
        return TestDomainTranslator.lessThan((Expression)symbol.toSymbolReference(), expression);
    }

    private static Comparison lessThanOrEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.lessThanOrEqual((Expression)symbol.toSymbolReference(), expression);
    }

    private static Comparison isDistinctFrom(Symbol symbol, Expression expression) {
        return TestDomainTranslator.isDistinctFrom((Expression)symbol.toSymbolReference(), expression);
    }

    private Call like(Symbol symbol, String pattern) {
        return new Call(this.functionResolution.resolveFunction("$like", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, LikePatternType.LIKE_PATTERN})), (List)ImmutableList.of((Object)symbol.toSymbolReference(), (Object)new Constant((Type)LikePatternType.LIKE_PATTERN, (Object)LikePattern.compile((String)pattern, Optional.empty()))));
    }

    private Call like(Symbol symbol, Expression pattern, Expression escape) {
        Call likePattern = new Call(this.functionResolution.resolveFunction("$like_pattern", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})), (List)ImmutableList.of((Object)pattern, (Object)escape));
        return new Call(this.functionResolution.resolveFunction("$like", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, LikePatternType.LIKE_PATTERN})), (List)ImmutableList.of((Object)symbol.toSymbolReference(), (Object)likePattern));
    }

    private Call like(Symbol symbol, String pattern, Character escape) {
        return new Call(this.functionResolution.resolveFunction("$like", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, LikePatternType.LIKE_PATTERN})), (List)ImmutableList.of((Object)symbol.toSymbolReference(), (Object)new Constant((Type)LikePatternType.LIKE_PATTERN, (Object)LikePattern.compile((String)pattern, Optional.of(escape)))));
    }

    private Call startsWith(Symbol symbol, Expression expression) {
        return new Call(this.functionResolution.resolveFunction("starts_with", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})), (List)ImmutableList.of((Object)symbol.toSymbolReference(), (Object)expression));
    }

    private static Expression isNotNull(Symbol symbol) {
        return TestDomainTranslator.isNotNull((Expression)symbol.toSymbolReference());
    }

    private static IsNull isNull(Symbol symbol) {
        return new IsNull((Expression)symbol.toSymbolReference());
    }

    private In in(Symbol symbol, List<?> values) {
        return this.in((Expression)symbol.toSymbolReference(), symbol.type(), values);
    }

    private static Between between(Symbol symbol, Expression min, Expression max) {
        return new Between((Expression)symbol.toSymbolReference(), min, max);
    }

    private static Expression isNotNull(Expression expression) {
        return new Not((Expression)new IsNull(expression));
    }

    private In in(Expression expression, Type type, List<?> values) {
        return new In(expression, (List)values.stream().map(value -> {
            Constant constant;
            if (value instanceof Expression) {
                Expression valueExpression = (Expression)value;
                constant = valueExpression;
            } else {
                constant = new Constant(type, value);
            }
            return constant;
        }).collect(ImmutableList.toImmutableList()));
    }

    private static Between between(Expression expression, Expression min, Expression max) {
        return new Between(expression, min, max);
    }

    private static Comparison equal(Expression left, Expression right) {
        return TestDomainTranslator.comparison(Comparison.Operator.EQUAL, left, right);
    }

    private static Comparison notEqual(Expression left, Expression right) {
        return TestDomainTranslator.comparison(Comparison.Operator.NOT_EQUAL, left, right);
    }

    private static Comparison greaterThan(Expression left, Expression right) {
        return TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN, left, right);
    }

    private static Comparison greaterThanOrEqual(Expression left, Expression right) {
        return TestDomainTranslator.comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, left, right);
    }

    private static Comparison lessThan(Expression left, Expression expression) {
        return TestDomainTranslator.comparison(Comparison.Operator.LESS_THAN, left, expression);
    }

    private static Comparison lessThanOrEqual(Expression left, Expression right) {
        return TestDomainTranslator.comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, left, right);
    }

    private static Comparison isDistinctFrom(Expression left, Expression right) {
        return TestDomainTranslator.comparison(Comparison.Operator.IS_DISTINCT_FROM, left, right);
    }

    private static Not not(Expression expression) {
        return new Not(expression);
    }

    private static Comparison comparison(Comparison.Operator operator, Expression expression1, Expression expression2) {
        return new Comparison(operator, expression1, expression2);
    }

    private static Constant bigintLiteral(long value) {
        return new Constant((Type)BigintType.BIGINT, (Object)value);
    }

    private static Constant doubleLiteral(double value) {
        return new Constant((Type)DoubleType.DOUBLE, (Object)value);
    }

    private static Expression realLiteral(float value) {
        return new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)value));
    }

    private static Constant stringLiteral(String value) {
        return new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)value));
    }

    private static Expression nullLiteral(Type type) {
        return new Constant(type, null);
    }

    private static Expression cast(Symbol symbol, Type type) {
        return TestDomainTranslator.cast((Expression)symbol.toSymbolReference(), type);
    }

    private static Expression cast(Expression expression, Type type) {
        return new Cast(expression, type);
    }

    private Expression colorLiteral(long value) {
        return new Constant((Type)ColorType.COLOR, (Object)value);
    }

    private void testSimpleComparison(Expression expression, Symbol symbol, Range expectedDomainRange) {
        this.testSimpleComparison(expression, symbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)expectedDomainRange, (Range[])new Range[0]), (boolean)false));
    }

    private void testSimpleComparison(Expression expression, Symbol symbol, Domain expectedDomain) {
        this.testSimpleComparison(expression, symbol, (Expression)Booleans.TRUE, expectedDomain);
    }

    private void testSimpleComparison(Expression expression, Symbol symbol, Expression expectedRemainingExpression, Domain expectedDomain) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)expectedRemainingExpression);
        TupleDomain actual = result.getTupleDomain();
        TupleDomain<Symbol> expected = TestDomainTranslator.tupleDomain(symbol, expectedDomain);
        if (!actual.equals(expected)) {
            Fail.fail((String)String.format("for comparison [%s] expected [%s] but found [%s]", expression.toString(), expected.toString(TestingConnectorSession.SESSION), actual.toString(TestingConnectorSession.SESSION)));
        }
    }

    private static <T> TupleDomain<T> tupleDomain(T key, Domain domain) {
        return TestDomainTranslator.tupleDomain(Map.of(key, domain));
    }

    private static <T> TupleDomain<T> tupleDomain(T key1, Domain domain1, T key2, Domain domain2) {
        return TestDomainTranslator.tupleDomain(Map.of(key1, domain1, key2, domain2));
    }

    private static <T> TupleDomain<T> tupleDomain(Map<T, Domain> domains) {
        return TupleDomain.withColumnDomains(domains);
    }

    private static class NumericValues<T> {
        private final Symbol column;
        private final Type type;
        private final T min;
        private final T integerNegative;
        private final T fractionalNegative;
        private final T integerPositive;
        private final T fractionalPositive;
        private final T max;

        private NumericValues(Symbol column, T min, T integerNegative, T fractionalNegative, T integerPositive, T fractionalPositive, T max) {
            this.column = Objects.requireNonNull(column, "column is null");
            this.type = Objects.requireNonNull(column.type(), "type for column not found: " + String.valueOf(column));
            this.min = Objects.requireNonNull(min, "min is null");
            this.integerNegative = Objects.requireNonNull(integerNegative, "integerNegative is null");
            this.fractionalNegative = Objects.requireNonNull(fractionalNegative, "fractionalNegative is null");
            this.integerPositive = Objects.requireNonNull(integerPositive, "integerPositive is null");
            this.fractionalPositive = Objects.requireNonNull(fractionalPositive, "fractionalPositive is null");
            this.max = Objects.requireNonNull(max, "max is null");
        }

        public Symbol getColumn() {
            return this.column;
        }

        public Type getType() {
            return this.type;
        }

        public T getMin() {
            return this.min;
        }

        public T getIntegerNegative() {
            return this.integerNegative;
        }

        public T getFractionalNegative() {
            return this.fractionalNegative;
        }

        public T getIntegerPositive() {
            return this.integerPositive;
        }

        public T getFractionalPositive() {
            return this.fractionalPositive;
        }

        public T getMax() {
            return this.max;
        }

        public boolean isFractional() {
            return this.type == DoubleType.DOUBLE || this.type == RealType.REAL || this.type instanceof DecimalType && ((DecimalType)this.type).getScale() > 0;
        }

        public boolean isTypeWithNaN() {
            return this.type instanceof DoubleType || this.type instanceof RealType;
        }
    }
}

