/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import io.trino.sql.ir.Array;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.assertions.SymbolAliases;
import java.util.List;
import java.util.Objects;

public final class ExpressionVerifier
extends IrVisitor<Boolean, Expression> {
    private final SymbolAliases symbolAliases;

    public ExpressionVerifier(SymbolAliases symbolAliases) {
        this.symbolAliases = Objects.requireNonNull(symbolAliases, "symbolAliases is null");
    }

    protected Boolean visitArray(Array actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Array)) {
            return false;
        }
        Array expected = (Array)expectedExpression;
        return this.process(actual.elements(), expected.elements());
    }

    protected Boolean visitConstant(Constant actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Constant)) {
            return false;
        }
        Constant expected = (Constant)expectedExpression;
        return Objects.equals(actual.value(), expected.value()) && actual.type().equals((Object)expected.type());
    }

    protected Boolean visitReference(Reference actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Reference)) {
            return false;
        }
        Reference expected = (Reference)expectedExpression;
        return this.symbolAliases.get(expected.name()).name().equals(actual.name());
    }

    protected Boolean visitCast(Cast actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Cast)) {
            return false;
        }
        Cast expected = (Cast)expectedExpression;
        if (!actual.type().toString().equalsIgnoreCase(expected.type().toString())) {
            return false;
        }
        return (Boolean)this.process(actual.expression(), expected.expression());
    }

    protected Boolean visitIsNull(IsNull actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof IsNull)) {
            return false;
        }
        IsNull expected = (IsNull)expectedExpression;
        return (Boolean)this.process(actual.value(), expected.value());
    }

    protected Boolean visitIn(In actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof In)) {
            return false;
        }
        In expected = (In)expectedExpression;
        return (Boolean)this.process(actual.value(), expected.value()) != false && this.process(actual.valueList(), expected.valueList());
    }

    protected Boolean visitComparison(Comparison actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Comparison)) {
            return false;
        }
        Comparison expected = (Comparison)expectedExpression;
        if (actual.operator() == expected.operator() && ((Boolean)this.process(actual.left(), expected.left())).booleanValue() && ((Boolean)this.process(actual.right(), expected.right())).booleanValue()) {
            return true;
        }
        return actual.operator() == expected.operator().flip() && (Boolean)this.process(actual.left(), expected.right()) != false && (Boolean)this.process(actual.right(), expected.left()) != false;
    }

    protected Boolean visitBetween(Between actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Between)) {
            return false;
        }
        Between expected = (Between)expectedExpression;
        return (Boolean)this.process(actual.value(), expected.value()) != false && (Boolean)this.process(actual.min(), expected.min()) != false && (Boolean)this.process(actual.max(), expected.max()) != false;
    }

    protected Boolean visitNot(Not actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Not)) {
            return false;
        }
        Not expected = (Not)expectedExpression;
        return (Boolean)this.process(actual.value(), expected.value());
    }

    protected Boolean visitLogical(Logical actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Logical)) {
            return false;
        }
        Logical expected = (Logical)expectedExpression;
        if (actual.terms().size() != expected.terms().size() || actual.operator() != expected.operator()) {
            return false;
        }
        for (int i = 0; i < actual.terms().size(); ++i) {
            if (((Boolean)this.process((Expression)actual.terms().get(i), (Expression)expected.terms().get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected Boolean visitCoalesce(Coalesce actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Coalesce)) {
            return false;
        }
        Coalesce expected = (Coalesce)expectedExpression;
        if (actual.operands().size() != expected.operands().size()) {
            return false;
        }
        for (int i = 0; i < actual.operands().size(); ++i) {
            if (((Boolean)this.process((Expression)actual.operands().get(i), (Expression)expected.operands().get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected Boolean visitSwitch(Switch actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Switch)) {
            return false;
        }
        Switch expected = (Switch)expectedExpression;
        return (Boolean)this.process(actual.operand(), expected.operand()) != false && this.processWhenClauses(actual.whenClauses(), expected.whenClauses()) && (Boolean)this.process(actual.defaultValue(), expected.defaultValue()) != false;
    }

    protected Boolean visitCase(Case actual, Expression expected) {
        if (!(expected instanceof Case)) {
            return false;
        }
        Case expectedCase = (Case)expected;
        if (!this.processWhenClauses(actual.whenClauses(), expectedCase.whenClauses())) {
            return false;
        }
        return (Boolean)this.process(actual.defaultValue(), expectedCase.defaultValue());
    }

    private boolean processWhenClauses(List<WhenClause> actual, List<WhenClause> expected) {
        if (actual.size() != expected.size()) {
            return false;
        }
        for (int i = 0; i < actual.size(); ++i) {
            if (this.process(actual.get(i), expected.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean process(WhenClause actual, WhenClause expected) {
        return (Boolean)this.process(actual.getOperand(), expected.getOperand()) != false && (Boolean)this.process(actual.getResult(), expected.getResult()) != false;
    }

    protected Boolean visitCall(Call actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Call)) {
            return false;
        }
        Call expected = (Call)expectedExpression;
        return actual.function().name().equals((Object)expected.function().name()) && this.process(actual.arguments(), expected.arguments());
    }

    protected Boolean visitLambda(Lambda actual, Expression expected) {
        if (!(expected instanceof Lambda)) {
            return false;
        }
        Lambda lambda = (Lambda)expected;
        if (!actual.arguments().equals(lambda.arguments())) {
            return false;
        }
        return (Boolean)this.process(actual.body(), lambda.body());
    }

    protected Boolean visitRow(Row actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Row)) {
            return false;
        }
        Row expected = (Row)expectedExpression;
        return this.process(actual.items(), expected.items());
    }

    protected Boolean visitFieldReference(FieldReference actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof FieldReference)) {
            return false;
        }
        FieldReference expected = (FieldReference)expectedExpression;
        return (Boolean)this.process(actual.base(), expected.base()) != false && actual.field() == expected.field();
    }

    private <T extends Expression> boolean process(List<T> actuals, List<T> expecteds) {
        if (actuals.size() != expecteds.size()) {
            return false;
        }
        for (int i = 0; i < actuals.size(); ++i) {
            if (((Boolean)this.process((Expression)actuals.get(i), (Expression)expecteds.get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

