/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

final class UnnestMatcher
implements Matcher {
    private final List<String> replicateSymbols;
    private final List<PlanMatchPattern.UnnestMapping> unnestMappings;
    private final Optional<String> ordinalitySymbol;
    private final JoinType type;

    public UnnestMatcher(List<String> replicateSymbols, List<PlanMatchPattern.UnnestMapping> unnestMappings, Optional<String> ordinalitySymbol, JoinType type) {
        this.replicateSymbols = Objects.requireNonNull(replicateSymbols, "replicateSymbols is null");
        this.unnestMappings = Objects.requireNonNull(unnestMappings, "unnestMappings is null");
        this.ordinalitySymbol = Objects.requireNonNull(ordinalitySymbol, "ordinalitySymbol is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof UnnestNode)) {
            return false;
        }
        UnnestNode unnestNode = (UnnestNode)node;
        return unnestNode.getJoinType() == this.type;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        UnnestNode unnestNode = (UnnestNode)node;
        if (unnestNode.getReplicateSymbols().size() != this.replicateSymbols.size()) {
            return MatchResult.NO_MATCH;
        }
        if (!((ImmutableList)this.replicateSymbols.stream().map(symbolAliases::get).map(Symbol::from).collect(ImmutableList.toImmutableList())).equals((Object)unnestNode.getReplicateSymbols())) {
            return MatchResult.NO_MATCH;
        }
        if (unnestNode.getMappings().size() != this.unnestMappings.size()) {
            return MatchResult.NO_MATCH;
        }
        if (!IntStream.range(0, this.unnestMappings.size()).boxed().allMatch(index -> {
            UnnestNode.Mapping nodeMapping = (UnnestNode.Mapping)unnestNode.getMappings().get((int)index);
            PlanMatchPattern.UnnestMapping patternMapping = this.unnestMappings.get((int)index);
            return nodeMapping.getInput().toSymbolReference().equals((Object)symbolAliases.get(patternMapping.getInput())) && patternMapping.getOutputs().size() == nodeMapping.getOutputs().size();
        })) {
            return MatchResult.NO_MATCH;
        }
        if (this.ordinalitySymbol.isPresent() != unnestNode.getOrdinalitySymbol().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.type.equals((Object)unnestNode.getJoinType())) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.type).add("replicateSymbols", this.replicateSymbols).add("unnestMappings", this.unnestMappings).add("ordinalitySymbol", this.ordinalitySymbol.orElse(null)).toString();
    }
}

