/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestCanonicalizeExpressionRewriter {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MULTIPLY_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final TransactionManager TRANSACTION_MANAGER = InMemoryTransactionManager.createTestTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final AllowAllAccessControl ACCESS_CONTROL = new AllowAllAccessControl();

    @Test
    public void testRewriteIsNotNullPredicate() {
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Not((Expression)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "x"))), (Expression)new Not((Expression)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "x"))));
    }

    @Test
    public void testRewriteIfExpression() {
        TestCanonicalizeExpressionRewriter.assertRewritten(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
    }

    @Test
    public void testCanonicalizeArithmetic() {
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Reference((Type)IntegerType.INTEGER, "a"))), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Reference((Type)IntegerType.INTEGER, "a"))), (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))));
    }

    @Test
    public void testCanonicalizeComparison() {
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Expression)new Comparison(Comparison.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new Comparison(Comparison.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Expression)new Comparison(Comparison.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Reference((Type)IntegerType.INTEGER, "a")));
    }

    @Test
    public void testCanonicalizeRewriteDateFunctionToCast() {
        TestCanonicalizeExpressionRewriter.assertCanonicalizedDate((Type)TimestampType.createTimestampType((int)3), "ts");
        TestCanonicalizeExpressionRewriter.assertCanonicalizedDate((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "tstz");
        TestCanonicalizeExpressionRewriter.assertCanonicalizedDate((Type)VarcharType.createVarcharType((int)100), "v");
    }

    private static void assertCanonicalizedDate(Type type, String symbolName) {
        Call date = new Call(PLANNER_CONTEXT.getMetadata().resolveBuiltinFunction("date", TypeSignatureProvider.fromTypes((Type[])new Type[]{type})), (List)ImmutableList.of((Object)new Reference(type, symbolName)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)date, (Expression)new Cast((Expression)new Reference((Type)VarcharType.VARCHAR, symbolName), (Type)DateType.DATE));
    }

    private static void assertRewritten(Expression from, Expression to) {
        ExpressionTestUtils.assertExpressionEquals((Expression)TransactionBuilder.transaction((TransactionManager)TRANSACTION_MANAGER, (Metadata)PLANNER_CONTEXT.getMetadata(), (AccessControl)ACCESS_CONTROL).execute(SessionTestUtils.TEST_SESSION, transactedSession -> CanonicalizeExpressionRewriter.rewrite((Expression)from, (PlannerContext)PLANNER_CONTEXT)), to, SymbolAliases.builder().put("x", new Reference((Type)BigintType.BIGINT, "x")).put("a", new Reference((Type)BigintType.BIGINT, "a")).put("ts", new Reference((Type)TimestampType.createTimestampType((int)3), "ts")).put("tstz", new Reference((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "tstz")).put("v", new Reference((Type)VarcharType.createVarcharType((int)100), "v")).build());
    }
}

