/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantPredicateAboveTableScan;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantPredicateAboveTableScan
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction MODULUS_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MODULUS, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction MODULUS_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MODULUS, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private RemoveRedundantPredicateAboveTableScan removeRedundantPredicateAboveTableScan;
    private TableHandle nationTableHandle;
    private TableHandle ordersTableHandle;

    public TestRemoveRedundantPredicateAboveTableScan() {
        super(new Plugin[0]);
    }

    @BeforeAll
    public void setUpBeforeClass() {
        this.removeRedundantPredicateAboveTableScan = new RemoveRedundantPredicateAboveTableScan(this.tester().getPlannerContext());
        CatalogHandle catalogHandle = this.tester().getCurrentCatalogHandle();
        TpchTableHandle nation = new TpchTableHandle("sf1", "nation", 1.0);
        this.nationTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)nation, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE);
        TpchTableHandle orders = new TpchTableHandle("sf1", "orders", 1.0);
        this.ordersTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)orders, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE);
    }

    @Test
    public void doesNotFireIfNoTableScan() {
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(p -> p.values(p.symbol("a", (Type)BigintType.BIGINT))).doesNotFire();
    }

    @Test
    public void consumesDeterministicPredicateIfNewDomainIsSame() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$consumesDeterministicPredicateIfNewDomainIsSame$1((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")));
    }

    @Test
    public void consumesDeterministicPredicateIfNewDomainIsWider() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$consumesDeterministicPredicateIfNewDomainIsWider$2((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")));
    }

    @Test
    public void consumesDeterministicPredicateIfNewDomainIsNarrower() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$consumesDeterministicPredicateIfNewDomainIsNarrower$3((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.filter((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)44L), (Object)new Constant((Type)BigintType.BIGINT, (Object)45L))), PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)44L, (Object)45L, (Object)46L))), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))));
    }

    @Test
    public void doesNotConsumeRemainingPredicateIfNewDomainIsWider() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$doesNotConsumeRemainingPredicateIfNewDomainIsWider$4((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.filter((Expression)Logical.and((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)this.tester().getMetadata()).setName("rand").build(), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)42.0)), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(MODULUS_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "nationkey"), (Object)new Constant((Type)BigintType.BIGINT, (Object)17L))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)44L))), PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))));
    }

    @Test
    public void doesNotFireOnNonDeterministicPredicate() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$doesNotFireOnNonDeterministicPredicate$5((ColumnHandle)columnHandle, arg_0)).doesNotFire();
    }

    @Test
    public void doesNotFireIfRuleNotChangePlan() {
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(p -> p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(MODULUS_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "nationkey"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)17L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)44L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(MODULUS_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "nationkey"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)15L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)43L)))), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), (TupleDomain<ColumnHandle>)TupleDomain.all()))).doesNotFire();
    }

    @Test
    public void doesNotAddTableLayoutToFilterTableScan() {
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(p -> p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)VarcharType.VARCHAR, "orderstatus"), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"F"))), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnNoTableScanPredicate() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$doesNotFireOnNoTableScanPredicate$8((ColumnHandle)columnHandle, arg_0)).doesNotFire();
    }

    @Test
    public void skipNotFullyExtractedConjunct() {
        TpchColumnHandle textColumnHandle = new TpchColumnHandle("name", (Type)VarcharType.VARCHAR);
        TpchColumnHandle nationKeyColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.removeRedundantPredicateAboveTableScan).on(arg_0 -> this.lambda$skipNotFullyExtractedConjunct$9((ColumnHandle)textColumnHandle, (ColumnHandle)nationKeyColumnHandle, arg_0)).matches(PlanMatchPattern.filter(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)VarcharType.VARCHAR, "name"), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"x"))), (Expression)Booleans.TRUE, (Expression)Booleans.FALSE), PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L), (Object)"name", (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value"))), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey", (Object)"name", (Object)"name"))));
    }

    private /* synthetic */ PlanNode lambda$skipNotFullyExtractedConjunct$9(ColumnHandle textColumnHandle, ColumnHandle nationKeyColumnHandle, PlanBuilder p) {
        return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)VarcharType.VARCHAR, "name"), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"x"))), (Expression)Booleans.TRUE, (Expression)Booleans.FALSE), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)44L)))), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("name", (Type)VarcharType.VARCHAR), (Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("name", (Type)VarcharType.VARCHAR), (Object)textColumnHandle, (Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)nationKeyColumnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)textColumnHandle, (Object)NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value")), (Object)nationKeyColumnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$doesNotFireOnNoTableScanPredicate$8(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "nationkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "nationkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "nationkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "nationkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)))))), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.all()));
    }

    private /* synthetic */ PlanNode lambda$doesNotFireOnNonDeterministicPredicate$5(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)this.tester().getMetadata()).setName("rand").build(), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)42.0)), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.all()));
    }

    private /* synthetic */ PlanNode lambda$doesNotConsumeRemainingPredicateIfNewDomainIsWider$4(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)this.tester().getMetadata()).setName("rand").build(), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)42.0)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(MODULUS_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "nationkey"), (Object)new Constant((Type)BigintType.BIGINT, (Object)17L))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)44L)), (Object)Logical.or((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)44L)), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)45L))))), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$consumesDeterministicPredicateIfNewDomainIsNarrower$3(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)44L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)45L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)47L)))), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)44L, (Object)45L, (Object)46L))))));
    }

    private /* synthetic */ PlanNode lambda$consumesDeterministicPredicateIfNewDomainIsWider$2(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)44L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)45L)))), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$consumesDeterministicPredicateIfNewDomainIsSame$1(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)44L)), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }
}

