/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantTableFunction;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantTableFunction
extends BaseRuleTest {
    public TestRemoveRedundantTableFunction() {
        super(new Plugin[0]);
    }

    @Test
    public void testRemoveTableFunction() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantTableFunction()).on(p -> {
            Symbol passThrough = p.symbol("pass_through");
            Symbol proper = p.symbol("proper");
            return p.tableFunctionProcessor(builder -> builder.name("test_function").pruneWhenEmpty().properOutputs(proper).passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(passThrough, true)))).source((PlanNode)p.values(passThrough)));
        }).matches(PlanMatchPattern.values("proper", "pass_through"));
    }

    @Test
    public void testDoNotRemoveKeepWhenEmpty() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantTableFunction()).on(p -> {
            Symbol passThrough = p.symbol("pass_through");
            Symbol proper = p.symbol("proper");
            return p.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs(proper).passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(passThrough, true)))).source((PlanNode)p.values(passThrough)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotRemoveNonEmptyInput() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantTableFunction()).on(p -> {
            Symbol passThrough = p.symbol("pass_through");
            Symbol proper = p.symbol("proper");
            return p.tableFunctionProcessor(builder -> builder.name("test_function").pruneWhenEmpty().properOutputs(proper).passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(passThrough, true)))).source((PlanNode)p.values(5, passThrough)));
        }).doesNotFire();
    }
}

