/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestRowPatternMatchingInWindow {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testSimpleQuery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, val OVER w, label OVER w           FROM (VALUES                    (1, 90),                    (2, 80),                    (3, 70),                    (4, 80),                    (5, 90),                    (6, 50),                    (7, 40),                    (8, 60)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP PAST LAST ROW                    PATTERN (A B+ C+)                    DEFINE /* A defaults to True, matches any row */                           B AS B.value < PREV (B.value),                           C AS C.value > PREV (C.value)                 )"))).matches("VALUES      (1, 90, CAST('C' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null),      (5, null, null),      (6, 60, 'C'),      (7, null, null),      (8, null, null) ");
    }

    @Test
    public void testRowPattern() {
        String query = "SELECT id, val OVER w, label OVER w           FROM (VALUES                    (1, 90),                    (2, 80),                    (3, 70),                    (4, 70)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             classifier() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP PAST LAST ROW                    %s                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (() | A)                   DEFINE A AS true ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B C)                   DEFINE                           B AS B.value < PREV (B.value),                           C AS C.value = PREV (C.value) ")))).matches("VALUES      (1, null, CAST(null AS varchar)),      (2, 70, 'C'),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (B | C | A)                   DEFINE                           B AS B.value < PREV (B.value),                           C AS C.value <= PREV (C.value) ")))).matches("VALUES      (1, 90, CAST('A' AS varchar)),      (2, 80, 'A'),      (3, 70, 'A'),      (4, 70, 'A') ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (PERMUTE(B, C, A))                   DEFINE                           B AS B.value < PREV (B.value),                           C AS C.value < PREV (C.value) ")))).matches("VALUES      (1, 70, CAST('C' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (((A) (B (C))))                   DEFINE                           B AS B.value < PREV (B.value),                           C AS C.value = PREV (C.value) ")))).matches("VALUES      (1, null, CAST(null AS varchar)),      (2, 70, 'C'),      (3, null, null),      (4, null, null) ");
    }

    @Test
    public void testPatternQuantifiers() {
        String query = "SELECT id, val OVER w, label OVER w           FROM (VALUES                    (1, 90),                    (2, 80),                    (3, 70),                    (4, 70)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             classifier() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP PAST LAST ROW                    %s                   DEFINE B AS B.value <= PREV (B.value)                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B*) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (B*?) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B+) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B+?) ")))).matches("VALUES      (1, 80, CAST('B' AS varchar)),      (2, null, null),      (3, 70, 'B'),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B?) ")))).matches("VALUES      (1, 80, CAST('B' AS varchar)),      (2, null, null),      (3, 70, 'B'),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B??) ")))).matches("VALUES      (1, 90, CAST('A' AS varchar)),      (2, 80, 'A'),      (3, 70, 'A'),      (4, 70, 'A') ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{,}) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{,}?) ")))).matches("VALUES      (1, 90, CAST('A' AS varchar)),      (2, 80, 'A'),      (3, 70, 'A'),      (4, 70, 'A') ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{1,}) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{1,}?) ")))).matches("VALUES      (1, 80, CAST('B' AS varchar)),      (2, null, null),      (3, 70, 'B'),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{2,}) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{2,}? | C) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, 70, 'C') ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (B{5,}) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (B{5,}?) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{,1}) ")))).matches("VALUES      (1, 80, CAST('B' AS varchar)),      (2, null, null),      (3, 70, 'B'),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{,1}?) ")))).matches("VALUES      (1, 90, CAST('A' AS varchar)),      (2, 80, 'A'),      (3, 70, 'A'),      (4, 70, 'A') ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{,2}) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, 70, 'A') ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{,2}?) ")))).matches("VALUES      (1, 90, CAST('A' AS varchar)),      (2, 80, 'A'),      (3, 70, 'A'),      (4, 70, 'A') ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{,5}) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{,5}?) ")))).matches("VALUES      (1, 90, CAST('A' AS varchar)),      (2, 80, 'A'),      (3, 70, 'A'),      (4, 70, 'A') ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{1,1}) ")))).matches("VALUES      (1, 80, CAST('B' AS varchar)),      (2, null, null),      (3, 70, 'B'),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{1,1}?) ")))).matches("VALUES      (1, 80, CAST('B' AS varchar)),      (2, null, null),      (3, 70, 'B'),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{1,5}) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{1,5}?) ")))).matches("VALUES      (1, 80, CAST('B' AS varchar)),      (2, null, null),      (3, 70, 'B'),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{5,7}) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{5,7}?) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{1}) ")))).matches("VALUES      (1, 80, CAST('B' AS varchar)),      (2, null, null),      (3, 70, 'B'),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{1}?) ")))).matches("VALUES      (1, 80, CAST('B' AS varchar)),      (2, null, null),      (3, 70, 'B'),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{2}) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{2}?) ")))).matches("VALUES      (1, 70, CAST('B' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{5}) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (A B{5}?) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
    }

    @Test
    public void testExclusionSyntax() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, val OVER w, label OVER w           FROM (VALUES                    (1, 90),                    (2, 80),                    (3, 70),                    (4, 80),                    (5, 90),                    (6, 50),                    (7, 40),                    (8, 60)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP PAST LAST ROW                    PATTERN ({- A B+ C+ -})                    DEFINE /* A defaults to True, matches any row */                           B AS B.value < PREV (B.value),                           C AS C.value > PREV (C.value)                 )"))).matches("VALUES      (1, 90, CAST('C' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null),      (5, null, null),      (6, 60, 'C'),      (7, null, null),      (8, null, null) ");
    }

    @Test
    public void testEmptyCycle() {
        String query = "SELECT id, val OVER w, label OVER w           FROM (VALUES                    (1, 70),                    (2, 80),                    (3, 80),                    (4, 70)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             classifier() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP PAST LAST ROW                    %s                   DEFINE B AS B.value >= NEXT (B.value)                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (()* | B) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (()+ | B) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN ((){5,} | B) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN (B | ()*) ")))).matches("VALUES      (1, null, CAST(null AS varchar)),      (2, 80, 'B'),      (3, 80, 'B'),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN ((B ()*)*) ")))).matches("VALUES      (1, null, CAST(null AS varchar)),      (2, 80, 'B'),      (3, null, null),      (4, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PATTERN ((B ()*)*?) ")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null) ");
    }

    @Test
    public void testAfterMatchSkipToPosition() {
        String query = "SELECT id, val OVER w, label OVER w           FROM (VALUES                    (1, 90),                    (2, 80),                    (3, 70),                    (4, 80),                    (5, 70),                    (6, 100)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             classifier() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    %s                   PATTERN (A B+ C+ | E)                    DEFINE                             B AS B.value < PREV (B.value),                             C AS C.value > PREV (C.value)                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "AFTER MATCH SKIP PAST LAST ROW")))).matches("VALUES      (1, 80, CAST('C' AS varchar)),      (2, null, null),      (3, null, null),      (4, null, null),      (5, 70, 'E'),      (6, 100, 'E') ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "AFTER MATCH SKIP TO NEXT ROW")))).matches("VALUES      (1, 80, CAST('C' AS varchar)),      (2, 80, 'C'),      (3, 70, 'E'),      (4, 100, 'C'),      (5, 70, 'E'),      (6, 100, 'E') ");
    }

    @Test
    public void testAfterMatchSkipToLabel() {
        String query = "SELECT id, val OVER w, label OVER w           FROM (VALUES                    (1, 90),                    (2, 80),                    (3, 70),                    (4, 80),                    (5, 70),                    (6, 100)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             classifier() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    %s                   PATTERN (A B+ C+ D?)                    SUBSET U = (C, D)                    DEFINE                             B AS B.value < PREV (B.value),                             C AS C.value > PREV (C.value),                             D AS false                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "AFTER MATCH SKIP TO FIRST C")))).matches("VALUES      (1, 80, CAST('C' AS varchar)),      (2, null, null),      (3, null, null),      (4, 100, 'C'),      (5, null, null),      (6, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "AFTER MATCH SKIP TO LAST B")))).matches("VALUES      (1, 80, CAST('C' AS varchar)),      (2, null, null),      (3, null, null),      (4, 100, 'C'),      (5, null, null),      (6, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "AFTER MATCH SKIP TO B")))).matches("VALUES      (1, 80, CAST('C' AS varchar)),      (2, null, null),      (3, null, null),      (4, 100, 'C'),      (5, null, null),      (6, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "AFTER MATCH SKIP TO U")))).matches("VALUES      (1, 80, CAST('C' AS varchar)),      (2, null, null),      (3, null, null),      (4, 100, 'C'),      (5, null, null),      (6, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "AFTER MATCH SKIP TO A")))).failure().hasMessage("AFTER MATCH SKIP failed: cannot skip to first row of match");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "AFTER MATCH SKIP TO D")))).failure().hasMessage("AFTER MATCH SKIP failed: pattern variable is not present in match");
    }

    @Test
    public void testUnionVariable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, val OVER w, lower_or_higher OVER w, label OVER w           FROM (VALUES                    (1, 90),                    (2, 80),                    (3, 70),                    (4, 80)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(U.value) AS val,                             classifier(U) AS lower_or_higher,                             classifier(W) AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN ((L | H) A)                    SUBSET                             U = (L, H),                             W = (A, L, H)                    DEFINE                             A AS A.value = 80,                             L AS L.value < 80,                             H AS H.value > 80                 )"))).matches("VALUES      (1, 90, CAST('H' AS varchar), CAST('A' AS varchar)),      (2, null, null, null),      (3, 70, 'L', 'A'),      (4, null, null, null) ");
    }

    @Test
    public void testNavigationFunctions() {
        String query = "SELECT id, measure OVER w           FROM (VALUES                    (1, 10),                    (2, 20),                    (3, 30)               ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES %s AS measure                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "value")))).matches("VALUES      (1, 30),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "LAST(value)")))).matches("VALUES      (1, 30),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "RUNNING LAST(value)")))).matches("VALUES      (1, 30),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "FINAL LAST(value)")))).matches("VALUES      (1, 30),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "FIRST(value)")))).matches("VALUES      (1, 10),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "RUNNING FIRST(value)")))).matches("VALUES      (1, 10),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "FINAL FIRST(value)")))).matches("VALUES      (1, 10),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "FINAL LAST(value, 2)")))).matches("VALUES      (1, 10),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "FIRST(value, 2)")))).matches("VALUES      (1, 30),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "LAST(value, 10)")))).matches("VALUES      (1, CAST(null AS integer)),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "FIRST(value, 10)")))).matches("VALUES      (1, CAST(null AS integer)),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PREV(value)")))).matches("VALUES      (1, 20),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "NEXT(value)")))).matches("VALUES      (1, CAST(null AS integer)),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "NEXT(FIRST(value), 2)")))).matches("VALUES      (1, 30),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "NEXT(FIRST(value), 10)")))).matches("VALUES      (1, CAST(null AS integer)),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PREV(FIRST(value), 10)")))).matches("VALUES      (1, CAST(null AS integer)),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PREV(FIRST(value, 10), 2)")))).matches("VALUES      (1, CAST(null AS integer)),      (2, null),      (3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PREV(LAST(value, 10), 2)")))).matches("VALUES      (1, CAST(null AS integer)),      (2, null),      (3, null) ");
    }

    @Test
    public void testNavigationPastFrameBounds() {
        String query = "SELECT measure OVER w           FROM (VALUES                    (1, 10),                    (2, 20),                    (3, 30),                    (4, 30),                    (5, 40)               ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES %s AS measure                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A B)                    DEFINE A AS A.value = NEXT(A.value)                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PREV(B.value, 4)")))).matches("VALUES      (CAST(null AS integer)),      (null),      (null),      (null),      (null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PREV(B.value, 3)")))).matches("VALUES      (CAST(null AS integer)),      (null),      (null),      (null),      (null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "PREV(B.value, 2)")))).matches("VALUES      (CAST(null AS integer)),      (null),      (null),      (null),      (null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "NEXT(B.value, 1)")))).matches("VALUES      (null),      (null),      (40),      (null),      (null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "NEXT(B.value, 2)")))).matches("VALUES      (CAST(null AS integer)),      (null),      (null),      (null),      (null) ");
        query = "SELECT measure OVER w           FROM (VALUES                    (1, 10),                    (2, 20),                    (3, 30),                    (4, 30),                    (5, 40)               ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES %s AS measure                    ROWS BETWEEN CURRENT ROW AND 1 FOLLOWING                    PATTERN (A B)                    DEFINE A AS A.value = NEXT(A.value)                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "NEXT(B.value, 1)")))).matches("VALUES      (CAST(null AS integer)),      (null),      (null),      (null),      (null) ");
    }

    @Test
    public void testFrameBounds() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, last_matched_row OVER w           FROM (VALUES                    (1, 1),                    (2, 2),                    (3, 6),                    (4, 0),                    (5, 2)               ) t(id, rows)                  WINDOW w AS (                    ORDER BY id                    MEASURES LAST(id) AS last_matched_row                    ROWS BETWEEN CURRENT ROW AND rows FOLLOWING                    AFTER MATCH SKIP TO NEXT ROW                    PATTERN (A+)                    DEFINE A AS true                 )"))).matches("VALUES      (1, 2),      (2, 4),      (3, 5),      (4, 4),      (5, 5) ");
    }

    @Test
    public void testCaseSensitiveLabels() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, label OVER w           FROM (VALUES                    (1, 90),                    (2, 80),                    (3, 70),                    (4, 80)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND 10 FOLLOWING                    AFTER MATCH SKIP TO NEXT ROW                    PATTERN (a b* C*)                    DEFINE                             \"B\" AS B.value < PREV(b.value),                             \"C\" AS C.value > PREV(c.value)                 )"))).matches("VALUES      (1, CAST('C' AS varchar)),      (2, 'C'),      (3, 'C'),      (4, 'A') ");
    }

    @Test
    public void testScalarFunctions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, label OVER w           FROM (VALUES                    (1, 90),                    (2, 80),                    (3, 60)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES CAST(lower(LAST(CLASSIFIER())) || '_label' AS varchar(7)) AS label                    ROWS BETWEEN CURRENT ROW AND 10 FOLLOWING                    PATTERN (A B+)                    DEFINE B AS B.value + 10 < abs(PREV (B.value))                 )"))).matches("VALUES      (1, null),      (2, 'b_label'),      (3, null) ");
    }

    @Test
    public void testPartitioningAndOrdering() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT part as partition, id AS row_id, val OVER w, label OVER w           FROM (VALUES                    (1, 'p1', 90),                    (2, 'p1', 80),                    (6, 'p1', 80),                    (2, 'p2', 20),                    (2, 'p3', 60),                    (1, 'p3', 50),                    (3, 'p1', 70),                    (4, 'p1', 80),                    (5, 'p1', 90),                    (1, 'p2', 20),                    (3, 'p3', 70),                    (3, 'p2', 10)                ) t(id, part, value)                  WINDOW w AS (                    PARTITION BY part                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             classifier() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP PAST LAST ROW                    PATTERN (B+)                    DEFINE B AS B.value > NEXT (B.value)                 )"))).matches("VALUES      ('p1', 1, 80, CAST('B' AS varchar)),      ('p1', 2, null, null),      ('p1', 3, null, null),      ('p1', 4, null, null),      ('p1', 5, 90, 'B'),      ('p1', 6, null, null),      ('p2', 1, null, null),      ('p2', 2, 20, 'B'),      ('p2', 3, null, null),      ('p3', 1, null, null),      ('p3', 2, null, null),      ('p3', 3, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT part as partition, id AS row_id, val OVER w, label OVER w           FROM (SELECT * FROM (VALUES (1, 'p1', 90)) WHERE false) t(id, part, value)                  WINDOW w AS (                    PARTITION BY part                    ORDER BY id                    MEASURES                             PREV(RUNNING LAST(value)) AS val,                             classifier() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP PAST LAST ROW                    PATTERN (B+)                    DEFINE B AS B.value < PREV (B.value)                 )"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id AS row_id, val OVER w, label OVER w           FROM (VALUES                    (5, 10),                    (2, 90),                    (1, 80),                    (4, 20),                    (3, 30)                 )t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             classifier() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP PAST LAST ROW                    PATTERN (B+)                    DEFINE B AS B.value > NEXT (B.value)                 )"))).matches("VALUES      (1, null, CAST(null AS varchar)),      (2, 20, 'B'),      (3, null, null),      (4, null, null),      (5, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id AS row_id, part as partition          FROM (VALUES                    (5, 'p2', 10),                    (2, 'p1', 90),                    (1, 'p1', 80),                    (4, 'p2', 20),                    (3, 'p1', 30)                 )t(id, part, value)                  WINDOW w AS (                    PARTITION BY part                    ORDER BY id                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (B+)                    DEFINE B AS B.value < PREV (B.value)                 )"))).matches("VALUES      (1, 'p1'),      (2, 'p1'),      (3, 'p1'),      (4, 'p2'),      (5, 'p2') ");
    }

    @Test
    public void testWindowFunctions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT part as partition, id AS row_id, val OVER w, label OVER w, row_number() OVER w, array_agg(value) OVER w           FROM (VALUES                    (1, 'p1', 90),                    (2, 'p1', 80),                    (6, 'p1', 80),                    (2, 'p2', 20),                    (2, 'p3', 60),                    (1, 'p3', 50),                    (3, 'p1', 70),                    (4, 'p1', 80),                    (5, 'p1', 90),                    (1, 'p2', 20),                    (3, 'p3', 70),                    (3, 'p2', 10)                ) t(id, part, value)                  WINDOW w AS (                    PARTITION BY part                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             classifier() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP PAST LAST ROW                    PATTERN (B+)                    DEFINE B AS B.value > NEXT (B.value)                 )"))).matches("VALUES      ('p1', 1, 80, CAST('B' AS varchar), BIGINT '1', ARRAY[90, 80]),      ('p1', 2, null, null, 2, null),      ('p1', 3, null, null, 3, null),      ('p1', 4, null, null, 4, null),      ('p1', 5, 90,   'B',  5, ARRAY[90]),      ('p1', 6, null, null, 6, null),      ('p2', 1, null, null, 1, null),      ('p2', 2, 20,   'B',  2, ARRAY[20]),      ('p2', 3, null, null, 3, null),      ('p3', 1, null, null, 1, null),      ('p3', 2, null, null, 2, null),      ('p3', 3, null, null, 3, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT part as partition, id AS row_id, array_agg(value) OVER w           FROM (VALUES                    (1, 'p1', 50),                    (2, 'p1', 80),                    (3, 'p1', 70),                    (4, 'p1', 60),                    (5, 'p1', 50),                    (1, 'p2', 10),                    (2, 'p2', 20),                    (3, 'p2', 30),                    (4, 'p2', 40),                    (5, 'p2', 10),                    (1, 'p3', 100),                    (2, 'p3', 100)                ) t(id, part, value)                  WINDOW w AS (                    PARTITION BY part                    ORDER BY id                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP TO NEXT ROW                    SEEK                    PATTERN (B+)                    DEFINE B AS B.value > NEXT (B.value)                 )"))).matches("VALUES      ('p1', 1, ARRAY[80, 70, 60]),      ('p1', 2, ARRAY[80, 70, 60]),      ('p1', 3, ARRAY[70, 60]),      ('p1', 4, ARRAY[60]),      ('p1', 5, null),      ('p2', 1, ARRAY[40]),      ('p2', 2, ARRAY[40]),      ('p2', 3, ARRAY[40]),      ('p2', 4, ARRAY[40]),      ('p2', 5, null),      ('p3', 1, null),      ('p3', 2, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT part as partition, id AS row_id, array_agg(value) OVER w           FROM (VALUES                    (1, 'p1', 50),                    (2, 'p1', 80),                    (3, 'p1', 70),                    (4, 'p1', 60),                    (5, 'p1', 50),                    (1, 'p2', 10),                    (2, 'p2', 20),                    (3, 'p2', 30),                    (4, 'p2', 40),                    (5, 'p2', 10),                    (1, 'p3', 100),                    (2, 'p3', 100)                ) t(id, part, value)                  WINDOW w AS (                    PARTITION BY part                    ORDER BY id                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP PAST LAST ROW                    SEEK                    PATTERN (B+)                    DEFINE B AS B.value > NEXT (B.value)                 )"))).matches("VALUES      ('p1', 1, ARRAY[80, 70, 60]),      ('p1', 2, null),      ('p1', 3, null),      ('p1', 4, null),      ('p1', 5, null),      ('p2', 1, ARRAY[40]),      ('p2', 2, null),      ('p2', 3, null),      ('p2', 4, null),      ('p2', 5, null),      ('p3', 1, null),      ('p3', 2, null) ");
    }

    @Test
    public void testAccessingValuesOutsideMatch() {
        String query = "SELECT id, row_0 OVER w, row_1 OVER w, row_2 OVER w, row_3 OVER w, row_4 OVER w, row_5 OVER w, row_6 OVER w, row_7 OVER w           FROM (VALUES                    (1, 10),                    (2, 20),                    (3, 30),                    (4, 30),                    (5, 40),                    (6, 50)               ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES                            PREV(B.id, 4) AS row_0,                            PREV(B.id, 3) AS row_1,                            PREV(B.id, 2) AS row_2,                            PREV(B.id, 1) AS row_3,                            PREV(B.id, 0) AS row_4,                            NEXT(B.id, 1) AS row_5,                            NEXT(B.id, 2) AS row_6,                            NEXT(B.id, 3) AS row_7                    %s                    %s                    %s                    PATTERN (A B)                    DEFINE A AS A.value = NEXT(A.value)                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "ROWS BETWEEN CURRENT ROW AND 4 FOLLOWING", "AFTER MATCH SKIP PAST LAST ROW", "SEEK")))).matches("VALUES      (1, CAST(null AS integer), 1, 2, 3, 4, 5, CAST(null AS integer), CAST(null AS integer)),      (2, null, null, null, null, null, null, null, null),      (3, null, null, null, null, null, null, null, null),      (4, null, null, null, null, null, null, null, null),      (5, null, null, null, null, null, null, null, null),      (6, null, null, null, null, null, null, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "ROWS BETWEEN CURRENT ROW AND 2 FOLLOWING", "AFTER MATCH SKIP PAST LAST ROW", "SEEK")))).matches("VALUES      (1, null, null, null, null, null, null, null, null),      (2, CAST(null AS integer), CAST(null AS integer), 2, 3, 4, CAST(null AS integer), CAST(null AS integer), CAST(null AS integer)),      (3, null, null, null, null, null, null, null, null),      (4, null, null, null, null, null, null, null, null),      (5, null, null, null, null, null, null, null, null),      (6, null, null, null, null, null, null, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "ROWS BETWEEN CURRENT ROW AND 2 FOLLOWING", "AFTER MATCH SKIP TO NEXT ROW", "SEEK")))).matches("VALUES      (1, null, null, null, null, null, null, null, null),      (2, CAST(null AS integer), CAST(null AS integer), 2, 3, 4, CAST(null AS integer), CAST(null AS integer), CAST(null AS integer)),      (3, null, null, null, 3, 4, 5, null, null),      (4, null, null, null, null, null, null, null, null),      (5, null, null, null, null, null, null, null, null),      (6, null, null, null, null, null, null, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "ROWS BETWEEN CURRENT ROW AND 2 FOLLOWING", "AFTER MATCH SKIP PAST LAST ROW", "INITIAL")))).matches("VALUES      (1, null, null, null, null, null, null, null, null),      (2, null, null, null, null, null, null, null, null),      (3, CAST(null AS integer), CAST(null AS integer), CAST(null AS integer), 3, 4, 5, CAST(null AS integer), CAST(null AS integer)),      (4, null, null, null, null, null, null, null, null),      (5, null, null, null, null, null, null, null, null),      (6, null, null, null, null, null, null, null, null) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "ROWS BETWEEN CURRENT ROW AND CURRENT ROW", "AFTER MATCH SKIP PAST LAST ROW", "SEEK")))).matches("VALUES      (1, CAST(null AS integer), CAST(null AS integer), CAST(null AS integer), CAST(null AS integer), CAST(null AS integer), CAST(null AS integer), CAST(null AS integer), CAST(null AS integer)),      (2, null, null, null, null, null, null, null, null),      (3, null, null, null, null, null, null, null, null),      (4, null, null, null, null, null, null, null, null),      (5, null, null, null, null, null, null, null, null),      (6, null, null, null, null, null, null, null, null) ");
    }

    @Test
    public void testRowPatternMatchingInOrderBy() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id           FROM (VALUES 1, 2, 3, 4, 5, 6) t(id)                 WINDOW w AS (                    ORDER BY id                    MEASURES CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (X Y A B C)                    DEFINE X AS true                 )           ORDER BY label OVER w ASC NULLS FIRST"))).matches("VALUES 6, 3, 4, 5, 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id           FROM (VALUES 1, 2, 3, 4, 5, 6) t(id)           ORDER BY label OVER (                               ORDER BY id                                MEASURES CLASSIFIER() AS label                                ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                                PATTERN (X Y A B C)                                DEFINE X AS true                               ) ASC NULLS FIRST"))).matches("VALUES 6, 3, 4, 5, 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id           FROM (VALUES 1, 2, 3, 4, 5, 6) t(id)                 WINDOW w AS (ORDER BY id)           ORDER BY label OVER (w                                MEASURES CLASSIFIER() AS label                                ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                                PATTERN (X Y A B C)                                DEFINE X AS true                               ) ASC NULLS FIRST"))).matches("VALUES 6, 3, 4, 5, 1, 2");
    }

    @Test
    public void testSubqueries() {
        String query = "SELECT id, val OVER w           FROM (VALUES                    (1, 100),                    (2, 200),                    (3, 300),                    (4, 400)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES %s AS val                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP TO NEXT ROW                    PATTERN (A+)                    DEFINE A AS %s                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "(SELECT 'x')", "(SELECT true)")))).matches("VALUES      (1, 'x'),      (2, 'x'),      (3, 'x'),      (4, 'x') ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "LAST(A.value + (SELECT 1000))", "FIRST(A.value < 0 OR (SELECT true))")))).matches("VALUES      (1, 1400),      (2, 1400),      (3, 1400),      (4, 1400) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "LAST(A.id < 0 OR 1 IN (SELECT 1))", "FIRST(A.id > 0 AND 1 IN (SELECT 1))")))).matches("VALUES      (1, true),      (2, true),      (3, true),      (4, true) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "LAST(id + 50 IN (SELECT 100))", "LAST(id NOT IN (SELECT 100))")))).matches("VALUES      (1, false),      (2, false),      (3, false),      (4, false) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "LAST(A.value < 0 OR EXISTS(SELECT 1))", "FIRST(A.value < 0 OR EXISTS(SELECT 1))")))).matches("VALUES      (1, true),      (2, true),      (3, true),      (4, true) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, max(value) OVER w           FROM (VALUES                    (1, 100),                    (2, 200),                    (3, 300),                    (4, 400)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP TO NEXT ROW                    PATTERN (A+)                    DEFINE A AS (SELECT true)                 )"))).matches("VALUES      (1, 400),      (2, 400),      (3, 400),      (4, 400) ");
    }

    @Test
    public void testInPredicateWithoutSubquery() {
        String query = "SELECT id, val OVER w           FROM (VALUES                    (1, 100),                    (2, 200),                    (3, 300),                    (4, 400)                ) t(id, value)                  WINDOW w AS (                    ORDER BY id                    MEASURES %s AS val                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    AFTER MATCH SKIP TO NEXT ROW                    PATTERN (A+)                    DEFINE A AS true                 )";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "FIRST(A.value) IN (300, LAST(A.value))")))).matches("VALUES      (1, false),      (2, false),      (3, true),      (4, true) ");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "CLASSIFIER() IN ('X', lower(CLASSIFIER()))")))).matches("VALUES      (1, false),      (2, false),      (3, false),      (4, false) ");
    }
}

