/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.util.LongBigArrayFIFOQueue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLongBigArrayFIFOQueue {
    @Test
    public void testEnqueueDequeue() {
        long i;
        LongBigArrayFIFOQueue queue = new LongBigArrayFIFOQueue();
        Assertions.assertThat((boolean)queue.isEmpty()).isTrue();
        Assertions.assertThat((int)queue.size()).isEqualTo(0);
        Assertions.assertThat((long)queue.longSize()).isEqualTo(0L);
        for (i = 1L; i <= 100L; ++i) {
            queue.enqueue(i);
            Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
            Assertions.assertThat((long)queue.lastLong()).isEqualTo(i);
            Assertions.assertThat((int)queue.size()).isEqualTo(i);
            Assertions.assertThat((long)queue.longSize()).isEqualTo(i);
        }
        Assertions.assertThat((long)queue.firstLong()).isEqualTo(1L);
        Assertions.assertThat((long)queue.lastLong()).isEqualTo(100L);
        for (i = 1L; i <= 100L; ++i) {
            Assertions.assertThat((int)queue.size()).isEqualTo(100L - i + 1L);
            Assertions.assertThat((long)queue.longSize()).isEqualTo(100L - i + 1L);
            Assertions.assertThat((long)queue.dequeueLong()).isEqualTo(i);
        }
        Assertions.assertThat((boolean)queue.isEmpty()).isTrue();
        Assertions.assertThat((int)queue.size()).isEqualTo(0);
        Assertions.assertThat((long)queue.longSize()).isEqualTo(0L);
    }

    @Test
    public void testReverseEnqueueDequeue() {
        long i;
        LongBigArrayFIFOQueue queue = new LongBigArrayFIFOQueue();
        Assertions.assertThat((boolean)queue.isEmpty()).isTrue();
        Assertions.assertThat((int)queue.size()).isEqualTo(0);
        Assertions.assertThat((long)queue.longSize()).isEqualTo(0L);
        for (i = 1L; i <= 100L; ++i) {
            queue.enqueueFirst(i);
            Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
            Assertions.assertThat((long)queue.firstLong()).isEqualTo(i);
            Assertions.assertThat((int)queue.size()).isEqualTo(i);
            Assertions.assertThat((long)queue.longSize()).isEqualTo(i);
        }
        Assertions.assertThat((long)queue.firstLong()).isEqualTo(100L);
        Assertions.assertThat((long)queue.lastLong()).isEqualTo(1L);
        for (i = 1L; i <= 100L; ++i) {
            Assertions.assertThat((int)queue.size()).isEqualTo(100L - i + 1L);
            Assertions.assertThat((long)queue.longSize()).isEqualTo(100L - i + 1L);
            Assertions.assertThat((long)queue.dequeueLastLong()).isEqualTo(i);
        }
        Assertions.assertThat((boolean)queue.isEmpty()).isTrue();
        Assertions.assertThat((int)queue.size()).isEqualTo(0);
        Assertions.assertThat((long)queue.longSize()).isEqualTo(0L);
    }

    @Test
    public void testResize() {
        long i;
        int initialCapacity = 1;
        LongBigArrayFIFOQueue queue = new LongBigArrayFIFOQueue((long)initialCapacity);
        for (i = 0L; i < 1000000L; ++i) {
            queue.enqueue(i);
        }
        for (i = 0L; i < 1000000L; ++i) {
            Assertions.assertThat((long)queue.dequeueLong()).isEqualTo(i);
        }
        queue.trim();
        for (i = 0L; i < 1000000L; ++i) {
            queue.enqueue(i);
        }
        for (i = 0L; i < 1000000L; ++i) {
            Assertions.assertThat((long)queue.dequeueLong()).isEqualTo(i);
        }
    }
}

