/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.timesharing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import io.airlift.concurrent.SetThreadName;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.stats.TimeDistribution;
import io.airlift.stats.TimeStat;
import io.airlift.tracing.Tracing;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.trino.execution.SplitRunner;
import io.trino.execution.TaskId;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.executor.RunningSplitInfo;
import io.trino.execution.executor.TaskExecutor;
import io.trino.execution.executor.TaskHandle;
import io.trino.execution.executor.timesharing.MultilevelSplitQueue;
import io.trino.execution.executor.timesharing.PrioritizedSplitRunner;
import io.trino.execution.executor.timesharing.TimeSharingTaskHandle;
import io.trino.spi.TrinoException;
import io.trino.spi.VersionEmbedder;
import io.trino.tracing.TrinoAttributes;
import io.trino.util.EmbedVersion;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class TimeSharingTaskExecutor
implements TaskExecutor {
    private static final Logger log = Logger.get(TimeSharingTaskExecutor.class);
    private static final AtomicLong NEXT_RUNNER_ID = new AtomicLong();
    private final ExecutorService executor;
    private final ThreadPoolExecutorMBean executorMBean;
    private final int runnerThreads;
    private final int minimumNumberOfDrivers;
    private final int guaranteedNumberOfDriversPerTask;
    private final int maximumNumberOfDriversPerTask;
    private final VersionEmbedder versionEmbedder;
    private final Tracer tracer;
    private final Ticker ticker;
    private final Duration stuckSplitsWarningThreshold;
    private final SortedSet<RunningSplitInfo> runningSplitInfos = new ConcurrentSkipListSet<RunningSplitInfo>();
    @GuardedBy(value="this")
    private final List<TimeSharingTaskHandle> tasks;
    @GuardedBy(value="this")
    private final Set<PrioritizedSplitRunner> allSplits = new HashSet<PrioritizedSplitRunner>();
    @GuardedBy(value="this")
    private final Set<PrioritizedSplitRunner> intermediateSplits = new HashSet<PrioritizedSplitRunner>();
    private final MultilevelSplitQueue waitingSplits;
    private final Set<PrioritizedSplitRunner> runningSplits = Sets.newConcurrentHashSet();
    private final Map<PrioritizedSplitRunner, Future<Void>> blockedSplits = new ConcurrentHashMap<PrioritizedSplitRunner, Future<Void>>();
    private final AtomicLongArray completedTasksPerLevel = new AtomicLongArray(5);
    private final AtomicLongArray completedSplitsPerLevel = new AtomicLongArray(5);
    private final TimeStat splitQueuedTime = new TimeStat(TimeUnit.NANOSECONDS);
    private final TimeStat splitWallTime = new TimeStat(TimeUnit.NANOSECONDS);
    private final TimeDistribution leafSplitWallTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution intermediateSplitWallTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution leafSplitScheduledTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution intermediateSplitScheduledTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution leafSplitWaitTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution intermediateSplitWaitTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution leafSplitCpuTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final TimeDistribution intermediateSplitCpuTime = new TimeDistribution(TimeUnit.MICROSECONDS);
    private final CounterStat globalCpuTimeMicros = new CounterStat();
    private final CounterStat globalScheduledTimeMicros = new CounterStat();
    private final TimeStat blockedQuantaWallTime = new TimeStat(TimeUnit.MICROSECONDS);
    private final TimeStat unblockedQuantaWallTime = new TimeStat(TimeUnit.MICROSECONDS);
    private final DistributionStat leafSplitsSize = new DistributionStat();
    @GuardedBy(value="this")
    private long lastLeafSplitsSizeRecordTime;
    @GuardedBy(value="this")
    private long lastLeafSplitsSize;
    private volatile boolean closed;

    @Inject
    public TimeSharingTaskExecutor(TaskManagerConfig config, VersionEmbedder versionEmbedder, Tracer tracer, MultilevelSplitQueue splitQueue) {
        this(config.getMaxWorkerThreads(), config.getMinDrivers(), config.getMinDriversPerTask(), config.getMaxDriversPerTask(), config.getInterruptStuckSplitTasksWarningThreshold(), versionEmbedder, tracer, splitQueue, Ticker.systemTicker());
    }

    @VisibleForTesting
    public TimeSharingTaskExecutor(int runnerThreads, int minDrivers, int guaranteedNumberOfDriversPerTask, int maximumNumberOfDriversPerTask, Ticker ticker) {
        this(runnerThreads, minDrivers, guaranteedNumberOfDriversPerTask, maximumNumberOfDriversPerTask, new Duration(10.0, TimeUnit.MINUTES), EmbedVersion.testingVersionEmbedder(), Tracing.noopTracer(), new MultilevelSplitQueue(2.0), ticker);
    }

    @VisibleForTesting
    public TimeSharingTaskExecutor(int runnerThreads, int minDrivers, int guaranteedNumberOfDriversPerTask, int maximumNumberOfDriversPerTask, MultilevelSplitQueue splitQueue, Ticker ticker) {
        this(runnerThreads, minDrivers, guaranteedNumberOfDriversPerTask, maximumNumberOfDriversPerTask, new Duration(10.0, TimeUnit.MINUTES), EmbedVersion.testingVersionEmbedder(), Tracing.noopTracer(), splitQueue, ticker);
    }

    @VisibleForTesting
    public TimeSharingTaskExecutor(int runnerThreads, int minDrivers, int guaranteedNumberOfDriversPerTask, int maximumNumberOfDriversPerTask, Duration stuckSplitsWarningThreshold, VersionEmbedder versionEmbedder, Tracer tracer, MultilevelSplitQueue splitQueue, Ticker ticker) {
        Preconditions.checkArgument((runnerThreads > 0 ? 1 : 0) != 0, (Object)"runnerThreads must be at least 1");
        Preconditions.checkArgument((guaranteedNumberOfDriversPerTask > 0 ? 1 : 0) != 0, (Object)"guaranteedNumberOfDriversPerTask must be at least 1");
        Preconditions.checkArgument((maximumNumberOfDriversPerTask > 0 ? 1 : 0) != 0, (Object)"maximumNumberOfDriversPerTask must be at least 1");
        Preconditions.checkArgument((guaranteedNumberOfDriversPerTask <= maximumNumberOfDriversPerTask ? 1 : 0) != 0, (Object)"guaranteedNumberOfDriversPerTask cannot be greater than maximumNumberOfDriversPerTask");
        this.executor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"task-processor-%s"));
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.executor);
        this.runnerThreads = runnerThreads;
        this.versionEmbedder = Objects.requireNonNull(versionEmbedder, "versionEmbedder is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
        this.stuckSplitsWarningThreshold = Objects.requireNonNull(stuckSplitsWarningThreshold, "stuckSplitsWarningThreshold is null");
        this.minimumNumberOfDrivers = minDrivers;
        this.guaranteedNumberOfDriversPerTask = guaranteedNumberOfDriversPerTask;
        this.maximumNumberOfDriversPerTask = maximumNumberOfDriversPerTask;
        this.waitingSplits = Objects.requireNonNull(splitQueue, "splitQueue is null");
        this.tasks = new LinkedList<TimeSharingTaskHandle>();
        this.lastLeafSplitsSizeRecordTime = ticker.read();
    }

    @Override
    @PostConstruct
    public synchronized void start() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"TaskExecutor is closed");
        for (int i = 0; i < this.runnerThreads; ++i) {
            this.addRunnerThread();
        }
    }

    @Override
    @PreDestroy
    public synchronized void stop() {
        this.closed = true;
        this.executor.shutdownNow();
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("runnerThreads", this.runnerThreads).add("allSplits", this.allSplits.size()).add("intermediateSplits", this.intermediateSplits.size()).add("waitingSplits", this.waitingSplits.size()).add("runningSplits", this.runningSplits.size()).add("blockedSplits", this.blockedSplits.size()).toString();
    }

    private synchronized void addRunnerThread() {
        try {
            this.executor.execute(this.versionEmbedder.embedVersion((Runnable)new TaskRunner()));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public synchronized TimeSharingTaskHandle addTask(TaskId taskId, DoubleSupplier utilizationSupplier, int initialSplitConcurrency, Duration splitConcurrencyAdjustFrequency, OptionalInt maxDriversPerTask) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(utilizationSupplier, "utilizationSupplier is null");
        Preconditions.checkArgument((maxDriversPerTask.isEmpty() || maxDriversPerTask.getAsInt() <= this.maximumNumberOfDriversPerTask ? 1 : 0) != 0, (Object)"maxDriversPerTask cannot be greater than the configured value");
        log.debug("Task scheduled %s", new Object[]{taskId});
        TimeSharingTaskHandle taskHandle = new TimeSharingTaskHandle(taskId, this.waitingSplits, utilizationSupplier, initialSplitConcurrency, splitConcurrencyAdjustFrequency, maxDriversPerTask);
        this.tasks.add(taskHandle);
        return taskHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTask(TaskHandle taskHandle) {
        TimeSharingTaskHandle handle = (TimeSharingTaskHandle)taskHandle;
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{handle.getTaskId()});){
            if (!this.doRemoveTask(handle)) {
                return;
            }
        }
        TimeSharingTaskExecutor timeSharingTaskExecutor = this;
        synchronized (timeSharingTaskExecutor) {
            this.addNewEntrants();
            this.recordLeafSplitsSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRemoveTask(TimeSharingTaskHandle taskHandle) {
        List<PrioritizedSplitRunner> splits;
        TimeSharingTaskExecutor timeSharingTaskExecutor = this;
        synchronized (timeSharingTaskExecutor) {
            this.tasks.remove(taskHandle);
            if (taskHandle.isDestroyed()) {
                return false;
            }
            splits = taskHandle.destroy();
            this.allSplits.removeAll(splits);
            this.intermediateSplits.removeAll(splits);
            this.blockedSplits.keySet().removeAll(splits);
            this.waitingSplits.removeAll(splits);
            this.recordLeafSplitsSize();
        }
        for (PrioritizedSplitRunner split : splits) {
            split.destroy();
        }
        long threadUsageNanos = taskHandle.getScheduledNanos();
        this.completedTasksPerLevel.incrementAndGet(MultilevelSplitQueue.computeLevel(threadUsageNanos));
        log.debug("Task finished or failed %s", new Object[]{taskHandle.getTaskId()});
        return !splits.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ListenableFuture<Void>> enqueueSplits(TaskHandle taskHandle, boolean intermediate, List<? extends SplitRunner> taskSplits) {
        TimeSharingTaskHandle handle = (TimeSharingTaskHandle)taskHandle;
        ArrayList<PrioritizedSplitRunner> splitsToDestroy = new ArrayList<PrioritizedSplitRunner>();
        ArrayList<ListenableFuture<Void>> finishedFutures = new ArrayList<ListenableFuture<Void>>(taskSplits.size());
        TimeSharingTaskExecutor timeSharingTaskExecutor = this;
        synchronized (timeSharingTaskExecutor) {
            for (SplitRunner splitRunner : taskSplits) {
                TaskId taskId = handle.getTaskId();
                int splitId = handle.getNextSplitId();
                Span splitSpan = this.tracer.spanBuilder(intermediate ? "split (intermediate)" : "split (leaf)").setParent(Context.current().with((ImplicitContextKeyed)splitRunner.getPipelineSpan())).setAttribute(TrinoAttributes.QUERY_ID, (Object)taskId.getQueryId().toString()).setAttribute(TrinoAttributes.STAGE_ID, (Object)taskId.getStageId().toString()).setAttribute(TrinoAttributes.TASK_ID, (Object)taskId.toString()).setAttribute(TrinoAttributes.PIPELINE_ID, (Object)(String.valueOf(taskId.getStageId()) + "-" + splitRunner.getPipelineId())).setAttribute(TrinoAttributes.SPLIT_ID, (Object)(String.valueOf(taskId) + "-" + splitId)).startSpan();
                PrioritizedSplitRunner prioritizedSplitRunner = new PrioritizedSplitRunner(handle, splitId, splitRunner, splitSpan, this.tracer, this.ticker, this.globalCpuTimeMicros, this.globalScheduledTimeMicros, this.blockedQuantaWallTime, this.unblockedQuantaWallTime);
                if (intermediate) {
                    if (handle.recordIntermediateSplit(prioritizedSplitRunner)) {
                        this.startIntermediateSplit(prioritizedSplitRunner);
                    } else {
                        splitsToDestroy.add(prioritizedSplitRunner);
                    }
                } else if (handle.enqueueSplit(prioritizedSplitRunner)) {
                    this.scheduleTaskIfNecessary(handle);
                    this.addNewEntrants();
                } else {
                    splitsToDestroy.add(prioritizedSplitRunner);
                }
                finishedFutures.add(prioritizedSplitRunner.getFinishedFuture());
            }
            this.recordLeafSplitsSize();
        }
        for (PrioritizedSplitRunner split : splitsToDestroy) {
            split.destroy();
        }
        return finishedFutures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitFinished(PrioritizedSplitRunner split) {
        this.completedSplitsPerLevel.incrementAndGet(split.getPriority().getLevel());
        TimeSharingTaskExecutor timeSharingTaskExecutor = this;
        synchronized (timeSharingTaskExecutor) {
            this.allSplits.remove(split);
            long wallNanos = System.nanoTime() - split.getCreatedNanos();
            this.splitWallTime.add(Duration.succinctNanos((long)wallNanos));
            if (this.intermediateSplits.remove(split)) {
                this.intermediateSplitWallTime.add(wallNanos);
                this.intermediateSplitScheduledTime.add(split.getScheduledNanos());
                this.intermediateSplitWaitTime.add(split.getWaitNanos());
                this.intermediateSplitCpuTime.add(split.getCpuTimeNanos());
            } else {
                this.leafSplitWallTime.add(wallNanos);
                this.leafSplitScheduledTime.add(split.getScheduledNanos());
                this.leafSplitWaitTime.add(split.getWaitNanos());
                this.leafSplitCpuTime.add(split.getCpuTimeNanos());
            }
            TimeSharingTaskHandle taskHandle = split.getTaskHandle();
            taskHandle.splitComplete(split);
            this.scheduleTaskIfNecessary(taskHandle);
            this.addNewEntrants();
            this.recordLeafSplitsSize();
        }
        split.destroy();
    }

    private synchronized void scheduleTaskIfNecessary(TimeSharingTaskHandle taskHandle) {
        int splitsToSchedule = Math.min(this.guaranteedNumberOfDriversPerTask, taskHandle.getMaxDriversPerTask().orElse(Integer.MAX_VALUE)) - taskHandle.getRunningLeafSplits();
        for (int i = 0; i < splitsToSchedule; ++i) {
            PrioritizedSplitRunner split = taskHandle.pollNextSplit();
            if (split == null) {
                return;
            }
            this.startSplit(split);
            this.splitQueuedTime.add(Duration.nanosSince((long)split.getCreatedNanos()));
        }
        this.recordLeafSplitsSize();
    }

    private synchronized void addNewEntrants() {
        PrioritizedSplitRunner split;
        int running = this.allSplits.size() - this.intermediateSplits.size();
        for (int i = 0; i < this.minimumNumberOfDrivers - running && (split = this.pollNextSplitWorker()) != null; ++i) {
            this.splitQueuedTime.add(Duration.nanosSince((long)split.getCreatedNanos()));
            this.startSplit(split);
        }
    }

    private synchronized void startIntermediateSplit(PrioritizedSplitRunner split) {
        this.startSplit(split);
        this.intermediateSplits.add(split);
    }

    private synchronized void startSplit(PrioritizedSplitRunner split) {
        this.allSplits.add(split);
        this.waitingSplits.offer(split);
    }

    private synchronized PrioritizedSplitRunner pollNextSplitWorker() {
        Iterator<TimeSharingTaskHandle> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            PrioritizedSplitRunner split;
            TimeSharingTaskHandle task = iterator.next();
            if (task.getRunningLeafSplits() >= task.getMaxDriversPerTask().orElse(this.maximumNumberOfDriversPerTask) || (split = task.pollNextSplit()) == null) continue;
            iterator.remove();
            this.tasks.add(task);
            return split;
        }
        return null;
    }

    private synchronized void recordLeafSplitsSize() {
        long now = this.ticker.read();
        long timeDifference = now - this.lastLeafSplitsSizeRecordTime;
        if (timeDifference > 0L) {
            this.leafSplitsSize.add(this.lastLeafSplitsSize, timeDifference);
            this.lastLeafSplitsSizeRecordTime = now;
        }
        this.lastLeafSplitsSize = this.allSplits.size() - this.intermediateSplits.size();
    }

    @Managed
    public synchronized int getTasks() {
        return this.tasks.size();
    }

    @Managed
    public int getRunnerThreads() {
        return this.runnerThreads;
    }

    @Managed
    public int getMinimumNumberOfDrivers() {
        return this.minimumNumberOfDrivers;
    }

    @Managed
    public synchronized int getTotalSplits() {
        return this.allSplits.size();
    }

    @Managed
    public synchronized int getIntermediateSplits() {
        return this.intermediateSplits.size();
    }

    @Managed
    public int getWaitingSplits() {
        return this.waitingSplits.size();
    }

    @Managed
    @Nested
    public DistributionStat getLeafSplitsSize() {
        return this.leafSplitsSize;
    }

    @Managed
    public synchronized int getCurrentLeafSplitsSize() {
        return this.allSplits.size() - this.intermediateSplits.size();
    }

    @Managed
    public int getRunningSplits() {
        return this.runningSplits.size();
    }

    @Managed
    public int getBlockedSplits() {
        return this.blockedSplits.size();
    }

    @Managed
    public long getCompletedTasksLevel0() {
        return this.completedTasksPerLevel.get(0);
    }

    @Managed
    public long getCompletedTasksLevel1() {
        return this.completedTasksPerLevel.get(1);
    }

    @Managed
    public long getCompletedTasksLevel2() {
        return this.completedTasksPerLevel.get(2);
    }

    @Managed
    public long getCompletedTasksLevel3() {
        return this.completedTasksPerLevel.get(3);
    }

    @Managed
    public long getCompletedTasksLevel4() {
        return this.completedTasksPerLevel.get(4);
    }

    @Managed
    public long getCompletedSplitsLevel0() {
        return this.completedSplitsPerLevel.get(0);
    }

    @Managed
    public long getCompletedSplitsLevel1() {
        return this.completedSplitsPerLevel.get(1);
    }

    @Managed
    public long getCompletedSplitsLevel2() {
        return this.completedSplitsPerLevel.get(2);
    }

    @Managed
    public long getCompletedSplitsLevel3() {
        return this.completedSplitsPerLevel.get(3);
    }

    @Managed
    public long getCompletedSplitsLevel4() {
        return this.completedSplitsPerLevel.get(4);
    }

    @Managed
    public long getRunningTasksLevel0() {
        return this.getRunningTasksForLevel(0);
    }

    @Managed
    public long getRunningTasksLevel1() {
        return this.getRunningTasksForLevel(1);
    }

    @Managed
    public long getRunningTasksLevel2() {
        return this.getRunningTasksForLevel(2);
    }

    @Managed
    public long getRunningTasksLevel3() {
        return this.getRunningTasksForLevel(3);
    }

    @Managed
    public long getRunningTasksLevel4() {
        return this.getRunningTasksForLevel(4);
    }

    @Managed
    @Nested
    public TimeStat getSplitQueuedTime() {
        return this.splitQueuedTime;
    }

    @Managed
    @Nested
    public TimeStat getSplitWallTime() {
        return this.splitWallTime;
    }

    @Managed
    @Nested
    public TimeStat getBlockedQuantaWallTime() {
        return this.blockedQuantaWallTime;
    }

    @Managed
    @Nested
    public TimeStat getUnblockedQuantaWallTime() {
        return this.unblockedQuantaWallTime;
    }

    @Managed
    @Nested
    public TimeDistribution getLeafSplitScheduledTime() {
        return this.leafSplitScheduledTime;
    }

    @Managed
    @Nested
    public TimeDistribution getIntermediateSplitScheduledTime() {
        return this.intermediateSplitScheduledTime;
    }

    @Managed
    @Nested
    public TimeDistribution getLeafSplitWallTime() {
        return this.leafSplitWallTime;
    }

    @Managed
    @Nested
    public TimeDistribution getIntermediateSplitWallTime() {
        return this.intermediateSplitWallTime;
    }

    @Managed
    @Nested
    public TimeDistribution getLeafSplitWaitTime() {
        return this.leafSplitWaitTime;
    }

    @Managed
    @Nested
    public TimeDistribution getIntermediateSplitWaitTime() {
        return this.intermediateSplitWaitTime;
    }

    @Managed
    @Nested
    public TimeDistribution getLeafSplitCpuTime() {
        return this.leafSplitCpuTime;
    }

    @Managed
    @Nested
    public TimeDistribution getIntermediateSplitCpuTime() {
        return this.intermediateSplitCpuTime;
    }

    @Managed
    @Nested
    public CounterStat getGlobalScheduledTimeMicros() {
        return this.globalScheduledTimeMicros;
    }

    @Managed
    @Nested
    public CounterStat getGlobalCpuTimeMicros() {
        return this.globalCpuTimeMicros;
    }

    private synchronized int getRunningTasksForLevel(int level) {
        int count = 0;
        for (TimeSharingTaskHandle task : this.tasks) {
            if (task.getPriority().getLevel() != level) continue;
            ++count;
        }
        return count;
    }

    public String getMaxActiveSplitsInfo() {
        StringBuilder stackTrace = new StringBuilder();
        int maxActiveSplitCount = 0;
        String message = "%s splits have been continuously active for more than %s seconds\n";
        for (RunningSplitInfo splitInfo : this.runningSplitInfos) {
            Duration duration = Duration.succinctNanos((long)(this.ticker.read() - splitInfo.getStartTime()));
            if (duration.compareTo(this.stuckSplitsWarningThreshold) < 0) continue;
            ++maxActiveSplitCount;
            stackTrace.append("\n");
            stackTrace.append(String.format("\"%s\" tid=%s", splitInfo.getThreadId(), splitInfo.getThread().threadId())).append("\n");
            for (StackTraceElement traceElement : splitInfo.getThread().getStackTrace()) {
                stackTrace.append("\tat ").append(traceElement).append("\n");
            }
        }
        return String.format(message, maxActiveSplitCount, this.stuckSplitsWarningThreshold).concat(stackTrace.toString());
    }

    @Managed
    public long getRunAwaySplitCount() {
        int count = 0;
        for (RunningSplitInfo splitInfo : this.runningSplitInfos) {
            Duration duration = Duration.succinctNanos((long)(this.ticker.read() - splitInfo.getStartTime()));
            if (duration.compareTo(this.stuckSplitsWarningThreshold) <= 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Set<TaskId> getStuckSplitTaskIds(Duration processingDurationThreshold, Predicate<RunningSplitInfo> filter) {
        return (Set)this.runningSplitInfos.stream().filter(splitInfo -> {
            Duration splitProcessingDuration = Duration.succinctNanos((long)(this.ticker.read() - splitInfo.getStartTime()));
            return splitProcessingDuration.compareTo(processingDurationThreshold) > 0;
        }).filter(filter).map(RunningSplitInfo::getTaskId).collect(ImmutableSet.toImmutableSet());
    }

    @Managed(description="Task processor executor")
    @Nested
    public ThreadPoolExecutorMBean getProcessorExecutor() {
        return this.executorMBean;
    }

    private class TaskRunner
    implements Runnable {
        private final long runnerId = NEXT_RUNNER_ID.getAndIncrement();

        private TaskRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try (SetThreadName runnerName = new SetThreadName("SplitRunner-%s", new Object[]{this.runnerId});){
                while (!TimeSharingTaskExecutor.this.closed) {
                    PrioritizedSplitRunner split;
                    if (Thread.currentThread().isInterrupted()) return;
                    try {
                        split = TimeSharingTaskExecutor.this.waitingSplits.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        runnerName.close();
                        if (TimeSharingTaskExecutor.this.closed) return;
                        TimeSharingTaskExecutor.this.addRunnerThread();
                        return;
                    }
                    String threadId = String.valueOf(split.getTaskHandle().getTaskId()) + "-" + split.getSplitId();
                    try (SetThreadName splitName = new SetThreadName(threadId, new Object[0]);){
                        ListenableFuture<Void> blocked;
                        RunningSplitInfo splitInfo = new RunningSplitInfo(TimeSharingTaskExecutor.this.ticker.read(), threadId, Thread.currentThread(), split.getTaskHandle().getTaskId(), split::getInfo);
                        TimeSharingTaskExecutor.this.runningSplitInfos.add(splitInfo);
                        TimeSharingTaskExecutor.this.runningSplits.add(split);
                        try {
                            blocked = split.process();
                        }
                        finally {
                            TimeSharingTaskExecutor.this.runningSplitInfos.remove(splitInfo);
                            TimeSharingTaskExecutor.this.runningSplits.remove(split);
                        }
                        if (split.isFinished()) {
                            if (log.isDebugEnabled()) {
                                log.debug("%s is finished", new Object[]{split.getInfo()});
                            }
                            TimeSharingTaskExecutor.this.splitFinished(split);
                            continue;
                        }
                        if (blocked.isDone()) {
                            TimeSharingTaskExecutor.this.waitingSplits.offer(split);
                            continue;
                        }
                        TimeSharingTaskExecutor.this.blockedSplits.put(split, (Future<Void>)blocked);
                        blocked.addListener(() -> {
                            TimeSharingTaskExecutor.this.blockedSplits.remove(split);
                            split.resetLevelPriority();
                            TimeSharingTaskExecutor.this.waitingSplits.offer(split);
                        }, (Executor)TimeSharingTaskExecutor.this.executor);
                    }
                    catch (Throwable t) {
                        if (!split.isDestroyed()) {
                            if (t instanceof TrinoException) {
                                TrinoException trinoException = (TrinoException)t;
                                log.debug(t, "Error processing %s: %s: %s", new Object[]{split.getInfo(), trinoException.getErrorCode().getName(), trinoException.getMessage()});
                            } else {
                                log.debug(t, "Error processing %s", new Object[]{split.getInfo()});
                            }
                        }
                        split.markFailed(t);
                        TimeSharingTaskExecutor.this.splitFinished(split);
                    }
                    finally {
                        if (!Thread.interrupted() || !TimeSharingTaskExecutor.this.closed) continue;
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
            finally {
                if (!TimeSharingTaskExecutor.this.closed) {
                    TimeSharingTaskExecutor.this.addRunnerThread();
                }
            }
        }
    }
}

