/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.CatalogHandle;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class NodeRequirements {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(NodeRequirements.class);
    private final Optional<CatalogHandle> catalogHandle;
    private final Set<HostAddress> addresses;

    public NodeRequirements(Optional<CatalogHandle> catalogHandle, Set<HostAddress> addresses) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.addresses = ImmutableSet.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
    }

    public Optional<CatalogHandle> getCatalogHandle() {
        return this.catalogHandle;
    }

    public Set<HostAddress> getAddresses() {
        return this.addresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeRequirements that = (NodeRequirements)o;
        return Objects.equals(this.catalogHandle, that.catalogHandle) && Objects.equals(this.addresses, that.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.catalogHandle, this.addresses);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogHandle", this.catalogHandle).add("addresses", this.addresses).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf(this.catalogHandle, CatalogHandle::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes);
    }
}

