/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.inject.Inject;
import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.Managed;

public class StageExecutionStats {
    private static final int EXECUTION_FRACTION_RESCALE_FACTOR = 1000000;
    private final Map<String, CounterStat> outputEstimationKindCounters = new ConcurrentHashMap<String, CounterStat>();
    private final DistributionStat speculativeExecutionFractionDistribution = new DistributionStat();
    private final MBeanExporter mbeanExporter;

    @Inject
    public StageExecutionStats(MBeanExporter mbeanExporter) {
        this.mbeanExporter = Objects.requireNonNull(mbeanExporter, "mbeanExporter is null");
    }

    public void recordSourceOutputEstimationOnStageStart(String sourceOutputEstimationKind, int sourcesCount) {
        this.updateSourceOutputEstimationKindCounter(sourceOutputEstimationKind, sourcesCount);
    }

    public void recordSourcesFinishedOnStageStart(int sourcesCount) {
        this.updateSourceOutputEstimationKindCounter("finished", sourcesCount);
    }

    @Managed
    public void recordStageSpeculativeExecutionFraction(double fractionSpentSpeculative) {
        this.speculativeExecutionFractionDistribution.add((long)(fractionSpentSpeculative * 1000000.0));
    }

    private void updateSourceOutputEstimationKindCounter(String outputEstimationKind, int sourcesCount) {
        this.getCounterStat(outputEstimationKind).update((long)sourcesCount);
    }

    private CounterStat getCounterStat(String outputEstimationKind) {
        return this.outputEstimationKindCounters.computeIfAbsent(outputEstimationKind, ignored -> {
            CounterStat counter = new CounterStat();
            this.mbeanExporter.exportWithGeneratedName((Object)counter, StageExecutionStats.class, "output_size_estimation_" + outputEstimationKind);
            return counter;
        });
    }
}

