/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OperatorNotFoundException
extends TrinoException {
    private final OperatorType operatorType;
    private final TypeSignature returnType;
    private final List<Type> argumentTypes;

    public OperatorNotFoundException(OperatorType operatorType, List<? extends Type> argumentTypes, Throwable cause) {
        super((ErrorCodeSupplier)StandardErrorCode.OPERATOR_NOT_FOUND, OperatorNotFoundException.formatErrorMessage(operatorType, argumentTypes, Optional.empty()), cause);
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.returnType = null;
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    public OperatorNotFoundException(OperatorType operatorType, List<? extends Type> argumentTypes, TypeSignature returnType, Throwable cause) {
        super((ErrorCodeSupplier)StandardErrorCode.OPERATOR_NOT_FOUND, OperatorNotFoundException.formatErrorMessage(operatorType, argumentTypes, Optional.of(returnType)), cause);
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
    }

    private static String formatErrorMessage(OperatorType operatorType, List<? extends Type> argumentTypes, Optional<TypeSignature> returnType) {
        return switch (operatorType) {
            case OperatorType.ADD, OperatorType.SUBTRACT, OperatorType.MULTIPLY, OperatorType.DIVIDE, OperatorType.MODULUS, OperatorType.EQUAL, OperatorType.LESS_THAN, OperatorType.LESS_THAN_OR_EQUAL -> String.format("Cannot apply operator: %s %s %s", argumentTypes.get(0), operatorType.getOperator(), argumentTypes.get(1));
            case OperatorType.NEGATION -> String.format("Cannot negate %s", argumentTypes.get(0));
            case OperatorType.IS_DISTINCT_FROM -> String.format("Cannot check if %s is distinct from %s", argumentTypes.get(0), argumentTypes.get(1));
            case OperatorType.CAST -> String.format("Cannot cast %s to %s", argumentTypes.get(0), returnType.orElseThrow());
            case OperatorType.SUBSCRIPT -> String.format("Cannot use %s for subscript of %s", argumentTypes.get(1), argumentTypes.get(0));
            default -> String.format("Operator '%s'%s cannot be applied to %s", operatorType.getOperator(), returnType.map(value -> ":" + String.valueOf(value)).orElse(""), Joiner.on((String)", ").join(argumentTypes));
        };
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public TypeSignature getReturnType() {
        return this.returnType;
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }
}

