/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.GroupedMapAggregationState;
import io.trino.operator.aggregation.MapAggregationState;
import io.trino.operator.aggregation.SingleMapAggregationState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

public class MapAggregationStateFactory
implements AccumulatorStateFactory<MapAggregationState> {
    private final Type keyType;
    private final MethodHandle keyReadFlat;
    private final MethodHandle keyWriteFlat;
    private final MethodHandle keyHashFlat;
    private final MethodHandle keyDistinctFlatBlock;
    private final MethodHandle keyHashBlock;
    private final Type valueType;
    private final MethodHandle valueReadFlat;
    private final MethodHandle valueWriteFlat;

    public MapAggregationStateFactory(@TypeParameter(value="K") Type keyType, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER)) MethodHandle keyReadFlat, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FLAT_RETURN)) MethodHandle keyWriteFlat, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle keyHashFlat, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle keyDistinctFlatBlock, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle keyHashBlock, @TypeParameter(value="V") Type valueType, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"V"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER)) MethodHandle valueReadFlat, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"V"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FLAT_RETURN)) MethodHandle valueWriteFlat) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.keyReadFlat = Objects.requireNonNull(keyReadFlat, "keyReadFlat is null");
        this.keyWriteFlat = Objects.requireNonNull(keyWriteFlat, "keyWriteFlat is null");
        this.keyHashFlat = Objects.requireNonNull(keyHashFlat, "keyHashFlat is null");
        this.keyDistinctFlatBlock = Objects.requireNonNull(keyDistinctFlatBlock, "keyDistinctFlatBlock is null");
        this.keyHashBlock = Objects.requireNonNull(keyHashBlock, "keyHashBlock is null");
        this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        this.valueReadFlat = Objects.requireNonNull(valueReadFlat, "valueReadFlat is null");
        this.valueWriteFlat = Objects.requireNonNull(valueWriteFlat, "valueWriteFlat is null");
    }

    public MapAggregationState createSingleState() {
        return new SingleMapAggregationState(this.keyType, this.keyReadFlat, this.keyWriteFlat, this.keyHashFlat, this.keyDistinctFlatBlock, this.keyHashBlock, this.valueType, this.valueReadFlat, this.valueWriteFlat);
    }

    public MapAggregationState createGroupedState() {
        return new GroupedMapAggregationState(this.keyType, this.keyReadFlat, this.keyWriteFlat, this.keyHashFlat, this.keyDistinctFlatBlock, this.keyHashBlock, this.valueType, this.valueReadFlat, this.valueWriteFlat);
    }
}

