/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.histogram;

import io.airlift.slice.SizeOf;
import io.trino.operator.aggregation.histogram.HistogramState;
import io.trino.operator.aggregation.histogram.TypedHistogram;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

public class GroupedHistogramState
extends AbstractGroupedAccumulatorState
implements HistogramState {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedHistogramState.class);
    private final TypedHistogram histogram;

    public GroupedHistogramState(Type keyType, MethodHandle readFlat, MethodHandle writeFlat, MethodHandle hashFlat, MethodHandle distinctFlatBlock, MethodHandle hashBlock) {
        this.histogram = new TypedHistogram(keyType, readFlat, writeFlat, hashFlat, distinctFlatBlock, hashBlock, true);
    }

    public void ensureCapacity(int size) {
        this.histogram.setMaxGroupId(size);
    }

    @Override
    public void add(ValueBlock block, int position, long count) {
        this.histogram.add(Math.toIntExact(this.getGroupId()), block, position, count);
    }

    @Override
    public void writeAll(MapBlockBuilder out) {
        this.histogram.serialize(Math.toIntExact(this.getGroupId()), out);
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.histogram.getEstimatedSize();
    }
}

