/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.operator.index.IndexSnapshot;
import io.trino.operator.index.UpdateRequest;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class UnloadedIndexKeyRecordSet
implements RecordSet {
    private final List<Type> types;
    private final List<PageAndPositions> pageAndPositions;

    public UnloadedIndexKeyRecordSet(Session session, IndexSnapshot existingSnapshot, Set<Integer> channelsForDistinct, List<Type> types, List<UpdateRequest> requests, FlatHashStrategyCompiler hashStrategyCompiler) {
        Objects.requireNonNull(existingSnapshot, "existingSnapshot is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        Objects.requireNonNull(requests, "requests is null");
        int[] distinctChannels = Ints.toArray(channelsForDistinct);
        ArrayList<Type> distinctChannelTypes = new ArrayList<Type>(distinctChannels.length);
        for (int i = 0; i < distinctChannels.length; ++i) {
            distinctChannelTypes.add(types.get(distinctChannels[i]));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        GroupByHash groupByHash = GroupByHash.createGroupByHash(session, distinctChannelTypes, false, 10000, hashStrategyCompiler, UpdateMemory.NOOP);
        for (UpdateRequest request : requests) {
            Page page = request.getPage();
            Work<int[]> work = groupByHash.getGroupIds(page.getColumns(distinctChannels));
            boolean done = work.process();
            Verify.verify((boolean)done);
            int[] groupIds = work.getResult();
            int positionCount = page.getBlock(0).getPositionCount();
            int nextDistinctId = -1;
            int groupCount = groupByHash.getGroupCount();
            IntArrayList positions = new IntArrayList(groupCount);
            for (int position = 0; position < positionCount; ++position) {
                int groupId;
                if (UnloadedIndexKeyRecordSet.containsNullValue(position, page) || existingSnapshot.getJoinPosition(position, page) != -2L || nextDistinctId >= (groupId = groupIds[position])) continue;
                nextDistinctId = groupId;
                positions.add(position);
            }
            if (positions.isEmpty()) continue;
            builder.add((Object)new PageAndPositions(request, (IntList)positions));
        }
        this.pageAndPositions = builder.build();
    }

    public List<Type> getColumnTypes() {
        return this.types;
    }

    public UnloadedIndexKeyRecordCursor cursor() {
        return new UnloadedIndexKeyRecordCursor(this.types, this.pageAndPositions);
    }

    private static boolean containsNullValue(int position, Page page) {
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            Block block = page.getBlock(channel);
            if (!block.isNull(position)) continue;
            return true;
        }
        return false;
    }

    private static class PageAndPositions {
        private final UpdateRequest updateRequest;
        private final IntList positions;

        private PageAndPositions(UpdateRequest updateRequest, IntList positions) {
            this.updateRequest = Objects.requireNonNull(updateRequest, "updateRequest is null");
            this.positions = Objects.requireNonNull(positions, "positions is null");
        }

        private UpdateRequest getUpdateRequest() {
            return this.updateRequest;
        }

        private IntList getPositions() {
            return this.positions;
        }
    }

    public static class UnloadedIndexKeyRecordCursor
    implements RecordCursor {
        private final List<Type> types;
        private final Iterator<PageAndPositions> pageAndPositionsIterator;
        private Page page;
        private IntListIterator positionIterator;
        private int position;

        public UnloadedIndexKeyRecordCursor(List<Type> types, List<PageAndPositions> pageAndPositions) {
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.pageAndPositionsIterator = pageAndPositions.iterator();
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return this.types.get(field);
        }

        public boolean advanceNextPosition() {
            while (this.positionIterator == null || !this.positionIterator.hasNext()) {
                if (!this.pageAndPositionsIterator.hasNext()) {
                    return false;
                }
                PageAndPositions pageAndPositions = this.pageAndPositionsIterator.next();
                this.page = pageAndPositions.getUpdateRequest().getPage();
                Preconditions.checkState((this.types.size() == this.page.getChannelCount() ? 1 : 0) != 0);
                this.positionIterator = pageAndPositions.getPositions().iterator();
            }
            this.position = this.positionIterator.nextInt();
            return true;
        }

        public Page getPage() {
            return this.page;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean getBoolean(int field) {
            return this.types.get(field).getBoolean(this.page.getBlock(field), this.position);
        }

        public long getLong(int field) {
            return this.types.get(field).getLong(this.page.getBlock(field), this.position);
        }

        public double getDouble(int field) {
            return this.types.get(field).getDouble(this.page.getBlock(field), this.position);
        }

        public Slice getSlice(int field) {
            return this.types.get(field).getSlice(this.page.getBlock(field), this.position);
        }

        public Object getObject(int field) {
            return this.types.get(field).getObject(this.page.getBlock(field), this.position);
        }

        public boolean isNull(int field) {
            return this.page.getBlock(field).isNull(this.position);
        }

        public void close() {
        }
    }
}

