/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.spi.Page;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class InputChannels {
    private final int[] inputChannels;
    private final int[] eagerlyLoadedChannels;

    public InputChannels(int ... inputChannels) {
        this.inputChannels = (int[])inputChannels.clone();
        this.eagerlyLoadedChannels = new int[0];
    }

    public InputChannels(List<Integer> inputChannels) {
        this(inputChannels, (List<Integer>)ImmutableList.of());
    }

    public InputChannels(List<Integer> inputChannels, List<Integer> eagerlyLoadedChannels) {
        this.inputChannels = inputChannels.stream().mapToInt(Integer::intValue).toArray();
        this.eagerlyLoadedChannels = eagerlyLoadedChannels.stream().mapToInt(Integer::intValue).toArray();
    }

    public int size() {
        return this.inputChannels.length;
    }

    public List<Integer> getInputChannels() {
        return Collections.unmodifiableList(Ints.asList((int[])this.inputChannels));
    }

    public Page getInputChannels(Page page) {
        return page.getLoadedPage(this.inputChannels, this.eagerlyLoadedChannels);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)Arrays.toString(this.inputChannels)).toString();
    }
}

