/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.window.pattern.MatchAggregation;
import java.util.Arrays;
import java.util.List;

class MatchAggregations {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(MatchAggregations.class);
    private MatchAggregation[][] values;
    private final List<MatchAggregation.MatchAggregationInstantiator> aggregationInstantiators;
    private final AggregatedMemoryContext memoryContext;
    private long valuesSize;
    private final long listSize;

    public MatchAggregations(int capacity, List<MatchAggregation.MatchAggregationInstantiator> aggregationInstantiators, AggregatedMemoryContext memoryContext) {
        this.values = new MatchAggregation[capacity][];
        this.aggregationInstantiators = aggregationInstantiators;
        this.memoryContext = memoryContext;
        this.valuesSize = 0L;
        this.listSize = SizeOf.sizeOf((Object[])new MatchAggregation[aggregationInstantiators.size()]);
    }

    public MatchAggregation[] get(int key) {
        if (this.values[key] == null) {
            MatchAggregation[] aggregations = new MatchAggregation[this.aggregationInstantiators.size()];
            for (int i = 0; i < this.aggregationInstantiators.size(); ++i) {
                aggregations[i] = this.aggregationInstantiators.get(i).get(this.memoryContext);
                this.values[key] = aggregations;
            }
            this.valuesSize += this.listSize;
        }
        return this.values[key];
    }

    public void release(int key) {
        if (this.values[key] != null) {
            this.valuesSize -= this.listSize;
            this.values[key] = null;
        }
    }

    public void copy(int parent, int child) {
        this.ensureCapacity(child);
        Preconditions.checkState((this.values[child] == null ? 1 : 0) != 0, (Object)"overriding aggregations for child thread");
        if (this.values[parent] != null) {
            MatchAggregation[] aggregations = new MatchAggregation[this.aggregationInstantiators.size()];
            for (int i = 0; i < this.aggregationInstantiators.size(); ++i) {
                aggregations[i] = this.values[parent][i].copy();
                this.values[child] = aggregations;
            }
            this.valuesSize += this.listSize;
        }
    }

    private void ensureCapacity(int key) {
        if (key >= this.values.length) {
            this.values = (MatchAggregation[][])Arrays.copyOf(this.values, Math.max(this.values.length * 2, key + 1));
        }
    }

    public long getSizeInBytes() {
        return INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.values) + this.valuesSize;
    }
}

