/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.OAuth2TokenHandler;
import jakarta.annotation.PreDestroy;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public class OAuth2TokenExchange
implements OAuth2TokenHandler {
    public static final Duration MAX_POLL_TIME = new Duration(10.0, TimeUnit.SECONDS);
    private static final TokenPoll TOKEN_POLL_TIMED_OUT = TokenPoll.error("Authentication has timed out");
    private static final TokenPoll TOKEN_POLL_DROPPED = TokenPoll.error("Authentication has been finished by the client");
    private final LoadingCache<String, SettableFuture<TokenPoll>> cache;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"oauth2-token-exchange"));

    @Inject
    public OAuth2TokenExchange(OAuth2Config config) {
        final long challengeTimeoutMillis = config.getChallengeTimeout().toMillis();
        this.cache = OAuth2TokenExchange.buildUnsafeCache(CacheBuilder.newBuilder().expireAfterWrite(challengeTimeoutMillis + MAX_POLL_TIME.toMillis() * 10L, TimeUnit.MILLISECONDS).removalListener(notification -> ((SettableFuture)notification.getValue()).set((Object)TOKEN_POLL_TIMED_OUT)), new CacheLoader<String, SettableFuture<TokenPoll>>(){

            public SettableFuture<TokenPoll> load(String authIdHash) {
                SettableFuture future = SettableFuture.create();
                ScheduledFuture<Boolean> timeout = OAuth2TokenExchange.this.executor.schedule(() -> future.set((Object)TOKEN_POLL_TIMED_OUT), challengeTimeoutMillis, TimeUnit.MILLISECONDS);
                future.addListener(() -> timeout.cancel(true), (Executor)OAuth2TokenExchange.this.executor);
                return future;
            }
        });
    }

    @SuppressModernizer
    private static <K, V> LoadingCache<K, V> buildUnsafeCache(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
        return cacheBuilder.build(cacheLoader);
    }

    @PreDestroy
    public void stop() {
        this.executor.shutdownNow();
    }

    @Override
    public void setAccessToken(String authIdHash, String accessToken) {
        ((SettableFuture)this.cache.getUnchecked((Object)authIdHash)).set((Object)TokenPoll.token(accessToken));
    }

    @Override
    public void setTokenExchangeError(String authIdHash, String message) {
        ((SettableFuture)this.cache.getUnchecked((Object)authIdHash)).set((Object)TokenPoll.error(message));
    }

    public ListenableFuture<TokenPoll> getTokenPoll(UUID authId) {
        return Futures.nonCancellationPropagating((ListenableFuture)((ListenableFuture)this.cache.getUnchecked((Object)OAuth2TokenExchange.hashAuthId(authId))));
    }

    public void dropToken(UUID authId) {
        ((SettableFuture)this.cache.getUnchecked((Object)OAuth2TokenExchange.hashAuthId(authId))).set((Object)TOKEN_POLL_DROPPED);
    }

    public static String hashAuthId(UUID authId) {
        return Hashing.sha256().hashString((CharSequence)authId.toString(), StandardCharsets.UTF_8).toString();
    }

    public static class TokenPoll {
        private final Optional<String> token;
        private final Optional<String> error;

        private TokenPoll(String token, String error) {
            this.token = Optional.ofNullable(token);
            this.error = Optional.ofNullable(error);
        }

        static TokenPoll token(String token) {
            Objects.requireNonNull(token, "token is null");
            return new TokenPoll(token, null);
        }

        static TokenPoll error(String error) {
            Objects.requireNonNull(error, "error is null");
            return new TokenPoll(null, error);
        }

        public Optional<String> getToken() {
            return this.token;
        }

        public Optional<String> getError() {
            return this.error;
        }
    }
}

