/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class MultipartUiCookie {
    public static final int MAXIMUM_COOKIE_SIZE = 4096;
    private final String cookieName;
    private final Pattern cookiePattern;
    private final String location;

    public MultipartUiCookie(String cookieName, String location) {
        this.cookieName = Objects.requireNonNull(cookieName, "cookieName is null");
        this.cookiePattern = Pattern.compile("^" + Pattern.quote(cookieName) + "(_\\d+)?$");
        this.location = Objects.requireNonNull(location, "location is null");
    }

    public NewCookie[] create(String token, Instant tokenExpiration, boolean isSecure) {
        Date expiration = Optional.ofNullable(tokenExpiration).map(Date::from).orElse(null);
        ImmutableList.Builder cookiesToSet = ImmutableList.builder();
        int index = 0;
        for (String part : this.splitValueByLength(token)) {
            cookiesToSet.add((Object)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(this.cookieName(index++)).value(part)).path(this.location)).domain(null)).comment(null)).maxAge(-1)).expiry(expiration)).secure(isSecure)).httpOnly(true)).build());
        }
        return (NewCookie[])cookiesToSet.build().toArray((Object[])new NewCookie[0]);
    }

    public Optional<String> read(Map<String, Cookie> existingCookies) {
        long cookiesCount = existingCookies.values().stream().filter(this::matchesName).filter(cookie -> !Strings.isNullOrEmpty((String)cookie.getValue())).count();
        if (cookiesCount == 0L) {
            return Optional.empty();
        }
        StringBuilder token = new StringBuilder();
        int i = 0;
        while ((long)i < cookiesCount) {
            Cookie cookie2 = existingCookies.get(this.cookieName(i));
            if (cookie2 == null || Strings.isNullOrEmpty((String)cookie2.getValue())) {
                return Optional.empty();
            }
            token.append(cookie2.getValue());
            ++i;
        }
        return Optional.of(token.toString());
    }

    public NewCookie[] delete(Map<String, Cookie> existingCookies, boolean isSecured) {
        ImmutableSet.Builder cookiesToDelete = ImmutableSet.builder();
        cookiesToDelete.add((Object)this.deleteCookie(this.cookieName, isSecured));
        for (Cookie existingCookie : existingCookies.values()) {
            if (!this.matchesName(existingCookie)) continue;
            cookiesToDelete.add((Object)this.deleteCookie(existingCookie.getName(), isSecured));
        }
        return (NewCookie[])cookiesToDelete.build().toArray((Object[])new NewCookie[0]);
    }

    private List<String> splitValueByLength(String value) {
        return Splitter.fixedLength((int)this.maximumCookieValueLength()).splitToList((CharSequence)value);
    }

    private boolean matchesName(Cookie cookie) {
        return this.cookiePattern.matcher(cookie.getName()).matches();
    }

    @VisibleForTesting
    String cookieName(int index) {
        if (index == 0) {
            return this.cookieName;
        }
        return this.cookieName + "_" + index;
    }

    int maximumCookieValueLength() {
        return 4096 - this.cookieName(999).length();
    }

    private NewCookie deleteCookie(String name, boolean isSecured) {
        return ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(name).value("delete")).path(this.location)).domain(null)).maxAge(0)).expiry(null)).secure(isSecured)).httpOnly(true)).build();
    }
}

