/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TranslationMap;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.type.TypeCoercion;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConstantEvaluator {
    private ConstantEvaluator() {
    }

    public static Object evaluateConstant(io.trino.sql.tree.Expression expression, Type expectedType, PlannerContext plannerContext, Session session, AccessControl accessControl) {
        Analysis analysis = new Analysis(null, (Map<NodeRef<Parameter>, io.trino.sql.tree.Expression>)ImmutableMap.of(), QueryType.OTHERS);
        Scope scope = Scope.create();
        ExpressionAnalyzer.analyzeExpressionWithoutSubqueries(session, plannerContext, accessControl, scope, analysis, expression, (ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery", WarningCollector.NOOP, CorrelationSupport.DISALLOWED);
        TranslationMap translationMap = new TranslationMap(Optional.empty(), scope, analysis, (Map<NodeRef<LambdaArgumentDeclaration>, Symbol>)ImmutableMap.of(), (List<Symbol>)ImmutableList.of(), session, plannerContext);
        Expression rewritten = translationMap.rewrite(expression);
        Type actualType = rewritten.type();
        if (!new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0)).canCoerce(actualType, expectedType)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "Cannot cast type %s to %s", actualType.getDisplayName(), expectedType.getDisplayName());
        }
        if (!actualType.equals((Object)expectedType)) {
            rewritten = new Cast(rewritten, expectedType, false);
        }
        return new IrExpressionInterpreter(rewritten, plannerContext, session).evaluate();
    }
}

