/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.math.IntMath;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.execution.Column;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.FunctionResolver;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableFunctionMetadata;
import io.trino.metadata.TableFunctionRegistry;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayout;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableProceduresPropertyManager;
import io.trino.metadata.TableProceduresRegistry;
import io.trino.metadata.TablePropertyManager;
import io.trino.metadata.TableSchema;
import io.trino.metadata.TableVersion;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.security.InjectedConnectorAccessControl;
import io.trino.security.SecurityContext;
import io.trino.security.ViewAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCodeSupplier;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.PointerType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.StandardWarningCode;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ArgumentSpecification;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.DescriptorArgument;
import io.trino.spi.function.table.DescriptorArgumentSpecification;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableArgument;
import io.trino.spi.function.table.TableArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.VarcharType;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.NodeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlFormatter;
import io.trino.sql.analyzer.AggregationAnalyzer;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.CanonicalizationAware;
import io.trino.sql.analyzer.ConstantEvaluator;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.DeterminismEvaluator;
import io.trino.sql.analyzer.ExpressionAnalysis;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.FieldId;
import io.trino.sql.analyzer.JsonPathAnalyzer;
import io.trino.sql.analyzer.NamesExtractor;
import io.trino.sql.analyzer.OutputColumn;
import io.trino.sql.analyzer.PatternRecognitionAnalysis;
import io.trino.sql.analyzer.PatternRecognitionAnalyzer;
import io.trino.sql.analyzer.RelationId;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.ScopeReferenceExtractor;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.SessionTimeProvider;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.analyzer.WindowFunctionValidator;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.AllRows;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.CallArgument;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.Deny;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DropCatalog;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.DropNotNullConstraint;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.EmptyTableTreatment;
import io.trino.sql.tree.Except;
import io.trino.sql.tree.Execute;
import io.trino.sql.tree.ExecuteImmediate;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GroupBy;
import io.trino.sql.tree.GroupingElement;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.GroupingSets;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.Intersect;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.JoinCriteria;
import io.trino.sql.tree.JoinOn;
import io.trino.sql.tree.JoinUsing;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonTable;
import io.trino.sql.tree.JsonTableColumnDefinition;
import io.trino.sql.tree.JsonTableSpecificPlan;
import io.trino.sql.tree.Lateral;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Merge;
import io.trino.sql.tree.MergeCase;
import io.trino.sql.tree.MergeDelete;
import io.trino.sql.tree.MergeInsert;
import io.trino.sql.tree.MergeUpdate;
import io.trino.sql.tree.NaturalJoin;
import io.trino.sql.tree.NestedColumns;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.OrdinalityColumn;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.PlanLeaf;
import io.trino.sql.tree.PlanParentChild;
import io.trino.sql.tree.PlanSiblings;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QueryBody;
import io.trino.sql.tree.QueryColumn;
import io.trino.sql.tree.QueryPeriod;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.RenameColumn;
import io.trino.sql.tree.RenameMaterializedView;
import io.trino.sql.tree.RenameSchema;
import io.trino.sql.tree.RenameTable;
import io.trino.sql.tree.RenameView;
import io.trino.sql.tree.ResetSession;
import io.trino.sql.tree.ResetSessionAuthorization;
import io.trino.sql.tree.Revoke;
import io.trino.sql.tree.Rollback;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SampledRelation;
import io.trino.sql.tree.SaveMode;
import io.trino.sql.tree.SecurityCharacteristic;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.SetColumnType;
import io.trino.sql.tree.SetOperation;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.SetSchemaAuthorization;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.SetSessionAuthorization;
import io.trino.sql.tree.SetTableAuthorization;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.SetViewAuthorization;
import io.trino.sql.tree.SimpleGroupBy;
import io.trino.sql.tree.SingleColumn;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableExecute;
import io.trino.sql.tree.TableFunctionArgument;
import io.trino.sql.tree.TableFunctionDescriptorArgument;
import io.trino.sql.tree.TableFunctionInvocation;
import io.trino.sql.tree.TableFunctionTableArgument;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.TruncateTable;
import io.trino.sql.tree.Union;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.UpdateAssignment;
import io.trino.sql.tree.Use;
import io.trino.sql.tree.ValueColumn;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.tree.Window;
import io.trino.sql.tree.WindowDefinition;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import io.trino.sql.tree.With;
import io.trino.sql.tree.WithQuery;
import io.trino.sql.util.AstUtils;
import io.trino.transaction.TransactionManager;
import io.trino.type.TypeCoercion;
import io.trino.type.UnknownType;
import io.trino.util.MoreLists;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StatementAnalyzer {
    private static final Set<String> WINDOW_VALUE_FUNCTIONS = ImmutableSet.of((Object)"lead", (Object)"lag", (Object)"first_value", (Object)"last_value", (Object)"nth_value");
    private final StatementAnalyzerFactory statementAnalyzerFactory;
    private final Analysis analysis;
    private final Metadata metadata;
    private final PlannerContext plannerContext;
    private final TypeCoercion typeCoercion;
    private final Session session;
    private final SqlParser sqlParser;
    private final SessionTimeProvider sessionTimeProvider;
    private final GroupProvider groupProvider;
    private final AccessControl accessControl;
    private final TransactionManager transactionManager;
    private final TableProceduresRegistry tableProceduresRegistry;
    private final TableFunctionRegistry tableFunctionRegistry;
    private final TablePropertyManager tablePropertyManager;
    private final AnalyzePropertyManager analyzePropertyManager;
    private final TableProceduresPropertyManager tableProceduresPropertyManager;
    private final FunctionResolver functionResolver;
    private final WarningCollector warningCollector;
    private final CorrelationSupport correlationSupport;

    StatementAnalyzer(StatementAnalyzerFactory statementAnalyzerFactory, Analysis analysis, PlannerContext plannerContext, SqlParser sqlParser, SessionTimeProvider sessionTimeProvider, GroupProvider groupProvider, AccessControl accessControl, TransactionManager transactionManager, Session session, TableProceduresRegistry tableProceduresRegistry, TableFunctionRegistry tableFunctionRegistry, TablePropertyManager tablePropertyManager, AnalyzePropertyManager analyzePropertyManager, TableProceduresPropertyManager tableProceduresPropertyManager, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.metadata = plannerContext.getMetadata();
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.sessionTimeProvider = Objects.requireNonNull(sessionTimeProvider, "sessionTimeProvider is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.tableProceduresRegistry = Objects.requireNonNull(tableProceduresRegistry, "tableProceduresRegistry is null");
        this.tableFunctionRegistry = Objects.requireNonNull(tableFunctionRegistry, "tableFunctionRegistry is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.analyzePropertyManager = Objects.requireNonNull(analyzePropertyManager, "analyzePropertyManager is null");
        this.tableProceduresPropertyManager = tableProceduresPropertyManager;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.correlationSupport = Objects.requireNonNull(correlationSupport, "correlationSupport is null");
        this.functionResolver = plannerContext.getFunctionResolver(warningCollector);
    }

    public Scope analyze(Node node) {
        return this.analyze(node, Optional.empty(), true);
    }

    public Scope analyze(Node node, Scope outerQueryScope) {
        return this.analyze(node, Optional.of(outerQueryScope), false);
    }

    private Scope analyze(Node node, Optional<Scope> outerQueryScope, boolean isTopLevel) {
        return new Visitor(outerQueryScope, this.warningCollector, Optional.empty(), isTopLevel).process(node, Optional.empty());
    }

    private Scope analyzeForUpdate(Relation relation, Optional<Scope> outerQueryScope, UpdateKind updateKind) {
        return new Visitor(outerQueryScope, this.warningCollector, Optional.of(updateKind), true).process((Node)relation, Optional.empty());
    }

    private static boolean hasScopeAsLocalParent(Scope root, Scope parent) {
        Scope scope = root;
        while (scope.getLocalParent().isPresent()) {
            if (!(scope = scope.getLocalParent().get()).equals(parent)) continue;
            return true;
        }
        return false;
    }

    private final class Visitor
    extends AstVisitor<Scope, Optional<Scope>> {
        private final boolean isTopLevel;
        private final Optional<Scope> outerQueryScope;
        private final WarningCollector warningCollector;
        private final Optional<UpdateKind> updateKind;

        private Visitor(Optional<Scope> outerQueryScope, WarningCollector warningCollector, Optional<UpdateKind> updateKind, boolean isTopLevel) {
            this.outerQueryScope = Objects.requireNonNull(outerQueryScope, "outerQueryScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.updateKind = Objects.requireNonNull(updateKind, "updateKind is null");
            this.isTopLevel = isTopLevel;
        }

        public Scope process(Node node, Optional<Scope> scope) {
            Scope returnScope = (Scope)super.process(node, scope);
            Preconditions.checkState((boolean)returnScope.getOuterQueryParent().equals(this.outerQueryScope), (Object)"result scope should have outer query scope equal with parameter outer query scope");
            scope.ifPresent(value -> Preconditions.checkState((boolean)StatementAnalyzer.hasScopeAsLocalParent(returnScope, value), (Object)"return scope should have context scope as one of its ancestors"));
            return returnScope;
        }

        private Scope process(Node node, Scope scope) {
            return this.process(node, Optional.of(scope));
        }

        protected Scope visitNode(Node node, Optional<Scope> context) {
            throw new IllegalStateException("Unsupported node type: " + node.getClass().getName());
        }

        protected Scope visitUse(Use node, Optional<Scope> scope) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "USE statement is not supported", new Object[0]);
        }

        protected Scope visitInsert(Insert insert, Optional<Scope> scope) {
            List insertColumns;
            QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)insert, insert.getTarget());
            if (StatementAnalyzer.this.metadata.isMaterializedView(StatementAnalyzer.this.session, targetTable)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)insert, "Inserting into materialized views is not supported", new Object[0]);
            }
            if (StatementAnalyzer.this.metadata.isView(StatementAnalyzer.this.session, targetTable)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)insert, "Inserting into views is not supported", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setUpdateType("INSERT");
            Scope queryScope = StatementAnalyzer.this.analyze((Node)insert.getQuery(), Optional.empty(), false);
            RedirectionAwareTableHandle redirection = StatementAnalyzer.this.metadata.getRedirectionAwareTableHandle(StatementAnalyzer.this.session, targetTable);
            Optional<TableHandle> targetTableHandle = redirection.tableHandle();
            targetTable = redirection.redirectedTableName().orElse(targetTable);
            if (targetTableHandle.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)insert, "Table '%s' does not exist", targetTable);
            }
            StatementAnalyzer.this.accessControl.checkCanInsertIntoTable(StatementAnalyzer.this.session.toSecurityContext(), targetTable);
            TableSchema tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.session, targetTableHandle.get());
            List columns = (List)tableSchema.columns().stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList());
            List checkConstraints = tableSchema.tableSchema().getCheckConstraints();
            for (ColumnSchema column2 : columns) {
                if (!StatementAnalyzer.this.accessControl.getColumnMask(StatementAnalyzer.this.session.toSecurityContext(), targetTable, column2.getName(), column2.getType()).isPresent()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)insert, "Insert into table with column masks is not supported", new Object[0]);
            }
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, targetTableHandle.get());
            List<Field> tableFields = this.analyzeTableOutputFields(insert.getTable(), targetTable, tableSchema, columnHandles);
            Scope accessControlScope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(tableFields)).build();
            this.analyzeFiltersAndMasks(insert.getTable(), targetTable, new RelationType(tableFields), accessControlScope);
            this.analyzeCheckConstraints(insert.getTable(), targetTable, accessControlScope, checkConstraints);
            StatementAnalyzer.this.analysis.registerTable(insert.getTable(), targetTableHandle, targetTable, StatementAnalyzer.this.session.getIdentity().getUser(), accessControlScope, Optional.empty());
            List tableColumns = (List)columns.stream().map(ColumnSchema::getName).collect(ImmutableList.toImmutableList());
            Optional<TableLayout> newTableLayout = StatementAnalyzer.this.metadata.getInsertLayout(StatementAnalyzer.this.session, targetTableHandle.get());
            newTableLayout.ifPresent(layout -> {
                if (!ImmutableSet.copyOf((Collection)tableColumns).containsAll(layout.getPartitionColumns())) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT must write all distribution columns: " + String.valueOf(layout.getPartitionColumns()));
                }
            });
            if (insert.getColumns().isPresent()) {
                insertColumns = (List)((List)insert.getColumns().get()).stream().map(Identifier::getValue).map(column -> column.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
                HashSet<String> columnNames = new HashSet<String>();
                for (String insertColumn2 : insertColumns) {
                    if (!tableColumns.contains(insertColumn2)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)insert, "Insert column name does not exist in target table: %s", insertColumn2);
                    }
                    if (columnNames.add(insertColumn2)) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)insert, "Insert column name is specified more than once: %s", insertColumn2);
                }
            } else {
                insertColumns = tableColumns;
            }
            StatementAnalyzer.this.analysis.setInsert(new Analysis.Insert(insert.getTable(), targetTableHandle.get(), (List)insertColumns.stream().map(columnHandles::get).collect(ImmutableList.toImmutableList()), newTableLayout));
            List tableTypes = (List)insertColumns.stream().map(insertColumn -> tableSchema.column((String)insertColumn).getType()).collect(ImmutableList.toImmutableList());
            List queryTypes = (List)queryScope.getRelationType().getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            if (!this.typesMatchForInsert(tableTypes, queryTypes)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)insert, "Insert query has mismatched column types: Table: [%s], Query: [%s]", Joiner.on((String)", ").join((Iterable)tableTypes), Joiner.on((String)", ").join((Iterable)queryTypes));
            }
            Stream columnStream = Streams.zip(insertColumns.stream(), tableTypes.stream().map(Type::toString), Column::new);
            StatementAnalyzer.this.analysis.setUpdateTarget(targetTableHandle.get().catalogHandle().getVersion(), targetTable, Optional.empty(), Optional.of((List)Streams.zip((Stream)columnStream, queryScope.getRelationType().getVisibleFields().stream(), (column, field) -> new OutputColumn((Column)column, StatementAnalyzer.this.analysis.getSourceColumns((Field)field))).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)insert, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitRefreshMaterializedView(RefreshMaterializedView refreshMaterializedView, Optional<Scope> scope) {
            QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)refreshMaterializedView, refreshMaterializedView.getName());
            MaterializedViewDefinition view = StatementAnalyzer.this.metadata.getMaterializedView(StatementAnalyzer.this.session, name).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)refreshMaterializedView, "Materialized view '%s' does not exist", name));
            StatementAnalyzer.this.accessControl.checkCanRefreshMaterializedView(StatementAnalyzer.this.session.toSecurityContext(), name);
            StatementAnalyzer.this.analysis.setUpdateType("REFRESH MATERIALIZED VIEW");
            CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, (Node)refreshMaterializedView, name.catalogName());
            if (StatementAnalyzer.this.metadata.delegateMaterializedViewRefreshToConnector(StatementAnalyzer.this.session, name)) {
                StatementAnalyzer.this.analysis.setDelegatedRefreshMaterializedView(name);
                StatementAnalyzer.this.analysis.setUpdateTarget(catalogHandle.getVersion(), name, Optional.empty(), Optional.empty());
                return this.createAndAssignScope((Node)refreshMaterializedView, scope);
            }
            QualifiedName storageName = this.getMaterializedViewStorageTableName(view).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)refreshMaterializedView, "Storage Table for materialized view '%s' does not exist", name));
            QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)refreshMaterializedView, storageName);
            this.checkStorageTableNotRedirected(targetTable);
            Query query = this.parseView(view.getOriginalSql(), name, (Node)refreshMaterializedView);
            Scope queryScope = this.process((Node)query, scope);
            TableHandle targetTableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, targetTable).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)refreshMaterializedView, "Table '%s' does not exist", targetTable));
            StatementAnalyzer.this.analysis.setSkipMaterializedViewRefresh(StatementAnalyzer.this.metadata.getMaterializedViewFreshness(StatementAnalyzer.this.session, name).getFreshness() == MaterializedViewFreshness.Freshness.FRESH);
            TableMetadata tableMetadata = StatementAnalyzer.this.metadata.getTableMetadata(StatementAnalyzer.this.session, targetTableHandle);
            List insertColumns = (List)tableMetadata.columns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, targetTableHandle);
            StatementAnalyzer.this.analysis.setRefreshMaterializedView(new Analysis.RefreshMaterializedViewAnalysis(refreshMaterializedView.getTable(), targetTableHandle, query, (List)insertColumns.stream().map(columnHandles::get).collect(ImmutableList.toImmutableList())));
            List tableTypes = (List)insertColumns.stream().map(insertColumn -> tableMetadata.column((String)insertColumn).getType()).collect(ImmutableList.toImmutableList());
            Stream columns = Streams.zip(insertColumns.stream(), tableTypes.stream().map(Type::toString), Column::new);
            StatementAnalyzer.this.analysis.setUpdateTarget(catalogHandle.getVersion(), name, Optional.empty(), Optional.of((List)Streams.zip((Stream)columns, queryScope.getRelationType().getVisibleFields().stream(), (column, field) -> new OutputColumn((Column)column, StatementAnalyzer.this.analysis.getSourceColumns((Field)field))).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)refreshMaterializedView, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        private boolean typesMatchForInsert(List<Type> tableTypes, List<Type> queryTypes) {
            if (tableTypes.size() != queryTypes.size()) {
                return false;
            }
            for (int i = 0; i < tableTypes.size(); ++i) {
                if (!(this.hasNestedBoundedCharacterType(tableTypes.get(i)) ? !StatementAnalyzer.this.typeCoercion.canCoerce(queryTypes.get(i), tableTypes.get(i)) : !StatementAnalyzer.this.typeCoercion.isCompatible(queryTypes.get(i), tableTypes.get(i)))) continue;
                return false;
            }
            return true;
        }

        private boolean hasNestedBoundedCharacterType(Type type) {
            if (type instanceof ArrayType) {
                return this.hasBoundedCharacterType(((ArrayType)type).getElementType());
            }
            if (type instanceof MapType) {
                return this.hasBoundedCharacterType(((MapType)type).getKeyType()) || this.hasBoundedCharacterType(((MapType)type).getValueType());
            }
            if (type instanceof RowType) {
                for (Type fieldType : type.getTypeParameters()) {
                    if (!this.hasBoundedCharacterType(fieldType)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean hasBoundedCharacterType(Type type) {
            return type instanceof CharType || type instanceof VarcharType && !((VarcharType)type).isUnbounded() || this.hasNestedBoundedCharacterType(type);
        }

        protected Scope visitDelete(Delete node, Optional<Scope> scope) {
            Table table = node.getTable();
            QualifiedObjectName originalName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            if (StatementAnalyzer.this.metadata.isMaterializedView(StatementAnalyzer.this.session, originalName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Deleting from materialized views is not supported", new Object[0]);
            }
            if (StatementAnalyzer.this.metadata.isView(StatementAnalyzer.this.session, originalName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Deleting from views is not supported", new Object[0]);
            }
            RedirectionAwareTableHandle redirection = StatementAnalyzer.this.metadata.getRedirectionAwareTableHandle(StatementAnalyzer.this.session, originalName);
            QualifiedObjectName tableName = redirection.redirectedTableName().orElse(originalName);
            TableHandle handle = redirection.tableHandle().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)table, "Table '%s' does not exist", tableName));
            StatementAnalyzer.this.accessControl.checkCanDeleteFromTable(StatementAnalyzer.this.session.toSecurityContext(), tableName);
            TableSchema tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.session, handle);
            for (ColumnSchema tableColumn : tableSchema.columns()) {
                if (!StatementAnalyzer.this.accessControl.getColumnMask(StatementAnalyzer.this.session.toSecurityContext(), tableName, tableColumn.getName(), tableColumn.getType()).isPresent()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Delete from table with column mask", new Object[0]);
            }
            StatementAnalyzer analyzer = StatementAnalyzer.this.statementAnalyzerFactory.withSpecializedAccessControl(new AllowAllAccessControl()).createStatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope tableScope = analyzer.analyzeForUpdate((Relation)table, scope, UpdateKind.DELETE);
            node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, tableScope, (Expression)where));
            StatementAnalyzer.this.analysis.setUpdateType("DELETE");
            StatementAnalyzer.this.analysis.setUpdateTarget(handle.catalogHandle().getVersion(), tableName, Optional.of(table), Optional.empty());
            Scope accessControlScope = Scope.builder().withRelationType(RelationId.anonymous(), StatementAnalyzer.this.analysis.getScope((Node)table).getRelationType()).build();
            this.analyzeFiltersAndMasks(table, tableName, StatementAnalyzer.this.analysis.getScope((Node)table).getRelationType(), accessControlScope);
            this.analyzeCheckConstraints(table, tableName, accessControlScope, tableSchema.tableSchema().getCheckConstraints());
            StatementAnalyzer.this.analysis.registerTable(table, Optional.of(handle), tableName, StatementAnalyzer.this.session.getIdentity().getUser(), accessControlScope, Optional.empty());
            this.createMergeAnalysis(table, handle, tableSchema, tableScope, tableScope, (List<List<ColumnHandle>>)ImmutableList.of());
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitAnalyze(Analyze node, Optional<Scope> scope) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getTableName());
            if (StatementAnalyzer.this.metadata.isView(StatementAnalyzer.this.session, tableName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Analyzing views is not supported", new Object[0]);
            }
            TableHandle tableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, tableName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)node, "Table '%s' does not exist", tableName));
            StatementAnalyzer.this.analysis.setUpdateType("ANALYZE");
            StatementAnalyzer.this.analysis.setUpdateTarget(tableHandle.catalogHandle().getVersion(), tableName, Optional.empty(), Optional.empty());
            this.validateProperties(node.getProperties(), scope);
            String catalogName = tableName.catalogName();
            CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, (Node)node, catalogName);
            Map analyzeProperties = StatementAnalyzer.this.analyzePropertyManager.getProperties(catalogName, catalogHandle, (Iterable)node.getProperties(), StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.accessControl, (Map)StatementAnalyzer.this.analysis.getParameters(), true);
            StatementAnalyzer.this.analysis.setAnalyzeMetadata(StatementAnalyzer.this.metadata.getStatisticsCollectionMetadata(StatementAnalyzer.this.session, tableHandle, analyzeProperties));
            StatementAnalyzer.this.analysis.addTableColumnReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), (Multimap<QualifiedObjectName, String>)ImmutableMultimap.builder().putAll((Object)tableName, StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, tableHandle).keySet()).build());
            try {
                StatementAnalyzer.this.accessControl.checkCanInsertIntoTable(StatementAnalyzer.this.session.toSecurityContext(), tableName);
            }
            catch (AccessDeniedException exception) {
                throw new AccessDeniedException(String.format("Cannot ANALYZE (missing insert privilege) table %s", tableName), exception);
            }
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitCreateTableAsSelect(CreateTableAsSelect node, Optional<Scope> scope) {
            TableLayout layout;
            QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            Optional<TableHandle> targetTableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, targetTable);
            if (targetTableHandle.isPresent() && node.getSaveMode() != SaveMode.REPLACE) {
                if (node.getSaveMode() == SaveMode.IGNORE) {
                    StatementAnalyzer.this.analysis.setCreate(new Analysis.Create(Optional.of(targetTable), Optional.empty(), Optional.empty(), node.isWithData(), true, false));
                    StatementAnalyzer.this.analysis.setUpdateType("CREATE TABLE");
                    StatementAnalyzer.this.analysis.setUpdateTarget(targetTableHandle.get().catalogHandle().getVersion(), targetTable, Optional.empty(), Optional.of(ImmutableList.of()));
                    return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
                }
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)node, "Destination table '%s' already exists", targetTable);
            }
            this.validateProperties(node.getProperties(), scope);
            String catalogName = targetTable.catalogName();
            CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, (Node)node, catalogName);
            Map properties = StatementAnalyzer.this.tablePropertyManager.getProperties(catalogName, catalogHandle, (Iterable)node.getProperties(), StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.accessControl, (Map)StatementAnalyzer.this.analysis.getParameters(), true);
            Set specifiedPropertyKeys = (Set)node.getProperties().stream().map(property -> property.getName().getValue().toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
            Map explicitlySetProperties = (Map)properties.keySet().stream().peek(key -> Verify.verify((boolean)key.equals(key.toLowerCase(Locale.ENGLISH)), (String)"Property name '%s' not in lower-case", (Object)key)).filter(specifiedPropertyKeys::contains).collect(ImmutableMap.toImmutableMap(Function.identity(), properties::get));
            StatementAnalyzer.this.accessControl.checkCanCreateTable(StatementAnalyzer.this.session.toSecurityContext(), targetTable, explicitlySetProperties);
            Scope queryScope = StatementAnalyzer.this.analyze((Node)node.getQuery(), Optional.empty(), false);
            ImmutableList.Builder columnsBuilder = ImmutableList.builder();
            ImmutableList.Builder outputColumns = ImmutableList.builder();
            if (node.getColumnAliases().isPresent()) {
                this.validateColumnAliases((List)node.getColumnAliases().get(), queryScope.getRelationType().getVisibleFieldCount());
                int aliasPosition = 0;
                for (Field field2 : queryScope.getRelationType().getVisibleFields()) {
                    if (field2.getType().equals((Object)UnknownType.UNKNOWN)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)node, "Column type is unknown at position %s", queryScope.getRelationType().indexOf(field2) + 1);
                    }
                    String columnName = ((Identifier)((List)node.getColumnAliases().get()).get(aliasPosition)).getValue();
                    columnsBuilder.add((Object)new ColumnMetadata(columnName, StatementAnalyzer.this.metadata.getSupportedType(StatementAnalyzer.this.session, catalogHandle, properties, field2.getType()).orElse(field2.getType())));
                    outputColumns.add((Object)new OutputColumn(new Column(columnName, field2.getType().toString()), StatementAnalyzer.this.analysis.getSourceColumns(field2)));
                    ++aliasPosition;
                }
            } else {
                this.validateColumns((Statement)node, queryScope.getRelationType());
                columnsBuilder.addAll((Iterable)queryScope.getRelationType().getVisibleFields().stream().map(field -> new ColumnMetadata(field.getName().orElseThrow(), StatementAnalyzer.this.metadata.getSupportedType(StatementAnalyzer.this.session, catalogHandle, properties, field.getType()).orElse(field.getType()))).collect(ImmutableList.toImmutableList()));
                queryScope.getRelationType().getVisibleFields().stream().map(this::createOutputColumn).forEach(arg_0 -> ((ImmutableList.Builder)outputColumns).add(arg_0));
            }
            ImmutableList columns = columnsBuilder.build();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(targetTable.asSchemaTableName(), (List)columns, properties, node.getComment());
            Optional<TableLayout> newTableLayout = StatementAnalyzer.this.metadata.getNewTableLayout(StatementAnalyzer.this.session, catalogName, tableMetadata);
            Set columnNames = (Set)columns.stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
            if (newTableLayout.isPresent() && !columnNames.containsAll((layout = newTableLayout.get()).getPartitionColumns())) {
                if (layout.getLayout().getPartitioning().isPresent()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT must write all distribution columns: " + String.valueOf(layout.getPartitionColumns()));
                }
                newTableLayout = Optional.empty();
            }
            StatementAnalyzer.this.analysis.setCreate(new Analysis.Create(Optional.of(targetTable), Optional.of(tableMetadata), newTableLayout, node.isWithData(), false, node.getSaveMode() == SaveMode.REPLACE));
            StatementAnalyzer.this.analysis.setUpdateType("CREATE TABLE");
            StatementAnalyzer.this.analysis.setUpdateTarget(catalogHandle.getVersion(), targetTable, Optional.empty(), Optional.of(outputColumns.build()));
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitCreateView(CreateView node, Optional<Scope> scope) {
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            node.getQuery().getFunctions().stream().findFirst().ifPresent(function -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)function, "Views cannot contain inline functions", new Object[0]);
            });
            StatementAnalyzer analyzer = StatementAnalyzer.this.statementAnalyzerFactory.createStatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope queryScope = analyzer.analyze((Node)node.getQuery());
            StatementAnalyzer.this.accessControl.checkCanCreateView(StatementAnalyzer.this.session.toSecurityContext(), viewName);
            this.validateColumns((Statement)node, queryScope.getRelationType());
            CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, (Node)node, viewName.catalogName());
            StatementAnalyzer.this.analysis.setUpdateType("CREATE VIEW");
            StatementAnalyzer.this.analysis.setUpdateTarget(catalogHandle.getVersion(), viewName, Optional.empty(), Optional.of((List)queryScope.getRelationType().getVisibleFields().stream().map(this::createOutputColumn).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetSession(SetSession node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitResetSession(ResetSession node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetSessionAuthorization(SetSessionAuthorization node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitResetSessionAuthorization(ResetSessionAuthorization node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitAddColumn(AddColumn node, Optional<Scope> scope) {
            ColumnDefinition element = node.getColumn();
            if (element.getName().getParts().size() > 1) {
                if (!element.isNullable()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Adding fields with NOT NULL constraint is unsupported", new Object[0]);
                }
                if (!element.getProperties().isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Adding fields with column properties is unsupported", new Object[0]);
                }
                if (element.getComment().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Adding fields with COMMENT is unsupported", new Object[0]);
                }
            }
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetColumnType(SetColumnType node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropNotNullConstraint(DropNotNullConstraint node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateCatalog(CreateCatalog node, Optional<Scope> scope) {
            for (Property property : node.getProperties()) {
                if (!property.isSetToDefault()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_CATALOG_PROPERTY, (Node)property, "Catalog properties do not support DEFAULT value", new Object[0]);
            }
            this.validateProperties(node.getProperties(), scope);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropCatalog(DropCatalog node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateSchema(CreateSchema node, Optional<Scope> scope) {
            this.validateProperties(node.getProperties(), scope);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropSchema(DropSchema node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameSchema(RenameSchema node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetSchemaAuthorization(SetSchemaAuthorization node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateTable(CreateTable node, Optional<Scope> scope) {
            this.validateProperties(node.getProperties(), scope);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitProperty(Property node, Optional<Scope> scope) {
            if (node.isSetToDefault()) {
                return this.createAndAssignScope((Node)node, scope);
            }
            ExpressionAnalyzer.createConstantAnalyzer(StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, StatementAnalyzer.this.analysis.getParameters(), WarningCollector.NOOP, StatementAnalyzer.this.analysis.isDescribe()).analyze(node.getNonDefaultValue(), this.createScope(scope));
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCallArgument(CallArgument node, Optional<Scope> scope) {
            ExpressionAnalyzer.createConstantAnalyzer(StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, StatementAnalyzer.this.analysis.getParameters(), WarningCollector.NOOP, StatementAnalyzer.this.analysis.isDescribe()).analyze(node.getValue(), this.createScope(scope));
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitTruncateTable(TruncateTable node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropTable(DropTable node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameTable(RenameTable node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetProperties(SetProperties node, Optional<Scope> context) {
            return this.createAndAssignScope((Node)node, context);
        }

        protected Scope visitComment(Comment node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameColumn(RenameColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropColumn(DropColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetTableAuthorization(SetTableAuthorization node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitTableExecute(TableExecute node, Optional<Scope> scope) {
            Table table = node.getTable();
            QualifiedObjectName originalName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            String procedureName = node.getProcedureName().getCanonicalValue();
            if (StatementAnalyzer.this.metadata.isMaterializedView(StatementAnalyzer.this.session, originalName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "ALTER TABLE EXECUTE is not supported for materialized views", new Object[0]);
            }
            if (StatementAnalyzer.this.metadata.isView(StatementAnalyzer.this.session, originalName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "ALTER TABLE EXECUTE is not supported for views", new Object[0]);
            }
            RedirectionAwareTableHandle redirection = StatementAnalyzer.this.metadata.getRedirectionAwareTableHandle(StatementAnalyzer.this.session, originalName);
            QualifiedObjectName tableName = redirection.redirectedTableName().orElse(originalName);
            TableHandle tableHandle = redirection.tableHandle().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)table, "Table '%s' does not exist", tableName));
            StatementAnalyzer.this.accessControl.checkCanExecuteTableProcedure(StatementAnalyzer.this.session.toSecurityContext(), tableName, procedureName);
            if (!StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.toSecurityContext(), tableName).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "ALTER TABLE EXECUTE is not supported for table with row filter", new Object[0]);
            }
            TableMetadata tableMetadata = StatementAnalyzer.this.metadata.getTableMetadata(StatementAnalyzer.this.session, tableHandle);
            for (ColumnMetadata tableColumn : tableMetadata.columns()) {
                if (!StatementAnalyzer.this.accessControl.getColumnMask(StatementAnalyzer.this.session.toSecurityContext(), tableName, tableColumn.getName(), tableColumn.getType()).isPresent()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "ALTER TABLE EXECUTE is not supported for table with column masks", new Object[0]);
            }
            Scope tableScope = StatementAnalyzer.this.analyze((Node)table);
            String catalogName = tableName.catalogName();
            CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, (Node)node, catalogName);
            TableProcedureMetadata procedureMetadata = StatementAnalyzer.this.tableProceduresRegistry.resolve(catalogHandle, procedureName);
            if (!procedureMetadata.getExecutionMode().supportsFilter() && node.getWhere().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "WHERE not supported for procedure %s", procedureName);
            }
            node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, tableScope, (Expression)where));
            Map<String, Expression> propertiesMap = this.processTableExecuteArguments(node, procedureMetadata, scope);
            Map<String, Object> tableProperties = StatementAnalyzer.this.tableProceduresPropertyManager.getProperties(catalogName, catalogHandle, procedureName, propertiesMap, StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.analysis.getParameters());
            TableExecuteHandle executeHandle = StatementAnalyzer.this.metadata.getTableHandleForExecute(StatementAnalyzer.this.session, tableHandle, procedureName, tableProperties).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Procedure '%s' cannot be executed on table '%s'", procedureName, tableName));
            StatementAnalyzer.this.analysis.setTableExecuteReadsData(procedureMetadata.getExecutionMode().isReadsData());
            StatementAnalyzer.this.analysis.setTableExecuteHandle(executeHandle);
            StatementAnalyzer.this.analysis.setUpdateType("ALTER TABLE EXECUTE");
            StatementAnalyzer.this.analysis.setUpdateTarget(executeHandle.catalogHandle().getVersion(), tableName, Optional.of(table), Optional.empty());
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        private Map<String, Expression> processTableExecuteArguments(TableExecute node, TableProcedureMetadata procedureMetadata, Optional<Scope> scope) {
            List arguments = node.getArguments();
            Predicate<CallArgument> hasName = argument -> argument.getName().isPresent();
            boolean anyNamed = arguments.stream().anyMatch(hasName);
            boolean allNamed = arguments.stream().allMatch(hasName);
            if (anyNamed && !allNamed) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "Named and positional arguments cannot be mixed", new Object[0]);
            }
            if (!anyNamed && arguments.size() > procedureMetadata.getProperties().size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "Too many positional arguments", new Object[0]);
            }
            for (Object argument2 : arguments) {
                this.process((Node)argument2, scope);
            }
            HashMap<String, Expression> argumentsMap = new HashMap<String, Expression>();
            if (anyNamed) {
                for (CallArgument argument3 : arguments) {
                    if (argumentsMap.put(((Identifier)argument3.getName().get()).getCanonicalValue(), argument3.getValue()) == null) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY, (Node)argument3, "Duplicate named argument: %s", argument3.getName());
                }
            } else {
                int pos = 0;
                for (CallArgument argument4 : arguments) {
                    argumentsMap.put(((PropertyMetadata)procedureMetadata.getProperties().get(pos)).getName(), argument4.getValue());
                    ++pos;
                }
            }
            return ImmutableMap.copyOf(argumentsMap);
        }

        protected Scope visitRenameView(RenameView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameMaterializedView(RenameMaterializedView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetViewAuthorization(SetViewAuthorization node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropView(DropView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitStartTransaction(StartTransaction node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCommit(Commit node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRollback(Rollback node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitPrepare(Prepare node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDeallocate(Deallocate node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitExecute(Execute node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitExecuteImmediate(ExecuteImmediate node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitGrant(Grant node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDeny(Deny node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRevoke(Revoke node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCall(Call node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateMaterializedView(CreateMaterializedView node, Optional<Scope> scope) {
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            if (node.isReplace() && node.isNotExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "'CREATE OR REPLACE' and 'IF NOT EXISTS' clauses can not be used together", new Object[0]);
            }
            node.getGracePeriod().ifPresent(gracePeriod -> this.analyzeExpression((Expression)gracePeriod, Scope.create()));
            StatementAnalyzer analyzer = StatementAnalyzer.this.statementAnalyzerFactory.createStatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope queryScope = analyzer.analyze((Node)node.getQuery());
            this.validateColumns((Statement)node, queryScope.getRelationType());
            CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, (Node)node, viewName.catalogName());
            StatementAnalyzer.this.analysis.setUpdateType("CREATE MATERIALIZED VIEW");
            StatementAnalyzer.this.analysis.setUpdateTarget(catalogHandle.getVersion(), viewName, Optional.empty(), Optional.of((List)queryScope.getRelationType().getVisibleFields().stream().map(this::createOutputColumn).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropMaterializedView(DropMaterializedView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetTimeZone(SetTimeZone node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        private void validateProperties(List<Property> properties, Optional<Scope> scope) {
            HashSet<String> propertyNames = new HashSet<String>();
            for (Property property : properties) {
                if (propertyNames.add(property.getName().getValue())) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY, (Node)property, "Duplicate property: %s", property.getName().getValue());
            }
            for (Property property : properties) {
                this.process((Node)property, scope);
            }
        }

        private void validateColumns(Statement node, RelationType descriptor) {
            HashSet<String> names = new HashSet<String>();
            for (Field field : descriptor.getVisibleFields()) {
                String fieldName = field.getName().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_COLUMN_NAME, (Node)node, "Column name not specified at position %s", descriptor.indexOf(field) + 1));
                if (!names.add(fieldName)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)node, "Column name '%s' specified more than once", fieldName);
                }
                if (!field.getType().equals((Object)UnknownType.UNKNOWN)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)node, "Column type is unknown: %s", fieldName);
            }
        }

        private void validateColumnAliases(List<Identifier> columnAliases, int sourceColumnSize) {
            this.validateColumnAliasesCount(columnAliases, sourceColumnSize);
            HashSet<String> names = new HashSet<String>();
            for (Identifier identifier : columnAliases) {
                if (names.contains(identifier.getValue().toLowerCase(Locale.ENGLISH))) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)identifier, "Column name '%s' specified more than once", identifier.getValue());
                }
                names.add(identifier.getValue().toLowerCase(Locale.ENGLISH));
            }
        }

        private void validateColumnAliasesCount(List<Identifier> columnAliases, int sourceColumnSize) {
            if (columnAliases.size() != sourceColumnSize) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)columnAliases.get(0), "Column alias list has %s entries but relation has %s columns", columnAliases.size(), sourceColumnSize);
            }
        }

        protected Scope visitExplain(Explain node, Optional<Scope> scope) {
            this.process((Node)node.getStatement(), scope);
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("Query Plan", (Type)VarcharType.VARCHAR));
        }

        protected Scope visitExplainAnalyze(ExplainAnalyze node, Optional<Scope> scope) {
            this.process((Node)node.getStatement(), scope);
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("Query Plan", (Type)VarcharType.VARCHAR));
        }

        protected Scope visitQuery(Query node, Optional<Scope> scope) {
            boolean requiresOrderBy;
            for (FunctionSpecification function : node.getFunctions()) {
                if (function.getName().getPrefix().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, (Node)function, "Inline function names cannot be qualified: %s", function.getName());
                }
                function.getRoutineCharacteristics().stream().filter(SecurityCharacteristic.class::isInstance).findFirst().ifPresent(security -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)security, "Security mode not supported for inline functions", new Object[0]);
                });
                StatementAnalyzer.this.plannerContext.getLanguageFunctionManager().addInlineFunction(StatementAnalyzer.this.session, SqlFormatter.formatSql((Node)function), StatementAnalyzer.this.accessControl);
            }
            Scope withScope = this.analyzeWith(node, scope);
            Scope queryBodyScope = this.process((Node)node.getQueryBody(), withScope);
            List<Expression> orderByExpressions = Collections.emptyList();
            if (node.getOrderBy().isPresent()) {
                orderByExpressions = this.analyzeOrderBy((Node)node, NodeUtils.getSortItemsFromOrderBy(node.getOrderBy()), queryBodyScope);
                if ((queryBodyScope.getOuterQueryParent().isPresent() || !this.isTopLevel) && node.getLimit().isEmpty() && node.getOffset().isEmpty()) {
                    StatementAnalyzer.this.analysis.markRedundantOrderBy((OrderBy)node.getOrderBy().get());
                    this.warningCollector.add(new TrinoWarning((WarningCodeSupplier)StandardWarningCode.REDUNDANT_ORDER_BY, "ORDER BY in subquery may have no effect"));
                }
            }
            StatementAnalyzer.this.analysis.setOrderByExpressions((Node)node, orderByExpressions);
            if (node.getOffset().isPresent()) {
                this.analyzeOffset((Offset)node.getOffset().get(), queryBodyScope);
            }
            if (node.getLimit().isPresent() && (requiresOrderBy = this.analyzeLimit((Node)node.getLimit().get(), queryBodyScope)) && node.getOrderBy().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, (Node)node.getLimit().get(), "FETCH FIRST WITH TIES clause requires ORDER BY", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setSelectExpressions((Node)node, (List)this.descriptorToFields(queryBodyScope).stream().map(expression -> new Analysis.SelectExpression((Expression)expression, Optional.empty())).collect(ImmutableList.toImmutableList()));
            Scope queryScope = Scope.builder().withParent(withScope).withRelationType(RelationId.of((Node)node), queryBodyScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope((Node)node, queryScope);
            return queryScope;
        }

        protected Scope visitUnnest(Unnest node, Optional<Scope> scope) {
            ImmutableMap.Builder mappings = ImmutableMap.builder();
            ImmutableList.Builder outputFields = ImmutableList.builder();
            for (Expression expression : node.getExpressions()) {
                Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, expression, "UNNEST");
                ArrayList<Field> expressionOutputs = new ArrayList<Field>();
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, this.createScope(scope));
                StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                Type expressionType = expressionAnalysis.getType(expression);
                if (expressionType instanceof ArrayType) {
                    Type elementType = ((ArrayType)expressionType).getElementType();
                    if (elementType instanceof RowType) {
                        ((RowType)elementType).getFields().stream().map(field -> Field.newUnqualified(field.getName(), field.getType())).forEach(expressionOutputs::add);
                    } else {
                        expressionOutputs.add(Field.newUnqualified(Optional.empty(), elementType));
                    }
                } else if (expressionType instanceof MapType) {
                    expressionOutputs.add(Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getKeyType()));
                    expressionOutputs.add(Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getValueType()));
                } else {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot unnest type: " + String.valueOf(expressionType));
                }
                outputFields.addAll(expressionOutputs);
                mappings.put((Object)NodeRef.of((Node)expression), expressionOutputs);
            }
            Optional<Field> ordinalityField = Optional.empty();
            if (node.isWithOrdinality()) {
                ordinalityField = Optional.of(Field.newUnqualified(Optional.empty(), (Type)BigintType.BIGINT));
            }
            ordinalityField.ifPresent(arg_0 -> ((ImmutableList.Builder)outputFields).add(arg_0));
            StatementAnalyzer.this.analysis.setUnnest(node, new Analysis.UnnestAnalysis((Map<NodeRef<Expression>, List<Field>>)mappings.buildOrThrow(), ordinalityField));
            return this.createAndAssignScope((Node)node, scope, (List<Field>)outputFields.build());
        }

        protected Scope visitLateral(Lateral node, Optional<Scope> scope) {
            StatementAnalyzer analyzer = StatementAnalyzer.this.statementAnalyzerFactory.createStatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope.orElseThrow());
            return this.createAndAssignScope((Node)node, scope, queryScope.getRelationType());
        }

        protected Scope visitTableFunctionInvocation(TableFunctionInvocation node, Optional<Scope> scope) {
            Descriptor properColumnsDescriptor;
            TableFunctionMetadata tableFunctionMetadata = this.resolveTableFunction(node).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, (Node)node, "Table function '%s' not registered", node.getName()));
            ConnectorTableFunction function = tableFunctionMetadata.function();
            CatalogHandle catalogHandle = tableFunctionMetadata.catalogHandle();
            TableFunctionInvocation errorLocation = node;
            if (!node.getArguments().isEmpty()) {
                errorLocation = (Node)node.getArguments().getFirst();
            }
            ArgumentsAnalysis argumentsAnalysis = this.analyzeArguments(function.getArguments(), node.getArguments(), scope, (Node)errorLocation);
            ConnectorTransactionHandle transactionHandle = StatementAnalyzer.this.transactionManager.getConnectorTransaction(StatementAnalyzer.this.session.getRequiredTransactionId(), catalogHandle);
            TableFunctionAnalysis functionAnalysis = function.analyze(StatementAnalyzer.this.session.toConnectorSession(catalogHandle), transactionHandle, argumentsAnalysis.getPassedArguments(), (ConnectorAccessControl)new InjectedConnectorAccessControl(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.toSecurityContext(), catalogHandle.getCatalogName().toString()));
            List<List<String>> copartitioningLists = this.analyzeCopartitioning(node.getCopartitioning(), argumentsAnalysis.getTableArgumentAnalyses());
            ReturnTypeSpecification returnTypeSpecification = function.getReturnTypeSpecification();
            if (returnTypeSpecification == ReturnTypeSpecification.GenericTable.GENERIC_TABLE || !argumentsAnalysis.getTableArgumentAnalyses().isEmpty()) {
                StatementAnalyzer.this.analysis.addPolymorphicTableFunction(node);
            }
            Optional analyzedProperColumnsDescriptor = functionAnalysis.getReturnedType();
            if (returnTypeSpecification == ReturnTypeSpecification.OnlyPassThrough.ONLY_PASS_THROUGH) {
                if (StatementAnalyzer.this.analysis.isAliased((Relation)node)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_FUNCTION_INVOCATION, (Node)node, "Alias specified for table function with ONLY PASS THROUGH return type", new Object[0]);
                }
                if (analyzedProperColumnsDescriptor.isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_RETURN_TYPE, (Node)node, "Returned relation type for table function %s is ambiguous", node.getName());
                }
                if (function.getArguments().stream().filter(TableArgumentSpecification.class::isInstance).map(TableArgumentSpecification.class::cast).noneMatch(TableArgumentSpecification::isPassThroughColumns)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "A table function with ONLY_PASS_THROUGH return type must have a table argument with pass-through columns.");
                }
                properColumnsDescriptor = null;
            } else if (returnTypeSpecification == ReturnTypeSpecification.GenericTable.GENERIC_TABLE) {
                properColumnsDescriptor = (Descriptor)analyzedProperColumnsDescriptor.orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_RETURN_TYPE, (Node)node, "Cannot determine returned relation type for table function %s", node.getName()));
            } else {
                if (analyzedProperColumnsDescriptor.isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_RETURN_TYPE, (Node)node, "Returned relation type for table function %s is ambiguous", node.getName());
                }
                properColumnsDescriptor = ((ReturnTypeSpecification.DescribedTable)returnTypeSpecification).getDescriptor();
            }
            Map requiredColumns = functionAnalysis.getRequiredColumns();
            Map tableArgumentsByName = (Map)argumentsAnalysis.getTableArgumentAnalyses().stream().collect(ImmutableMap.toImmutableMap(Analysis.TableArgumentAnalysis::getArgumentName, Function.identity()));
            ImmutableSet allInputs = ImmutableSet.copyOf(tableArgumentsByName.keySet());
            requiredColumns.forEach((arg_0, arg_1) -> this.lambda$visitTableFunctionInvocation$32((Set)allInputs, node, tableArgumentsByName, arg_0, arg_1));
            ImmutableSet requiredInputs = ImmutableSet.copyOf(requiredColumns.keySet());
            allInputs.stream().filter(arg_0 -> Visitor.lambda$visitTableFunctionInvocation$33((Set)requiredInputs, arg_0)).findFirst().ifPresent(input -> {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Table function %s does not specify required input columns from table argument %s", node.getName(), input));
            });
            ImmutableList.Builder fields = ImmutableList.builder();
            if (properColumnsDescriptor != null) {
                properColumnsDescriptor.getFields().stream().map(field -> Field.newUnqualified(field.getName(), (Type)field.getType().orElseThrow(() -> new IllegalStateException("missing returned type for proper field")))).forEach(arg_0 -> ((ImmutableList.Builder)fields).add(arg_0));
            }
            List tableArgumentNames = (List)function.getArguments().stream().filter(argumentSpecification -> argumentSpecification instanceof TableArgumentSpecification).map(ArgumentSpecification::getName).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder orderedTableArguments = ImmutableList.builder();
            for (String name : tableArgumentNames) {
                Analysis.TableArgumentAnalysis argument = (Analysis.TableArgumentAnalysis)tableArgumentsByName.get(name);
                orderedTableArguments.add((Object)argument);
                Scope argumentScope = StatementAnalyzer.this.analysis.getScope((Node)argument.getRelation());
                if (argument.isPassThroughColumns()) {
                    argumentScope.getRelationType().getAllFields().forEach(arg_0 -> ((ImmutableList.Builder)fields).add(arg_0));
                    continue;
                }
                if (!argument.getPartitionBy().isPresent()) continue;
                argument.getPartitionBy().get().stream().map(expression -> this.validateAndGetInputField((Expression)expression, argumentScope)).forEach(arg_0 -> ((ImmutableList.Builder)fields).add(arg_0));
            }
            StatementAnalyzer.this.analysis.setTableFunctionAnalysis(node, new Analysis.TableFunctionInvocationAnalysis(catalogHandle, function.getName(), argumentsAnalysis.getPassedArguments(), (List<Analysis.TableArgumentAnalysis>)orderedTableArguments.build(), functionAnalysis.getRequiredColumns(), copartitioningLists, properColumnsDescriptor == null ? 0 : properColumnsDescriptor.getFields().size(), functionAnalysis.getHandle(), transactionHandle));
            return this.createAndAssignScope((Node)node, scope, (List<Field>)fields.build());
        }

        private Optional<TableFunctionMetadata> resolveTableFunction(TableFunctionInvocation node) {
            boolean unauthorized = false;
            for (CatalogSchemaFunctionName name : FunctionResolver.toPath(StatementAnalyzer.this.session, node.getName(), StatementAnalyzer.this.accessControl)) {
                CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, (Node)node, name.getCatalogName());
                Optional<ConnectorTableFunction> resolved = StatementAnalyzer.this.tableFunctionRegistry.resolve(catalogHandle, name.getSchemaFunctionName());
                if (!resolved.isPresent()) continue;
                if (GlobalFunctionCatalog.isBuiltinFunctionName(name) || StatementAnalyzer.this.accessControl.canExecuteFunction(SecurityContext.of(StatementAnalyzer.this.session), new QualifiedObjectName(name.getCatalogName(), name.getSchemaName(), name.getFunctionName()))) {
                    return Optional.of(new TableFunctionMetadata(catalogHandle, resolved.get()));
                }
                unauthorized = true;
            }
            if (unauthorized) {
                AccessDeniedException.denyExecuteFunction((String)node.getName().toString());
            }
            return Optional.empty();
        }

        private ArgumentsAnalysis analyzeArguments(List<ArgumentSpecification> argumentSpecifications, List<TableFunctionArgument> arguments, Optional<Scope> scope, Node errorLocation) {
            if (argumentSpecifications.size() < arguments.size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, errorLocation, "Too many arguments. Expected at most %s arguments, got %s arguments", argumentSpecifications.size(), arguments.size());
            }
            if (argumentSpecifications.isEmpty()) {
                return new ArgumentsAnalysis((Map<String, Argument>)ImmutableMap.of(), (List<Analysis.TableArgumentAnalysis>)ImmutableList.of());
            }
            boolean argumentsPassedByName = !arguments.isEmpty() && arguments.stream().allMatch(argument -> argument.getName().isPresent());
            boolean argumentsPassedByPosition = arguments.stream().allMatch(argument -> argument.getName().isEmpty());
            if (!argumentsPassedByName && !argumentsPassedByPosition) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, errorLocation, "All arguments must be passed by name or all must be passed positionally", new Object[0]);
            }
            ImmutableMap.Builder passedArguments = ImmutableMap.builder();
            ImmutableList.Builder tableArgumentAnalyses = ImmutableList.builder();
            if (argumentsPassedByName) {
                HashMap<String, ArgumentSpecification> argumentSpecificationsByName = new HashMap<String, ArgumentSpecification>();
                for (ArgumentSpecification argumentSpecification : argumentSpecifications) {
                    if (argumentSpecificationsByName.put(argumentSpecification.getName(), argumentSpecification) == null) continue;
                    throw new IllegalStateException("Duplicate argument specification for name: " + argumentSpecification.getName());
                }
                HashSet<String> uniqueArgumentNames = new HashSet<String>();
                for (TableFunctionArgument tableFunctionArgument : arguments) {
                    String argumentName = ((Identifier)tableFunctionArgument.getName().orElseThrow()).getCanonicalValue();
                    if (!uniqueArgumentNames.add(argumentName)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)tableFunctionArgument, "Duplicate argument name: %s", argumentName);
                    }
                    ArgumentSpecification argumentSpecification = (ArgumentSpecification)argumentSpecificationsByName.remove(argumentName);
                    if (argumentSpecification == null) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)tableFunctionArgument, "Unexpected argument name: %s", argumentName);
                    }
                    ArgumentAnalysis argumentAnalysis = this.analyzeArgument(argumentSpecification, tableFunctionArgument, scope);
                    passedArguments.put((Object)argumentSpecification.getName(), (Object)argumentAnalysis.getArgument());
                    argumentAnalysis.getTableArgumentAnalysis().ifPresent(arg_0 -> ((ImmutableList.Builder)tableArgumentAnalyses).add(arg_0));
                }
                for (Map.Entry entry : argumentSpecificationsByName.entrySet()) {
                    ArgumentSpecification argumentSpecification = (ArgumentSpecification)entry.getValue();
                    passedArguments.put((Object)argumentSpecification.getName(), (Object)this.analyzeDefault(argumentSpecification, errorLocation));
                }
            } else {
                int i;
                for (i = 0; i < arguments.size(); ++i) {
                    TableFunctionArgument argument3 = arguments.get(i);
                    ArgumentSpecification argumentSpecification = argumentSpecifications.get(i);
                    ArgumentAnalysis argumentAnalysis = this.analyzeArgument(argumentSpecification, argument3, scope);
                    passedArguments.put((Object)argumentSpecification.getName(), (Object)argumentAnalysis.getArgument());
                    argumentAnalysis.getTableArgumentAnalysis().ifPresent(arg_0 -> ((ImmutableList.Builder)tableArgumentAnalyses).add(arg_0));
                }
                for (i = arguments.size(); i < argumentSpecifications.size(); ++i) {
                    ArgumentSpecification argumentSpecification = argumentSpecifications.get(i);
                    passedArguments.put((Object)argumentSpecification.getName(), (Object)this.analyzeDefault(argumentSpecification, errorLocation));
                }
            }
            return new ArgumentsAnalysis((Map<String, Argument>)passedArguments.buildOrThrow(), (List<Analysis.TableArgumentAnalysis>)tableArgumentAnalyses.build());
        }

        private ArgumentAnalysis analyzeArgument(ArgumentSpecification argumentSpecification, TableFunctionArgument argument, Optional<Scope> scope) {
            String actualType;
            if (argument.getValue() instanceof TableFunctionTableArgument) {
                actualType = "table";
            } else if (argument.getValue() instanceof TableFunctionDescriptorArgument) {
                actualType = "descriptor";
            } else if (argument.getValue() instanceof Expression) {
                actualType = "expression";
            } else {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)argument, "Unexpected table function argument type: %s", argument.getClass().getSimpleName());
            }
            if (argumentSpecification instanceof TableArgumentSpecification) {
                if (!(argument.getValue() instanceof TableFunctionTableArgument)) {
                    if (argument.getValue() instanceof FunctionCall) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)argument, "Invalid table argument %s. Table functions are not allowed as table function arguments", argumentSpecification.getName());
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)argument, "Invalid argument %s. Expected table, got %s", argumentSpecification.getName(), actualType);
                }
                return this.analyzeTableArgument(argument, (TableArgumentSpecification)argumentSpecification, scope);
            }
            if (argumentSpecification instanceof DescriptorArgumentSpecification) {
                if (!(argument.getValue() instanceof TableFunctionDescriptorArgument)) {
                    if (argument.getValue() instanceof FunctionCall && ((FunctionCall)argument.getValue()).getName().hasSuffix(QualifiedName.of((String)"descriptor"))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)argument, "Invalid descriptor argument %s. Descriptors should be formatted as 'DESCRIPTOR(name [type], ...)'", argumentSpecification.getName());
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)argument, "Invalid argument %s. Expected descriptor, got %s", argumentSpecification.getName(), actualType);
                }
                return this.analyzeDescriptorArgument((TableFunctionDescriptorArgument)argument.getValue());
            }
            if (argumentSpecification instanceof ScalarArgumentSpecification) {
                Node node = argument.getValue();
                if (!(node instanceof Expression)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)argument, "Invalid argument %s. Expected expression, got %s", argumentSpecification.getName(), actualType);
                }
                Expression expression = (Expression)node;
                if (expression instanceof FunctionCall && ((FunctionCall)expression).getName().hasSuffix(QualifiedName.of((String)"descriptor"))) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)argument, "'descriptor' function is not allowed as a table function argument", new Object[0]);
                }
                return this.analyzeScalarArgument(expression, ((ScalarArgumentSpecification)argumentSpecification).getType());
            }
            throw new IllegalStateException("Unexpected argument specification: " + argumentSpecification.getClass().getSimpleName());
        }

        private ArgumentAnalysis analyzeTableArgument(TableFunctionArgument argument, TableArgumentSpecification argumentSpecification, Optional<Scope> scope) {
            TableFunctionTableArgument tableArgument = (TableFunctionTableArgument)argument.getValue();
            TableArgument.Builder argumentBuilder = TableArgument.builder();
            Analysis.TableArgumentAnalysis.Builder analysisBuilder = Analysis.TableArgumentAnalysis.builder();
            analysisBuilder.withArgumentName(argumentSpecification.getName());
            Relation relation = tableArgument.getTable();
            analysisBuilder.withRelation(relation);
            Scope argumentScope = this.process((Node)relation, scope);
            QualifiedName relationName = StatementAnalyzer.this.analysis.getRelationName(relation);
            if (relationName != null) {
                analysisBuilder.withName(relationName);
            }
            argumentBuilder.rowType(RowType.from((List)((List)argumentScope.getRelationType().getVisibleFields().stream().map(field -> new RowType.Field(field.getName(), field.getType())).collect(ImmutableList.toImmutableList()))));
            if (tableArgument.getPartitionBy().isPresent()) {
                if (argumentSpecification.isRowSemantics()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)argument, "Invalid argument %s. Partitioning specified for table argument with row semantics", argumentSpecification.getName());
                }
                List partitionBy = (List)tableArgument.getPartitionBy().get();
                analysisBuilder.withPartitionBy(partitionBy);
                partitionBy.forEach(partitioningColumn -> {
                    this.validateAndGetInputField((Expression)partitioningColumn, argumentScope);
                    Type type = this.analyzeExpression((Expression)partitioningColumn, argumentScope).getType((Expression)partitioningColumn);
                    if (!type.isComparable()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)partitioningColumn, "%s is not comparable, and therefore cannot be used in PARTITION BY", type);
                    }
                });
                argumentBuilder.partitionBy((List)partitionBy.stream().map(Expression::toString).collect(ImmutableList.toImmutableList()));
            }
            if (tableArgument.getOrderBy().isPresent()) {
                if (argumentSpecification.isRowSemantics()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)argument, "Invalid argument %s. Ordering specified for table argument with row semantics", argumentSpecification.getName());
                }
                OrderBy orderBy = (OrderBy)tableArgument.getOrderBy().get();
                analysisBuilder.withOrderBy(orderBy);
                orderBy.getSortItems().stream().map(SortItem::getSortKey).forEach(orderingColumn -> {
                    this.validateAndGetInputField((Expression)orderingColumn, argumentScope);
                    Type type = this.analyzeExpression((Expression)orderingColumn, argumentScope).getType((Expression)orderingColumn);
                    if (!type.isOrderable()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)orderingColumn, "%s is not orderable, and therefore cannot be used in ORDER BY", type);
                    }
                });
                argumentBuilder.orderBy((List)orderBy.getSortItems().stream().map(sortItem -> sortItem.getSortKey().toString()).collect(ImmutableList.toImmutableList()));
            }
            boolean pruneWhenEmpty = argumentSpecification.isPruneWhenEmpty();
            if (tableArgument.getEmptyTableTreatment().isPresent()) {
                if (argumentSpecification.isRowSemantics()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)tableArgument.getEmptyTableTreatment().get(), "Invalid argument %s. Empty behavior specified for table argument with row semantics", argumentSpecification.getName());
                }
                pruneWhenEmpty = ((EmptyTableTreatment)tableArgument.getEmptyTableTreatment().get()).getTreatment() == EmptyTableTreatment.Treatment.PRUNE;
            }
            analysisBuilder.withPruneWhenEmpty(pruneWhenEmpty);
            analysisBuilder.withRowSemantics(argumentSpecification.isRowSemantics());
            analysisBuilder.withPassThroughColumns(argumentSpecification.isPassThroughColumns());
            return new ArgumentAnalysis((Argument)argumentBuilder.build(), Optional.of(analysisBuilder.build()));
        }

        private ArgumentAnalysis analyzeDescriptorArgument(TableFunctionDescriptorArgument argument) {
            return new ArgumentAnalysis((Argument)argument.getDescriptor().map(descriptor -> DescriptorArgument.builder().descriptor(new Descriptor((List)descriptor.getFields().stream().map(field -> new Descriptor.Field(field.getName().getCanonicalValue(), field.getType().map(type -> {
                try {
                    return StatementAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(type));
                }
                catch (TypeNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)type, "Unknown type: %s", type);
                }
            }))).collect(ImmutableList.toImmutableList()))).build()).orElse(DescriptorArgument.NULL_DESCRIPTOR), Optional.empty());
        }

        private ArgumentAnalysis analyzeScalarArgument(Expression expression, Type type) {
            Expression inlined = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

                public Expression rewriteParameter(Parameter node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    if (StatementAnalyzer.this.analysis.isDescribe()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "DESCRIBE is not supported if a table function uses parameters", new Object[0]);
                    }
                    return StatementAnalyzer.this.analysis.getParameters().get(NodeRef.of((Node)node));
                }
            }, (Expression)expression);
            Object constantValue = ConstantEvaluator.evaluateConstant(inlined, type, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.session, StatementAnalyzer.this.accessControl);
            return new ArgumentAnalysis((Argument)ScalarArgument.builder().type(type).value(constantValue).build(), Optional.empty());
        }

        private Argument analyzeDefault(ArgumentSpecification argumentSpecification, Node errorLocation) {
            if (argumentSpecification.isRequired()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ARGUMENT, errorLocation, "Missing argument: %s", argumentSpecification.getName());
            }
            Preconditions.checkArgument((!(argumentSpecification instanceof TableArgumentSpecification) ? 1 : 0) != 0, (Object)"invalid table argument specification: default set");
            if (argumentSpecification instanceof DescriptorArgumentSpecification) {
                return DescriptorArgument.builder().descriptor((Descriptor)argumentSpecification.getDefaultValue()).build();
            }
            if (argumentSpecification instanceof ScalarArgumentSpecification) {
                return ScalarArgument.builder().type(((ScalarArgumentSpecification)argumentSpecification).getType()).value(argumentSpecification.getDefaultValue()).build();
            }
            throw new IllegalStateException("Unexpected argument specification: " + argumentSpecification.getClass().getSimpleName());
        }

        private List<List<String>> analyzeCopartitioning(List<List<QualifiedName>> copartitioning, List<Analysis.TableArgumentAnalysis> tableArgumentAnalyses) {
            ImmutableMultimap.Builder unqualifiedInputsBuilder = ImmutableMultimap.builder();
            ImmutableMultimap.Builder qualifiedInputsBuilder = ImmutableMultimap.builder();
            tableArgumentAnalyses.stream().filter(argument -> argument.getName().isPresent()).forEach(argument -> {
                QualifiedName name = argument.getName().get();
                if (name.getParts().size() == 1) {
                    unqualifiedInputsBuilder.put((Object)name, argument);
                } else if (name.getParts().size() == 3) {
                    qualifiedInputsBuilder.put((Object)name, argument);
                } else {
                    throw new IllegalStateException("relation name should be unqualified or fully qualified");
                }
            });
            ImmutableMultimap unqualifiedInputs = unqualifiedInputsBuilder.build();
            ImmutableMultimap qualifiedInputs = qualifiedInputsBuilder.build();
            ImmutableList.Builder copartitionBuilder = ImmutableList.builder();
            HashSet<String> referencedArguments = new HashSet<String>();
            for (List<QualifiedName> nameList : copartitioning) {
                ImmutableList.Builder copartitionListBuilder = ImmutableList.builder();
                for (QualifiedName name : nameList) {
                    Collection<Object> candidates = Collections.emptyList();
                    if (name.getParts().size() == 1) {
                        candidates = unqualifiedInputs.get((Object)name);
                    }
                    if (candidates.isEmpty()) {
                        QualifiedObjectName fullyQualifiedName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)name.getOriginalParts().get(0), name);
                        candidates = qualifiedInputs.get((Object)QualifiedName.of((String)fullyQualifiedName.catalogName(), (String[])new String[]{fullyQualifiedName.schemaName(), fullyQualifiedName.objectName()}));
                    }
                    if (candidates.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COPARTITIONING, (Node)name.getOriginalParts().get(0), "No table argument found for name: %s", name);
                    }
                    if (candidates.size() > 1) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COPARTITIONING, (Node)name.getOriginalParts().get(0), "Ambiguous reference: multiple table arguments found for name: %s", name);
                    }
                    Analysis.TableArgumentAnalysis argument2 = (Analysis.TableArgumentAnalysis)Iterables.getOnlyElement(candidates);
                    if (!referencedArguments.add(argument2.getArgumentName())) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COPARTITIONING, (Node)name.getOriginalParts().get(0), "Multiple references to table argument: %s in COPARTITION clause", name);
                    }
                    copartitionListBuilder.add((Object)argument2);
                }
                ImmutableList copartitionList = copartitionListBuilder.build();
                copartitionList.stream().filter(argument -> argument.getPartitionBy().isEmpty()).findFirst().ifPresent(unpartitioned -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COPARTITIONING, (Node)unpartitioned.getRelation(), "Table %s referenced in COPARTITION clause is not partitioned", unpartitioned.getName().orElseThrow());
                });
                copartitionList.stream().filter(argument -> argument.getPartitionBy().orElseThrow().isEmpty()).findFirst().ifPresent(partitionedOnEmpty -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COPARTITIONING, (Node)partitionedOnEmpty.getRelation(), "No partitioning columns specified for table %s referenced in COPARTITION clause", partitionedOnEmpty.getName().orElseThrow());
                });
                List partitioningColumns = (List)copartitionList.stream().map(Analysis.TableArgumentAnalysis::getPartitionBy).map(Optional::orElseThrow).collect(ImmutableList.toImmutableList());
                if (partitioningColumns.stream().map(List::size).distinct().count() > 1L) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COPARTITIONING, (Node)nameList.get(0).getOriginalParts().get(0), "Numbers of partitioning columns in copartitioned tables do not match", new Object[0]);
                }
                for (int index = 0; index < ((List)partitioningColumns.get(0)).size(); ++index) {
                    Type commonSuperType = StatementAnalyzer.this.analysis.getType((Expression)((List)partitioningColumns.get(0)).get(index));
                    for (List columnList : partitioningColumns) {
                        Optional<Type> superType = StatementAnalyzer.this.typeCoercion.getCommonSuperType(commonSuperType, StatementAnalyzer.this.analysis.getType((Expression)columnList.get(index)));
                        if (superType.isEmpty()) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)nameList.get(0).getOriginalParts().get(0), "Partitioning columns in copartitioned tables have incompatible types", new Object[0]);
                        }
                        commonSuperType = superType.get();
                    }
                    for (List columnList : partitioningColumns) {
                        Expression column = (Expression)columnList.get(index);
                        Type type = StatementAnalyzer.this.analysis.getType(column);
                        if (type.equals((Object)commonSuperType)) continue;
                        if (!StatementAnalyzer.this.typeCoercion.canCoerce(type, commonSuperType)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)column, "Cannot coerce column of type %s to common supertype: %s", type.getDisplayName(), commonSuperType.getDisplayName());
                        }
                        StatementAnalyzer.this.analysis.addCoercion(column, commonSuperType);
                    }
                }
                copartitionBuilder.add((Object)((List)copartitionList.stream().map(Analysis.TableArgumentAnalysis::getArgumentName).collect(ImmutableList.toImmutableList())));
            }
            return copartitionBuilder.build();
        }

        private Optional<QualifiedName> getMaterializedViewStorageTableName(MaterializedViewDefinition viewDefinition) {
            if (viewDefinition.getStorageTable().isEmpty()) {
                return Optional.empty();
            }
            CatalogSchemaTableName catalogSchemaTableName = viewDefinition.getStorageTable().get();
            SchemaTableName schemaTableName = catalogSchemaTableName.getSchemaTableName();
            return Optional.of(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(catalogSchemaTableName.getCatalogName(), true), (Object)new Identifier(schemaTableName.getSchemaName(), true), (Object)new Identifier(schemaTableName.getTableName(), true))));
        }

        protected Scope visitTable(Table table, Optional<Scope> scope) {
            if (table.getName().getPrefix().isEmpty()) {
                Optional<WithQuery> withQuery = this.createScope(scope).getNamedQuery(table.getName().getSuffix());
                if (withQuery.isPresent()) {
                    StatementAnalyzer.this.analysis.setRelationName((Relation)table, table.getName());
                    return this.createScopeForCommonTableExpression(table, scope, withQuery.get());
                }
                Optional<Scope> expandableBaseScope = StatementAnalyzer.this.analysis.getExpandableBaseScope((Node)table);
                if (expandableBaseScope.isPresent()) {
                    Scope baseScope = expandableBaseScope.get();
                    Scope resultScope = this.scopeBuilder(scope).withRelationType(baseScope.getRelationId(), baseScope.getRelationType()).build();
                    StatementAnalyzer.this.analysis.setScope((Node)table, resultScope);
                    StatementAnalyzer.this.analysis.setRelationName((Relation)table, table.getName());
                    return resultScope;
                }
            }
            QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            StatementAnalyzer.this.analysis.setRelationName((Relation)table, QualifiedName.of((String)name.catalogName(), (String[])new String[]{name.schemaName(), name.objectName()}));
            Optional<MaterializedViewDefinition> optionalMaterializedView = StatementAnalyzer.this.metadata.getMaterializedView(StatementAnalyzer.this.session, name);
            if (optionalMaterializedView.isPresent()) {
                MaterializedViewDefinition materializedViewDefinition = optionalMaterializedView.get();
                StatementAnalyzer.this.analysis.addEmptyColumnReferencesForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), name);
                if (this.isMaterializedViewSufficientlyFresh(StatementAnalyzer.this.session, name, materializedViewDefinition)) {
                    QualifiedName storageName = this.getMaterializedViewStorageTableName(materializedViewDefinition).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "Materialized view '%s' is fresh but does not have storage table name", name));
                    QualifiedObjectName storageTableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, storageName);
                    this.checkStorageTableNotRedirected(storageTableName);
                    TableHandle tableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, storageTableName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "Storage table '%s' does not exist", storageTableName));
                    return this.createScopeForMaterializedView(table, name, scope, materializedViewDefinition, Optional.of(tableHandle));
                }
                return this.createScopeForMaterializedView(table, name, scope, materializedViewDefinition, Optional.empty());
            }
            Optional<ViewDefinition> optionalView = StatementAnalyzer.this.metadata.getView(StatementAnalyzer.this.session, name);
            if (optionalView.isPresent()) {
                StatementAnalyzer.this.analysis.addEmptyColumnReferencesForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), name);
                return this.createScopeForView(table, name, scope, optionalView.get());
            }
            RedirectionAwareTableHandle redirection = this.getTableHandle(table, name, scope);
            Optional<TableHandle> tableHandle = redirection.tableHandle();
            QualifiedObjectName targetTableName = redirection.redirectedTableName().orElse(name);
            StatementAnalyzer.this.analysis.addEmptyColumnReferencesForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), targetTableName);
            if (tableHandle.isEmpty()) {
                MetadataUtil.getRequiredCatalogHandle(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, (Node)table, targetTableName.catalogName());
                if (!StatementAnalyzer.this.metadata.schemaExists(StatementAnalyzer.this.session, new CatalogSchemaName(targetTableName.catalogName(), targetTableName.schemaName()))) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)table, "Schema '%s' does not exist", targetTableName.schemaName());
                }
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)table, "Table '%s' does not exist", targetTableName);
            }
            TableSchema tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.session, tableHandle.get());
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, tableHandle.get());
            ImmutableList.Builder fields = ImmutableList.builder();
            fields.addAll(this.analyzeTableOutputFields(table, targetTableName, tableSchema, columnHandles));
            boolean addRowIdColumn = this.updateKind.isPresent();
            if (addRowIdColumn) {
                ColumnHandle rowIdColumnHandle = StatementAnalyzer.this.metadata.getMergeRowIdColumnHandle(StatementAnalyzer.this.session, tableHandle.get());
                Type type = StatementAnalyzer.this.metadata.getColumnMetadata(StatementAnalyzer.this.session, tableHandle.get(), rowIdColumnHandle).getType();
                Field field = Field.newUnqualified(Optional.empty(), type);
                fields.add((Object)field);
                StatementAnalyzer.this.analysis.setColumn(field, rowIdColumnHandle);
            }
            ImmutableList outputFields = fields.build();
            Scope accessControlScope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType((List<Field>)outputFields)).build();
            this.analyzeFiltersAndMasks(table, targetTableName, new RelationType((List<Field>)outputFields), accessControlScope);
            StatementAnalyzer.this.analysis.registerTable(table, tableHandle, targetTableName, StatementAnalyzer.this.session.getIdentity().getUser(), accessControlScope, Optional.empty());
            Scope tableScope = this.createAndAssignScope((Node)table, scope, (List<Field>)outputFields);
            if (addRowIdColumn) {
                FieldReference reference = new FieldReference(outputFields.size() - 1);
                this.analyzeExpression((Expression)reference, tableScope);
                StatementAnalyzer.this.analysis.setRowIdField(table, reference);
            }
            return tableScope;
        }

        private boolean isMaterializedViewSufficientlyFresh(Session session, QualifiedObjectName name, MaterializedViewDefinition materializedViewDefinition) {
            MaterializedViewFreshness materializedViewFreshness = StatementAnalyzer.this.metadata.getMaterializedViewFreshness(session, name);
            MaterializedViewFreshness.Freshness freshness = materializedViewFreshness.getFreshness();
            if (freshness == MaterializedViewFreshness.Freshness.FRESH) {
                return true;
            }
            Optional lastFreshTime = materializedViewFreshness.getLastFreshTime();
            if (lastFreshTime.isEmpty()) {
                return false;
            }
            if (materializedViewDefinition.getGracePeriod().isEmpty()) {
                return true;
            }
            Duration gracePeriod = materializedViewDefinition.getGracePeriod().get();
            if (gracePeriod.isZero()) {
                return false;
            }
            Duration staleness = Duration.between((Temporal)lastFreshTime.get(), StatementAnalyzer.this.sessionTimeProvider.getStart(session));
            return staleness.compareTo(gracePeriod) <= 0;
        }

        private void checkStorageTableNotRedirected(QualifiedObjectName source) {
            StatementAnalyzer.this.metadata.getRedirectionAwareTableHandle(StatementAnalyzer.this.session, source).redirectedTableName().ifPresent(name -> {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Redirection of materialized view storage table '%s' to '%s' is not supported", source, name));
            });
        }

        private void analyzeFiltersAndMasks(Table table, QualifiedObjectName name, RelationType relationType, Scope accessControlScope) {
            for (int index = 0; index < relationType.getAllFieldCount(); ++index) {
                Optional<ViewExpression> mask;
                Field field = relationType.getFieldByIndex(index);
                if (!field.getName().isPresent() || !(mask = StatementAnalyzer.this.accessControl.getColumnMask(StatementAnalyzer.this.session.toSecurityContext(), name, field.getName().get(), field.getType())).isPresent() || !this.checkCanSelectFromColumn(name, field.getName().orElseThrow())) continue;
                this.analyzeColumnMask(StatementAnalyzer.this.session.getIdentity().getUser(), table, name, field, accessControlScope, mask.get());
            }
            StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.toSecurityContext(), name).forEach(filter -> this.analyzeRowFilter(StatementAnalyzer.this.session.getIdentity().getUser(), table, name, accessControlScope, (ViewExpression)filter));
        }

        private void analyzeCheckConstraints(Table table, QualifiedObjectName name, Scope accessControlScope, List<String> constraints) {
            for (String constraint : constraints) {
                ViewExpression expression = ViewExpression.builder().catalog(name.catalogName()).schema(name.schemaName()).expression(constraint).build();
                this.analyzeCheckConstraint(table, name, accessControlScope, expression);
            }
        }

        private boolean checkCanSelectFromColumn(QualifiedObjectName name, String column) {
            try {
                StatementAnalyzer.this.accessControl.checkCanSelectFromColumns(StatementAnalyzer.this.session.toSecurityContext(), name, (Set<String>)ImmutableSet.of((Object)column));
                return true;
            }
            catch (AccessDeniedException e) {
                return false;
            }
        }

        private Scope createScopeForCommonTableExpression(Table table, Optional<Scope> scope, WithQuery withQuery) {
            ImmutableList fields;
            Query query = withQuery.getQuery();
            StatementAnalyzer.this.analysis.registerNamedQuery(table, query);
            RelationType queryDescriptor = StatementAnalyzer.this.analysis.getOutputDescriptor((Node)query);
            Optional columnNames = withQuery.getColumnNames();
            if (columnNames.isPresent()) {
                Preconditions.checkState((((List)columnNames.get()).size() == queryDescriptor.getVisibleFieldCount() ? 1 : 0) != 0, (Object)"mismatched aliases");
                ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                Iterator aliases = ((List)columnNames.get()).iterator();
                for (int i = 0; i < queryDescriptor.getAllFieldCount(); ++i) {
                    Field inputField = queryDescriptor.getFieldByIndex(i);
                    if (inputField.isHidden()) continue;
                    Field field = Field.newQualified(QualifiedName.of((String)table.getName().getSuffix()), Optional.of(((Identifier)aliases.next()).getValue()), inputField.getType(), false, inputField.getOriginTable(), inputField.getOriginColumnName(), inputField.isAliased());
                    fieldBuilder.add((Object)field);
                    StatementAnalyzer.this.analysis.addSourceColumns(field, StatementAnalyzer.this.analysis.getSourceColumns(inputField));
                }
                fields = fieldBuilder.build();
            } else {
                ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                for (int i = 0; i < queryDescriptor.getAllFieldCount(); ++i) {
                    Field inputField = queryDescriptor.getFieldByIndex(i);
                    if (inputField.isHidden()) continue;
                    Field field = Field.newQualified(QualifiedName.of((String)table.getName().getSuffix()), inputField.getName(), inputField.getType(), false, inputField.getOriginTable(), inputField.getOriginColumnName(), inputField.isAliased());
                    fieldBuilder.add((Object)field);
                    StatementAnalyzer.this.analysis.addSourceColumns(field, StatementAnalyzer.this.analysis.getSourceColumns(inputField));
                }
                fields = fieldBuilder.build();
            }
            return this.createAndAssignScope((Node)table, scope, (List<Field>)fields);
        }

        private Scope createScopeForMaterializedView(Table table, QualifiedObjectName name, Optional<Scope> scope, MaterializedViewDefinition view, Optional<TableHandle> storageTable) {
            return this.createScopeForView(table, name, scope, view.getOriginalSql(), view.getCatalog(), view.getSchema(), view.getRunAsIdentity(), view.getPath(), view.getColumns(), storageTable, true);
        }

        private Scope createScopeForView(Table table, QualifiedObjectName name, Optional<Scope> scope, ViewDefinition view) {
            return this.createScopeForView(table, name, scope, view.getOriginalSql(), view.getCatalog(), view.getSchema(), view.getRunAsIdentity(), view.getPath(), view.getColumns(), Optional.empty(), false);
        }

        private Scope createScopeForView(Table table, QualifiedObjectName name, Optional<Scope> scope, String originalSql, Optional<String> catalog, Optional<String> schema, Optional<Identity> owner, List<CatalogSchemaName> path, List<ViewColumn> columns, Optional<TableHandle> storageTable, boolean isMaterializedView) {
            QualifiedObjectName viewNameFromStatement;
            CreateView viewStatement;
            Statement statement = StatementAnalyzer.this.analysis.getStatement();
            if (statement instanceof CreateView) {
                viewStatement = (CreateView)statement;
                viewNameFromStatement = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)viewStatement, viewStatement.getName());
                if (viewStatement.isReplace() && viewNameFromStatement.equals(name)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.VIEW_IS_RECURSIVE, (Node)table, "Statement would create a recursive view", new Object[0]);
                }
            }
            if (statement instanceof CreateMaterializedView) {
                viewStatement = (CreateMaterializedView)statement;
                viewNameFromStatement = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)viewStatement, viewStatement.getName());
                if (viewStatement.isReplace() && viewNameFromStatement.equals(name)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.VIEW_IS_RECURSIVE, (Node)table, "Statement would create a recursive materialized view", new Object[0]);
                }
            }
            if (StatementAnalyzer.this.analysis.hasTableInView(table)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.VIEW_IS_RECURSIVE, (Node)table, "View is recursive", new Object[0]);
            }
            Query query = this.parseView(originalSql, name, (Node)table);
            if (!query.getFunctions().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)table, "View contains inline function: %s", name);
            }
            StatementAnalyzer.this.analysis.registerTableForView(table, name, isMaterializedView);
            RelationType descriptor = this.analyzeView(query, name, catalog, schema, owner, path, table);
            StatementAnalyzer.this.analysis.unregisterTableForView();
            this.checkViewStaleness(columns, descriptor.getVisibleFields(), name, (Node)table).ifPresent(explanation -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.VIEW_IS_STALE, (Node)table, "View '%s' is stale or in invalid state: %s", name, explanation);
            });
            List viewFields = (List)columns.stream().map(column -> Field.newQualified(table.getName(), Optional.of(column.name()), this.getViewColumnType((ViewColumn)column, name, (Node)table), false, Optional.of(name), Optional.of(column.name()), false)).collect(ImmutableList.toImmutableList());
            if (storageTable.isPresent()) {
                List<Field> storageTableFields = this.analyzeStorageTable(table, viewFields, storageTable.get());
                StatementAnalyzer.this.analysis.setMaterializedViewStorageTableFields(table, storageTableFields);
            } else {
                StatementAnalyzer.this.analysis.registerNamedQuery(table, query);
            }
            Scope accessControlScope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(viewFields)).build();
            this.analyzeFiltersAndMasks(table, name, new RelationType(viewFields), accessControlScope);
            StatementAnalyzer.this.analysis.registerTable(table, storageTable, name, StatementAnalyzer.this.session.getIdentity().getUser(), accessControlScope, Optional.of(originalSql));
            viewFields.forEach(field -> StatementAnalyzer.this.analysis.addSourceColumns((Field)field, (Set<Analysis.SourceColumn>)ImmutableSet.of((Object)new Analysis.SourceColumn(name, field.getName().orElseThrow()))));
            return this.createAndAssignScope((Node)table, scope, viewFields);
        }

        private List<Field> analyzeStorageTable(Table table, List<Field> viewFields, TableHandle storageTable) {
            TableSchema tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.session, storageTable);
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, storageTable);
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            this.checkStorageTableNotRedirected(tableName);
            List tableFields = (List)this.analyzeTableOutputFields(table, tableName, tableSchema, columnHandles).stream().filter(field -> !field.isHidden()).collect(ImmutableList.toImmutableList());
            if (tableFields.size() != viewFields.size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "storage table column count (%s) does not match column count derived from the materialized view query analysis (%s)", tableFields.size(), viewFields.size());
            }
            for (int index = 0; index < tableFields.size(); ++index) {
                Field tableField = (Field)tableFields.get(index);
                Field viewField = viewFields.get(index);
                if (tableField.getName().isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "a column of type %s projected from query view at position %s has no name", tableField.getType(), index);
                }
                String tableFieldName = tableField.getName().orElseThrow();
                String viewFieldName = viewField.getName().orElseThrow();
                if (!viewFieldName.equalsIgnoreCase(tableFieldName)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "column [%s] of type %s projected from storage table at position %s has a different name from column [%s] of type %s stored in materialized view definition", tableFieldName, tableField.getType(), index, viewFieldName, viewField.getType());
                }
                if (tableField.getType().equals((Object)viewField.getType())) continue;
                try {
                    StatementAnalyzer.this.metadata.getCoercion(viewField.getType(), tableField.getType());
                    continue;
                }
                catch (TrinoException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)table, "cannot cast column [%s] of type %s projected from storage table at position %s into column [%s] of type %s stored in view definition", tableFieldName, tableField.getType(), index, viewFieldName, viewField.getType());
                }
            }
            return tableFields;
        }

        private List<Field> analyzeTableOutputFields(Table table, QualifiedObjectName tableName, TableSchema tableSchema, Map<String, ColumnHandle> columnHandles) {
            ImmutableList.Builder fields = ImmutableList.builder();
            for (ColumnSchema column : tableSchema.columns()) {
                Field field = Field.newQualified(table.getName(), Optional.of(column.getName()), column.getType(), column.isHidden(), Optional.of(tableName), Optional.of(column.getName()), false);
                fields.add((Object)field);
                ColumnHandle columnHandle = columnHandles.get(column.getName());
                Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Unknown field %s", (Object)field);
                StatementAnalyzer.this.analysis.setColumn(field, columnHandle);
                StatementAnalyzer.this.analysis.addSourceColumns(field, (Set<Analysis.SourceColumn>)ImmutableSet.of((Object)new Analysis.SourceColumn(tableName, column.getName())));
            }
            return fields.build();
        }

        protected Scope visitPatternRecognitionRelation(PatternRecognitionRelation relation, Optional<Scope> scope) {
            ImmutableList outputFields;
            Scope inputScope = this.process((Node)relation.getInput(), scope);
            this.validateNoNestedTableFunction(relation.getInput(), "row pattern matching");
            HashSet inputNames = new HashSet();
            for (Field field : inputScope.getRelationType().getAllFields()) {
                field.getName().ifPresent(name -> {
                    if (!inputNames.add(name.toUpperCase(Locale.ENGLISH))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)relation.getInput(), "ambiguous column: %s in row pattern input relation", name);
                    }
                });
            }
            for (Expression expression : relation.getPartitionBy()) {
                this.validateAndGetInputField(expression, inputScope);
                Type type = this.analyzeExpression(expression, inputScope).getType(expression);
                if (type.isComparable()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "%s is not comparable, and therefore cannot be used in PARTITION BY", type);
            }
            for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(relation.getOrderBy())) {
                Expression expression = sortItem.getSortKey();
                this.validateAndGetInputField(expression, inputScope);
                Type type = this.analyzeExpression(expression, inputScope).getType(sortItem.getSortKey());
                if (type.isOrderable()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)sortItem, "%s is not orderable, and therefore cannot be used in ORDER BY", type);
            }
            PatternRecognitionAnalysis patternRecognitionAnalysis = PatternRecognitionAnalyzer.analyze(relation.getSubsets(), relation.getVariableDefinitions(), relation.getMeasures(), relation.getPattern(), relation.getAfterMatchSkipTo());
            relation.getAfterMatchSkipTo().flatMap(SkipTo::getIdentifier).ifPresent(label -> StatementAnalyzer.this.analysis.addResolvedLabel((Identifier)label, label.getCanonicalValue()));
            for (SubsetDefinition subset : relation.getSubsets()) {
                StatementAnalyzer.this.analysis.addResolvedLabel(subset.getName(), subset.getName().getCanonicalValue());
                StatementAnalyzer.this.analysis.addSubsetLabels(subset, subset.getIdentifiers().stream().map(Identifier::getCanonicalValue).collect(Collectors.toSet()));
            }
            StatementAnalyzer.this.analysis.setUndefinedLabels(relation.getPattern(), patternRecognitionAnalysis.undefinedLabels());
            StatementAnalyzer.this.analysis.setRanges(patternRecognitionAnalysis.ranges());
            PatternRecognitionAnalyzer.validateNoPatternSearchMode(relation.getPatternSearchMode());
            PatternRecognitionAnalyzer.validatePatternExclusions(relation.getRowsPerMatch(), relation.getPattern());
            for (Object variableDefinition : relation.getVariableDefinitions()) {
                Expression expression = variableDefinition.getExpression();
                ExpressionAnalysis expressionAnalysis = this.analyzePatternRecognitionExpression(expression, inputScope, patternRecognitionAnalysis.allLabels());
                StatementAnalyzer.this.analysis.recordSubqueries((Node)relation, expressionAnalysis);
                StatementAnalyzer.this.analysis.addResolvedLabel(variableDefinition.getName(), variableDefinition.getName().getCanonicalValue());
                Type type = expressionAnalysis.getType(expression);
                if (type.equals((Object)BooleanType.BOOLEAN)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "Expression defining a label must be boolean (actual type: %s)", type);
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (MeasureDefinition measureDefinition : relation.getMeasures()) {
                Expression expression = measureDefinition.getExpression();
                ExpressionAnalysis expressionAnalysis = this.analyzePatternRecognitionExpression(expression, inputScope, patternRecognitionAnalysis.allLabels());
                StatementAnalyzer.this.analysis.recordSubqueries((Node)relation, expressionAnalysis);
                StatementAnalyzer.this.analysis.addResolvedLabel(measureDefinition.getName(), measureDefinition.getName().getCanonicalValue());
                builder.put((Object)NodeRef.of((Node)expression), (Object)expressionAnalysis.getType(expression));
            }
            ImmutableMap measureTypes = builder.buildOrThrow();
            PatternRecognitionRelation.RowsPerMatch rowsPerMatch = relation.getRowsPerMatch().orElse(PatternRecognitionRelation.RowsPerMatch.ONE);
            boolean oneRowPerMatch = rowsPerMatch == PatternRecognitionRelation.RowsPerMatch.ONE || rowsPerMatch == PatternRecognitionRelation.RowsPerMatch.WINDOW;
            ImmutableSet.Builder inputFieldsOnOutputBuilder = ImmutableSet.builder();
            ImmutableList.Builder outputFieldsBuilder = ImmutableList.builder();
            for (Expression expression : relation.getPartitionBy()) {
                Field inputField2 = this.validateAndGetInputField(expression, inputScope);
                outputFieldsBuilder.add((Object)this.unqualifiedVisible(inputField2));
                inputFieldsOnOutputBuilder.add((Object)inputField2);
            }
            if (!oneRowPerMatch) {
                for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(relation.getOrderBy())) {
                    Field inputField = this.validateAndGetInputField(sortItem.getSortKey(), inputScope);
                    outputFieldsBuilder.add((Object)this.unqualifiedVisible(inputField));
                    inputFieldsOnOutputBuilder.add((Object)inputField);
                }
            }
            for (MeasureDefinition measureDefinition : relation.getMeasures()) {
                outputFieldsBuilder.add((Object)Field.newUnqualified(measureDefinition.getName().getValue(), (Type)measureTypes.get(NodeRef.of((Node)measureDefinition.getExpression()))));
            }
            if (!oneRowPerMatch) {
                ImmutableSet inputFieldsOnOutput = inputFieldsOnOutputBuilder.build();
                for (Field inputField : inputScope.getRelationType().getAllFields()) {
                    if (inputFieldsOnOutput.contains(inputField)) continue;
                    outputFieldsBuilder.add((Object)this.unqualified(inputField));
                }
            }
            if ((outputFields = outputFieldsBuilder.build()).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_HAS_NO_COLUMNS, (Node)relation, "pattern recognition output table has no columns", new Object[0]);
            }
            return this.createAndAssignScope((Node)relation, scope, (List<Field>)outputFields);
        }

        private Field validateAndGetInputField(Expression expression, Scope inputScope) {
            QualifiedName qualifiedName;
            if (expression instanceof Identifier) {
                qualifiedName = QualifiedName.of((Iterable)ImmutableList.of((Object)((Identifier)expression)));
            } else if (expression instanceof DereferenceExpression) {
                qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
            } else {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, (Node)expression, "Expected column reference. Actual: %s", expression);
            }
            Optional<ResolvedField> field = inputScope.tryResolveField(expression, qualifiedName);
            if (field.isEmpty() || !field.get().isLocal()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)expression, "Column %s is not present in the input relation", expression);
            }
            return field.get().getField();
        }

        private Field unqualifiedVisible(Field field) {
            return new Field(Optional.empty(), field.getName(), field.getType(), false, field.getOriginTable(), field.getOriginColumnName(), field.isAliased());
        }

        private Field unqualified(Field field) {
            return new Field(Optional.empty(), field.getName(), field.getType(), field.isHidden(), field.getOriginTable(), field.getOriginColumnName(), field.isAliased());
        }

        private ExpressionAnalysis analyzePatternRecognitionExpression(Expression expression, Scope scope, Set<String> labels) {
            List<Expression> nestedWindowExpressions = ExpressionTreeUtils.extractWindowExpressions((Iterable<? extends Node>)ImmutableList.of((Object)expression));
            if (!nestedWindowExpressions.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)nestedWindowExpressions.getFirst(), "Cannot nest window functions or row pattern measures inside pattern recognition expressions", new Object[0]);
            }
            return ExpressionAnalyzer.analyzePatternRecognitionExpression(StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, labels);
        }

        protected Scope visitAliasedRelation(AliasedRelation relation, Optional<Scope> scope) {
            int totalColumns;
            StatementAnalyzer.this.analysis.setRelationName((Relation)relation, QualifiedName.of((Iterable)ImmutableList.of((Object)relation.getAlias())));
            StatementAnalyzer.this.analysis.addAliased(relation.getRelation());
            Scope relationScope = this.process((Node)relation.getRelation(), scope);
            RelationType relationType = relationScope.getRelationType();
            Relation relation2 = relation.getRelation();
            if (relation2 instanceof TableFunctionInvocation) {
                TableFunctionInvocation function = (TableFunctionInvocation)relation2;
                return this.createAndAssignScope((Node)relation, scope, this.aliasTableFunctionInvocation(relation, relationType, function));
            }
            if (relation.getColumnNames() != null && (totalColumns = relationType.getVisibleFieldCount()) != relation.getColumnNames().size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)relation, "Column alias list has %s entries but '%s' has %s columns available", relation.getColumnNames().size(), relation.getAlias(), totalColumns);
            }
            List aliases = null;
            Collection<Field> inputFields = relationType.getAllFields();
            if (relation.getColumnNames() != null) {
                aliases = relation.getColumnNames().stream().map(Identifier::getValue).collect(Collectors.toList());
                inputFields = relationType.getVisibleFields();
            }
            RelationType descriptor = relationType.withAlias(relation.getAlias().getValue(), aliases);
            Preconditions.checkArgument((inputFields.size() == descriptor.getAllFieldCount() ? 1 : 0) != 0, (String)"Expected %s fields, got %s", (int)descriptor.getAllFieldCount(), (int)inputFields.size());
            Streams.forEachPair(descriptor.getAllFields().stream(), inputFields.stream(), (newField, field) -> StatementAnalyzer.this.analysis.addSourceColumns((Field)newField, StatementAnalyzer.this.analysis.getSourceColumns((Field)field)));
            return this.createAndAssignScope((Node)relation, scope, descriptor);
        }

        private RelationType aliasTableFunctionInvocation(AliasedRelation relation, RelationType relationType, TableFunctionInvocation function) {
            int i;
            Analysis.TableFunctionInvocationAnalysis tableFunctionAnalysis = StatementAnalyzer.this.analysis.getTableFunctionAnalysis(function);
            int properColumnsCount = tableFunctionAnalysis.getProperColumnsCount();
            tableFunctionAnalysis.getTableArgumentAnalyses().stream().map(Analysis.TableArgumentAnalysis::getName).filter(Optional::isPresent).map(Optional::get).filter(name -> name.hasSuffix(QualifiedName.of((Iterable)ImmutableList.of((Object)relation.getAlias())))).findFirst().ifPresent(name -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_RANGE_VARIABLE, (Node)relation.getAlias(), "Relation alias: %s is a duplicate of input table name: %s", relation.getAlias(), name);
            });
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            if (relation.getColumnNames() != null) {
                if (properColumnsCount != relation.getColumnNames().size()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)relation, "Column alias list has %s entries but table function has %s proper columns", relation.getColumnNames().size(), properColumnsCount);
                }
                for (i = 0; i < properColumnsCount; ++i) {
                    field = relationType.getFieldByIndex(i);
                    fieldsBuilder.add((Object)Field.newQualified(QualifiedName.of((Iterable)ImmutableList.of((Object)relation.getAlias())), Optional.of(((Identifier)relation.getColumnNames().get(i)).getCanonicalValue()), field.getType(), field.isHidden(), field.getOriginTable(), field.getOriginColumnName(), field.isAliased()));
                }
            } else {
                for (i = 0; i < properColumnsCount; ++i) {
                    field = relationType.getFieldByIndex(i);
                    fieldsBuilder.add((Object)Field.newQualified(QualifiedName.of((Iterable)ImmutableList.of((Object)relation.getAlias())), field.getName(), field.getType(), field.isHidden(), field.getOriginTable(), field.getOriginColumnName(), field.isAliased()));
                }
            }
            for (i = properColumnsCount; i < relationType.getAllFieldCount(); ++i) {
                fieldsBuilder.add((Object)relationType.getFieldByIndex(i));
            }
            ImmutableList fields = fieldsBuilder.build();
            HashSet names = new HashSet();
            fields.subList(0, properColumnsCount).stream().map(Field::getName).filter(Optional::isPresent).map(Optional::get).map(name -> name.toLowerCase(Locale.ENGLISH)).forEach(name -> {
                if (!names.add(name)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)relation.getRelation(), "Duplicate name of table function proper column: %s", name);
                }
            });
            return new RelationType((List<Field>)fields);
        }

        protected Scope visitSampledRelation(SampledRelation relation, Optional<Scope> scope) {
            Expression samplePercentage = relation.getSamplePercentage();
            if (!NamesExtractor.extractNames(samplePercentage, StatementAnalyzer.this.analysis.getColumnReferences()).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)samplePercentage, "Sample percentage cannot contain column references", new Object[0]);
            }
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.analyzeExpressions(StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, (Iterable<Expression>)ImmutableList.of((Object)samplePercentage), StatementAnalyzer.this.analysis.getParameters(), WarningCollector.NOOP, StatementAnalyzer.this.analysis.getQueryType()).getExpressionTypes();
            Type samplePercentageType = expressionTypes.get(NodeRef.of((Node)samplePercentage));
            if (!StatementAnalyzer.this.typeCoercion.canCoerce(samplePercentageType, (Type)DoubleType.DOUBLE)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)samplePercentage, "Sample percentage should be a numeric expression", new Object[0]);
            }
            if (samplePercentageType == UnknownType.UNKNOWN) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)samplePercentage, "Sample percentage cannot be NULL", new Object[0]);
            }
            Object samplePercentageObject = ConstantEvaluator.evaluateConstant(samplePercentage, samplePercentageType, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.session, StatementAnalyzer.this.accessControl);
            if (samplePercentageObject == null) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)samplePercentage, "Sample percentage cannot be NULL", new Object[0]);
            }
            double samplePercentageValue = (Double)this.coerce(samplePercentageType, samplePercentageObject, (Type)DoubleType.DOUBLE);
            if (samplePercentageValue < 0.0) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)samplePercentage, "Sample percentage must be greater than or equal to 0", new Object[0]);
            }
            if (samplePercentageValue > 100.0) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)samplePercentage, "Sample percentage must be less than or equal to 100", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setSampleRatio(relation, samplePercentageValue / 100.0);
            Scope relationScope = this.process((Node)relation.getRelation(), scope);
            this.validateNoNestedTableFunction(relation.getRelation(), "sample");
            return this.createAndAssignScope((Node)relation, scope, relationScope.getRelationType());
        }

        private void validateNoNestedTableFunction(Relation base, String context) {
            AliasedRelation aliasedRelation;
            Relation relation;
            TableFunctionInvocation tableFunctionInvocation = null;
            if (base instanceof TableFunctionInvocation) {
                TableFunctionInvocation invocation;
                tableFunctionInvocation = invocation = (TableFunctionInvocation)base;
            } else if (base instanceof AliasedRelation && (relation = (aliasedRelation = (AliasedRelation)base).getRelation()) instanceof TableFunctionInvocation) {
                TableFunctionInvocation invocation;
                tableFunctionInvocation = invocation = (TableFunctionInvocation)relation;
            }
            if (tableFunctionInvocation != null && StatementAnalyzer.this.analysis.isPolymorphicTableFunction(tableFunctionInvocation)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_FUNCTION_INVOCATION, (Node)base, "Cannot apply %s to polymorphic table function invocation", context);
            }
        }

        protected Scope visitTableSubquery(TableSubquery node, Optional<Scope> scope) {
            StatementAnalyzer analyzer = StatementAnalyzer.this.statementAnalyzerFactory.createStatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope.orElseThrow());
            return this.createAndAssignScope((Node)node, scope, queryScope.getRelationType());
        }

        protected Scope visitQuerySpecification(QuerySpecification node, Optional<Scope> scope) {
            boolean requiresOrderBy;
            Scope sourceScope = this.analyzeFrom(node, scope);
            this.analyzeWindowDefinitions(node, sourceScope);
            this.resolveFunctionCallAndMeasureWindows(node);
            node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, sourceScope, (Expression)where));
            List<Expression> outputExpressions = this.analyzeSelect(node, sourceScope);
            Analysis.GroupingSetAnalysis groupByAnalysis = this.analyzeGroupBy(node, sourceScope, outputExpressions);
            this.analyzeHaving(node, sourceScope);
            Scope outputScope = this.computeAndAssignOutputScope(node, scope, sourceScope);
            List<Expression> orderByExpressions = Collections.emptyList();
            Optional<Object> orderByScope = Optional.empty();
            if (node.getOrderBy().isPresent()) {
                OrderBy orderBy = (OrderBy)node.getOrderBy().get();
                orderByScope = Optional.of(this.computeAndAssignOrderByScope(orderBy, sourceScope, outputScope));
                orderByExpressions = this.analyzeOrderBy((Node)node, orderBy.getSortItems(), (Scope)orderByScope.get());
                if ((sourceScope.getOuterQueryParent().isPresent() || !this.isTopLevel) && node.getLimit().isEmpty() && node.getOffset().isEmpty()) {
                    StatementAnalyzer.this.analysis.markRedundantOrderBy(orderBy);
                    this.warningCollector.add(new TrinoWarning((WarningCodeSupplier)StandardWarningCode.REDUNDANT_ORDER_BY, "ORDER BY in subquery may have no effect"));
                }
            }
            StatementAnalyzer.this.analysis.setOrderByExpressions((Node)node, orderByExpressions);
            if (node.getOffset().isPresent()) {
                this.analyzeOffset((Offset)node.getOffset().get(), outputScope);
            }
            if (node.getLimit().isPresent() && (requiresOrderBy = this.analyzeLimit((Node)node.getLimit().get(), outputScope)) && node.getOrderBy().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, (Node)node.getLimit().get(), "FETCH FIRST WITH TIES clause requires ORDER BY", new Object[0]);
            }
            ArrayList<Expression> sourceExpressions = new ArrayList<Expression>();
            StatementAnalyzer.this.analysis.getSelectExpressions((Node)node).stream().map(Analysis.SelectExpression::getExpression).forEach(sourceExpressions::add);
            node.getHaving().ifPresent(sourceExpressions::add);
            for (WindowDefinition windowDefinition : node.getWindows()) {
                WindowSpecification window = windowDefinition.getWindow();
                sourceExpressions.addAll(window.getPartitionBy());
                NodeUtils.getSortItemsFromOrderBy(window.getOrderBy()).stream().map(SortItem::getSortKey).forEach(sourceExpressions::add);
                if (!window.getFrame().isPresent()) continue;
                WindowFrame frame = (WindowFrame)window.getFrame().get();
                frame.getStart().getValue().ifPresent(sourceExpressions::add);
                frame.getEnd().flatMap(FrameBound::getValue).ifPresent(sourceExpressions::add);
                frame.getMeasures().stream().map(MeasureDefinition::getExpression).forEach(sourceExpressions::add);
                frame.getVariableDefinitions().stream().map(VariableDefinition::getExpression).forEach(sourceExpressions::add);
            }
            this.analyzeGroupingOperations(node, sourceExpressions, orderByExpressions);
            this.analyzeAggregations(node, sourceScope, orderByScope, groupByAnalysis, sourceExpressions, orderByExpressions);
            this.analyzeWindowFunctionsAndMeasures(node, outputExpressions, orderByExpressions);
            if (StatementAnalyzer.this.analysis.isAggregation(node) && node.getOrderBy().isPresent()) {
                ImmutableList.Builder aggregates = ImmutableList.builder().addAll(groupByAnalysis.getOriginalExpressions()).addAll(ExpressionTreeUtils.extractAggregateFunctions(orderByExpressions, StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl)).addAll(ExpressionTreeUtils.extractExpressions(orderByExpressions, GroupingOperation.class));
                StatementAnalyzer.this.analysis.setOrderByAggregates((OrderBy)node.getOrderBy().get(), (List<Expression>)aggregates.build());
            }
            if (node.getOrderBy().isPresent() && node.getSelect().isDistinct()) {
                this.verifySelectDistinct(node, orderByExpressions, outputExpressions, sourceScope, (Scope)orderByScope.orElseThrow());
            }
            return outputScope;
        }

        protected Scope visitSubqueryExpression(SubqueryExpression node, Optional<Scope> context) {
            return this.process((Node)node.getQuery(), context);
        }

        protected Scope visitSetOperation(SetOperation node, Optional<Scope> scope) {
            Preconditions.checkState((node.getRelations().size() >= 2 ? 1 : 0) != 0);
            List childrenTypes = (List)node.getRelations().stream().map(relation -> this.process((Node)relation, scope).getRelationType().withOnlyVisibleFields()).collect(ImmutableList.toImmutableList());
            String setOperationName = node.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
            Type[] outputFieldTypes = (Type[])((RelationType)childrenTypes.get(0)).getVisibleFields().stream().map(Field::getType).toArray(Type[]::new);
            Type[] typeArray = childrenTypes.iterator();
            while (typeArray.hasNext()) {
                int outputFieldSize = outputFieldTypes.length;
                RelationType relationType2 = (RelationType)typeArray.next();
                int descFieldSize = relationType2.getVisibleFields().size();
                if (outputFieldSize != descFieldSize) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "%s query has different number of fields: %d, %d", setOperationName, outputFieldSize, descFieldSize);
                }
                for (int i = 0; i < descFieldSize; ++i) {
                    Type descFieldType = relationType2.getFieldByIndex(i).getType();
                    Optional<Type> commonSuperType = StatementAnalyzer.this.typeCoercion.getCommonSuperType(outputFieldTypes[i], descFieldType);
                    if (commonSuperType.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "column %d in %s query has incompatible types: %s, %s", i + 1, setOperationName, outputFieldTypes[i].getDisplayName(), descFieldType.getDisplayName());
                    }
                    outputFieldTypes[i] = commonSuperType.get();
                }
            }
            if (node instanceof Intersect || node instanceof Except || node instanceof Union && node.isDistinct()) {
                for (Type type : outputFieldTypes) {
                    if (type.isComparable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Type %s is not comparable and therefore cannot be used in %s%s", type, setOperationName, node instanceof Union ? " DISTINCT" : "");
                }
            }
            Field[] outputDescriptorFields = new Field[outputFieldTypes.length];
            RelationType firstDescriptor = (RelationType)childrenTypes.getFirst();
            int i = 0;
            while (i < outputFieldTypes.length) {
                Field oldField = firstDescriptor.getFieldByIndex(i);
                outputDescriptorFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), outputFieldTypes[i], oldField.isHidden(), oldField.getOriginTable(), oldField.getOriginColumnName(), oldField.isAliased());
                int index = i++;
                StatementAnalyzer.this.analysis.addSourceColumns(outputDescriptorFields[index], (Set)childrenTypes.stream().map(relationType -> relationType.getFieldByIndex(index)).flatMap(field -> StatementAnalyzer.this.analysis.getSourceColumns((Field)field).stream()).collect(ImmutableSet.toImmutableSet()));
            }
            block4: for (i = 0; i < node.getRelations().size(); ++i) {
                Relation relation2 = (Relation)node.getRelations().get(i);
                RelationType relationType3 = (RelationType)childrenTypes.get(i);
                for (int j = 0; j < relationType3.getVisibleFields().size(); ++j) {
                    Type outputFieldType = outputFieldTypes[j];
                    Type descFieldType = relationType3.getFieldByIndex(j).getType();
                    if (outputFieldType.equals((Object)descFieldType)) continue;
                    StatementAnalyzer.this.analysis.addRelationCoercion(relation2, outputFieldTypes);
                    continue block4;
                }
            }
            return this.createAndAssignScope((Node)node, scope, outputDescriptorFields);
        }

        protected Scope visitJoin(Join node, Optional<Scope> scope) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            JoinCriteria criteria = node.getCriteria().orElse(null);
            if (criteria instanceof NaturalJoin) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Natural join not supported", new Object[0]);
            }
            Scope left = this.process((Node)node.getLeft(), scope);
            Scope right = this.process((Node)node.getRight(), this.isLateralRelation(node.getRight()) ? Optional.of(left) : scope);
            if (this.isLateralRelation(node.getRight())) {
                if (node.getType() == Join.Type.RIGHT || node.getType() == Join.Type.FULL) {
                    Stream<Expression> leftScopeReferences = ScopeReferenceExtractor.getReferencesToScope((Node)node.getRight(), StatementAnalyzer.this.analysis, left);
                    leftScopeReferences.findFirst().ifPresent(reference -> {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, (Node)reference, "LATERAL reference not allowed in %s JOIN", node.getType().name());
                    });
                }
                if (this.isUnnestRelation(node.getRight())) {
                    if (!(criteria == null || criteria instanceof JoinOn && ((JoinOn)criteria).getExpression().equals((Object)BooleanLiteral.TRUE_LITERAL))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)(criteria instanceof JoinOn ? ((JoinOn)criteria).getExpression() : node), "%s JOIN involving UNNEST is only supported with condition ON TRUE", node.getType().name());
                    }
                } else if (this.isJsonTable(node.getRight())) {
                    if (!(criteria == null || criteria instanceof JoinOn && ((JoinOn)criteria).getExpression().equals((Object)BooleanLiteral.TRUE_LITERAL))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)(criteria instanceof JoinOn ? ((JoinOn)criteria).getExpression() : node), "%s JOIN involving JSON_TABLE is only supported with condition ON TRUE", node.getType().name());
                    }
                } else if (!(node.getType() != Join.Type.FULL || criteria instanceof JoinOn && ((JoinOn)criteria).getExpression().equals((Object)BooleanLiteral.TRUE_LITERAL))) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)(criteria instanceof JoinOn ? ((JoinOn)criteria).getExpression() : node), "FULL JOIN involving LATERAL relation is only supported with condition ON TRUE", new Object[0]);
                }
            }
            if (criteria instanceof JoinUsing) {
                return this.analyzeJoinUsing(node, ((JoinUsing)criteria).getColumns(), scope, left, right);
            }
            Scope output = this.createAndAssignScope((Node)node, scope, left.getRelationType().joinWith(right.getRelationType()));
            if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) {
                return output;
            }
            if (criteria instanceof JoinOn) {
                expression = ((JoinOn)criteria).getExpression();
                Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, expression, "JOIN clause");
                expressionAnalysis = this.analyzeExpression(expression, output, node.getType() == Join.Type.INNER ? CorrelationSupport.ALLOWED : CorrelationSupport.DISALLOWED);
                Type clauseType = expressionAnalysis.getType(expression);
                if (!clauseType.equals((Object)BooleanType.BOOLEAN)) {
                    if (!clauseType.equals((Object)UnknownType.UNKNOWN)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "JOIN ON clause must evaluate to a boolean: actual type %s", clauseType);
                    }
                    StatementAnalyzer.this.analysis.addCoercion(expression, (Type)BooleanType.BOOLEAN);
                }
            } else {
                throw new UnsupportedOperationException("Unsupported join criteria: " + criteria.getClass().getName());
            }
            StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            StatementAnalyzer.this.analysis.setJoinCriteria(node, expression);
            return output;
        }

        protected Scope visitUpdate(Update update, Optional<Scope> scope) {
            Table table = update.getTable();
            QualifiedObjectName originalName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            if (StatementAnalyzer.this.metadata.isMaterializedView(StatementAnalyzer.this.session, originalName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)update, "Updating materialized views is not supported", new Object[0]);
            }
            if (StatementAnalyzer.this.metadata.isView(StatementAnalyzer.this.session, originalName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)update, "Updating views is not supported", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setUpdateType("UPDATE");
            RedirectionAwareTableHandle redirection = StatementAnalyzer.this.metadata.getRedirectionAwareTableHandle(StatementAnalyzer.this.session, originalName);
            QualifiedObjectName tableName = redirection.redirectedTableName().orElse(originalName);
            TableHandle handle = redirection.tableHandle().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)table, "Table '%s' does not exist", tableName));
            TableSchema tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.session, handle);
            List<ColumnSchema> allColumns = tableSchema.columns();
            Map columns = (Map)allColumns.stream().collect(ImmutableMap.toImmutableMap(ColumnSchema::getName, Function.identity()));
            for (Object assignment2 : update.getAssignments()) {
                String columnName = assignment2.getName().getValue();
                if (columns.containsKey(columnName)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)assignment2.getName(), "The UPDATE SET target column %s doesn't exist", columnName);
            }
            Set assignmentTargets = (Set)update.getAssignments().stream().map(assignment -> assignment.getName().getValue()).collect(ImmutableSet.toImmutableSet());
            StatementAnalyzer.this.accessControl.checkCanUpdateTableColumns(StatementAnalyzer.this.session.toSecurityContext(), tableName, assignmentTargets);
            if (!StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.toSecurityContext(), tableName).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)update, "Updating a table with a row filter is not supported", new Object[0]);
            }
            for (ColumnSchema tableColumn : allColumns) {
                if (!StatementAnalyzer.this.accessControl.getColumnMask(StatementAnalyzer.this.session.toSecurityContext(), tableName, tableColumn.getName(), tableColumn.getType()).isPresent()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)update, "Updating a table with column masks is not supported", new Object[0]);
            }
            List updatedColumnSchemas = (List)allColumns.stream().filter(column -> assignmentTargets.contains(column.getName())).collect(ImmutableList.toImmutableList());
            StatementAnalyzer.this.analysis.setUpdatedColumns(updatedColumnSchemas);
            Map<String, ColumnHandle> allColumnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, handle);
            List updatedColumnHandles = (List)updatedColumnSchemas.stream().map(columnSchema -> (ColumnHandle)allColumnHandles.get(columnSchema.getName())).collect(ImmutableList.toImmutableList());
            StatementAnalyzer analyzer = StatementAnalyzer.this.statementAnalyzerFactory.withSpecializedAccessControl(new AllowAllAccessControl()).createStatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            Scope tableScope = analyzer.analyzeForUpdate((Relation)table, scope, UpdateKind.UPDATE);
            update.getWhere().ifPresent(where -> this.analyzeWhere((Node)update, tableScope, (Expression)where));
            this.analyzeCheckConstraints(table, tableName, tableScope, tableSchema.tableSchema().getCheckConstraints());
            StatementAnalyzer.this.analysis.registerTable(table, redirection.tableHandle(), tableName, StatementAnalyzer.this.session.getIdentity().getUser(), tableScope, Optional.empty());
            ImmutableList.Builder analysesBuilder = ImmutableList.builder();
            ImmutableList.Builder expressionTypesBuilder = ImmutableList.builder();
            ImmutableMap.Builder sourceColumnsByColumnNameBuilder = ImmutableMap.builder();
            for (UpdateAssignment assignment3 : update.getAssignments()) {
                String targetColumnName = assignment3.getName().getValue();
                Expression expression = assignment3.getValue();
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, tableScope);
                analysesBuilder.add((Object)expressionAnalysis);
                expressionTypesBuilder.add((Object)expressionAnalysis.getType(expression));
                Set sourceColumns = (Set)expressionAnalysis.getSubqueries().stream().map(query -> StatementAnalyzer.this.analyze(query.getNode(), tableScope)).flatMap(subqueryScope -> subqueryScope.getRelationType().getVisibleFields().stream()).flatMap(field -> StatementAnalyzer.this.analysis.getSourceColumns((Field)field).stream()).collect(ImmutableSet.toImmutableSet());
                sourceColumnsByColumnNameBuilder.put((Object)targetColumnName, (Object)sourceColumns);
            }
            ImmutableList analyses = analysesBuilder.build();
            ImmutableList expressionTypes = expressionTypesBuilder.build();
            ImmutableMap sourceColumnsByColumnName = sourceColumnsByColumnNameBuilder.buildOrThrow();
            List tableTypes = (List)update.getAssignments().stream().map(assignment -> Objects.requireNonNull((ColumnSchema)columns.get(assignment.getName().getValue()))).map(ColumnSchema::getType).collect(ImmutableList.toImmutableList());
            if (!this.typesMatchForInsert(tableTypes, (List<Type>)expressionTypes)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)update, "UPDATE table column types don't match SET expressions: Table: [%s], Expressions: [%s]", Joiner.on((String)", ").join((Iterable)tableTypes), Joiner.on((String)", ").join((Iterable)expressionTypes));
            }
            for (int index = 0; index < expressionTypes.size(); ++index) {
                Expression expression = ((UpdateAssignment)update.getAssignments().get(index)).getValue();
                Type expressionType = (Type)expressionTypes.get(index);
                Type targetType = (Type)tableTypes.get(index);
                if (!targetType.equals((Object)expressionType)) {
                    StatementAnalyzer.this.analysis.addCoercion(expression, targetType);
                }
                StatementAnalyzer.this.analysis.recordSubqueries((Node)update, (ExpressionAnalysis)analyses.get(index));
            }
            StatementAnalyzer.this.analysis.setUpdateTarget(handle.catalogHandle().getVersion(), tableName, Optional.of(table), Optional.of((List)updatedColumnSchemas.stream().map(arg_0 -> Visitor.lambda$visitUpdate$84((Map)sourceColumnsByColumnName, arg_0)).collect(ImmutableList.toImmutableList())));
            this.createMergeAnalysis(table, handle, tableSchema, tableScope, tableScope, (List<List<ColumnHandle>>)ImmutableList.of((Object)updatedColumnHandles));
            return this.createAndAssignScope((Node)update, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitMerge(Merge merge, Optional<Scope> scope) {
            Relation relation = merge.getTarget();
            Table table = Visitor.getMergeTargetTable(relation);
            QualifiedObjectName originalTableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            if (StatementAnalyzer.this.metadata.isMaterializedView(StatementAnalyzer.this.session, originalTableName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)merge, "Merging into materialized views is not supported", new Object[0]);
            }
            if (StatementAnalyzer.this.metadata.isView(StatementAnalyzer.this.session, originalTableName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)merge, "Merging into views is not supported", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setUpdateType("MERGE");
            RedirectionAwareTableHandle redirection = StatementAnalyzer.this.metadata.getRedirectionAwareTableHandle(StatementAnalyzer.this.session, originalTableName);
            QualifiedObjectName tableName = redirection.redirectedTableName().orElse(originalTableName);
            TableHandle targetTableHandle = redirection.tableHandle().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)table, "Table '%s' does not exist", tableName));
            StatementAnalyzer analyzer = StatementAnalyzer.this.statementAnalyzerFactory.withSpecializedAccessControl(new AllowAllAccessControl()).createStatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.session, this.warningCollector, CorrelationSupport.ALLOWED);
            TableSchema tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.session, targetTableHandle);
            List dataColumnSchemas = (List)tableSchema.columns().stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList());
            merge.getMergeCases().stream().filter(mergeCase -> mergeCase instanceof MergeInsert).findFirst().ifPresent(mergeCase -> StatementAnalyzer.this.accessControl.checkCanInsertIntoTable(StatementAnalyzer.this.session.toSecurityContext(), tableName));
            merge.getMergeCases().stream().filter(mergeCase -> mergeCase instanceof MergeDelete).findFirst().ifPresent(mergeCase -> StatementAnalyzer.this.accessControl.checkCanDeleteFromTable(StatementAnalyzer.this.session.toSecurityContext(), tableName));
            HashSet<String> allUpdateColumnNames = new HashSet<String>();
            for (int caseCounter = 0; caseCounter < merge.getMergeCases().size(); ++caseCounter) {
                MergeCase operation = (MergeCase)merge.getMergeCases().get(caseCounter);
                List<String> caseColumnNames = this.lowercaseIdentifierList(operation.getSetColumns());
                if (!(operation instanceof MergeUpdate)) continue;
                allUpdateColumnNames.addAll(caseColumnNames);
            }
            if (!allUpdateColumnNames.isEmpty()) {
                StatementAnalyzer.this.accessControl.checkCanUpdateTableColumns(StatementAnalyzer.this.session.toSecurityContext(), tableName, allUpdateColumnNames);
            }
            if (!StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.toSecurityContext(), tableName).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)merge, "Cannot merge into a table with row filters", new Object[0]);
            }
            Scope mergeScope = this.createScope(scope);
            Scope targetTableScope = analyzer.analyzeForUpdate(relation, Optional.of(mergeScope), UpdateKind.MERGE);
            Scope sourceTableScope = this.process((Node)merge.getSource(), mergeScope);
            Scope joinScope = this.createAndAssignScope((Node)merge, Optional.of(mergeScope), targetTableScope.getRelationType().joinWith(sourceTableScope.getRelationType()));
            this.analyzeCheckConstraints(table, tableName, targetTableScope, tableSchema.tableSchema().getCheckConstraints());
            StatementAnalyzer.this.analysis.registerTable(table, redirection.tableHandle(), tableName, StatementAnalyzer.this.session.getIdentity().getUser(), targetTableScope, Optional.empty());
            for (ColumnSchema column2 : dataColumnSchemas) {
                if (!StatementAnalyzer.this.accessControl.getColumnMask(StatementAnalyzer.this.session.toSecurityContext(), tableName, column2.getName(), column2.getType()).isPresent()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)merge, "Cannot merge into a table with column masks", new Object[0]);
            }
            Map<String, ColumnHandle> allColumnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, targetTableHandle);
            Map dataColumnTypes = (Map)dataColumnSchemas.stream().collect(ImmutableMap.toImmutableMap(ColumnSchema::getName, ColumnSchema::getType));
            Expression mergePredicate = merge.getPredicate();
            ExpressionAnalysis predicateAnalysis = this.analyzeExpression(mergePredicate, joinScope, CorrelationSupport.DISALLOWED);
            Type mergePredicateType = predicateAnalysis.getType(mergePredicate);
            if (!StatementAnalyzer.this.typeCoercion.canCoerce(mergePredicateType, (Type)BooleanType.BOOLEAN)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)mergePredicate, "The MERGE predicate must evaluate to a boolean: actual type %s", mergePredicateType);
            }
            if (!mergePredicateType.equals((Object)BooleanType.BOOLEAN)) {
                StatementAnalyzer.this.analysis.addCoercion(mergePredicate, (Type)BooleanType.BOOLEAN);
            }
            StatementAnalyzer.this.analysis.recordSubqueries((Node)merge, predicateAnalysis);
            for (int caseCounter = 0; caseCounter < merge.getMergeCases().size(); ++caseCounter) {
                ImmutableList setExpressionTypes;
                Type targetType;
                MergeCase operation = (MergeCase)merge.getMergeCases().get(caseCounter);
                List caseColumnNames = this.lowercaseIdentifierList(operation.getSetColumns());
                if (operation instanceof MergeUpdate) {
                    allUpdateColumnNames.addAll(caseColumnNames);
                } else if (operation instanceof MergeInsert && caseColumnNames.isEmpty()) {
                    caseColumnNames = (List)dataColumnSchemas.stream().map(ColumnSchema::getName).collect(ImmutableList.toImmutableList());
                }
                int columnCount = caseColumnNames.size();
                List setExpressions = operation.getSetExpressions();
                Preconditions.checkArgument((columnCount == setExpressions.size() ? 1 : 0) != 0, (String)"Number of merge columns (%s) isn't equal to number of expressions (%s)", (int)columnCount, (int)setExpressions.size());
                HashSet columnNameSet = new HashSet(columnCount);
                caseColumnNames.forEach(mergeColumn -> {
                    if (!dataColumnTypes.containsKey(mergeColumn)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)merge, "Merge column name does not exist in target table: %s", mergeColumn);
                    }
                    if (!columnNameSet.add(mergeColumn)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)merge, "Merge column name is specified more than once: %s", mergeColumn);
                    }
                });
                if (operation.getExpression().isPresent()) {
                    Expression predicate = (Expression)operation.getExpression().get();
                    StatementAnalyzer.this.analysis.recordSubqueries((Node)merge, this.analyzeExpression(predicate, joinScope));
                    Type predicateType = StatementAnalyzer.this.analysis.getType(predicate);
                    if (!predicateType.equals((Object)BooleanType.BOOLEAN)) {
                        if (!StatementAnalyzer.this.typeCoercion.canCoerce(predicateType, (Type)BooleanType.BOOLEAN)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)predicate, "WHERE clause predicate must evaluate to a boolean: actual type %s", predicateType);
                        }
                        StatementAnalyzer.this.analysis.addCoercion(predicate, (Type)BooleanType.BOOLEAN);
                    }
                }
                ImmutableList.Builder setColumnTypesBuilder = ImmutableList.builder();
                ImmutableList.Builder setExpressionTypesBuilder = ImmutableList.builder();
                for (int index = 0; index < caseColumnNames.size(); ++index) {
                    String columnName = (String)caseColumnNames.get(index);
                    Expression expression = (Expression)setExpressions.get(index);
                    ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, joinScope);
                    StatementAnalyzer.this.analysis.recordSubqueries((Node)merge, expressionAnalysis);
                    targetType = Objects.requireNonNull((Type)dataColumnTypes.get(columnName));
                    setColumnTypesBuilder.add((Object)targetType);
                    setExpressionTypesBuilder.add((Object)expressionAnalysis.getType(expression));
                }
                ImmutableList setColumnTypes = setColumnTypesBuilder.build();
                if (!this.typesMatchForInsert((List<Type>)setColumnTypes, (List<Type>)(setExpressionTypes = setExpressionTypesBuilder.build()))) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)operation, "MERGE table column types don't match for MERGE case %s, SET expressions: Table: [%s], Expressions: [%s]", caseCounter, Joiner.on((String)", ").join((Iterable)setColumnTypes), Joiner.on((String)", ").join((Iterable)setExpressionTypes));
                }
                for (int index = 0; index < caseColumnNames.size(); ++index) {
                    Type expressionType;
                    Expression expression = (Expression)operation.getSetExpressions().get(index);
                    targetType = (Type)dataColumnTypes.get(caseColumnNames.get(index));
                    if (targetType.equals((Object)(expressionType = (Type)setExpressionTypes.get(index)))) continue;
                    StatementAnalyzer.this.analysis.addCoercion(expression, targetType);
                }
            }
            List updatedColumns = (List)allColumnHandles.keySet().stream().filter(allUpdateColumnNames::contains).map(columnHandle -> new OutputColumn(new Column((String)columnHandle, ((Type)dataColumnTypes.get(columnHandle)).toString()), (Set<Analysis.SourceColumn>)ImmutableSet.of())).collect(ImmutableList.toImmutableList());
            StatementAnalyzer.this.analysis.setUpdateTarget(targetTableHandle.catalogHandle().getVersion(), tableName, Optional.of(table), Optional.of(updatedColumns));
            List<List<ColumnHandle>> mergeCaseColumnHandles = this.buildCaseColumnLists(merge, dataColumnSchemas, allColumnHandles);
            this.createMergeAnalysis(table, targetTableHandle, tableSchema, targetTableScope, joinScope, mergeCaseColumnHandles);
            return this.createAndAssignScope((Node)merge, Optional.empty(), Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        private void createMergeAnalysis(Table table, TableHandle handle, TableSchema tableSchema, Scope tableScope, Scope joinScope, List<List<ColumnHandle>> updatedColumns) {
            Optional<PartitioningHandle> updateLayout = StatementAnalyzer.this.metadata.getUpdateLayout(StatementAnalyzer.this.session, handle);
            Map<String, ColumnHandle> allColumnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, handle);
            ImmutableMap.Builder columnHandleFieldNumbersBuilder = ImmutableMap.builder();
            HashMap fieldIndexes = new HashMap();
            RelationType relationType = tableScope.getRelationType();
            for (Field field : relationType.getAllFields()) {
                field.getName().ifPresent(name -> {
                    int fieldIndex = relationType.indexOf(field);
                    ColumnHandle columnHandle = (ColumnHandle)allColumnHandles.get(name);
                    Verify.verify((handle != null ? 1 : 0) != 0, (String)"allColumnHandles does not contain the named handle: %s", (Object)name);
                    columnHandleFieldNumbersBuilder.put((Object)columnHandle, (Object)fieldIndex);
                    fieldIndexes.put(name, fieldIndex);
                });
            }
            ImmutableMap columnHandleFieldNumbers = columnHandleFieldNumbersBuilder.buildOrThrow();
            List dataColumnSchemas = (List)tableSchema.columns().stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList());
            Optional<TableLayout> insertLayout = StatementAnalyzer.this.metadata.getInsertLayout(StatementAnalyzer.this.session, handle);
            ImmutableList.Builder dataColumnHandlesBuilder = ImmutableList.builder();
            ImmutableSet.Builder dataColumnNamesBuilder = ImmutableSet.builder();
            ImmutableList.Builder redistributionColumnHandlesBuilder = ImmutableList.builder();
            ImmutableSet partitioningColumnNames = ImmutableSet.copyOf((Collection)insertLayout.map(TableLayout::getPartitionColumns).orElse((List)ImmutableList.of()));
            for (ColumnSchema columnSchema : dataColumnSchemas) {
                String name2 = columnSchema.getName();
                ColumnHandle columnHandle = allColumnHandles.get(name2);
                dataColumnNamesBuilder.add((Object)name2);
                dataColumnHandlesBuilder.add((Object)columnHandle);
                if (!partitioningColumnNames.contains(name2)) continue;
                redistributionColumnHandlesBuilder.add((Object)columnHandle);
            }
            ImmutableList dataColumnHandles = dataColumnHandlesBuilder.build();
            ImmutableList redistributionColumnHandles = redistributionColumnHandlesBuilder.build();
            List insertPartitioningArgumentIndexes = (List)partitioningColumnNames.stream().map(fieldIndexes::get).collect(ImmutableList.toImmutableList());
            Set nonNullableColumnHandles = (Set)StatementAnalyzer.this.metadata.getTableMetadata(StatementAnalyzer.this.session, handle).columns().stream().filter(column -> !column.isNullable()).map(ColumnMetadata::getName).map(allColumnHandles::get).collect(ImmutableSet.toImmutableSet());
            ArrayList<RowType.Field> fields = new ArrayList<RowType.Field>();
            for (ColumnSchema schema : dataColumnSchemas) {
                fields.add(RowType.field((Type)schema.getType()));
            }
            fields.add(new RowType.Field(Optional.empty(), (Type)BooleanType.BOOLEAN));
            fields.add(new RowType.Field(Optional.empty(), (Type)TinyintType.TINYINT));
            fields.add(new RowType.Field(Optional.empty(), (Type)IntegerType.INTEGER));
            RowType mergeRowType = RowType.from(fields);
            StatementAnalyzer.this.analysis.setMergeAnalysis(new Analysis.MergeAnalysis(table, dataColumnSchemas, (List<ColumnHandle>)dataColumnHandles, (List<ColumnHandle>)redistributionColumnHandles, updatedColumns, nonNullableColumnHandles, (Map<ColumnHandle, Integer>)columnHandleFieldNumbers, mergeRowType, insertPartitioningArgumentIndexes, insertLayout, updateLayout, tableScope, joinScope));
        }

        private static Table getMergeTargetTable(Relation relation) {
            if (relation instanceof Table) {
                Table table = (Table)relation;
                return table;
            }
            Preconditions.checkArgument((boolean)(relation instanceof AliasedRelation), (Object)"relation is neither a Table nor an AliasedRelation");
            return (Table)((AliasedRelation)relation).getRelation();
        }

        private List<List<ColumnHandle>> buildCaseColumnLists(Merge merge, List<ColumnSchema> columnSchemas, Map<String, ColumnHandle> allColumnHandles) {
            ImmutableList.Builder mergeCaseColumnsListsBuilder = ImmutableList.builder();
            for (int caseCounter = 0; caseCounter < merge.getMergeCases().size(); ++caseCounter) {
                MergeCase operation = (MergeCase)merge.getMergeCases().get(caseCounter);
                List mergeColumnNames = operation instanceof MergeInsert && operation.getSetColumns().isEmpty() ? (List)columnSchemas.stream().map(ColumnSchema::getName).collect(ImmutableList.toImmutableList()) : this.lowercaseIdentifierList(operation.getSetColumns());
                mergeCaseColumnsListsBuilder.add((Object)((List)mergeColumnNames.stream().map(name -> Objects.requireNonNull((ColumnHandle)allColumnHandles.get(name), "No column found for name")).collect(ImmutableList.toImmutableList())));
            }
            return mergeCaseColumnsListsBuilder.build();
        }

        private List<String> lowercaseIdentifierList(Collection<Identifier> identifiers) {
            return (List)identifiers.stream().map(identifier -> identifier.getValue().toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
        }

        private Scope analyzeJoinUsing(Join node, List<Identifier> columns, Optional<Scope> scope, Scope left, Scope right) {
            ArrayList<Field> joinFields = new ArrayList<Field>();
            ArrayList<Integer> leftJoinFields = new ArrayList<Integer>();
            ArrayList<Integer> rightJoinFields = new ArrayList<Integer>();
            HashSet<Identifier> seen = new HashSet<Identifier>();
            for (Identifier column : columns) {
                if (!seen.add(column)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, (Node)column, "Column '%s' appears multiple times in USING clause", column.getValue());
                }
                ResolvedField leftField = left.tryResolveField((Expression)column).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)column, "Column '%s' is missing from left side of join", column.getValue()));
                ResolvedField rightField = right.tryResolveField((Expression)column).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)column, "Column '%s' is missing from right side of join", column.getValue()));
                try {
                    StatementAnalyzer.this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)leftField.getType(), (Object)rightField.getType()));
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)column, (Throwable)((Object)e), "%s", e.getMessage());
                }
                Optional<Type> type = StatementAnalyzer.this.typeCoercion.getCommonSuperType(leftField.getType(), rightField.getType());
                StatementAnalyzer.this.analysis.addTypes((Map<NodeRef<Expression>, Type>)ImmutableMap.of((Object)NodeRef.of((Node)column), (Object)type.orElseThrow()));
                joinFields.add(Field.newUnqualified(column.getValue(), type.get()));
                leftJoinFields.add(leftField.getRelationFieldIndex());
                rightJoinFields.add(rightField.getRelationFieldIndex());
                this.recordColumnAccess(leftField.getField());
                this.recordColumnAccess(rightField.getField());
            }
            ImmutableList.Builder outputs = ImmutableList.builder();
            outputs.addAll(joinFields);
            ImmutableList.Builder leftFields = ImmutableList.builder();
            for (int i = 0; i < left.getRelationType().getAllFieldCount(); ++i) {
                if (leftJoinFields.contains(i)) continue;
                outputs.add((Object)left.getRelationType().getFieldByIndex(i));
                leftFields.add((Object)i);
            }
            ImmutableList.Builder rightFields = ImmutableList.builder();
            for (int i = 0; i < right.getRelationType().getAllFieldCount(); ++i) {
                if (rightJoinFields.contains(i)) continue;
                outputs.add((Object)right.getRelationType().getFieldByIndex(i));
                rightFields.add((Object)i);
            }
            StatementAnalyzer.this.analysis.setJoinUsing(node, new Analysis.JoinUsingAnalysis(leftJoinFields, rightJoinFields, (List<Integer>)leftFields.build(), (List<Integer>)rightFields.build()));
            return this.createAndAssignScope((Node)node, scope, new RelationType((List<Field>)outputs.build()));
        }

        private void recordColumnAccess(Field field) {
            if (field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()) {
                StatementAnalyzer.this.analysis.addTableColumnReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), (Multimap<QualifiedObjectName, String>)ImmutableMultimap.of((Object)field.getOriginTable().get(), (Object)field.getOriginColumnName().get()));
            }
        }

        private boolean isLateralRelation(Relation node) {
            if (node instanceof AliasedRelation) {
                return this.isLateralRelation(((AliasedRelation)node).getRelation());
            }
            return node instanceof Unnest || node instanceof Lateral || node instanceof JsonTable;
        }

        private boolean isUnnestRelation(Relation node) {
            if (node instanceof AliasedRelation) {
                return this.isUnnestRelation(((AliasedRelation)node).getRelation());
            }
            return node instanceof Unnest;
        }

        private boolean isJsonTable(Relation node) {
            if (node instanceof AliasedRelation) {
                return this.isJsonTable(((AliasedRelation)node).getRelation());
            }
            return node instanceof JsonTable;
        }

        protected Scope visitValues(Values node, Optional<Scope> scope) {
            Preconditions.checkState((!node.getRows().isEmpty() ? 1 : 0) != 0);
            List rowTypes = (List)node.getRows().stream().map(row -> this.analyzeExpression((Expression)row, this.createScope(scope)).getType((Expression)row)).map(type -> {
                if (type instanceof RowType) {
                    return type;
                }
                return RowType.anonymousRow((Type[])new Type[]{type});
            }).collect(ImmutableList.toImmutableList());
            int fieldCount = ((Type)rowTypes.getFirst()).getTypeParameters().size();
            Type commonSuperType = (Type)rowTypes.getFirst();
            for (Type rowType : rowTypes) {
                if (rowType.getTypeParameters().size() != fieldCount) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Values rows have mismatched sizes: %s vs %s", fieldCount, rowType.getTypeParameters().size());
                }
                commonSuperType = StatementAnalyzer.this.typeCoercion.getCommonSuperType(rowType, commonSuperType).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Values rows have mismatched types: %s vs %s", rowTypes.get(0), rowType));
            }
            for (Expression row2 : node.getRows()) {
                Type actualType = StatementAnalyzer.this.analysis.getType(row2);
                if (row2 instanceof Row) {
                    for (int i = 0; i < actualType.getTypeParameters().size(); ++i) {
                        Type expectedItemType;
                        Expression item = (Expression)((Row)row2).getItems().get(i);
                        Type actualItemType = (Type)actualType.getTypeParameters().get(i);
                        if (actualItemType.equals((Object)(expectedItemType = (Type)commonSuperType.getTypeParameters().get(i)))) continue;
                        StatementAnalyzer.this.analysis.addCoercion(item, expectedItemType);
                    }
                    continue;
                }
                if (actualType instanceof RowType) {
                    if (actualType.equals((Object)commonSuperType)) continue;
                    StatementAnalyzer.this.analysis.addCoercion(row2, commonSuperType);
                    continue;
                }
                Type superType = (Type)Iterables.getOnlyElement((Iterable)commonSuperType.getTypeParameters());
                if (actualType.equals((Object)superType)) continue;
                StatementAnalyzer.this.analysis.addCoercion(row2, superType);
            }
            List fields = (List)commonSuperType.getTypeParameters().stream().map(valueType -> Field.newUnqualified(Optional.empty(), valueType)).collect(ImmutableList.toImmutableList());
            return this.createAndAssignScope((Node)node, scope, fields);
        }

        protected Scope visitJsonTable(JsonTable node, Optional<Scope> scope) {
            Scope enclosingScope = this.createScope(scope);
            RowType parametersType = this.analyzeJsonPathInvocation(node, enclosingScope);
            CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, (Node)node, "system");
            ConnectorTransactionHandle transactionHandle = StatementAnalyzer.this.transactionManager.getConnectorTransaction(StatementAnalyzer.this.session.getRequiredTransactionId(), catalogHandle);
            HashSet<String> uniqueNames = new HashSet<String>();
            JsonPathInvocation rootPath = node.getJsonPathInvocation();
            rootPath.getPathName().ifPresent(name -> uniqueNames.add(name.getCanonicalValue()));
            ImmutableList.Builder outputFields = ImmutableList.builder();
            ImmutableList.Builder orderedOutputColumns = ImmutableList.builder();
            this.analyzeJsonTableColumns(node.getColumns(), uniqueNames, (ImmutableList.Builder<Field>)outputFields, (ImmutableList.Builder<NodeRef<JsonTableColumnDefinition>>)orderedOutputColumns, enclosingScope, node);
            StatementAnalyzer.this.analysis.addJsonTableAnalysis(node, new Analysis.JsonTableAnalysis(catalogHandle, transactionHandle, parametersType, (List<NodeRef<JsonTableColumnDefinition>>)orderedOutputColumns.build()));
            node.getPlan().ifPresent(plan -> {
                if (plan instanceof JsonTableSpecificPlan) {
                    JsonTableSpecificPlan specificPlan = (JsonTableSpecificPlan)plan;
                    this.validateJsonTableSpecificPlan(rootPath, specificPlan, node.getColumns());
                } else {
                    this.checkAllNestedPathsNamed(node.getColumns());
                }
            });
            return this.createAndAssignScope((Node)node, scope, (List<Field>)outputFields.build());
        }

        private RowType analyzeJsonPathInvocation(JsonTable node, Scope scope) {
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, node.getJsonPathInvocation().getInputExpression(), "JSON_TABLE input expression");
            node.getJsonPathInvocation().getPathParameters().stream().map(JsonPathParameter::getParameter).forEach(parameter -> Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, parameter, "JSON_TABLE path parameter"));
            ExpressionAnalyzer.ParametersTypeAndAnalysis parametersTypeAndAnalysis = ExpressionAnalyzer.analyzeJsonPathInvocation(node, StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, WarningCollector.NOOP, StatementAnalyzer.this.correlationSupport);
            StatementAnalyzer.this.analysis.recordSubqueries((Node)node, parametersTypeAndAnalysis.expressionAnalysis());
            return parametersTypeAndAnalysis.parametersType();
        }

        private void analyzeJsonTableColumns(List<JsonTableColumnDefinition> columns, Set<String> uniqueNames, ImmutableList.Builder<Field> outputFields, ImmutableList.Builder<NodeRef<JsonTableColumnDefinition>> orderedOutputColumns, Scope enclosingScope, JsonTable jsonTable) {
            for (JsonTableColumnDefinition column : columns) {
                JsonPathAnalyzer.JsonPathAnalysis pathAnalysis;
                String name2;
                if (column instanceof OrdinalityColumn) {
                    OrdinalityColumn ordinalityColumn = (OrdinalityColumn)column;
                    name2 = ordinalityColumn.getName().getCanonicalValue();
                    if (!uniqueNames.add(name2)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_OR_PATH_NAME, (Node)ordinalityColumn.getName(), "All column and path names in JSON_TABLE invocation must be unique", new Object[0]);
                    }
                    outputFields.add((Object)Field.newUnqualified(name2, (Type)BigintType.BIGINT));
                    orderedOutputColumns.add((Object)NodeRef.of((Node)ordinalityColumn));
                    continue;
                }
                if (column instanceof ValueColumn) {
                    ValueColumn valueColumn = (ValueColumn)column;
                    name2 = valueColumn.getName().getCanonicalValue();
                    if (!uniqueNames.add(name2)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_OR_PATH_NAME, (Node)valueColumn.getName(), "All column and path names in JSON_TABLE invocation must be unique", new Object[0]);
                    }
                    valueColumn.getEmptyDefault().ifPresent(expression -> Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, expression, "default expression for JSON_TABLE column"));
                    valueColumn.getErrorDefault().ifPresent(expression -> Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, expression, "default expression for JSON_TABLE column"));
                    pathAnalysis = valueColumn.getJsonPath().map(this::analyzeJsonPath).orElseGet(() -> this.analyzeImplicitJsonPath(Visitor.getImplicitJsonPath(name2), valueColumn.getLocation()));
                    StatementAnalyzer.this.analysis.setJsonPathAnalysis((Node)valueColumn, pathAnalysis);
                    ExpressionAnalyzer.TypeAndAnalysis typeAndAnalysis = ExpressionAnalyzer.analyzeJsonValueExpression(valueColumn, pathAnalysis, StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, enclosingScope, StatementAnalyzer.this.analysis, this.warningCollector, StatementAnalyzer.this.correlationSupport);
                    StatementAnalyzer.this.analysis.recordSubqueries((Node)jsonTable, typeAndAnalysis.analysis());
                    outputFields.add((Object)Field.newUnqualified(name2, typeAndAnalysis.type()));
                    orderedOutputColumns.add((Object)NodeRef.of((Node)valueColumn));
                    continue;
                }
                if (column instanceof QueryColumn) {
                    QueryColumn queryColumn = (QueryColumn)column;
                    name2 = queryColumn.getName().getCanonicalValue();
                    if (!uniqueNames.add(name2)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_OR_PATH_NAME, (Node)queryColumn.getName(), "All column and path names in JSON_TABLE invocation must be unique", new Object[0]);
                    }
                    pathAnalysis = queryColumn.getJsonPath().map(this::analyzeJsonPath).orElseGet(() -> this.analyzeImplicitJsonPath(Visitor.getImplicitJsonPath(name2), queryColumn.getLocation()));
                    StatementAnalyzer.this.analysis.setJsonPathAnalysis((Node)queryColumn, pathAnalysis);
                    Type type = ExpressionAnalyzer.analyzeJsonQueryExpression(queryColumn, StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, enclosingScope, StatementAnalyzer.this.analysis, this.warningCollector);
                    outputFields.add((Object)Field.newUnqualified(name2, type));
                    orderedOutputColumns.add((Object)NodeRef.of((Node)queryColumn));
                    continue;
                }
                if (column instanceof NestedColumns) {
                    NestedColumns nestedColumns = (NestedColumns)column;
                    nestedColumns.getPathName().ifPresent(name -> {
                        if (!uniqueNames.add(name.getCanonicalValue())) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_OR_PATH_NAME, (Node)name, "All column and path names in JSON_TABLE invocation must be unique", new Object[0]);
                        }
                    });
                    JsonPathAnalyzer.JsonPathAnalysis pathAnalysis2 = this.analyzeJsonPath(nestedColumns.getJsonPath());
                    StatementAnalyzer.this.analysis.setJsonPathAnalysis((Node)nestedColumns, pathAnalysis2);
                    this.analyzeJsonTableColumns(nestedColumns.getColumns(), uniqueNames, outputFields, orderedOutputColumns, enclosingScope, jsonTable);
                    continue;
                }
                throw new IllegalArgumentException("unexpected type of JSON_TABLE column: " + column.getClass().getSimpleName());
            }
        }

        private static String getImplicitJsonPath(String name) {
            return "lax $.\"" + name.replace("\"", "\"\"") + "\"";
        }

        private JsonPathAnalyzer.JsonPathAnalysis analyzeJsonPath(StringLiteral path) {
            return new JsonPathAnalyzer(StatementAnalyzer.this.plannerContext.getMetadata(), ExpressionAnalyzer.createConstantAnalyzer(StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, StatementAnalyzer.this.analysis.getParameters(), WarningCollector.NOOP, StatementAnalyzer.this.analysis.isDescribe())).analyzeJsonPath(path, (Map<String, Type>)ImmutableMap.of());
        }

        private JsonPathAnalyzer.JsonPathAnalysis analyzeImplicitJsonPath(String path, Optional<NodeLocation> columnLocation) {
            return new JsonPathAnalyzer(StatementAnalyzer.this.plannerContext.getMetadata(), ExpressionAnalyzer.createConstantAnalyzer(StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, StatementAnalyzer.this.analysis.getParameters(), WarningCollector.NOOP, StatementAnalyzer.this.analysis.isDescribe())).analyzeImplicitJsonPath(path, columnLocation.orElseThrow(() -> new IllegalStateException("missing NodeLocation for JSON_TABLE column")));
        }

        private void validateJsonTableSpecificPlan(JsonPathInvocation rootPath, JsonTableSpecificPlan rootPlan, List<JsonTableColumnDefinition> rootColumns) {
            String rootPlanName;
            String rootPathName = ((Identifier)rootPath.getPathName().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_PATH_NAME, (Node)rootPath, "All JSON paths must be named when specific plan is given", new Object[0]))).getCanonicalValue();
            if (rootPlan instanceof PlanLeaf) {
                PlanLeaf planLeaf = (PlanLeaf)rootPlan;
                rootPlanName = planLeaf.getName().getCanonicalValue();
            } else if (rootPlan instanceof PlanParentChild) {
                PlanParentChild planParentChild = (PlanParentChild)rootPlan;
                rootPlanName = planParentChild.getParent().getName().getCanonicalValue();
            } else {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PLAN, (Node)rootPlan, "JSON_TABLE plan must either be a single path name or it must be rooted in parent-child relationship (OUTER or INNER)", new Object[0]);
            }
            this.validateJsonTablePlan((Map<String, List<JsonTableColumnDefinition>>)ImmutableMap.of((Object)rootPathName, rootColumns), (Map<String, JsonTableSpecificPlan>)ImmutableMap.of((Object)rootPlanName, (Object)rootPlan), rootPlan);
        }

        private void validateJsonTablePlan(Map<String, List<JsonTableColumnDefinition>> actualNodes, Map<String, JsonTableSpecificPlan> planNodes, JsonTableSpecificPlan rootPlan) {
            Sets.SetView unhandledActualNodes = Sets.difference(actualNodes.keySet(), planNodes.keySet());
            if (!unhandledActualNodes.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PLAN, (Node)rootPlan, "JSON_TABLE plan should contain all JSON paths available at each level of nesting. Paths not included: %s", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)unhandledActualNodes));
            }
            Sets.SetView irrelevantPlanChildren = Sets.difference(planNodes.keySet(), actualNodes.keySet());
            if (!irrelevantPlanChildren.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PLAN, (Node)rootPlan, "JSON_TABLE plan includes unavailable JSON path names: %s", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)irrelevantPlanChildren));
            }
            actualNodes.forEach((name, columns) -> {
                Object planChildren;
                JsonTableSpecificPlan plan = (JsonTableSpecificPlan)planNodes.get(name);
                Map actualChildren = (Map)columns.stream().filter(NestedColumns.class::isInstance).map(NestedColumns.class::cast).collect(ImmutableMap.toImmutableMap(child -> ((Identifier)child.getPathName().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_PATH_NAME, (Node)child.getJsonPath(), "All JSON paths must be named when specific plan is given", new Object[0]))).getCanonicalValue(), NestedColumns::getColumns));
                if (plan instanceof PlanLeaf) {
                    planChildren = ImmutableMap.of();
                } else if (plan instanceof PlanParentChild) {
                    PlanParentChild planParentChild = (PlanParentChild)plan;
                    planChildren = new HashMap();
                    this.getPlanSiblings(planParentChild.getChild(), (Map<String, JsonTableSpecificPlan>)planChildren);
                } else {
                    throw new IllegalStateException("unexpected JSON_TABLE plan node: " + plan.getClass().getSimpleName());
                }
                this.validateJsonTablePlan(actualChildren, (Map<String, JsonTableSpecificPlan>)planChildren, rootPlan);
            });
        }

        private void getPlanSiblings(JsonTableSpecificPlan plan, Map<String, JsonTableSpecificPlan> plansByName) {
            if (plan instanceof PlanLeaf) {
                PlanLeaf planLeaf = (PlanLeaf)plan;
                if (plansByName.put(planLeaf.getName().getCanonicalValue(), (JsonTableSpecificPlan)planLeaf) != null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PLAN, (Node)planLeaf, "Duplicate reference to JSON path name in sibling plan: %s", planLeaf.getName().getCanonicalValue());
                }
            } else if (plan instanceof PlanParentChild) {
                PlanParentChild planParentChild = (PlanParentChild)plan;
                if (plansByName.put(planParentChild.getParent().getName().getCanonicalValue(), (JsonTableSpecificPlan)planParentChild) != null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PLAN, (Node)planParentChild.getParent(), "Duplicate reference to JSON path name in sibling plan: %s", planParentChild.getParent().getName().getCanonicalValue());
                }
            } else if (plan instanceof PlanSiblings) {
                PlanSiblings planSiblings = (PlanSiblings)plan;
                for (JsonTableSpecificPlan sibling : planSiblings.getSiblings()) {
                    this.getPlanSiblings(sibling, plansByName);
                }
            }
        }

        private void checkAllNestedPathsNamed(List<JsonTableColumnDefinition> columns) {
            List nestedColumns = (List)columns.stream().filter(NestedColumns.class::isInstance).map(NestedColumns.class::cast).collect(ImmutableList.toImmutableList());
            nestedColumns.forEach(definition -> {
                if (definition.getPathName().isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_PATH_NAME, (Node)definition.getJsonPath(), "All nested JSON paths must be named when default plan is given", new Object[0]);
                }
            });
            nestedColumns.forEach(definition -> this.checkAllNestedPathsNamed(definition.getColumns()));
        }

        private void analyzeWindowDefinitions(QuerySpecification node, Scope scope) {
            for (WindowDefinition windowDefinition : node.getWindows()) {
                CanonicalizationAware<Identifier> canonicalName = CanonicalizationAware.canonicalizationAwareKey(windowDefinition.getName());
                if (StatementAnalyzer.this.analysis.getWindowDefinition(node, canonicalName) != null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_WINDOW_NAME, (Node)windowDefinition, "WINDOW name '%s' specified more than once", windowDefinition.getName());
                }
                Analysis.ResolvedWindow resolvedWindow = this.resolveWindowSpecification(node, (Window)windowDefinition.getWindow());
                this.analyzeWindow(node, resolvedWindow, scope, (Node)windowDefinition.getWindow());
                StatementAnalyzer.this.analysis.addWindowDefinition(node, canonicalName, resolvedWindow);
            }
        }

        private Analysis.ResolvedWindow resolveWindowSpecification(QuerySpecification querySpecification, Window window) {
            if (window instanceof WindowReference) {
                WindowReference windowReference = (WindowReference)window;
                CanonicalizationAware<Identifier> canonicalName = CanonicalizationAware.canonicalizationAwareKey(windowReference.getName());
                Analysis.ResolvedWindow referencedWindow = StatementAnalyzer.this.analysis.getWindowDefinition(querySpecification, canonicalName);
                if (referencedWindow == null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_REFERENCE, (Node)windowReference.getName(), "Cannot resolve WINDOW name %s", windowReference.getName());
                }
                return new Analysis.ResolvedWindow(referencedWindow.getPartitionBy(), referencedWindow.getOrderBy(), referencedWindow.getFrame(), !referencedWindow.getPartitionBy().isEmpty(), referencedWindow.getOrderBy().isPresent(), referencedWindow.getFrame().isPresent());
            }
            WindowSpecification windowSpecification = (WindowSpecification)window;
            if (windowSpecification.getExistingWindowName().isPresent()) {
                Identifier referencedName = (Identifier)windowSpecification.getExistingWindowName().get();
                CanonicalizationAware<Identifier> canonicalName = CanonicalizationAware.canonicalizationAwareKey(referencedName);
                Analysis.ResolvedWindow referencedWindow = StatementAnalyzer.this.analysis.getWindowDefinition(querySpecification, canonicalName);
                if (referencedWindow == null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_REFERENCE, (Node)referencedName, "Cannot resolve WINDOW name %s", referencedName);
                }
                if (!windowSpecification.getPartitionBy().isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARTITION_BY, (Node)windowSpecification.getPartitionBy().getFirst(), "WINDOW specification with named WINDOW reference cannot specify PARTITION BY", new Object[0]);
                }
                if (windowSpecification.getOrderBy().isPresent() && referencedWindow.getOrderBy().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ORDER_BY, (Node)windowSpecification.getOrderBy().get(), "Cannot specify ORDER BY if referenced named WINDOW specifies ORDER BY", new Object[0]);
                }
                if (referencedWindow.getFrame().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_REFERENCE, (Node)windowSpecification.getExistingWindowName().get(), "Cannot reference named WINDOW containing frame specification", new Object[0]);
                }
                Optional<OrderBy> orderBy = windowSpecification.getOrderBy();
                boolean orderByInherited = false;
                if (orderBy.isEmpty() && referencedWindow.getOrderBy().isPresent()) {
                    orderBy = referencedWindow.getOrderBy();
                    orderByInherited = true;
                }
                List<Expression> partitionBy = windowSpecification.getPartitionBy();
                boolean partitionByInherited = false;
                if (!referencedWindow.getPartitionBy().isEmpty()) {
                    partitionBy = referencedWindow.getPartitionBy();
                    partitionByInherited = true;
                }
                Optional<WindowFrame> windowFrame = windowSpecification.getFrame();
                boolean frameInherited = false;
                if (windowFrame.isEmpty() && referencedWindow.getFrame().isPresent()) {
                    windowFrame = referencedWindow.getFrame();
                    frameInherited = true;
                }
                return new Analysis.ResolvedWindow(partitionBy, orderBy, windowFrame, partitionByInherited, orderByInherited, frameInherited);
            }
            return new Analysis.ResolvedWindow(windowSpecification.getPartitionBy(), windowSpecification.getOrderBy(), windowSpecification.getFrame(), false, false, false);
        }

        private void analyzeWindow(QuerySpecification querySpecification, Analysis.ResolvedWindow window, Scope scope, Node originalNode) {
            ExpressionAnalysis expressionAnalysis = ExpressionAnalyzer.analyzeWindow(StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, WarningCollector.NOOP, StatementAnalyzer.this.correlationSupport, window, originalNode);
            StatementAnalyzer.this.analysis.recordSubqueries((Node)querySpecification, expressionAnalysis);
        }

        private void resolveFunctionCallAndMeasureWindows(QuerySpecification querySpecification) {
            Analysis.ResolvedWindow resolvedWindow;
            ImmutableList.Builder expressions = ImmutableList.builder();
            for (SelectItem item : querySpecification.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    ((AllColumns)item).getTarget().ifPresent(arg_0 -> ((ImmutableList.Builder)expressions).add(arg_0));
                    continue;
                }
                if (!(item instanceof SingleColumn)) continue;
                expressions.add((Object)((SingleColumn)item).getExpression());
            }
            for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(querySpecification.getOrderBy())) {
                expressions.add((Object)sortItem.getSortKey());
            }
            for (FunctionCall windowFunction : ExpressionTreeUtils.extractWindowFunctions((Iterable<? extends Node>)expressions.build())) {
                resolvedWindow = this.resolveWindowSpecification(querySpecification, (Window)windowFunction.getWindow().orElseThrow());
                StatementAnalyzer.this.analysis.setWindow((Node)windowFunction, resolvedWindow);
            }
            for (WindowOperation measure : ExpressionTreeUtils.extractWindowMeasures((Iterable<? extends Node>)expressions.build())) {
                resolvedWindow = this.resolveWindowSpecification(querySpecification, measure.getWindow());
                StatementAnalyzer.this.analysis.setWindow((Node)measure, resolvedWindow);
            }
        }

        private void analyzeWindowFunctionsAndMeasures(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            StatementAnalyzer.this.analysis.setWindowFunctions(node, this.analyzeWindowFunctions(node, outputExpressions));
            StatementAnalyzer.this.analysis.setWindowMeasures(node, ExpressionTreeUtils.extractWindowMeasures(outputExpressions));
            if (node.getOrderBy().isPresent()) {
                OrderBy orderBy = (OrderBy)node.getOrderBy().get();
                StatementAnalyzer.this.analysis.setOrderByWindowFunctions(orderBy, this.analyzeWindowFunctions(node, orderByExpressions));
                StatementAnalyzer.this.analysis.setOrderByWindowMeasures(orderBy, ExpressionTreeUtils.extractWindowMeasures(orderByExpressions));
            }
        }

        private List<FunctionCall> analyzeWindowFunctions(QuerySpecification node, List<Expression> expressions) {
            for (Expression expression : expressions) {
                new WindowFunctionValidator().process((Node)expression, StatementAnalyzer.this.analysis);
            }
            List<FunctionCall> windowFunctions = ExpressionTreeUtils.extractWindowFunctions(expressions);
            for (FunctionCall windowFunction : windowFunctions) {
                if (windowFunction.getFilter().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "FILTER is not yet supported for window functions", new Object[0]);
                }
                if (windowFunction.getOrderBy().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)windowFunction, "Window function with ORDER BY is not supported", new Object[0]);
                }
                List<Expression> nestedWindowExpressions = ExpressionTreeUtils.extractWindowExpressions(windowFunction.getArguments());
                if (!nestedWindowExpressions.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)nestedWindowExpressions.getFirst(), "Cannot nest window functions or row pattern measures inside window function arguments", new Object[0]);
                }
                if (windowFunction.isDistinct()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT in window function parameters not yet supported: %s", windowFunction);
                }
                Analysis.ResolvedWindow window = StatementAnalyzer.this.analysis.getWindow((Node)windowFunction);
                String name = windowFunction.getName().toString().toLowerCase(Locale.ENGLISH);
                if (name.equals("lag") || name.equals("lead")) {
                    if (window.getOrderBy().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, (Node)windowFunction.getWindow().orElseThrow(), "%s function requires an ORDER BY window clause", windowFunction.getName());
                    }
                    if (window.getFrame().isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)window.getFrame().get(), "Cannot specify window frame for %s function", windowFunction.getName());
                    }
                }
                if (!WINDOW_VALUE_FUNCTIONS.contains(name) && windowFunction.getNullTreatment().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NULL_TREATMENT_NOT_ALLOWED, (Node)windowFunction, "Cannot specify null treatment clause for %s function", windowFunction.getName());
                }
                List<Type> argumentTypes = MoreLists.mappedCopy(windowFunction.getArguments(), StatementAnalyzer.this.analysis::getType);
                ResolvedFunction resolvedFunction = StatementAnalyzer.this.functionResolver.resolveFunction(StatementAnalyzer.this.session, windowFunction.getName(), TypeSignatureProvider.fromTypes(argumentTypes), StatementAnalyzer.this.accessControl);
                FunctionKind kind = resolvedFunction.functionKind();
                if (kind == FunctionKind.AGGREGATE || kind == FunctionKind.WINDOW) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_WINDOW, (Node)node, "Not a window function: %s", windowFunction.getName());
            }
            return windowFunctions;
        }

        private void analyzeHaving(QuerySpecification node, Scope scope) {
            if (node.getHaving().isPresent()) {
                Expression predicate = (Expression)node.getHaving().get();
                List<Expression> windowExpressions = ExpressionTreeUtils.extractWindowExpressions((Iterable<? extends Node>)ImmutableList.of((Object)predicate), StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl);
                if (!windowExpressions.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)windowExpressions.getFirst(), "HAVING clause cannot contain window functions or row pattern measures", new Object[0]);
                }
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
                StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                Type predicateType = expressionAnalysis.getType(predicate);
                if (!predicateType.equals((Object)BooleanType.BOOLEAN) && !predicateType.equals((Object)UnknownType.UNKNOWN)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)predicate, "HAVING clause must evaluate to a boolean: actual type %s", predicateType);
                }
                StatementAnalyzer.this.analysis.setHaving(node, predicate);
            }
        }

        private void checkGroupingSetsCount(GroupBy node) {
            int crossProduct = 1;
            for (GroupingElement element : node.getGroupingElements()) {
                try {
                    int product;
                    if (element instanceof SimpleGroupBy) {
                        product = 1;
                    } else if (element instanceof GroupingSets) {
                        GroupingSets groupingSets = (GroupingSets)element;
                        product = switch (groupingSets.getType()) {
                            default -> throw new MatchException(null, null);
                            case GroupingSets.Type.CUBE -> {
                                int exponent = ((GroupingSets)element).getSets().size();
                                if (exponent > 30) {
                                    throw new ArithmeticException();
                                }
                                yield 1 << exponent;
                            }
                            case GroupingSets.Type.ROLLUP -> groupingSets.getSets().size() + 1;
                            case GroupingSets.Type.EXPLICIT -> groupingSets.getSets().size();
                        };
                    } else {
                        throw new UnsupportedOperationException("Unsupported grouping element type: " + element.getClass().getName());
                    }
                    crossProduct = Math.multiplyExact(crossProduct, product);
                }
                catch (ArithmeticException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_GROUPING_SETS, (Node)node, "GROUP BY has more than %s grouping sets but can contain at most %s", Integer.MAX_VALUE, SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session));
                }
                if (crossProduct <= SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_GROUPING_SETS, (Node)node, "GROUP BY has %s grouping sets but can contain at most %s", crossProduct, SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session));
            }
        }

        private Analysis.GroupingSetAnalysis analyzeGroupBy(QuerySpecification node, Scope scope, List<Expression> outputExpressions) {
            if (node.getGroupBy().isPresent()) {
                ImmutableList.Builder cubes = ImmutableList.builder();
                ImmutableList.Builder rollups = ImmutableList.builder();
                ImmutableList.Builder sets = ImmutableList.builder();
                ImmutableList.Builder complexExpressions = ImmutableList.builder();
                ImmutableList.Builder groupingExpressions = ImmutableList.builder();
                this.checkGroupingSetsCount((GroupBy)node.getGroupBy().get());
                for (Object groupingElement : ((GroupBy)node.getGroupBy().get()).getGroupingElements()) {
                    if (groupingElement instanceof SimpleGroupBy) {
                        for (Expression column : groupingElement.getExpressions()) {
                            if (column instanceof LongLiteral) {
                                long ordinal = ((LongLiteral)column).getParsedValue();
                                if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, (Node)column, "GROUP BY position %s is not in select list", ordinal);
                                }
                                column = outputExpressions.get(Math.toIntExact(ordinal - 1L));
                                Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, column, "GROUP BY clause");
                            } else {
                                Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, column, "GROUP BY clause");
                                this.analyzeExpression(column, scope);
                            }
                            ResolvedField field = StatementAnalyzer.this.analysis.getColumnReferenceFields().get(NodeRef.of((Node)column));
                            if (field != null) {
                                sets.add((Object)ImmutableList.of((Object)ImmutableSet.of((Object)field.getFieldId())));
                            } else {
                                StatementAnalyzer.this.analysis.recordSubqueries((Node)node, this.analyzeExpression(column, scope));
                                complexExpressions.add((Object)column);
                            }
                            groupingExpressions.add((Object)column);
                        }
                        continue;
                    }
                    if (!(groupingElement instanceof GroupingSets)) continue;
                    GroupingSets element = (GroupingSets)groupingElement;
                    for (Expression column : groupingElement.getExpressions()) {
                        this.analyzeExpression(column, scope);
                        if (!StatementAnalyzer.this.analysis.getColumnReferences().contains(NodeRef.of((Node)column))) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, (Node)column, "GROUP BY expression must be a column reference: %s", column);
                        }
                        groupingExpressions.add((Object)column);
                    }
                    List groupingSets = (List)element.getSets().stream().map(set -> (ImmutableSet)set.stream().map(NodeRef::of).map(StatementAnalyzer.this.analysis.getColumnReferenceFields()::get).map(ResolvedField::getFieldId).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
                    switch (element.getType()) {
                        case CUBE: {
                            cubes.add((Object)groupingSets);
                            break;
                        }
                        case ROLLUP: {
                            rollups.add((Object)groupingSets);
                            break;
                        }
                        case EXPLICIT: {
                            sets.add((Object)groupingSets);
                        }
                    }
                }
                ImmutableList expressions = groupingExpressions.build();
                for (Expression expression : expressions) {
                    Type type = StatementAnalyzer.this.analysis.getType(expression);
                    if (type.isComparable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in GROUP BY", type);
                }
                Analysis.GroupingSetAnalysis groupingSets = new Analysis.GroupingSetAnalysis((List<Expression>)expressions, (List<List<Set<FieldId>>>)cubes.build(), (List<List<Set<FieldId>>>)rollups.build(), (List<List<Set<FieldId>>>)sets.build(), (List<Expression>)complexExpressions.build());
                StatementAnalyzer.this.analysis.setGroupingSets(node, groupingSets);
                return groupingSets;
            }
            Analysis.GroupingSetAnalysis result = new Analysis.GroupingSetAnalysis((List<Expression>)ImmutableList.of(), (List<List<Set<FieldId>>>)ImmutableList.of(), (List<List<Set<FieldId>>>)ImmutableList.of(), (List<List<Set<FieldId>>>)ImmutableList.of(), (List<Expression>)ImmutableList.of());
            if (this.hasAggregates(node) || node.getHaving().isPresent()) {
                StatementAnalyzer.this.analysis.setGroupingSets(node, result);
            }
            return result;
        }

        private boolean hasAggregates(QuerySpecification node) {
            ImmutableList toExtract = ImmutableList.builder().addAll((Iterable)node.getSelect().getSelectItems()).addAll(NodeUtils.getSortItemsFromOrderBy(node.getOrderBy())).build();
            List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions((Iterable<? extends Node>)toExtract, StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl);
            return !aggregates.isEmpty();
        }

        private Scope computeAndAssignOutputScope(QuerySpecification node, Optional<Scope> scope, Scope sourceScope) {
            ImmutableList.Builder outputFields = ImmutableList.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    AllColumns allColumns = (AllColumns)item;
                    List<Field> fields = StatementAnalyzer.this.analysis.getSelectAllResultFields(allColumns);
                    Preconditions.checkNotNull(fields, (String)"output fields is null for select item %s", (Object)item);
                    for (int i = 0; i < fields.size(); ++i) {
                        Field field = fields.get(i);
                        Optional<String> name = !allColumns.getAliases().isEmpty() ? Optional.of(((Identifier)allColumns.getAliases().get(i)).getCanonicalValue()) : field.getName();
                        Field newField = Field.newUnqualified(name, field.getType(), field.getOriginTable(), field.getOriginColumnName(), false);
                        StatementAnalyzer.this.analysis.addSourceColumns(newField, StatementAnalyzer.this.analysis.getSourceColumns(field));
                        outputFields.add((Object)newField);
                    }
                    continue;
                }
                if (item instanceof SingleColumn) {
                    List<Field> matchingFields;
                    SingleColumn column = (SingleColumn)item;
                    Expression expression = column.getExpression();
                    Optional<Identifier> field = column.getAlias();
                    Optional<QualifiedObjectName> originTable = Optional.empty();
                    Optional<String> originColumn = Optional.empty();
                    QualifiedName name = null;
                    if (expression instanceof Identifier) {
                        name = QualifiedName.of((String)((Identifier)expression).getValue());
                    } else if (expression instanceof DereferenceExpression) {
                        name = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
                    }
                    if (name != null && !(matchingFields = sourceScope.getRelationType().resolveFields(name)).isEmpty()) {
                        originTable = matchingFields.get(0).getOriginTable();
                        originColumn = matchingFields.get(0).getOriginColumnName();
                    }
                    if (field.isEmpty() && name != null) {
                        field = Optional.of((Identifier)Iterables.getLast((Iterable)name.getOriginalParts()));
                    }
                    Field newField = Field.newUnqualified(field.map(Identifier::getValue), StatementAnalyzer.this.analysis.getType(expression), originTable, originColumn, column.getAlias().isPresent());
                    if (originTable.isPresent()) {
                        StatementAnalyzer.this.analysis.addSourceColumns(newField, (Set<Analysis.SourceColumn>)ImmutableSet.of((Object)new Analysis.SourceColumn(originTable.get(), originColumn.orElseThrow())));
                    } else {
                        StatementAnalyzer.this.analysis.addSourceColumns(newField, StatementAnalyzer.this.analysis.getExpressionSourceColumns(expression));
                    }
                    outputFields.add((Object)newField);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
            }
            return this.createAndAssignScope((Node)node, scope, (List<Field>)outputFields.build());
        }

        private Scope computeAndAssignOrderByScope(OrderBy node, Scope sourceScope, Scope outputScope) {
            Scope orderByScope = Scope.builder().withParent(sourceScope).withRelationType(outputScope.getRelationId(), outputScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope((Node)node, orderByScope);
            return orderByScope;
        }

        private List<Expression> analyzeSelect(QuerySpecification node, Scope scope) {
            ImmutableList.Builder outputExpressionBuilder = ImmutableList.builder();
            ImmutableList.Builder selectExpressionBuilder = ImmutableList.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    this.analyzeSelectAllColumns((AllColumns)item, node, scope, (ImmutableList.Builder<Expression>)outputExpressionBuilder, (ImmutableList.Builder<Analysis.SelectExpression>)selectExpressionBuilder);
                    continue;
                }
                if (item instanceof SingleColumn) {
                    this.analyzeSelectSingleColumn((SingleColumn)item, node, scope, (ImmutableList.Builder<Expression>)outputExpressionBuilder, (ImmutableList.Builder<Analysis.SelectExpression>)selectExpressionBuilder);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
            }
            StatementAnalyzer.this.analysis.setSelectExpressions((Node)node, (List<Analysis.SelectExpression>)selectExpressionBuilder.build());
            return outputExpressionBuilder.build();
        }

        private void analyzeSelectAllColumns(AllColumns allColumns, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder) {
            if (allColumns.getTarget().isPresent()) {
                Scope.AsteriskedIdentifierChainBasis identifierChainBasis;
                Expression expression = (Expression)allColumns.getTarget().get();
                QualifiedName prefix = ExpressionTreeUtils.asQualifiedName(expression);
                if (prefix != null && (identifierChainBasis = scope.resolveAsteriskedIdentifierChainBasis(prefix, allColumns).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)allColumns, "Unable to resolve reference %s", prefix))).getBasisType() == Scope.BasisType.TABLE) {
                    RelationType relationType = identifierChainBasis.getRelationType().orElseThrow();
                    List<Field> requestedFields = relationType.resolveVisibleFieldsWithRelationPrefix(Optional.of(prefix));
                    List<Field> fields = this.filterInaccessibleFields(requestedFields);
                    if (fields.isEmpty()) {
                        if (!requestedFields.isEmpty()) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)allColumns, "Relation not found or not allowed", new Object[0]);
                        }
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)allColumns, "SELECT * not allowed from relation that has no columns", new Object[0]);
                    }
                    boolean local = scope.isLocalScope(identifierChainBasis.getScope().orElseThrow());
                    this.analyzeAllColumnsFromTable(fields, allColumns, node, local ? scope : identifierChainBasis.getScope().get(), outputExpressionBuilder, selectExpressionBuilder, relationType, local);
                    return;
                }
                this.analyzeAllFieldsFromRowTypeExpression(expression, allColumns, node, scope, outputExpressionBuilder, selectExpressionBuilder);
            } else {
                if (!allColumns.getAliases().isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)allColumns, "Column aliases not supported", new Object[0]);
                }
                List requestedFields = (List)scope.getRelationType().getVisibleFields();
                List<Field> fields = this.filterInaccessibleFields(requestedFields);
                if (fields.isEmpty()) {
                    if (node.getFrom().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)allColumns, "SELECT * not allowed in queries without FROM clause", new Object[0]);
                    }
                    if (!requestedFields.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)allColumns, "Relation not found or not allowed", new Object[0]);
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)allColumns, "SELECT * not allowed from relation that has no columns", new Object[0]);
                }
                this.analyzeAllColumnsFromTable(fields, allColumns, node, scope, outputExpressionBuilder, selectExpressionBuilder, scope.getRelationType(), true);
            }
        }

        private List<Field> filterInaccessibleFields(List<Field> fields) {
            if (!SystemSessionProperties.isHideInaccessibleColumns(StatementAnalyzer.this.session)) {
                return fields;
            }
            ImmutableSet.Builder accessibleFields = ImmutableSet.builder();
            ArrayListMultimap tableFieldsMap = ArrayListMultimap.create();
            fields.forEach(arg_0 -> Visitor.lambda$filterInaccessibleFields$121((ListMultimap)tableFieldsMap, accessibleFields, arg_0));
            tableFieldsMap.asMap().forEach((table, tableFields) -> {
                Set<String> accessibleColumns = StatementAnalyzer.this.accessControl.filterColumns(StatementAnalyzer.this.session.toSecurityContext(), table.catalogName(), (Map<SchemaTableName, Set<String>>)ImmutableMap.of((Object)table.asSchemaTableName(), (Object)((Set)tableFields.stream().map(field -> field.getOriginColumnName().get()).collect(ImmutableSet.toImmutableSet())))).getOrDefault(table.asSchemaTableName(), (Set<String>)ImmutableSet.of());
                accessibleFields.addAll((Iterable)tableFields.stream().filter(field -> accessibleColumns.contains(field.getOriginColumnName().get())).collect(ImmutableList.toImmutableList()));
            });
            return (List)fields.stream().filter(arg_0 -> ((ImmutableSet)accessibleFields.build()).contains(arg_0)).collect(ImmutableList.toImmutableList());
        }

        private void analyzeAllColumnsFromTable(List<Field> fields, AllColumns allColumns, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder, RelationType relationType, boolean local) {
            if (!allColumns.getAliases().isEmpty()) {
                this.validateColumnAliasesCount(allColumns.getAliases(), fields.size());
            }
            ImmutableList.Builder itemOutputFieldBuilder = ImmutableList.builder();
            for (int i = 0; i < fields.size(); ++i) {
                FieldReference fieldExpression;
                Field field = fields.get(i);
                if (local) {
                    fieldExpression = new FieldReference(relationType.indexOf(field));
                } else {
                    if (field.getName().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node.getSelect(), "SELECT * from outer scope table not supported with anonymous columns", new Object[0]);
                    }
                    Preconditions.checkState((boolean)field.getRelationAlias().isPresent(), (Object)"missing relation alias");
                    fieldExpression = new DereferenceExpression(DereferenceExpression.from((QualifiedName)field.getRelationAlias().get()), new Identifier(field.getName().get()));
                }
                this.analyzeExpression((Expression)fieldExpression, scope);
                outputExpressionBuilder.add((Object)fieldExpression);
                selectExpressionBuilder.add((Object)new Analysis.SelectExpression((Expression)fieldExpression, Optional.empty()));
                Optional<String> alias = field.getName();
                if (!allColumns.getAliases().isEmpty()) {
                    alias = Optional.of(((Identifier)allColumns.getAliases().get(i)).getValue());
                }
                Field newField = new Field(field.getRelationAlias(), alias, field.getType(), false, field.getOriginTable(), field.getOriginColumnName(), !allColumns.getAliases().isEmpty() || field.isAliased());
                itemOutputFieldBuilder.add((Object)newField);
                StatementAnalyzer.this.analysis.addSourceColumns(newField, StatementAnalyzer.this.analysis.getSourceColumns(field));
                Type type = field.getType();
                if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s)", type);
            }
            StatementAnalyzer.this.analysis.setSelectAllResultFields(allColumns, (List<Field>)itemOutputFieldBuilder.build());
        }

        private void analyzeAllFieldsFromRowTypeExpression(Expression expression, AllColumns allColumns, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder) {
            ImmutableList.Builder itemOutputFieldBuilder = ImmutableList.builder();
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, scope);
            Type type = expressionAnalysis.getType(expression);
            if (!(type instanceof RowType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "expected expression of type Row", new Object[0]);
            }
            int referencedFieldsCount = ((RowType)type).getFields().size();
            if (!allColumns.getAliases().isEmpty()) {
                this.validateColumnAliasesCount(allColumns.getAliases(), referencedFieldsCount);
            }
            StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            ImmutableList.Builder unfoldedExpressionsBuilder = ImmutableList.builder();
            for (int i = 0; i < referencedFieldsCount; ++i) {
                SubscriptExpression outputExpression = new SubscriptExpression(expression, (Expression)new LongLiteral("" + (i + 1)));
                outputExpressionBuilder.add((Object)outputExpression);
                this.analyzeExpression((Expression)outputExpression, scope);
                unfoldedExpressionsBuilder.add((Object)outputExpression);
                Type outputExpressionType = (Type)type.getTypeParameters().get(i);
                if (node.getSelect().isDistinct() && !outputExpressionType.isComparable()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s)", type.getTypeParameters().get(i));
                }
                Optional<String> name = ((RowType.Field)((RowType)type).getFields().get(i)).getName();
                if (!allColumns.getAliases().isEmpty()) {
                    name = Optional.of(((Identifier)allColumns.getAliases().get(i)).getValue());
                }
                itemOutputFieldBuilder.add((Object)Field.newUnqualified(name, outputExpressionType));
            }
            selectExpressionBuilder.add((Object)new Analysis.SelectExpression(expression, Optional.of(unfoldedExpressionsBuilder.build())));
            StatementAnalyzer.this.analysis.setSelectAllResultFields(allColumns, (List<Field>)itemOutputFieldBuilder.build());
        }

        private void analyzeSelectSingleColumn(SingleColumn singleColumn, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder) {
            Expression expression = singleColumn.getExpression();
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, scope);
            StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            outputExpressionBuilder.add((Object)expression);
            selectExpressionBuilder.add((Object)new Analysis.SelectExpression(expression, Optional.empty()));
            Type type = expressionAnalysis.getType(expression);
            if (node.getSelect().isDistinct() && !type.isComparable()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s): %s", type, expression);
            }
        }

        private void analyzeWhere(Node node, Scope scope, Expression predicate) {
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, predicate, "WHERE clause");
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
            StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
            Type predicateType = expressionAnalysis.getType(predicate);
            if (!predicateType.equals((Object)BooleanType.BOOLEAN)) {
                if (!predicateType.equals((Object)UnknownType.UNKNOWN)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)predicate, "WHERE clause must evaluate to a boolean: actual type %s", predicateType);
                }
                StatementAnalyzer.this.analysis.addCoercion(predicate, (Type)BooleanType.BOOLEAN);
            }
            StatementAnalyzer.this.analysis.setWhere(node, predicate);
        }

        private Scope analyzeFrom(QuerySpecification node, Optional<Scope> scope) {
            if (node.getFrom().isPresent()) {
                return this.process((Node)node.getFrom().get(), scope);
            }
            Scope result = this.createScope(scope);
            StatementAnalyzer.this.analysis.setImplicitFromScope(node, result);
            return result;
        }

        private void analyzeGroupingOperations(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            boolean isGroupingOperationPresent;
            List<GroupingOperation> groupingOperations = ExpressionTreeUtils.extractExpressions(Iterables.concat(outputExpressions, orderByExpressions), GroupingOperation.class);
            boolean bl = isGroupingOperationPresent = !groupingOperations.isEmpty();
            if (isGroupingOperationPresent && node.getGroupBy().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_GROUP_BY, (Node)node, "A GROUPING() operation can only be used with a corresponding GROUPING SET/CUBE/ROLLUP/GROUP BY clause", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setGroupingOperations(node, groupingOperations);
        }

        private void analyzeAggregations(QuerySpecification node, Scope sourceScope, Optional<Scope> orderByScope, Analysis.GroupingSetAnalysis groupByAnalysis, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            Preconditions.checkState((orderByExpressions.isEmpty() || orderByScope.isPresent() ? 1 : 0) != 0, (Object)"non-empty orderByExpressions list without orderByScope provided");
            List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions(Iterables.concat(outputExpressions, orderByExpressions), StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl);
            StatementAnalyzer.this.analysis.setAggregates(node, aggregates);
            if (StatementAnalyzer.this.analysis.isAggregation(node)) {
                ImmutableList distinctGroupingColumns = ImmutableSet.copyOf(groupByAnalysis.getOriginalExpressions()).asList();
                AggregationAnalyzer.verifySourceAggregations((List<Expression>)distinctGroupingColumns, sourceScope, outputExpressions, StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.analysis);
                if (!orderByExpressions.isEmpty()) {
                    AggregationAnalyzer.verifyOrderByAggregations((List<Expression>)distinctGroupingColumns, sourceScope, orderByScope.orElseThrow(), orderByExpressions, StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.analysis);
                }
            }
        }

        private RelationType analyzeView(Query query, QualifiedObjectName name, Optional<String> catalog, Optional<String> schema, Optional<Identity> owner, List<CatalogSchemaName> path, Table node) {
            try {
                AccessControl viewAccessControl;
                Identity identity;
                if (owner.isPresent()) {
                    identity = Identity.from((Identity)owner.get()).withGroups(StatementAnalyzer.this.groupProvider.getGroups(owner.get().getUser())).build();
                    viewAccessControl = owner.get().getUser().equals(StatementAnalyzer.this.session.getIdentity().getUser()) ? StatementAnalyzer.this.accessControl : new ViewAccessControl(StatementAnalyzer.this.accessControl);
                } else {
                    identity = StatementAnalyzer.this.session.getIdentity();
                    viewAccessControl = StatementAnalyzer.this.accessControl;
                }
                Session viewSession = StatementAnalyzer.this.session.createViewSession(catalog, schema, identity, path);
                StatementAnalyzer analyzer = StatementAnalyzer.this.statementAnalyzerFactory.withSpecializedAccessControl(viewAccessControl).createStatementAnalyzer(StatementAnalyzer.this.analysis, viewSession, this.warningCollector, CorrelationSupport.ALLOWED);
                Scope queryScope = analyzer.analyze((Node)query);
                return queryScope.getRelationType().withAlias(name.objectName(), null);
            }
            catch (RuntimeException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, (Node)node, e, "Failed analyzing stored view '%s': %s", name, e.getMessage());
            }
        }

        private Query parseView(String view, QualifiedObjectName name, Node node) {
            try {
                return (Query)StatementAnalyzer.this.sqlParser.createStatement(view);
            }
            catch (ParsingException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, node, e, "Failed parsing stored view '%s': %s", name, e.getMessage());
            }
        }

        private Optional<String> checkViewStaleness(List<ViewColumn> columns, Collection<Field> fields, QualifiedObjectName name, Node node) {
            if (columns.size() != fields.size()) {
                return Optional.of(String.format("stored view column count (%s) does not match column count derived from the view query analysis (%s)", columns.size(), fields.size()));
            }
            ImmutableList fieldList = ImmutableList.copyOf(fields);
            for (int i = 0; i < columns.size(); ++i) {
                ViewColumn column = columns.get(i);
                Type type = this.getViewColumnType(column, name, node);
                Field field = (Field)fieldList.get(i);
                if (field.getName().isEmpty()) {
                    return Optional.of(String.format("a column of type %s projected from query view at position %s has no name", field.getType(), i));
                }
                String fieldName = field.getName().orElseThrow();
                if (!column.name().equalsIgnoreCase(fieldName)) {
                    return Optional.of(String.format("column [%s] of type %s projected from query view at position %s has a different name from column [%s] of type %s stored in view definition", fieldName, field.getType(), i, column.name(), type));
                }
                if (StatementAnalyzer.this.typeCoercion.canCoerce(field.getType(), type)) continue;
                return Optional.of(String.format("column [%s] of type %s projected from query view at position %s cannot be coerced to column [%s] of type %s stored in view definition", fieldName, field.getType(), i, column.name(), type));
            }
            return Optional.empty();
        }

        private Type getViewColumnType(ViewColumn column, QualifiedObjectName name, Node node) {
            try {
                return StatementAnalyzer.this.plannerContext.getTypeManager().getType(column.type());
            }
            catch (TypeNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, node, e, "Unknown type '%s' for column '%s' in view: %s", column.type(), column.name(), name);
            }
        }

        private ExpressionAnalysis analyzeExpression(Expression expression, Scope scope) {
            return ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, StatementAnalyzer.this.correlationSupport);
        }

        private ExpressionAnalysis analyzeExpression(Expression expression, Scope scope, CorrelationSupport correlationSupport) {
            return ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, correlationSupport);
        }

        private void analyzeRowFilter(String currentIdentity, Table table, QualifiedObjectName name, Scope scope, ViewExpression filter) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            if (StatementAnalyzer.this.analysis.hasRowFilter(name, currentIdentity)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, ExpressionTreeUtils.extractLocation((Node)table), String.format("Row filter for '%s' is recursive", name), null);
            }
            try {
                expression = StatementAnalyzer.this.sqlParser.createExpression(filter.getExpression());
            }
            catch (ParsingException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, ExpressionTreeUtils.extractLocation((Node)table), String.format("Invalid row filter for '%s': %s", name, e.getErrorMessage()), (Throwable)e);
            }
            StatementAnalyzer.this.analysis.registerTableForRowFiltering(name, currentIdentity, expression.toString());
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, expression, String.format("Row filter for '%s'", name));
            try {
                Identity filterIdentity = filter.getSecurityIdentity().map(filterUser -> Identity.forUser((String)filterUser).withGroups(StatementAnalyzer.this.groupProvider.getGroups(filterUser)).build()).orElseGet(StatementAnalyzer.this.session::getIdentity);
                expressionAnalysis = ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session.createViewSession((Optional<String>)filter.getCatalog(), (Optional<String>)filter.getSchema(), filterIdentity, filter.getPath()), StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, StatementAnalyzer.this.correlationSupport);
            }
            catch (TrinoException e) {
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)table), String.format("Invalid row filter for '%s': %s", name, e.getRawMessage()), (Throwable)e);
            }
            finally {
                StatementAnalyzer.this.analysis.unregisterTableForRowFiltering(name, currentIdentity);
            }
            StatementAnalyzer.this.analysis.recordSubqueries((Node)expression, expressionAnalysis);
            Type actualType = expressionAnalysis.getType(expression);
            if (!actualType.equals((Object)BooleanType.BOOLEAN)) {
                TypeCoercion coercion = new TypeCoercion(arg_0 -> ((TypeManager)StatementAnalyzer.this.plannerContext.getTypeManager()).getType(arg_0));
                if (!coercion.canCoerce(actualType, (Type)BooleanType.BOOLEAN)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ExpressionTreeUtils.extractLocation((Node)table), String.format("Expected row filter for '%s' to be of type BOOLEAN, but was %s", name, actualType), null);
                }
                StatementAnalyzer.this.analysis.addCoercion(expression, (Type)BooleanType.BOOLEAN);
            }
            StatementAnalyzer.this.analysis.addRowFilter(table, expression);
        }

        private void analyzeCheckConstraint(Table table, QualifiedObjectName name, Scope scope, ViewExpression constraint) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            try {
                expression = StatementAnalyzer.this.sqlParser.createExpression(constraint.getExpression());
            }
            catch (ParsingException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CHECK_CONSTRAINT, ExpressionTreeUtils.extractLocation((Node)table), String.format("Invalid check constraint for '%s': %s", name, e.getErrorMessage()), (Throwable)e);
            }
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, expression, String.format("Check constraint for '%s'", name));
            List<SubqueryExpression> subQueries = ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)expression), SubqueryExpression.class);
            if (!subQueries.isEmpty() && Set.of("UPDATE", "MERGE").contains(StatementAnalyzer.this.analysis.getUpdateType())) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_SUBQUERY, (Node)subQueries.getFirst(), "Subqueries are not currently supported in CHECK constraints", new Object[0]);
            }
            try {
                Identity constraintIdentity = constraint.getSecurityIdentity().map(user -> Identity.forUser((String)user).withGroups(StatementAnalyzer.this.groupProvider.getGroups(user)).build()).orElseGet(StatementAnalyzer.this.session::getIdentity);
                expressionAnalysis = ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session.createViewSession((Optional<String>)constraint.getCatalog(), (Optional<String>)constraint.getSchema(), constraintIdentity, constraint.getPath()), StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, StatementAnalyzer.this.correlationSupport);
            }
            catch (TrinoException e) {
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)table), String.format("Invalid check constraint for '%s': %s", name, e.getRawMessage()), (Throwable)e);
            }
            if (!DeterminismEvaluator.isDeterministic(expression, this::getResolvedFunction)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_CHECK_CONSTRAINT, (Node)expression, "Check constraint expression should be deterministic", new Object[0]);
            }
            if (DeterminismEvaluator.containsCurrentTimeFunctions(expression)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_CHECK_CONSTRAINT, (Node)expression, "Check constraint expression should not contain temporal expression", new Object[0]);
            }
            StatementAnalyzer.this.analysis.recordSubqueries((Node)expression, expressionAnalysis);
            Type actualType = expressionAnalysis.getType(expression);
            if (!actualType.equals((Object)BooleanType.BOOLEAN)) {
                TypeCoercion coercion = new TypeCoercion(arg_0 -> ((TypeManager)StatementAnalyzer.this.plannerContext.getTypeManager()).getType(arg_0));
                if (!coercion.canCoerce(actualType, (Type)BooleanType.BOOLEAN)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ExpressionTreeUtils.extractLocation((Node)table), String.format("Expected check constraint for '%s' to be of type BOOLEAN, but was %s", name, actualType), null);
                }
                StatementAnalyzer.this.analysis.addCoercion(expression, (Type)BooleanType.BOOLEAN);
            }
            StatementAnalyzer.this.analysis.addCheckConstraints(table, expression);
        }

        private void analyzeColumnMask(String currentIdentity, Table table, QualifiedObjectName tableName, Field field, Scope scope, ViewExpression mask) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            String column = field.getName().orElseThrow();
            if (StatementAnalyzer.this.analysis.hasColumnMask(tableName, column, currentIdentity)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, ExpressionTreeUtils.extractLocation((Node)table), String.format("Column mask for '%s.%s' is recursive", tableName, column), null);
            }
            try {
                expression = StatementAnalyzer.this.sqlParser.createExpression(mask.getExpression());
            }
            catch (ParsingException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, ExpressionTreeUtils.extractLocation((Node)table), String.format("Invalid column mask for '%s.%s': %s", tableName, column, e.getErrorMessage()), (Throwable)e);
            }
            StatementAnalyzer.this.analysis.registerTableForColumnMasking(tableName, column, currentIdentity, expression.toString());
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.session, StatementAnalyzer.this.functionResolver, StatementAnalyzer.this.accessControl, expression, String.format("Column mask for '%s.%s'", table.getName(), column));
            try {
                Identity maskIdentity = mask.getSecurityIdentity().map(maskUser -> Identity.forUser((String)maskUser).withGroups(StatementAnalyzer.this.groupProvider.getGroups(maskUser)).build()).orElseGet(StatementAnalyzer.this.session::getIdentity);
                expressionAnalysis = ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session.createViewSession((Optional<String>)mask.getCatalog(), (Optional<String>)mask.getSchema(), maskIdentity, mask.getPath()), StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, StatementAnalyzer.this.correlationSupport);
            }
            catch (TrinoException e) {
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)table), String.format("Invalid column mask for '%s.%s': %s", tableName, column, e.getRawMessage()), (Throwable)e);
            }
            finally {
                StatementAnalyzer.this.analysis.unregisterTableForColumnMasking(tableName, column, currentIdentity);
            }
            StatementAnalyzer.this.analysis.recordSubqueries((Node)expression, expressionAnalysis);
            Type expectedType = field.getType();
            Type actualType = expressionAnalysis.getType(expression);
            if (!actualType.equals((Object)expectedType)) {
                TypeCoercion coercion = new TypeCoercion(arg_0 -> ((TypeManager)StatementAnalyzer.this.plannerContext.getTypeManager()).getType(arg_0));
                if (!coercion.canCoerce(actualType, field.getType())) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ExpressionTreeUtils.extractLocation((Node)table), String.format("Expected column mask for '%s.%s' to be of type %s, but was %s", tableName, column, field.getType(), actualType), null);
                }
                StatementAnalyzer.this.analysis.addCoercion(expression, expectedType);
            }
            StatementAnalyzer.this.analysis.addColumnMask(table, column, expression);
        }

        private List<Expression> descriptorToFields(Scope scope) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int fieldIndex = 0; fieldIndex < scope.getRelationType().getAllFieldCount(); ++fieldIndex) {
                FieldReference expression = new FieldReference(fieldIndex);
                builder.add((Object)expression);
                this.analyzeExpression((Expression)expression, scope);
            }
            return builder.build();
        }

        private Scope analyzeWith(Query node, Optional<Scope> scope) {
            if (node.getWith().isEmpty()) {
                return this.createScope(scope);
            }
            With with = (With)node.getWith().get();
            Scope.Builder withScopeBuilder = this.scopeBuilder(scope);
            for (WithQuery withQuery : with.getQueries()) {
                String name = withQuery.getName().getValue().toLowerCase(Locale.ENGLISH);
                if (withScopeBuilder.containsNamedQuery(name)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_NAMED_QUERY, (Node)withQuery, "WITH query name '%s' specified more than once", name);
                }
                boolean isRecursive = false;
                if (with.isRecursive()) {
                    List<Node> recursiveReferences;
                    AstUtils.preOrder((Node)withQuery.getQuery()).filter(child -> child instanceof PatternRecognitionRelation || child instanceof RowPattern).findFirst().ifPresent(nested -> {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION, nested, "nested row pattern recognition in recursive query", new Object[0]);
                    });
                    isRecursive = this.tryProcessRecursiveQuery(withQuery, name, withScopeBuilder);
                    if (!isRecursive && !(recursiveReferences = this.findReferences((Node)withQuery.getQuery(), withQuery.getName())).isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, recursiveReferences.getFirst(), "recursive reference not allowed in this context", new Object[0]);
                    }
                }
                if (isRecursive) continue;
                Query query = withQuery.getQuery();
                StatementAnalyzer.this.analyze((Node)query, withScopeBuilder.build());
                if (withQuery.getColumnNames().isPresent()) {
                    this.validateColumnAliases((List)withQuery.getColumnNames().get(), StatementAnalyzer.this.analysis.getOutputDescriptor((Node)query).getVisibleFieldCount());
                }
                withScopeBuilder.withNamedQuery(name, withQuery);
            }
            Scope withScope = withScopeBuilder.build();
            StatementAnalyzer.this.analysis.setScope((Node)with, withScope);
            return withScope;
        }

        private boolean tryProcessRecursiveQuery(WithQuery withQuery, String name, Scope.Builder withScopeBuilder) {
            if (withQuery.getColumnNames().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_COLUMN_ALIASES, (Node)withQuery, "missing column aliases in recursive WITH query", new Object[0]);
            }
            AstUtils.preOrder((Node)withQuery.getQuery()).filter(child -> child instanceof With && ((With)child).isRecursive()).findFirst().ifPresent(child -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_RECURSIVE, child, "nested recursive WITH query", new Object[0]);
            });
            QueryBody queryBody = withQuery.getQuery().getQueryBody();
            if (!(queryBody instanceof Union)) {
                return false;
            }
            Union union = (Union)queryBody;
            if (union.getRelations().size() != 2) {
                return false;
            }
            Relation anchor = (Relation)union.getRelations().get(0);
            Relation step = (Relation)union.getRelations().get(1);
            List<Node> anchorReferences = this.findReferences((Node)anchor, withQuery.getName());
            if (!anchorReferences.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, anchorReferences.getFirst(), "WITH table name is referenced in the base relation of recursion", new Object[0]);
            }
            List<Node> stepReferences = this.findReferences((Node)step, withQuery.getName());
            if (stepReferences.size() > 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, stepReferences.get(1), "multiple recursive references in the step relation of recursion", new Object[0]);
            }
            if (stepReferences.size() != 1) {
                return false;
            }
            Relation specification = step;
            while (specification instanceof TableSubquery) {
                Query query = ((TableSubquery)specification).getQuery();
                query.getLimit().ifPresent(limit -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LIMIT_CLAUSE, limit, "FETCH FIRST / LIMIT clause in the step relation of recursion", new Object[0]);
                });
                specification = query.getQueryBody();
            }
            if (!(specification instanceof QuerySpecification) || ((QuerySpecification)specification).getFrom().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, stepReferences.getFirst(), "recursive reference outside of FROM clause of the step relation of recursion", new Object[0]);
            }
            Relation from = (Relation)((QuerySpecification)specification).getFrom().get();
            List<Node> fromReferences = this.findReferences((Node)from, withQuery.getName());
            if (fromReferences.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, stepReferences.getFirst(), "recursive reference outside of FROM clause of the step relation of recursion", new Object[0]);
            }
            withQuery.getQuery().getWith().ifPresent(innerWith -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)innerWith, "immediate WITH clause in recursive query", new Object[0]);
            });
            withQuery.getQuery().getOrderBy().ifPresent(orderBy -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)orderBy, "immediate ORDER BY clause in recursive query", new Object[0]);
            });
            withQuery.getQuery().getOffset().ifPresent(offset -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)offset, "immediate OFFSET clause in recursive query", new Object[0]);
            });
            withQuery.getQuery().getLimit().ifPresent(limit -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LIMIT_CLAUSE, limit, "immediate FETCH FIRST / LIMIT clause in recursive query", new Object[0]);
            });
            this.validateFromClauseOfRecursiveTerm(from, withQuery.getName());
            Scope parentScope = withScopeBuilder.build();
            Scope anchorScope = this.process((Node)anchor, parentScope);
            Scope aliasedAnchorScope = this.setAliases(anchorScope, withQuery.getName(), (List)withQuery.getColumnNames().get());
            Node recursiveReference = fromReferences.getFirst();
            StatementAnalyzer.this.analysis.setExpandableBaseScope(recursiveReference, aliasedAnchorScope);
            Scope stepScope = this.process((Node)step, parentScope);
            RelationType anchorType = aliasedAnchorScope.getRelationType().withOnlyVisibleFields();
            RelationType stepType = stepScope.getRelationType().withOnlyVisibleFields();
            if (anchorType.getVisibleFieldCount() != stepType.getVisibleFieldCount()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)step, "base and step relations of recursion have different number of fields: %s, %s", anchorType.getVisibleFieldCount(), stepType.getVisibleFieldCount());
            }
            List anchorFieldTypes = (List)anchorType.getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            List stepFieldTypes = (List)stepType.getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            for (int i = 0; i < anchorFieldTypes.size(); ++i) {
                if (StatementAnalyzer.this.typeCoercion.canCoerce((Type)stepFieldTypes.get(i), (Type)anchorFieldTypes.get(i))) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)step, "recursion step relation output type (%s) is not coercible to recursion base relation output type (%s) at column %s", stepFieldTypes.get(i), anchorFieldTypes.get(i), i + 1);
            }
            if (!anchorFieldTypes.equals(stepFieldTypes)) {
                StatementAnalyzer.this.analysis.addRelationCoercion(step, (Type[])anchorFieldTypes.toArray(Type[]::new));
            }
            StatementAnalyzer.this.analysis.setScope((Node)withQuery.getQuery(), aliasedAnchorScope);
            StatementAnalyzer.this.analysis.registerExpandableQuery(withQuery.getQuery(), recursiveReference);
            withScopeBuilder.withNamedQuery(name, withQuery);
            return true;
        }

        private List<Node> findReferences(Node node, Identifier name) {
            Stream<Node> allReferences = AstUtils.preOrder((Node)node).filter(this.isTableWithName(name));
            Set shadowedReferences = (Set)AstUtils.preOrder((Node)node).filter(this.isQueryWithNameShadowed(name)).flatMap(query -> AstUtils.preOrder((Node)query).filter(this.isTableWithName(name))).collect(ImmutableSet.toImmutableSet());
            return (List)allReferences.filter(reference -> !shadowedReferences.contains(reference)).collect(ImmutableList.toImmutableList());
        }

        private Predicate<Node> isTableWithName(Identifier name) {
            return node -> {
                if (!(node instanceof Table)) {
                    return false;
                }
                Table table = (Table)node;
                QualifiedName tableName = table.getName();
                return tableName.getPrefix().isEmpty() && tableName.hasSuffix(QualifiedName.of((String)name.getValue()));
            };
        }

        private Predicate<Node> isQueryWithNameShadowed(Identifier name) {
            return node -> {
                if (!(node instanceof Query)) {
                    return false;
                }
                Query query = (Query)node;
                if (query.getWith().isEmpty()) {
                    return false;
                }
                return ((With)query.getWith().get()).getQueries().stream().map(WithQuery::getName).map(Identifier::getValue).anyMatch(withQueryName -> withQueryName.equalsIgnoreCase(name.getValue()));
            };
        }

        private void validateFromClauseOfRecursiveTerm(Relation from, Identifier name) {
            AstUtils.preOrder((Node)from).filter(Join.class::isInstance).forEach(node -> {
                Join join = (Join)node;
                Join.Type type = join.getType();
                if (type == Join.Type.LEFT || type == Join.Type.RIGHT || type == Join.Type.FULL) {
                    List<Node> leftRecursiveReferences = this.findReferences((Node)join.getLeft(), name);
                    List<Node> rightRecursiveReferences = this.findReferences((Node)join.getRight(), name);
                    if (!(leftRecursiveReferences.isEmpty() || type != Join.Type.RIGHT && type != Join.Type.FULL)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, leftRecursiveReferences.getFirst(), "recursive reference in left source of %s join", type);
                    }
                    if (!(rightRecursiveReferences.isEmpty() || type != Join.Type.LEFT && type != Join.Type.FULL)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, rightRecursiveReferences.getFirst(), "recursive reference in right source of %s join", type);
                    }
                }
            });
            AstUtils.preOrder((Node)from).filter(node -> node instanceof Intersect && !((Intersect)node).isDistinct()).forEach(node -> {
                Intersect intersect = (Intersect)node;
                intersect.getRelations().stream().flatMap(relation -> this.findReferences((Node)relation, name).stream()).findFirst().ifPresent(reference -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, reference, "recursive reference in INTERSECT ALL", new Object[0]);
                });
            });
            AstUtils.preOrder((Node)from).filter(Except.class::isInstance).forEach(node -> {
                List<Node> leftRecursiveReferences;
                Except except = (Except)node;
                List<Node> rightRecursiveReferences = this.findReferences((Node)except.getRight(), name);
                if (!rightRecursiveReferences.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, rightRecursiveReferences.getFirst(), "recursive reference in right relation of EXCEPT %s", except.isDistinct() ? "DISTINCT" : "ALL");
                }
                if (!except.isDistinct() && !(leftRecursiveReferences = this.findReferences((Node)except.getLeft(), name)).isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RECURSIVE_REFERENCE, leftRecursiveReferences.getFirst(), "recursive reference in left relation of EXCEPT ALL", new Object[0]);
                }
            });
        }

        private Scope setAliases(Scope scope, Identifier tableName, List<Identifier> columnNames) {
            RelationType oldDescriptor = scope.getRelationType();
            this.validateColumnAliases(columnNames, oldDescriptor.getVisibleFieldCount());
            RelationType newDescriptor = oldDescriptor.withAlias(tableName.getValue(), (List)columnNames.stream().map(Identifier::getValue).collect(ImmutableList.toImmutableList()));
            Streams.forEachPair(oldDescriptor.getAllFields().stream(), newDescriptor.getAllFields().stream(), (newField, field) -> StatementAnalyzer.this.analysis.addSourceColumns((Field)newField, StatementAnalyzer.this.analysis.getSourceColumns((Field)field)));
            return scope.withRelationType(newDescriptor);
        }

        private void verifySelectDistinct(QuerySpecification node, List<Expression> orderByExpressions, List<Expression> outputExpressions, Scope sourceScope, Scope orderByScope) {
            Set<CanonicalizationAware<Identifier>> aliases = this.getAliases(node.getSelect());
            Set expressions = outputExpressions.stream().map(e -> ScopeAware.scopeAwareKey(e, StatementAnalyzer.this.analysis, sourceScope)).collect(Collectors.toSet());
            for (Expression expression : orderByExpressions) {
                if (expression instanceof FieldReference || expression instanceof Identifier && aliases.contains(CanonicalizationAware.canonicalizationAwareKey(expression)) || expressions.contains(ScopeAware.scopeAwareKey(expression, StatementAnalyzer.this.analysis, orderByScope))) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT, (Node)node.getSelect(), "For SELECT DISTINCT, ORDER BY expressions must appear in select list", new Object[0]);
            }
            for (Expression expression : orderByExpressions) {
                if (DeterminismEvaluator.isDeterministic(expression, this::getResolvedFunction)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT, (Node)expression, "Non deterministic ORDER BY expression is not supported with SELECT DISTINCT", new Object[0]);
            }
        }

        private Set<CanonicalizationAware<Identifier>> getAliases(Select node) {
            ImmutableSet.Builder aliases = ImmutableSet.builder();
            for (SelectItem item : node.getSelectItems()) {
                if (item instanceof SingleColumn) {
                    SingleColumn column = (SingleColumn)item;
                    Optional alias = column.getAlias();
                    if (alias.isPresent()) {
                        aliases.add(CanonicalizationAware.canonicalizationAwareKey((Identifier)alias.get()));
                        continue;
                    }
                    Expression expression = column.getExpression();
                    if (expression instanceof Identifier) {
                        Identifier identifier = (Identifier)expression;
                        aliases.add(CanonicalizationAware.canonicalizationAwareKey(identifier));
                        continue;
                    }
                    expression = column.getExpression();
                    if (!(expression instanceof DereferenceExpression)) continue;
                    DereferenceExpression dereferenceExpression = (DereferenceExpression)expression;
                    aliases.add(CanonicalizationAware.canonicalizationAwareKey((Identifier)dereferenceExpression.getField().orElseThrow()));
                    continue;
                }
                if (!(item instanceof AllColumns)) continue;
                AllColumns allColumns = (AllColumns)item;
                List<Field> fields = StatementAnalyzer.this.analysis.getSelectAllResultFields(allColumns);
                Preconditions.checkNotNull(fields, (String)"output fields is null for select item %s", (Object)item);
                for (int i = 0; i < fields.size(); ++i) {
                    Field field = fields.get(i);
                    if (!allColumns.getAliases().isEmpty()) {
                        aliases.add(CanonicalizationAware.canonicalizationAwareKey((Identifier)allColumns.getAliases().get(i)));
                        continue;
                    }
                    if (!field.getName().isPresent()) continue;
                    aliases.add(CanonicalizationAware.canonicalizationAwareKey(new Identifier(field.getName().get())));
                }
            }
            return aliases.build();
        }

        private ResolvedFunction getResolvedFunction(FunctionCall functionCall) {
            ResolvedFunction resolvedFunction = StatementAnalyzer.this.analysis.getResolvedFunction((Node)functionCall);
            Verify.verify((resolvedFunction != null ? 1 : 0) != 0, (String)"function has not been analyzed yet: %s", (Object)functionCall);
            return resolvedFunction;
        }

        private List<Expression> analyzeOrderBy(Node node, List<SortItem> sortItems, Scope orderByScope) {
            ImmutableList.Builder orderByFieldsBuilder = ImmutableList.builder();
            for (SortItem item : sortItems) {
                Expression expression = item.getSortKey();
                if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getParsedValue();
                    if (ordinal < 1L || ordinal > (long)orderByScope.getRelationType().getVisibleFieldCount()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                    }
                    expression = new FieldReference(Math.toIntExact(ordinal - 1L));
                }
                ExpressionAnalysis expressionAnalysis = ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, orderByScope, StatementAnalyzer.this.analysis, expression, WarningCollector.NOOP, StatementAnalyzer.this.correlationSupport);
                StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
                Type type = StatementAnalyzer.this.analysis.getType(expression);
                if (!type.isOrderable()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Type %s is not orderable, and therefore cannot be used in ORDER BY: %s", type, expression);
                }
                orderByFieldsBuilder.add((Object)expression);
            }
            return orderByFieldsBuilder.build();
        }

        private void analyzeOffset(Offset node, Scope scope) {
            long rowCount;
            if (node.getRowCount() instanceof LongLiteral) {
                rowCount = ((LongLiteral)node.getRowCount()).getParsedValue();
            } else {
                Preconditions.checkState((boolean)(node.getRowCount() instanceof Parameter), (Object)("unexpected OFFSET rowCount: " + node.getRowCount().getClass().getSimpleName()));
                OptionalLong providedValue = this.analyzeParameterAsRowCount((Parameter)node.getRowCount(), scope, "OFFSET");
                rowCount = providedValue.orElse(0L);
            }
            if (rowCount < 0L) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)node, "OFFSET row count must be greater or equal to 0 (actual value: %s)", rowCount);
            }
            StatementAnalyzer.this.analysis.setOffset(node, rowCount);
        }

        private boolean analyzeLimit(Node node, Scope scope) {
            Preconditions.checkState((node instanceof FetchFirst || node instanceof Limit ? 1 : 0) != 0, (String)"Invalid limit node type. Expected: FetchFirst or Limit. Actual: %s", (Object)node.getClass().getName());
            if (node instanceof FetchFirst) {
                return this.analyzeLimit((FetchFirst)node, scope);
            }
            return this.analyzeLimit((Limit)node, scope);
        }

        private boolean analyzeLimit(FetchFirst node, Scope scope) {
            long rowCount = 1L;
            if (node.getRowCount().isPresent()) {
                Expression count = (Expression)node.getRowCount().get();
                if (count instanceof LongLiteral) {
                    rowCount = ((LongLiteral)count).getParsedValue();
                } else {
                    Preconditions.checkState((boolean)(count instanceof Parameter), (Object)("unexpected FETCH FIRST rowCount: " + count.getClass().getSimpleName()));
                    OptionalLong providedValue = this.analyzeParameterAsRowCount((Parameter)count, scope, "FETCH FIRST");
                    if (providedValue.isPresent()) {
                        rowCount = providedValue.getAsLong();
                    }
                }
            }
            if (rowCount <= 0L) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)node, "FETCH FIRST row count must be positive (actual value: %s)", rowCount);
            }
            StatementAnalyzer.this.analysis.setLimit((Node)node, rowCount);
            return node.isWithTies();
        }

        private boolean analyzeLimit(Limit node, Scope scope) {
            OptionalLong rowCount;
            if (node.getRowCount() instanceof AllRows) {
                rowCount = OptionalLong.empty();
            } else if (node.getRowCount() instanceof LongLiteral) {
                rowCount = OptionalLong.of(((LongLiteral)node.getRowCount()).getParsedValue());
            } else {
                Preconditions.checkState((boolean)(node.getRowCount() instanceof Parameter), (Object)("unexpected LIMIT rowCount: " + node.getRowCount().getClass().getSimpleName()));
                rowCount = this.analyzeParameterAsRowCount((Parameter)node.getRowCount(), scope, "LIMIT");
            }
            rowCount.ifPresent(count -> {
                if (count < 0L) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)node, "LIMIT row count must be greater or equal to 0 (actual value: %s)", count);
                }
            });
            StatementAnalyzer.this.analysis.setLimit((Node)node, rowCount);
            return false;
        }

        private OptionalLong analyzeParameterAsRowCount(Parameter parameter, Scope scope, String context) {
            Object value;
            if (StatementAnalyzer.this.analysis.isDescribe()) {
                this.analyzeExpression((Expression)parameter, scope);
                StatementAnalyzer.this.analysis.addCoercion((Expression)parameter, (Type)BigintType.BIGINT);
                return OptionalLong.empty();
            }
            this.analyzeExpression((Expression)parameter, scope);
            Expression providedValue = StatementAnalyzer.this.analysis.getParameters().get(NodeRef.of((Node)parameter));
            try {
                value = ConstantEvaluator.evaluateConstant(providedValue, (Type)BigintType.BIGINT, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.session, StatementAnalyzer.this.accessControl);
            }
            catch (VerifyException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)parameter, "Non constant parameter value for %s: %s", context, providedValue);
            }
            if (value == null) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)parameter, "Parameter value provided for %s is NULL: %s", context, providedValue);
            }
            return OptionalLong.of((Long)value);
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope) {
            return this.createAndAssignScope(node, parentScope, Collections.emptyList());
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, Field ... fields) {
            return this.createAndAssignScope(node, parentScope, new RelationType(fields));
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, List<Field> fields) {
            return this.createAndAssignScope(node, parentScope, new RelationType(fields));
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, RelationType relationType) {
            Scope scope = this.scopeBuilder(parentScope).withRelationType(RelationId.of(node), relationType).build();
            StatementAnalyzer.this.analysis.setScope(node, scope);
            return scope;
        }

        private Scope createScope(Optional<Scope> parentScope) {
            return this.scopeBuilder(parentScope).build();
        }

        private Scope.Builder scopeBuilder(Optional<Scope> parentScope) {
            Scope.Builder scopeBuilder = Scope.builder();
            if (parentScope.isPresent()) {
                scopeBuilder.withParent(parentScope.get());
            } else {
                this.outerQueryScope.ifPresent(scopeBuilder::withOuterQueryParent);
            }
            return scopeBuilder;
        }

        private OutputColumn createOutputColumn(Field field) {
            return new OutputColumn(new Column(field.getName().orElseThrow(), field.getType().toString()), StatementAnalyzer.this.analysis.getSourceColumns(field));
        }

        private RedirectionAwareTableHandle getTableHandle(Table table, QualifiedObjectName name, Optional<Scope> scope) {
            if (table.getQueryPeriod().isPresent()) {
                Optional<TableVersion> startVersion = this.extractTableVersion(table, ((QueryPeriod)table.getQueryPeriod().get()).getStart(), scope);
                Optional<TableVersion> endVersion = this.extractTableVersion(table, ((QueryPeriod)table.getQueryPeriod().get()).getEnd(), scope);
                return StatementAnalyzer.this.metadata.getRedirectionAwareTableHandle(StatementAnalyzer.this.session, name, startVersion, endVersion);
            }
            return StatementAnalyzer.this.metadata.getRedirectionAwareTableHandle(StatementAnalyzer.this.session, name);
        }

        private Optional<TableVersion> extractTableVersion(Table table, Optional<Expression> version, Optional<Scope> scope) {
            Optional<TableVersion> tableVersion = Optional.empty();
            if (version.isEmpty()) {
                return tableVersion;
            }
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(version.get(), scope.get());
            StatementAnalyzer.this.analysis.recordSubqueries((Node)table, expressionAnalysis);
            Type versionType = expressionAnalysis.getType(version.get());
            PointerType pointerType = this.toPointerType(((QueryPeriod)table.getQueryPeriod().get()).getRangeType());
            if (versionType == UnknownType.UNKNOWN) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)table.getQueryPeriod().get(), "Pointer value cannot be NULL", new Object[0]);
            }
            Object evaluatedVersion = ConstantEvaluator.evaluateConstant(version.get(), versionType, StatementAnalyzer.this.plannerContext, StatementAnalyzer.this.session, StatementAnalyzer.this.accessControl);
            TableVersion extractedVersion = new TableVersion(pointerType, versionType, evaluatedVersion);
            this.validateVersionPointer((QueryPeriod)table.getQueryPeriod().get(), extractedVersion);
            return Optional.of(extractedVersion);
        }

        private void validateVersionPointer(QueryPeriod queryPeriod, TableVersion extractedVersion) {
            Type type = extractedVersion.objectType();
            Object pointer = extractedVersion.pointer();
            if (extractedVersion.pointerType() == PointerType.TEMPORAL) {
                if (!(type instanceof TimestampWithTimeZoneType || type instanceof TimestampType || type instanceof DateType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)queryPeriod, "Type %s invalid. Temporal pointers must be of type Timestamp, Timestamp with Time Zone, or Date.", type.getDisplayName());
                }
                if (pointer == null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)queryPeriod, "Pointer value cannot be NULL", new Object[0]);
                }
                Instant pointerInstant = this.getInstantWithRoundUp((LongTimestampWithTimeZone)this.coerce(type, pointer, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12)));
                if (!pointerInstant.isBefore(StatementAnalyzer.this.session.getStart())) {
                    String varchar = ((Slice)this.coerce(type, pointer, (Type)VarcharType.createUnboundedVarcharType())).toStringUtf8();
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)queryPeriod, "Pointer value '%s' is not in the past", varchar);
                }
            } else if (pointer == null) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)queryPeriod, "Pointer value cannot be NULL", new Object[0]);
            }
        }

        private Instant getInstantWithRoundUp(LongTimestampWithTimeZone value) {
            return Instant.ofEpochMilli(value.getEpochMillis()).plus((long)IntMath.divide((int)value.getPicosOfMilli(), (int)1000, (RoundingMode)RoundingMode.CEILING), ChronoUnit.NANOS);
        }

        private PointerType toPointerType(QueryPeriod.RangeType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case QueryPeriod.RangeType.TIMESTAMP -> PointerType.TEMPORAL;
                case QueryPeriod.RangeType.VERSION -> PointerType.TARGET_ID;
            };
        }

        private Object coerce(Type sourceType, Object value, Type targetType) {
            if (sourceType.equals((Object)targetType)) {
                return value;
            }
            ResolvedFunction coercion = StatementAnalyzer.this.metadata.getCoercion(sourceType, targetType);
            InterpretedFunctionInvoker functionInvoker = new InterpretedFunctionInvoker(StatementAnalyzer.this.plannerContext.getFunctionManager());
            return functionInvoker.invoke(coercion, StatementAnalyzer.this.session.toConnectorSession(), value);
        }

        private static /* synthetic */ void lambda$filterInaccessibleFields$121(ListMultimap tableFieldsMap, ImmutableSet.Builder accessibleFields, Field field) {
            Optional<QualifiedObjectName> originTable = field.getOriginTable();
            if (originTable.isPresent()) {
                tableFieldsMap.put((Object)originTable.get(), (Object)field);
            } else {
                accessibleFields.add((Object)field);
            }
        }

        private static /* synthetic */ OutputColumn lambda$visitUpdate$84(Map sourceColumnsByColumnName, ColumnSchema column) {
            return new OutputColumn(new Column(column.getName(), column.getType().toString()), (Set)sourceColumnsByColumnName.getOrDefault(column.getName(), ImmutableSet.of()));
        }

        private static /* synthetic */ boolean lambda$visitTableFunctionInvocation$33(Set requiredInputs, String input) {
            return !requiredInputs.contains(input);
        }

        private /* synthetic */ void lambda$visitTableFunctionInvocation$32(Set allInputs, TableFunctionInvocation node, Map tableArgumentsByName, String name, List columns) {
            if (!allInputs.contains(name)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Table function %s specifies required columns from table argument %s which cannot be found", node.getName(), name));
            }
            if (columns.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Table function %s specifies empty list of required columns from table argument %s", node.getName(), name));
            }
            Scope inputScope = StatementAnalyzer.this.analysis.getScope((Node)((Analysis.TableArgumentAnalysis)tableArgumentsByName.get(name)).getRelation());
            columns.stream().filter(column -> column < 0 || column >= inputScope.getRelationType().getVisibleFieldCount()).findFirst().ifPresent(column -> {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Invalid index: %s of required column from table argument %s", column, name));
            });
            columns.stream().map(inputScope.getRelationType()::getFieldByIndex).forEach(this::recordColumnAccess);
        }
    }

    private static final class ArgumentsAnalysis {
        private final Map<String, Argument> passedArguments;
        private final List<Analysis.TableArgumentAnalysis> tableArgumentAnalyses;

        public ArgumentsAnalysis(Map<String, Argument> passedArguments, List<Analysis.TableArgumentAnalysis> tableArgumentAnalyses) {
            this.passedArguments = ImmutableMap.copyOf(Objects.requireNonNull(passedArguments, "passedArguments is null"));
            this.tableArgumentAnalyses = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableArgumentAnalyses, "tableArgumentAnalyses is null"));
        }

        public Map<String, Argument> getPassedArguments() {
            return this.passedArguments;
        }

        public List<Analysis.TableArgumentAnalysis> getTableArgumentAnalyses() {
            return this.tableArgumentAnalyses;
        }
    }

    private static final class ArgumentAnalysis {
        private final Argument argument;
        private final Optional<Analysis.TableArgumentAnalysis> tableArgumentAnalysis;

        public ArgumentAnalysis(Argument argument, Optional<Analysis.TableArgumentAnalysis> tableArgumentAnalysis) {
            this.argument = Objects.requireNonNull(argument, "argument is null");
            this.tableArgumentAnalysis = Objects.requireNonNull(tableArgumentAnalysis, "tableArgumentAnalysis is null");
        }

        public Argument getArgument() {
            return this.argument;
        }

        public Optional<Analysis.TableArgumentAnalysis> getTableArgumentAnalysis() {
            return this.tableArgumentAnalysis;
        }
    }

    private static enum UpdateKind {
        DELETE,
        UPDATE,
        MERGE;

    }
}

