/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.List;

public class ArrayConstructorCodeGenerator
implements BytecodeGenerator {
    private final Type elementType;
    private final List<RowExpression> elements;

    public ArrayConstructorCodeGenerator(SpecialForm specialForm) {
        this.elementType = ((ArrayType)specialForm.type()).getElementType();
        this.elements = specialForm.arguments();
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext context) {
        CallSiteBinder binder = context.getCallSiteBinder();
        Scope scope = context.getScope();
        BytecodeBlock block = new BytecodeBlock().setDescription("Constructor for array(%s)".formatted(this.elementType));
        Variable blockBuilder = scope.createTempVariable(BlockBuilder.class);
        block.append((BytecodeNode)blockBuilder.set(SqlTypeBytecodeExpression.constantType(binder, this.elementType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)this.elements.size())})));
        Variable element = scope.createTempVariable(this.elementType.getJavaType());
        for (RowExpression item : this.elements) {
            block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
            block.append(context.generate(item));
            block.putVariable(element);
            block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)context.wasNull()).ifTrue((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, this.elementType).writeValue((BytecodeExpression)blockBuilder, (BytecodeExpression)element).pop()));
        }
        block.append((BytecodeNode)blockBuilder.invoke("build", Block.class, new BytecodeExpression[0]));
        block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
        return block;
    }
}

