/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

public record Array(Type elementType, List<Expression> elements) implements Expression
{
    public Array {
        Objects.requireNonNull(elementType, "type is null");
        elements = ImmutableList.copyOf(elements);
        for (Expression item : elements) {
            IrUtils.validateType(elementType, item);
        }
    }

    @Override
    public Type type() {
        return new ArrayType(this.elementType);
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitArray(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return this.elements;
    }
}

