/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

@JsonSerialize
public record Cast(Expression expression, Type type, boolean safe) implements Expression
{
    public Cast(Expression expression, Type type) {
        this(expression, type, false);
    }

    public Cast {
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(type, "type is null");
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitCast(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return ImmutableList.of((Object)this.expression);
    }

    @Override
    public String toString() {
        return "%sCast(%s, %s)".formatted(this.safe ? "Try" : "", this.expression, this.type);
    }
}

