/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import io.trino.sql.ir.Array;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Bind;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;

public abstract class DefaultTraversalVisitor<C>
extends IrVisitor<Void, C> {
    @Override
    protected Void visitArray(Array node, C context) {
        for (Expression element : node.elements()) {
            this.process(element, context);
        }
        return null;
    }

    @Override
    protected Void visitCast(Cast node, C context) {
        this.process(node.expression(), context);
        return null;
    }

    @Override
    protected Void visitBetween(Between node, C context) {
        this.process(node.value(), context);
        this.process(node.min(), context);
        this.process(node.max(), context);
        return null;
    }

    @Override
    protected Void visitCoalesce(Coalesce node, C context) {
        for (Expression operand : node.operands()) {
            this.process(operand, context);
        }
        return null;
    }

    @Override
    protected Void visitFieldReference(FieldReference node, C context) {
        this.process(node.base(), context);
        return null;
    }

    @Override
    protected Void visitComparison(Comparison node, C context) {
        this.process(node.left(), context);
        this.process(node.right(), context);
        return null;
    }

    @Override
    protected Void visitIn(In node, C context) {
        this.process(node.value(), context);
        for (Expression argument : node.valueList()) {
            this.process(argument, context);
        }
        return null;
    }

    @Override
    protected Void visitCall(Call node, C context) {
        for (Expression argument : node.arguments()) {
            this.process(argument, context);
        }
        return null;
    }

    @Override
    protected Void visitSwitch(Switch node, C context) {
        this.process(node.operand(), context);
        for (WhenClause clause : node.whenClauses()) {
            this.process(clause.getOperand(), context);
            this.process(clause.getResult(), context);
        }
        this.process(node.defaultValue(), context);
        return null;
    }

    @Override
    protected Void visitNullIf(NullIf node, C context) {
        this.process(node.first(), context);
        this.process(node.second(), context);
        return null;
    }

    @Override
    protected Void visitBind(Bind node, C context) {
        for (Expression value : node.values()) {
            this.process(value, context);
        }
        this.process(node.function(), context);
        return null;
    }

    @Override
    protected Void visitNot(Not node, C context) {
        this.process(node.value(), context);
        return null;
    }

    @Override
    protected Void visitCase(Case node, C context) {
        for (WhenClause clause : node.whenClauses()) {
            this.process(clause.getOperand(), context);
            this.process(clause.getResult(), context);
        }
        this.process(node.defaultValue(), context);
        return null;
    }

    @Override
    protected Void visitIsNull(IsNull node, C context) {
        this.process(node.value(), context);
        return null;
    }

    @Override
    protected Void visitLogical(Logical node, C context) {
        for (Expression child : node.terms()) {
            this.process(child, context);
        }
        return null;
    }

    @Override
    protected Void visitRow(Row node, C context) {
        for (Expression expression : node.items()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected Void visitLambda(Lambda node, C context) {
        this.process(node.body(), context);
        return null;
    }
}

