/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Bind;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.Symbol;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ExpressionFormatter {
    private static final CharMatcher UNAMBIGUOUS_REFERENCE_NAME_CHARACTERS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_$")).precomputed();

    private ExpressionFormatter() {
    }

    public static String formatExpression(Expression expression) {
        return (String)new Formatter(Optional.empty(), Optional.empty()).process(expression, null);
    }

    public static class Formatter
    extends IrVisitor<String, Void> {
        private final Optional<Function<Constant, String>> literalFormatter;
        private final Optional<Function<Reference, String>> symbolReferenceFormatter;

        public Formatter(Optional<Function<Constant, String>> literalFormatter, Optional<Function<Reference, String>> symbolReferenceFormatter) {
            this.literalFormatter = Objects.requireNonNull(literalFormatter, "literalFormatter is null");
            this.symbolReferenceFormatter = Objects.requireNonNull(symbolReferenceFormatter, "symbolReferenceFormatter is null");
        }

        @Override
        protected String visitArray(Array node, Void context) {
            return node.elements().stream().map(child -> (String)this.process((Expression)child, context)).collect(Collectors.joining(", ", "ARRAY[", "]"));
        }

        @Override
        protected String visitRow(Row node, Void context) {
            return node.items().stream().map(child -> (String)this.process((Expression)child, context)).collect(Collectors.joining(", ", "ROW (", ")"));
        }

        @Override
        protected String visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: %s.visit%s".formatted(this.getClass().getName(), node.getClass().getSimpleName()));
        }

        @Override
        protected String visitFieldReference(FieldReference node, Void context) {
            return ExpressionFormatter.formatExpression(node.base()) + "." + node.field();
        }

        @Override
        protected String visitConstant(Constant node, Void context) {
            return this.literalFormatter.map(formatter -> (String)formatter.apply(node)).orElseGet(() -> {
                if (node.value() == null) {
                    return "null::" + String.valueOf(node.type());
                }
                return String.valueOf(node.type()) + " '" + String.valueOf(node.type().getObjectValue(null, node.getValueAsBlock(), 0)) + "'";
            });
        }

        @Override
        protected String visitCall(Call node, Void context) {
            String name = GlobalFunctionCatalog.isBuiltinFunctionName(node.function().name()) ? node.function().name().getFunctionName() : node.function().name().toString();
            return name + "(" + this.joinExpressions(node.arguments()) + ")";
        }

        @Override
        protected String visitLambda(Lambda node, Void context) {
            return "(" + node.arguments().stream().map(Symbol::name).collect(Collectors.joining(", ")) + ") -> " + (String)this.process(node.body(), context);
        }

        @Override
        protected String visitReference(Reference node, Void context) {
            if (this.symbolReferenceFormatter.isPresent()) {
                return this.symbolReferenceFormatter.get().apply(node);
            }
            String name = node.name();
            if (UNAMBIGUOUS_REFERENCE_NAME_CHARACTERS.matchesAllOf((CharSequence)name)) {
                return name;
            }
            return "\"" + name.replace("\"", "\"\"") + "\"";
        }

        @Override
        protected String visitBind(Bind node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("\"$bind\"(");
            for (Expression value : node.values()) {
                builder.append((String)this.process(value, context)).append(", ");
            }
            builder.append((String)this.process(node.function(), context)).append(")");
            return builder.toString();
        }

        @Override
        protected String visitLogical(Logical node, Void context) {
            return "(" + node.terms().stream().map(term -> (String)this.process((Expression)term, context)).collect(Collectors.joining(" " + node.operator().toString() + " ")) + ")";
        }

        @Override
        protected String visitNot(Not node, Void context) {
            return "(NOT " + (String)this.process(node.value(), context) + ")";
        }

        @Override
        protected String visitComparison(Comparison node, Void context) {
            return this.formatBinaryExpression(node.operator().getValue(), node.left(), node.right());
        }

        @Override
        protected String visitIsNull(IsNull node, Void context) {
            return "(" + (String)this.process(node.value(), context) + " IS NULL)";
        }

        @Override
        protected String visitNullIf(NullIf node, Void context) {
            return "NULLIF(" + (String)this.process(node.first(), context) + ", " + (String)this.process(node.second(), context) + ")";
        }

        @Override
        protected String visitCoalesce(Coalesce node, Void context) {
            return "COALESCE(" + this.joinExpressions(node.operands()) + ")";
        }

        @Override
        public String visitCast(Cast node, Void context) {
            return (node.safe() ? "TRY_CAST" : "CAST") + "(" + (String)this.process(node.expression(), context) + " AS " + node.type().getDisplayName() + ")";
        }

        @Override
        protected String visitCase(Case node, Void context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE");
            for (WhenClause whenClause : node.whenClauses()) {
                parts.add((Object)this.format(whenClause, context));
            }
            parts.add((Object)"ELSE").add((Object)((String)this.process(node.defaultValue(), context)));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        protected String visitSwitch(Switch node, Void context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE").add((Object)((String)this.process(node.operand(), context)));
            for (WhenClause whenClause : node.whenClauses()) {
                parts.add((Object)this.format(whenClause, context));
            }
            parts.add((Object)"ELSE").add((Object)((String)this.process(node.defaultValue(), context)));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        protected String format(WhenClause node, Void context) {
            return "WHEN " + (String)this.process(node.getOperand(), context) + " THEN " + (String)this.process(node.getResult(), context);
        }

        @Override
        protected String visitBetween(Between node, Void context) {
            return "(" + (String)this.process(node.value(), context) + " BETWEEN " + (String)this.process(node.min(), context) + " AND " + (String)this.process(node.max(), context) + ")";
        }

        @Override
        protected String visitIn(In node, Void context) {
            return "(" + (String)this.process(node.value(), context) + " IN (" + this.joinExpressions(node.valueList()) + "))";
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right) {
            return "(" + (String)this.process(left, null) + " " + operator + " " + (String)this.process(right, null) + ")";
        }

        private String joinExpressions(List<Expression> expressions) {
            return expressions.stream().map(e -> (String)this.process((Expression)e, null)).collect(Collectors.joining(", "));
        }
    }
}

