/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.sql.DynamicFilters;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Bind;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.type.TypeCoercion;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;

public class IrExpressions {
    private IrExpressions() {
    }

    public static Expression ifExpression(Expression condition, Expression trueCase) {
        return new Case((List<WhenClause>)ImmutableList.of((Object)new WhenClause(condition, trueCase)), new Constant(trueCase.type(), null));
    }

    public static Expression ifExpression(Expression condition, Expression trueCase, Expression falseCase) {
        return new Case((List<WhenClause>)ImmutableList.of((Object)new WhenClause(condition, trueCase)), falseCase);
    }

    public static boolean mayFail(PlannerContext plannerContext, Expression expression) {
        Expression expression2 = expression;
        Objects.requireNonNull(expression2);
        Expression expression3 = expression2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Array.class, Between.class, Bind.class, Call.class, Case.class, Cast.class, Coalesce.class, Comparison.class, Constant.class, FieldReference.class, In.class, IsNull.class, Lambda.class, Logical.class, Not.class, NullIf.class, Reference.class, Row.class, Switch.class}, (Object)expression3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Array e = (Array)expression3;
                yield e.elements().stream().anyMatch(element -> IrExpressions.mayFail(plannerContext, element));
            }
            case 1 -> {
                Between e = (Between)expression3;
                if (IrExpressions.mayFail(plannerContext, e.value()) || IrExpressions.mayFail(plannerContext, e.min()) || IrExpressions.mayFail(plannerContext, e.max())) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                Bind e = (Bind)expression3;
                yield false;
            }
            case 3 -> {
                Call e = (Call)expression3;
                if (IrExpressions.mayFail(e.function()) || e.arguments().stream().anyMatch(argument -> IrExpressions.mayFail(plannerContext, argument))) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                Case e = (Case)expression3;
                if (e.whenClauses().stream().anyMatch(clause -> IrExpressions.mayFail(plannerContext, clause.getOperand()) || IrExpressions.mayFail(plannerContext, clause.getResult())) || IrExpressions.mayFail(plannerContext, e.defaultValue())) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                Cast e = (Cast)expression3;
                yield IrExpressions.mayFail(plannerContext, e);
            }
            case 6 -> {
                Coalesce e = (Coalesce)expression3;
                yield e.operands().stream().anyMatch(argument -> IrExpressions.mayFail(plannerContext, argument));
            }
            case 7 -> {
                Comparison e = (Comparison)expression3;
                if (IrExpressions.mayFail(plannerContext, e.left()) || IrExpressions.mayFail(plannerContext, e.right())) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                Constant e = (Constant)expression3;
                yield false;
            }
            case 9 -> {
                FieldReference e = (FieldReference)expression3;
                yield false;
            }
            case 10 -> {
                In e = (In)expression3;
                if (IrExpressions.mayFail(plannerContext, e.value()) || e.valueList().stream().anyMatch(argument -> IrExpressions.mayFail(plannerContext, argument))) {
                    yield true;
                }
                yield false;
            }
            case 11 -> {
                IsNull e = (IsNull)expression3;
                yield IrExpressions.mayFail(plannerContext, e.value());
            }
            case 12 -> {
                Lambda e = (Lambda)expression3;
                yield false;
            }
            case 13 -> {
                Logical e = (Logical)expression3;
                yield e.terms().stream().anyMatch(argument -> IrExpressions.mayFail(plannerContext, argument));
            }
            case 14 -> {
                Not e = (Not)expression3;
                yield IrExpressions.mayFail(plannerContext, e.value());
            }
            case 15 -> {
                NullIf e = (NullIf)expression3;
                if (IrExpressions.mayFail(plannerContext, e.first()) || IrExpressions.mayFail(plannerContext, e.second())) {
                    yield true;
                }
                yield false;
            }
            case 16 -> {
                Reference e = (Reference)expression3;
                yield false;
            }
            case 17 -> {
                Row e = (Row)expression3;
                yield e.items().stream().anyMatch(argument -> IrExpressions.mayFail(plannerContext, argument));
            }
            case 18 -> {
                Switch e = (Switch)expression3;
                yield IrExpressions.mayFail(plannerContext, e.operand()) || e.whenClauses().stream().anyMatch(clause -> IrExpressions.mayFail(plannerContext, clause.getOperand()) || IrExpressions.mayFail(plannerContext, clause.getResult())) || IrExpressions.mayFail(plannerContext, e.defaultValue());
            }
        };
    }

    private static boolean mayFail(PlannerContext plannerContext, Cast cast) {
        if (cast.safe()) {
            return false;
        }
        TypeCoercion coercions = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
        if (coercions.canCoerce(cast.expression().type(), cast.type())) {
            return false;
        }
        return !cast.type().equals((Object)VarcharType.VARCHAR);
    }

    private static boolean mayFail(ResolvedFunction function) {
        CatalogSchemaFunctionName name = function.name();
        return !name.equals((Object)GlobalFunctionCatalog.builtinFunctionName("length")) && !name.equals((Object)GlobalFunctionCatalog.builtinFunctionName("substring")) && !name.equals((Object)GlobalFunctionCatalog.builtinFunctionName("$like")) && !DynamicFilters.isDynamicFilterFunction(function.name());
    }
}

