/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonSerialize
public record Logical(Operator operator, List<Expression> terms) implements Expression
{
    public Logical {
        Objects.requireNonNull(operator, "operator is null");
        Preconditions.checkArgument((terms.size() >= 2 ? 1 : 0) != 0, (Object)"Expected at least 2 terms");
        for (Expression term : terms) {
            IrUtils.validateType((Type)BooleanType.BOOLEAN, term);
        }
        terms = ImmutableList.copyOf(terms);
    }

    @Override
    public Type type() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitLogical(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return this.terms;
    }

    public static Logical and(Expression left, Expression right) {
        return new Logical(Operator.AND, (List<Expression>)ImmutableList.of((Object)left, (Object)right));
    }

    public static Logical or(Expression left, Expression right) {
        return new Logical(Operator.OR, (List<Expression>)ImmutableList.of((Object)left, (Object)right));
    }

    @Override
    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = switch (this.operator.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "$and";
            case 1 -> "$or";
        };
        objectArray[1] = this.terms.stream().map((Function<Expression, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/trino/sql/ir/Expression;)Ljava/lang/String;)()).collect(Collectors.joining(", "));
        return "%s(%s)".formatted(objectArray);
    }

    public static enum Operator {
        AND,
        OR;


        public Operator flip() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> OR;
                case 1 -> AND;
            };
        }
    }
}

