/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import java.util.List;

@JsonSerialize
public record Not(Expression value) implements Expression
{
    public Not {
        IrUtils.validateType((Type)BooleanType.BOOLEAN, value);
    }

    @Override
    public Type type() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitNot(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public String toString() {
        return "$not(%s)".formatted(this.value);
    }
}

