/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.scalar.JsonPath;
import io.trino.plugin.base.expression.ConnectorExpressions;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.DynamicFilters;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.ResolvedFunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.tree.QualifiedName;
import io.trino.type.JoniRegexp;
import io.trino.type.JoniRegexpType;
import io.trino.type.JsonPathType;
import io.trino.type.LikePattern;
import io.trino.type.LikePatternType;
import io.trino.type.Re2JRegexp;
import io.trino.type.Re2JRegexpType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ConnectorExpressionTranslator {
    private ConnectorExpressionTranslator() {
    }

    public static Expression translate(Session session, ConnectorExpression expression, PlannerContext plannerContext, Map<String, Symbol> variableMappings) {
        return new ConnectorToSqlExpressionTranslator(session, plannerContext, variableMappings).translate(expression).orElseThrow(() -> new UnsupportedOperationException("Expression is not supported: " + expression.toString()));
    }

    public static Optional<ConnectorExpression> translate(Session session, Expression expression) {
        return (Optional)new SqlToConnectorExpressionTranslator(session).process(expression);
    }

    public static ConnectorExpressionTranslation translateConjuncts(Session session, Expression expression) {
        SqlToConnectorExpressionTranslator translator = new SqlToConnectorExpressionTranslator(session);
        List<Expression> conjuncts = IrUtils.extractConjuncts(expression);
        ArrayList<Expression> remaining = new ArrayList<Expression>();
        ArrayList<ConnectorExpression> converted = new ArrayList<ConnectorExpression>(conjuncts.size());
        for (Expression conjunct : conjuncts) {
            Optional connectorExpression = (Optional)translator.process(conjunct);
            if (connectorExpression.isPresent()) {
                converted.add((ConnectorExpression)connectorExpression.get());
                continue;
            }
            remaining.add(conjunct);
        }
        return new ConnectorExpressionTranslation(ConnectorExpressions.and(converted), IrUtils.combineConjuncts(remaining));
    }

    @VisibleForTesting
    static FunctionName functionNameForComparisonOperator(Comparison.Operator operator) {
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case Comparison.Operator.EQUAL -> StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME;
            case Comparison.Operator.NOT_EQUAL -> StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME;
            case Comparison.Operator.LESS_THAN -> StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME;
            case Comparison.Operator.LESS_THAN_OR_EQUAL -> StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME;
            case Comparison.Operator.GREATER_THAN -> StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME;
            case Comparison.Operator.GREATER_THAN_OR_EQUAL -> StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME;
            case Comparison.Operator.IS_DISTINCT_FROM -> StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME;
        };
    }

    private static class ConnectorToSqlExpressionTranslator {
        private final Session session;
        private final PlannerContext plannerContext;
        private final Map<String, Symbol> variableMappings;

        public ConnectorToSqlExpressionTranslator(Session session, PlannerContext plannerContext, Map<String, Symbol> variableMappings) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.variableMappings = Objects.requireNonNull(variableMappings, "variableMappings is null");
        }

        public Optional<Expression> translate(ConnectorExpression expression) {
            if (expression instanceof Variable) {
                Variable variable = (Variable)expression;
                String name = variable.getName();
                return Optional.of(this.variableMappings.get(name).toSymbolReference());
            }
            if (expression instanceof io.trino.spi.expression.Constant) {
                io.trino.spi.expression.Constant constant = (io.trino.spi.expression.Constant)expression;
                return Optional.of(new Constant(constant.getType(), constant.getValue()));
            }
            if (expression instanceof FieldDereference) {
                FieldDereference dereference = (FieldDereference)expression;
                return this.translate(dereference.getTarget()).map(base -> new FieldReference((Expression)base, dereference.getField()));
            }
            if (expression instanceof Call) {
                Call call = (Call)expression;
                return this.translateCall(call);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateCall(Call call) {
            Optional<Comparison.Operator> operator;
            if (call.getFunctionName().getCatalogSchema().isPresent()) {
                CatalogSchemaName catalogSchemaName = (CatalogSchemaName)call.getFunctionName().getCatalogSchema().get();
                Preconditions.checkArgument((!catalogSchemaName.getCatalogName().equals("system") ? 1 : 0) != 0, (Object)"System functions must not be fully qualified");
                ResolvedFunction resolved = this.plannerContext.getFunctionResolver().resolveFunction(this.session, QualifiedName.of((String)catalogSchemaName.getCatalogName(), (String[])new String[]{catalogSchemaName.getSchemaName(), call.getFunctionName().getName()}), TypeSignatureProvider.fromTypes((List)call.getArguments().stream().map(ConnectorExpression::getType).collect(ImmutableList.toImmutableList())), new AllowAllAccessControl());
                return this.translateCall(call.getFunctionName().getName(), resolved, call.getArguments());
            }
            if (StandardFunctions.AND_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return this.translateLogicalExpression(Logical.Operator.AND, call.getArguments());
            }
            if (StandardFunctions.OR_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return this.translateLogicalExpression(Logical.Operator.OR, call.getArguments());
            }
            if (StandardFunctions.NOT_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                Call innerCall;
                ConnectorExpression expression = (ConnectorExpression)Iterables.getOnlyElement((Iterable)call.getArguments());
                if (expression instanceof Call && (innerCall = (Call)expression).getFunctionName().equals((Object)StandardFunctions.IS_NULL_FUNCTION_NAME) && innerCall.getArguments().size() == 1) {
                    return this.translateIsNotNull((ConnectorExpression)innerCall.getArguments().get(0));
                }
                return this.translateNot(expression);
            }
            if (StandardFunctions.IS_NULL_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translateIsNull((ConnectorExpression)call.getArguments().get(0));
            }
            if (StandardFunctions.NULLIF_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 2) {
                return this.translateNullIf((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (StandardFunctions.CAST_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translateCast(call.getType(), (ConnectorExpression)call.getArguments().get(0));
            }
            if (call.getArguments().size() == 2 && (operator = this.comparisonOperatorForFunctionName(call.getFunctionName())).isPresent()) {
                return this.translateComparison(operator.get(), (ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (call.getArguments().size() == 2 && (operator = this.arithmeticBinaryOperatorForFunctionName(call.getFunctionName())).isPresent()) {
                return this.translateArithmeticBinary((OperatorType)operator.get(), (ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (StandardFunctions.NEGATE_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                ConnectorExpression argument = (ConnectorExpression)Iterables.getOnlyElement((Iterable)call.getArguments());
                ResolvedFunction function = this.plannerContext.getMetadata().resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)argument.getType()));
                return this.translate(argument).map(value -> new io.trino.sql.ir.Call(function, (List<Expression>)ImmutableList.of((Object)value)));
            }
            if (StandardFunctions.LIKE_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return switch (call.getArguments().size()) {
                    case 2 -> this.translateLike((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1), Optional.empty());
                    case 3 -> this.translateLike((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1), Optional.of((ConnectorExpression)call.getArguments().get(2)));
                    default -> Optional.empty();
                };
            }
            if (StandardFunctions.IN_PREDICATE_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 2) {
                return this.translateInPredicate((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            ResolvedFunction resolved = this.plannerContext.getMetadata().resolveBuiltinFunction(call.getFunctionName().getName(), TypeSignatureProvider.fromTypes((List)call.getArguments().stream().map(ConnectorExpression::getType).collect(ImmutableList.toImmutableList())));
            return this.translateCall(call.getFunctionName().getName(), resolved, call.getArguments());
        }

        private Optional<Expression> translateCall(String functionName, ResolvedFunction resolved, List<ConnectorExpression> arguments) {
            ResolvedFunctionCallBuilder builder = ResolvedFunctionCallBuilder.builder(resolved);
            for (int i = 0; i < arguments.size(); ++i) {
                ConnectorExpression argument = arguments.get(i);
                Type formalType = (Type)resolved.signature().getArgumentTypes().get(i);
                Type argumentType = argument.getType();
                Optional<Expression> translated = this.translate(argument);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                Expression expression = translated.get();
                if ((formalType == JoniRegexpType.JONI_REGEXP || formalType instanceof Re2JRegexpType || formalType instanceof JsonPathType) && argumentType instanceof VarcharType) {
                    expression = new Cast(expression, formalType);
                } else if (!argumentType.equals((Object)formalType)) {
                    throw new IllegalArgumentException("Unexpected type %s for argument %s of type %s of %s".formatted(argumentType, formalType, i, functionName));
                }
                builder.addArgument(expression);
            }
            return Optional.of(builder.build());
        }

        private Optional<Expression> translateIsNotNull(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (translatedArgument.isPresent()) {
                return Optional.of(new Not(new IsNull(translatedArgument.get())));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateIsNull(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (translatedArgument.isPresent()) {
                return Optional.of(new IsNull(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateNot(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (argument.getType().equals((Object)BooleanType.BOOLEAN) && translatedArgument.isPresent()) {
                return Optional.of(new Not(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateCast(Type type, ConnectorExpression expression) {
            Optional<Expression> translatedExpression = this.translate(expression);
            if (translatedExpression.isPresent()) {
                return Optional.of(new Cast(translatedExpression.get(), type));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateLogicalExpression(Logical.Operator operator, List<ConnectorExpression> arguments) {
            Optional<List<Expression>> translatedArguments = this.translateExpressions(arguments);
            return translatedArguments.map(expressions -> new Logical(operator, (List<Expression>)expressions));
        }

        private Optional<Expression> translateComparison(Comparison.Operator operator, ConnectorExpression left, ConnectorExpression right) {
            return this.translate(left).flatMap(leftTranslated -> this.translate(right).map(rightTranslated -> new Comparison(operator, (Expression)leftTranslated, (Expression)rightTranslated)));
        }

        private Optional<Expression> translateNullIf(ConnectorExpression first, ConnectorExpression second) {
            Optional<Expression> firstExpression = this.translate(first);
            Optional<Expression> secondExpression = this.translate(second);
            if (firstExpression.isPresent() && secondExpression.isPresent()) {
                return Optional.of(new NullIf(firstExpression.get(), secondExpression.get()));
            }
            return Optional.empty();
        }

        private Optional<Comparison.Operator> comparisonOperatorForFunctionName(FunctionName functionName) {
            if (StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(Comparison.Operator.EQUAL);
            }
            if (StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(Comparison.Operator.NOT_EQUAL);
            }
            if (StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(Comparison.Operator.LESS_THAN);
            }
            if (StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(Comparison.Operator.LESS_THAN_OR_EQUAL);
            }
            if (StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(Comparison.Operator.GREATER_THAN);
            }
            if (StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(Comparison.Operator.GREATER_THAN_OR_EQUAL);
            }
            if (StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(Comparison.Operator.IS_DISTINCT_FROM);
            }
            return Optional.empty();
        }

        private Optional<Expression> translateArithmeticBinary(OperatorType operator, ConnectorExpression left, ConnectorExpression right) {
            ResolvedFunction function = this.plannerContext.getMetadata().resolveOperator(operator, (List<? extends Type>)ImmutableList.of((Object)left.getType(), (Object)right.getType()));
            return this.translate(left).flatMap(leftTranslated -> this.translate(right).map(rightTranslated -> new io.trino.sql.ir.Call(function, (List<Expression>)ImmutableList.of((Object)leftTranslated, (Object)rightTranslated))));
        }

        private Optional<OperatorType> arithmeticBinaryOperatorForFunctionName(FunctionName functionName) {
            if (StandardFunctions.ADD_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(OperatorType.ADD);
            }
            if (StandardFunctions.SUBTRACT_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(OperatorType.SUBTRACT);
            }
            if (StandardFunctions.MULTIPLY_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(OperatorType.MULTIPLY);
            }
            if (StandardFunctions.DIVIDE_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(OperatorType.DIVIDE);
            }
            if (StandardFunctions.MODULUS_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(OperatorType.MODULUS);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateLike(ConnectorExpression value, ConnectorExpression pattern, Optional<ConnectorExpression> escape) {
            Optional<Expression> translatedValue = this.translate(value);
            Optional<Expression> translatedPattern = this.translate(pattern);
            if (translatedValue.isPresent() && translatedPattern.isPresent()) {
                io.trino.sql.ir.Call patternCall;
                if (escape.isPresent()) {
                    Optional<Expression> translatedEscape = this.translate(escape.get());
                    if (translatedEscape.isEmpty()) {
                        return Optional.empty();
                    }
                    patternCall = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like_pattern").addArgument((Type)VarcharType.VARCHAR, ConnectorToSqlExpressionTranslator.castIfNecessary(translatedPattern.get(), (Type)VarcharType.VARCHAR)).addArgument((Type)VarcharType.VARCHAR, ConnectorToSqlExpressionTranslator.castIfNecessary(translatedEscape.get(), (Type)VarcharType.VARCHAR)).build();
                } else {
                    patternCall = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like_pattern").addArgument((Type)VarcharType.VARCHAR, ConnectorToSqlExpressionTranslator.castIfNecessary(translatedPattern.get(), (Type)VarcharType.VARCHAR)).build();
                }
                io.trino.sql.ir.Call call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like").addArgument(value.getType(), translatedValue.get()).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)patternCall).build();
                return Optional.of(call);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateInPredicate(ConnectorExpression value, ConnectorExpression values) {
            Optional<Expression> translatedValue = this.translate(value);
            Optional<List<Expression>> translatedValues = this.extractExpressionsFromArrayCall(values);
            if (translatedValue.isPresent() && translatedValues.isPresent()) {
                return Optional.of(new In(translatedValue.get(), translatedValues.get()));
            }
            return Optional.empty();
        }

        protected Optional<List<Expression>> extractExpressionsFromArrayCall(ConnectorExpression expression) {
            if (!(expression instanceof Call)) {
                return Optional.empty();
            }
            Call call = (Call)expression;
            if (!call.getFunctionName().equals((Object)StandardFunctions.ARRAY_CONSTRUCTOR_FUNCTION_NAME)) {
                return Optional.empty();
            }
            return this.translateExpressions(call.getArguments());
        }

        protected Optional<List<Expression>> translateExpressions(List<ConnectorExpression> expressions) {
            ImmutableList.Builder translatedExpressions = ImmutableList.builderWithExpectedSize((int)expressions.size());
            for (ConnectorExpression expression : expressions) {
                Optional<Expression> translated = this.translate(expression);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                translatedExpressions.add((Object)translated.get());
            }
            return Optional.of(translatedExpressions.build());
        }

        private static Expression castIfNecessary(Expression expression, Type type) {
            if (expression.type().equals((Object)type)) {
                return expression;
            }
            return new Cast(expression, type);
        }
    }

    public static class SqlToConnectorExpressionTranslator
    extends IrVisitor<Optional<ConnectorExpression>, Void> {
        private final Session session;

        public SqlToConnectorExpressionTranslator(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        @Override
        protected Optional<ConnectorExpression> visitReference(Reference node, Void context) {
            return Optional.of(new Variable(node.name(), node.type()));
        }

        @Override
        protected Optional<ConnectorExpression> visitConstant(Constant node, Void context) {
            return Optional.of(this.constantFor(node.type(), node.value()));
        }

        @Override
        protected Optional<ConnectorExpression> visitLogical(Logical node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            ImmutableList.Builder arguments = ImmutableList.builderWithExpectedSize((int)node.terms().size());
            for (Expression argument : node.terms()) {
                Optional translated = (Optional)this.process(argument);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)translated.get()));
            }
            return switch (node.operator()) {
                default -> throw new MatchException(null, null);
                case Logical.Operator.AND -> Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, (List)arguments.build()));
                case Logical.Operator.OR -> Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.OR_FUNCTION_NAME, (List)arguments.build()));
            };
        }

        @Override
        protected Optional<ConnectorExpression> visitComparison(Comparison node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process(node.left())).flatMap(left -> ((Optional)this.process(node.right())).map(right -> new Call(node.type(), ConnectorExpressionTranslator.functionNameForComparisonOperator(node.operator()), (List)ImmutableList.of((Object)left, (Object)right))));
        }

        @Override
        protected Optional<ConnectorExpression> visitBetween(Between node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process(node.value())).flatMap(value -> ((Optional)this.process(node.min())).flatMap(min -> ((Optional)this.process(node.max())).map(max -> new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, (List)ImmutableList.of((Object)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)value, (Object)min)), (Object)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)value, (Object)max)))))));
        }

        protected Optional<ConnectorExpression> translateNegation(io.trino.sql.ir.Call node) {
            return ((Optional)this.process(node.arguments().getFirst())).map(value -> new Call(node.type(), StandardFunctions.NEGATE_FUNCTION_NAME, (List)ImmutableList.of((Object)value)));
        }

        @Override
        protected Optional<ConnectorExpression> visitCast(Cast node, Void context) {
            if (this.isSpecialType(node.type())) {
                return Optional.empty();
            }
            if (node.safe()) {
                return Optional.empty();
            }
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            Optional translatedExpression = (Optional)this.process(node.expression());
            if (translatedExpression.isPresent()) {
                return Optional.of(new Call(node.type(), StandardFunctions.CAST_FUNCTION_NAME, List.of((ConnectorExpression)translatedExpression.get())));
            }
            return Optional.empty();
        }

        @Override
        protected Optional<ConnectorExpression> visitCall(io.trino.sql.ir.Call node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            CatalogSchemaFunctionName functionName = node.function().name();
            Preconditions.checkArgument((!DynamicFilters.isDynamicFilterFunction(functionName) ? 1 : 0) != 0, (Object)"Dynamic filter has no meaning for a connector, it should not be translated into ConnectorExpression");
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("$like"))) {
                return this.translateLike(node);
            }
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(OperatorType.NEGATION))) {
                return this.translateNegation(node);
            }
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(OperatorType.ADD))) {
                return ((Optional)this.process(node.arguments().get(0))).flatMap(left -> ((Optional)this.process(node.arguments().get(1))).map(right -> new Call(node.type(), StandardFunctions.ADD_FUNCTION_NAME, (List)ImmutableList.of((Object)left, (Object)right))));
            }
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(OperatorType.SUBTRACT))) {
                return ((Optional)this.process(node.arguments().get(0))).flatMap(left -> ((Optional)this.process(node.arguments().get(1))).map(right -> new Call(node.type(), StandardFunctions.SUBTRACT_FUNCTION_NAME, (List)ImmutableList.of((Object)left, (Object)right))));
            }
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(OperatorType.MULTIPLY))) {
                return ((Optional)this.process(node.arguments().get(0))).flatMap(left -> ((Optional)this.process(node.arguments().get(1))).map(right -> new Call(node.type(), StandardFunctions.MULTIPLY_FUNCTION_NAME, (List)ImmutableList.of((Object)left, (Object)right))));
            }
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(OperatorType.DIVIDE))) {
                return ((Optional)this.process(node.arguments().get(0))).flatMap(left -> ((Optional)this.process(node.arguments().get(1))).map(right -> new Call(node.type(), StandardFunctions.DIVIDE_FUNCTION_NAME, (List)ImmutableList.of((Object)left, (Object)right))));
            }
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(OperatorType.MODULUS))) {
                return ((Optional)this.process(node.arguments().get(0))).flatMap(left -> ((Optional)this.process(node.arguments().get(1))).map(right -> new Call(node.type(), StandardFunctions.MODULUS_FUNCTION_NAME, (List)ImmutableList.of((Object)left, (Object)right))));
            }
            ImmutableList.Builder arguments = ImmutableList.builder();
            for (Expression argumentExpression : node.arguments()) {
                Optional argument = (Optional)this.process(argumentExpression);
                if (argument.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)argument.get()));
            }
            if (LanguageFunctionManager.isInlineFunction(functionName)) {
                return Optional.empty();
            }
            FunctionName name = GlobalFunctionCatalog.isBuiltinFunctionName(functionName) ? new FunctionName(functionName.getFunctionName()) : new FunctionName(Optional.of(new CatalogSchemaName(functionName.getCatalogName(), functionName.getSchemaName())), functionName.getFunctionName());
            return Optional.of(new Call(node.type(), name, (List)arguments.build()));
        }

        private Optional<ConnectorExpression> translateLike(io.trino.sql.ir.Call node) {
            io.trino.sql.ir.Call call;
            ImmutableList.Builder arguments = ImmutableList.builder();
            Optional value = (Optional)this.process(node.arguments().get(0));
            if (value.isEmpty()) {
                return Optional.empty();
            }
            arguments.add((Object)((ConnectorExpression)value.get()));
            Expression patternArgument = node.arguments().get(1);
            if (patternArgument instanceof Constant) {
                Constant constant = (Constant)patternArgument;
                LikePattern matcher = (LikePattern)constant.value();
                arguments.add((Object)new io.trino.spi.expression.Constant((Object)Slices.utf8Slice((String)matcher.getPattern()), (Type)VarcharType.createVarcharType((int)matcher.getPattern().length())));
                if (matcher.getEscape().isPresent()) {
                    arguments.add((Object)new io.trino.spi.expression.Constant((Object)Slices.utf8Slice((String)matcher.getEscape().get().toString()), (Type)VarcharType.createVarcharType((int)1)));
                }
            } else if (patternArgument instanceof io.trino.sql.ir.Call && (call = (io.trino.sql.ir.Call)patternArgument).function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("$like_pattern"))) {
                Optional translatedPattern = (Optional)this.process(call.arguments().get(0));
                if (translatedPattern.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)translatedPattern.get()));
                if (call.arguments().size() == 2) {
                    Optional translatedEscape = (Optional)this.process(call.arguments().get(1));
                    if (translatedEscape.isEmpty()) {
                        return Optional.empty();
                    }
                    arguments.add((Object)((ConnectorExpression)translatedEscape.get()));
                }
            } else {
                return Optional.empty();
            }
            return Optional.of(new Call(node.type(), StandardFunctions.LIKE_FUNCTION_NAME, (List)arguments.build()));
        }

        @Override
        protected Optional<ConnectorExpression> visitIsNull(IsNull node, Void context) {
            Optional translatedValue = (Optional)this.process(node.value());
            if (translatedValue.isPresent()) {
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IS_NULL_FUNCTION_NAME, (List)ImmutableList.of((Object)((ConnectorExpression)translatedValue.get()))));
            }
            return Optional.empty();
        }

        @Override
        protected Optional<ConnectorExpression> visitNot(Not node, Void context) {
            Optional translatedValue = (Optional)this.process(node.value());
            if (translatedValue.isPresent()) {
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of((ConnectorExpression)translatedValue.get())));
            }
            return Optional.empty();
        }

        private boolean isSpecialType(Type type) {
            return type.equals((Object)JoniRegexpType.JONI_REGEXP) || type instanceof Re2JRegexpType || type instanceof JsonPathType;
        }

        private ConnectorExpression constantFor(Type type, Object value) {
            if (type == JoniRegexpType.JONI_REGEXP) {
                Slice pattern = ((JoniRegexp)value).pattern();
                return new io.trino.spi.expression.Constant((Object)pattern, (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)pattern)));
            }
            if (type instanceof Re2JRegexpType) {
                Slice pattern = Slices.utf8Slice((String)((Re2JRegexp)value).pattern());
                return new io.trino.spi.expression.Constant((Object)pattern, (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)pattern)));
            }
            if (type instanceof JsonPathType) {
                Slice pattern = Slices.utf8Slice((String)((JsonPath)value).pattern());
                return new io.trino.spi.expression.Constant((Object)pattern, (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)pattern)));
            }
            return new io.trino.spi.expression.Constant(value, type);
        }

        @Override
        protected Optional<ConnectorExpression> visitNullIf(NullIf node, Void context) {
            Optional firstValue = (Optional)this.process(node.first());
            Optional secondValue = (Optional)this.process(node.second());
            if (firstValue.isPresent() && secondValue.isPresent()) {
                return Optional.of(new Call(node.type(), StandardFunctions.NULLIF_FUNCTION_NAME, (List)ImmutableList.of((Object)((ConnectorExpression)firstValue.get()), (Object)((ConnectorExpression)secondValue.get()))));
            }
            return Optional.empty();
        }

        @Override
        protected Optional<ConnectorExpression> visitFieldReference(FieldReference node, Void context) {
            if (!(node.base().type() instanceof RowType)) {
                return Optional.empty();
            }
            Optional translatedBase = (Optional)this.process(node.base());
            if (translatedBase.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new FieldDereference(node.type(), (ConnectorExpression)translatedBase.get(), node.field()));
        }

        @Override
        protected Optional<ConnectorExpression> visitIn(In node, Void context) {
            Optional valueExpression = (Optional)this.process(node.value());
            if (valueExpression.isEmpty()) {
                return Optional.empty();
            }
            ImmutableList.Builder values = ImmutableList.builderWithExpectedSize((int)node.valueList().size());
            for (Expression value : node.valueList()) {
                if (value == null) {
                    return Optional.empty();
                }
                Optional processedValue = (Optional)this.process(value);
                if (processedValue.isEmpty()) {
                    return Optional.empty();
                }
                values.add((Object)((ConnectorExpression)processedValue.get()));
            }
            Call arrayExpression = new Call((Type)new ArrayType(node.value().type()), StandardFunctions.ARRAY_CONSTRUCTOR_FUNCTION_NAME, (List)values.build());
            return Optional.of(new Call(node.type(), StandardFunctions.IN_PREDICATE_FUNCTION_NAME, List.of((ConnectorExpression)valueExpression.get(), arrayExpression)));
        }

        @Override
        protected Optional<ConnectorExpression> visitExpression(Expression node, Void context) {
            return Optional.empty();
        }
    }

    public record ConnectorExpressionTranslation(ConnectorExpression connectorExpression, Expression remainingExpression) {
        public ConnectorExpressionTranslation {
            Objects.requireNonNull(connectorExpression, "connectorExpression is null");
            Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        }
    }
}

