/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.sql.ir.Call;
import io.trino.sql.ir.DefaultTraversalVisitor;
import io.trino.sql.ir.Expression;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DeterminismEvaluator {
    private DeterminismEvaluator() {
    }

    public static boolean isDeterministic(Expression expression) {
        AtomicBoolean deterministic = new AtomicBoolean(true);
        new Visitor().process(expression, deterministic);
        return deterministic.get();
    }

    private static class Visitor
    extends DefaultTraversalVisitor<AtomicBoolean> {
        private Visitor() {
        }

        @Override
        protected Void visitCall(Call node, AtomicBoolean deterministic) {
            if (!node.function().deterministic()) {
                deterministic.set(false);
                return null;
            }
            return super.visitCall(node, deterministic);
        }
    }
}

