/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.DiscreteValues;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.Ranges;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.Symbol;
import io.trino.type.LikeFunctions;
import io.trino.type.LikePattern;
import io.trino.type.TypeCoercion;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandle;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class DomainTranslator {
    private DomainTranslator() {
    }

    public static Expression toPredicate(TupleDomain<Symbol> tupleDomain) {
        if (tupleDomain.isNone()) {
            return Booleans.FALSE;
        }
        Map domains = (Map)tupleDomain.getDomains().get();
        return domains.entrySet().stream().sorted(Comparator.comparing(e -> ((Symbol)e.getKey()).name())).map(entry -> DomainTranslator.toPredicate((Domain)entry.getValue(), ((Symbol)entry.getKey()).toSymbolReference())).collect(Collectors.collectingAndThen(ImmutableList.toImmutableList(), IrUtils::combineConjuncts));
    }

    private static Expression toPredicate(Domain domain, Reference reference) {
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? new IsNull(reference) : Booleans.FALSE;
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? Booleans.TRUE : new Not(new IsNull(reference));
        }
        ArrayList<Expression> disjuncts = new ArrayList<Expression>();
        if (domain.isNullAllowed()) {
            disjuncts.add(new IsNull(reference));
        }
        disjuncts.addAll((Collection)domain.getValues().getValuesProcessor().transform(ranges -> DomainTranslator.extractDisjuncts(domain.getType(), ranges, reference), discreteValues -> DomainTranslator.extractDisjuncts(domain.getType(), discreteValues, reference), allOrNone -> {
            throw new IllegalStateException("Case should not be reachable");
        }));
        return IrUtils.combineDisjunctsWithDefault(disjuncts, Booleans.TRUE);
    }

    private static Expression processRange(Type type, Range range, Reference reference) {
        if (range.isAll()) {
            return Booleans.TRUE;
        }
        if (DomainTranslator.isBetween(range)) {
            return new Between(reference, new Constant(type, range.getLowBoundedValue()), new Constant(type, range.getHighBoundedValue()));
        }
        ArrayList<Expression> rangeConjuncts = new ArrayList<Expression>();
        if (!range.isLowUnbounded()) {
            rangeConjuncts.add(new Comparison(range.isLowInclusive() ? Comparison.Operator.GREATER_THAN_OR_EQUAL : Comparison.Operator.GREATER_THAN, reference, new Constant(type, range.getLowBoundedValue())));
        }
        if (!range.isHighUnbounded()) {
            rangeConjuncts.add(new Comparison(range.isHighInclusive() ? Comparison.Operator.LESS_THAN_OR_EQUAL : Comparison.Operator.LESS_THAN, reference, new Constant(type, range.getHighBoundedValue())));
        }
        Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
        return IrUtils.combineConjuncts(rangeConjuncts);
    }

    private static Expression combineRangeWithExcludedPoints(Type type, Reference reference, Range range, List<Expression> excludedPoints) {
        if (excludedPoints.isEmpty()) {
            return DomainTranslator.processRange(type, range, reference);
        }
        Record excludedPointsExpression = new Not(new In(reference, excludedPoints));
        if (excludedPoints.size() == 1) {
            excludedPointsExpression = new Comparison(Comparison.Operator.NOT_EQUAL, reference, (Expression)Iterables.getOnlyElement(excludedPoints));
        }
        return IrUtils.combineConjuncts(new Expression[]{DomainTranslator.processRange(type, range, reference), excludedPointsExpression});
    }

    private static List<Expression> extractDisjuncts(Type type, Ranges ranges, Reference reference) {
        ArrayList<Expression> disjuncts = new ArrayList<Expression>();
        ArrayList<Expression> singleValues = new ArrayList<Expression>();
        List orderedRanges = ranges.getOrderedRanges();
        SortedRangeSet sortedRangeSet = SortedRangeSet.copyOf((Type)type, (List)orderedRanges);
        SortedRangeSet complement = sortedRangeSet.complement();
        List singleValueExclusionsList = complement.getOrderedRanges().stream().filter(Range::isSingleValue).collect(Collectors.toList());
        List originalUnionSingleValues = SortedRangeSet.copyOf((Type)type, singleValueExclusionsList).union((ValueSet)sortedRangeSet).getOrderedRanges();
        PeekingIterator singleValueExclusions = Iterators.peekingIterator(singleValueExclusionsList.iterator());
        if (type instanceof RealType || type instanceof DoubleType) {
            boolean originalRangeIsAll = orderedRanges.stream().anyMatch(Range::isAll);
            boolean coalescedRangeIsAll = originalUnionSingleValues.stream().anyMatch(Range::isAll);
            if (!originalRangeIsAll && coalescedRangeIsAll) {
                for (Range range : orderedRanges) {
                    disjuncts.add(DomainTranslator.processRange(type, range, reference));
                }
                return disjuncts;
            }
        }
        for (Range range : originalUnionSingleValues) {
            if (range.isSingleValue()) {
                singleValues.add(new Constant(type, range.getSingleValue()));
                continue;
            }
            ArrayList<Expression> singleValuesInRange = new ArrayList<Expression>();
            while (singleValueExclusions.hasNext() && range.contains((Range)singleValueExclusions.peek())) {
                singleValuesInRange.add(new Constant(type, ((Range)singleValueExclusions.next()).getSingleValue()));
            }
            if (!singleValuesInRange.isEmpty()) {
                disjuncts.add(DomainTranslator.combineRangeWithExcludedPoints(type, reference, range, singleValuesInRange));
                continue;
            }
            disjuncts.add(DomainTranslator.processRange(type, range, reference));
        }
        if (singleValues.size() == 1) {
            disjuncts.add(new Comparison(Comparison.Operator.EQUAL, reference, (Expression)Iterables.getOnlyElement(singleValues)));
        } else if (singleValues.size() > 1) {
            disjuncts.add(new In(reference, singleValues));
        }
        return disjuncts;
    }

    private static List<Expression> extractDisjuncts(Type type, DiscreteValues discreteValues, Reference reference) {
        List<Expression> values = discreteValues.getValues().stream().map(object -> new Constant(type, object)).collect(Collectors.toList());
        Preconditions.checkState((!values.isEmpty() ? 1 : 0) != 0);
        Record predicate = values.size() == 1 ? new Comparison(Comparison.Operator.EQUAL, reference, (Expression)Iterables.getOnlyElement(values)) : new In(reference, values);
        if (!discreteValues.isInclusive()) {
            predicate = new Not((Expression)((Object)predicate));
        }
        return ImmutableList.of((Object)predicate);
    }

    private static boolean isBetween(Range range) {
        return range.isLowInclusive() && range.isHighInclusive();
    }

    public static ExtractionResult getExtractionResult(PlannerContext plannerContext, Session session, Expression predicate) {
        return (ExtractionResult)new Visitor(plannerContext, session).process(predicate, false);
    }

    private static class Visitor
    extends IrVisitor<ExtractionResult, Boolean> {
        private final PlannerContext plannerContext;
        private final Session session;
        private final InterpretedFunctionInvoker functionInvoker;
        private final TypeCoercion typeCoercion;

        private Visitor(PlannerContext plannerContext, Session session) {
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
            this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
        }

        private static ValueSet complementIfNecessary(ValueSet valueSet, boolean complement) {
            return complement ? valueSet.complement() : valueSet;
        }

        private static Domain complementIfNecessary(Domain domain, boolean complement) {
            return complement ? domain.complement() : domain;
        }

        private static Expression complementIfNecessary(Expression expression, boolean complement) {
            return complement ? new Not(expression) : expression;
        }

        @Override
        protected ExtractionResult visitExpression(Expression node, Boolean complement) {
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.all(), Visitor.complementIfNecessary(node, (boolean)complement));
        }

        @Override
        protected ExtractionResult visitLogical(Logical node, Boolean complement) {
            List results = (List)node.terms().stream().map(term -> (ExtractionResult)this.process((Expression)term, complement)).collect(ImmutableList.toImmutableList());
            List tupleDomains = (List)results.stream().map(ExtractionResult::getTupleDomain).collect(ImmutableList.toImmutableList());
            List residuals = (List)results.stream().map(ExtractionResult::getRemainingExpression).collect(ImmutableList.toImmutableList());
            Logical.Operator operator = complement != false ? node.operator().flip() : node.operator();
            switch (operator) {
                case AND: {
                    return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.intersect((List)tupleDomains), IrUtils.combineConjuncts(residuals));
                }
                case OR: {
                    TupleDomain columnUnionedTupleDomain = TupleDomain.columnWiseUnion((List)tupleDomains);
                    Expression remainingExpression = Visitor.complementIfNecessary(node, (boolean)complement);
                    if (Set.copyOf(residuals).size() == 1 && DeterminismEvaluator.isDeterministic((Expression)residuals.get(0))) {
                        boolean matchingSingleSymbolDomains = (tupleDomains = tupleDomains.stream().filter(domain -> !domain.isNone()).collect(Collectors.toList())).stream().allMatch(domain -> ((Map)domain.getDomains().get()).size() == 1);
                        matchingSingleSymbolDomains = matchingSingleSymbolDomains && tupleDomains.stream().map(tupleDomain -> ((Map)tupleDomain.getDomains().get()).keySet()).distinct().count() == 1L;
                        boolean oneTermIsSuperSet = TupleDomain.maximal(tupleDomains).isPresent();
                        if (oneTermIsSuperSet) {
                            remainingExpression = (Expression)residuals.get(0);
                        } else if (matchingSingleSymbolDomains) {
                            boolean implicitlyAddedNaN;
                            Type type = ((Domain)Iterables.getOnlyElement(((Map)((TupleDomain)tupleDomains.get(0)).getDomains().get()).values())).getType();
                            boolean unionedDomainContainsNaN = columnUnionedTupleDomain.isAll() || columnUnionedTupleDomain.getDomains().isPresent() && ((Domain)Iterables.getOnlyElement(((Map)columnUnionedTupleDomain.getDomains().get()).values())).getValues().isAll();
                            boolean bl = implicitlyAddedNaN = (type instanceof RealType || type instanceof DoubleType) && tupleDomains.stream().noneMatch(TupleDomain::isAll) && unionedDomainContainsNaN;
                            if (!implicitlyAddedNaN) {
                                remainingExpression = (Expression)residuals.get(0);
                            }
                        }
                    }
                    return new ExtractionResult((TupleDomain<Symbol>)columnUnionedTupleDomain, remainingExpression);
                }
            }
            throw new AssertionError((Object)("Unknown operator: " + String.valueOf((Object)node.operator())));
        }

        @Override
        protected ExtractionResult visitNot(Not node, Boolean complement) {
            return (ExtractionResult)this.process(node.value(), complement == false);
        }

        @Override
        protected ExtractionResult visitReference(Reference node, Boolean complement) {
            if (node.type().equals((Object)BooleanType.BOOLEAN)) {
                Comparison newNode = new Comparison(Comparison.Operator.EQUAL, node, Booleans.TRUE);
                return this.visitComparison(newNode, complement);
            }
            return this.visitExpression((Expression)node, complement);
        }

        @Override
        protected ExtractionResult visitComparison(Comparison node, Boolean complement) {
            Optional<NormalizedSimpleComparison> optionalNormalized = this.toNormalizedSimpleComparison(node);
            if (optionalNormalized.isEmpty()) {
                return (ExtractionResult)super.visitComparison(node, complement);
            }
            NormalizedSimpleComparison normalized = optionalNormalized.get();
            Expression symbolExpression = normalized.getSymbolExpression();
            if (symbolExpression instanceof Reference) {
                Symbol symbol = Symbol.from(symbolExpression);
                NullableValue value = normalized.getValue();
                Type type = value.getType();
                return Visitor.createComparisonExtractionResult(normalized.getComparisonOperator(), symbol, type, value.getValue(), complement).orElseGet(() -> (ExtractionResult)super.visitComparison(node, complement));
            }
            if (symbolExpression instanceof Cast) {
                Optional<ExtractionResult> result;
                Cast castExpression = (Cast)symbolExpression;
                Type castSourceType = castExpression.expression().type();
                Type castTargetType = castExpression.type();
                if (castSourceType instanceof VarcharType && castTargetType == DateType.DATE && !castExpression.safe() && (result = this.createVarcharCastToDateComparisonExtractionResult(normalized, (VarcharType)castSourceType, complement, node)).isPresent()) {
                    return result.get();
                }
                if (!this.isImplicitCoercion(castExpression)) {
                    return (ExtractionResult)super.visitComparison(node, complement);
                }
                Optional<Expression> coercedExpression = this.coerceComparisonWithRounding(castSourceType, castExpression.expression(), normalized.getValue(), normalized.getComparisonOperator());
                if (coercedExpression.isPresent()) {
                    return (ExtractionResult)this.process(coercedExpression.get(), complement);
                }
                return (ExtractionResult)super.visitComparison(node, complement);
            }
            return (ExtractionResult)super.visitComparison(node, complement);
        }

        private Optional<NormalizedSimpleComparison> toNormalizedSimpleComparison(Comparison comparison) {
            Expression right;
            Expression left = comparison.left();
            if (left instanceof Constant == (right = comparison.right()) instanceof Constant) {
                return Optional.empty();
            }
            if (left instanceof Constant) {
                Constant constant = (Constant)left;
                return Optional.of(new NormalizedSimpleComparison(right, comparison.operator().flip(), new NullableValue(left.type(), constant.value())));
            }
            return Optional.of(new NormalizedSimpleComparison(left, comparison.operator(), new NullableValue(right.type(), ((Constant)right).value())));
        }

        private boolean isImplicitCoercion(Cast cast) {
            return this.typeCoercion.canCoerce(cast.expression().type(), cast.type());
        }

        private Optional<ExtractionResult> createVarcharCastToDateComparisonExtractionResult(NormalizedSimpleComparison comparison, VarcharType sourceType, boolean complement, Comparison originalExpression) {
            SortedRangeSet valueSet;
            Expression sourceExpression = ((Cast)comparison.getSymbolExpression()).expression();
            Comparison.Operator operator = comparison.getComparisonOperator();
            NullableValue value = comparison.getValue();
            if (complement || value.isNull()) {
                return Optional.empty();
            }
            if (!(sourceExpression instanceof Reference)) {
                return Optional.empty();
            }
            Symbol sourceSymbol = Symbol.from(sourceExpression);
            if (!sourceType.isUnbounded() && sourceType.getBoundedLength() < 10) {
                return Optional.empty();
            }
            LocalDate date = LocalDate.ofEpochDay((Long)value.getValue());
            if (date.getYear() < 1001 || date.getYear() > 9998) {
                return Optional.empty();
            }
            boolean nullAllowed = false;
            switch (operator) {
                case EQUAL: {
                    valueSet = Visitor.dateStringRanges(date, sourceType);
                    break;
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    if (date.getDayOfMonth() < 10) {
                        return Optional.empty();
                    }
                    valueSet = ValueSet.all((Type)sourceType).subtract((ValueSet)Visitor.dateStringRanges(date, sourceType));
                    nullAllowed = operator == Comparison.Operator.IS_DISTINCT_FROM;
                    break;
                }
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    valueSet = ValueSet.ofRanges((Range)Range.lessThan((Type)sourceType, (Object)Slices.utf8Slice((String)Integer.toString(date.getYear() + 1))), (Range[])new Range[0]);
                    break;
                }
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    valueSet = ValueSet.ofRanges((Range)Range.greaterThan((Type)sourceType, (Object)Slices.utf8Slice((String)Integer.toString(date.getYear() - 1))), (Range[])new Range[0]);
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            valueSet = valueSet.union(ValueSet.ofRanges((Range)Range.lessThan((Type)sourceType, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.greaterThan((Type)sourceType, (Object)Slices.utf8Slice((String)"9"))}));
            return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)sourceSymbol, (Object)Domain.create((ValueSet)valueSet, (boolean)nullAllowed))), originalExpression));
        }

        private static SortedRangeSet dateStringRanges(LocalDate date, VarcharType domainType) {
            Preconditions.checkArgument((date.getYear() >= 1000 && date.getYear() <= 9999 ? 1 : 0) != 0, (String)"Unsupported date: %s", (Object)date);
            int month = date.getMonthValue();
            int day = date.getDayOfMonth();
            boolean isMonthSingleDigit = date.getMonthValue() < 10;
            boolean isDaySingleDigit = date.getDayOfMonth() < 10;
            ArrayList<Range> valueRanges = new ArrayList<Range>(4);
            for (boolean useSingleDigitMonth : List.of(Boolean.valueOf(true), Boolean.valueOf(false))) {
                for (boolean useSingleDigitDay : List.of(Boolean.valueOf(true), Boolean.valueOf(false))) {
                    if (useSingleDigitMonth && !isMonthSingleDigit || useSingleDigitDay && !isDaySingleDigit) continue;
                    String dateString = date.getYear() + (!useSingleDigitMonth && isMonthSingleDigit ? "-0" : "-") + month + (!useSingleDigitDay && isDaySingleDigit ? "-0" : "-") + day;
                    String nextStringPrefix = dateString.substring(0, dateString.length() - 1) + (char)(dateString.charAt(dateString.length() - 1) + '\u0001');
                    Verify.verify((dateString.length() <= domainType.getLength().orElse(Integer.MAX_VALUE) ? 1 : 0) != 0, (String)"dateString length exceeds type bounds", (Object[])new Object[0]);
                    Verify.verify((dateString.length() == nextStringPrefix.length() ? 1 : 0) != 0, (String)"Next string length mismatch", (Object[])new Object[0]);
                    valueRanges.add(Range.range((Type)domainType, (Object)Slices.utf8Slice((String)dateString), (boolean)true, (Object)Slices.utf8Slice((String)nextStringPrefix), (boolean)false));
                }
            }
            return (SortedRangeSet)ValueSet.ofRanges(valueRanges);
        }

        private static Optional<ExtractionResult> createComparisonExtractionResult(Comparison.Operator comparisonOperator, Symbol column, Type type, @Nullable Object value, boolean complement) {
            if (value == null) {
                return switch (comparisonOperator) {
                    default -> throw new MatchException(null, null);
                    case Comparison.Operator.EQUAL, Comparison.Operator.NOT_EQUAL, Comparison.Operator.LESS_THAN, Comparison.Operator.LESS_THAN_OR_EQUAL, Comparison.Operator.GREATER_THAN, Comparison.Operator.GREATER_THAN_OR_EQUAL -> Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), Booleans.TRUE));
                    case Comparison.Operator.IS_DISTINCT_FROM -> {
                        Domain domain = Visitor.complementIfNecessary(Domain.notNull((Type)type), complement);
                        yield Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)), Booleans.TRUE));
                    }
                };
            }
            if (type.isOrderable()) {
                return Visitor.extractOrderableDomain(comparisonOperator, type, value, complement).map(domain -> new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)), Booleans.TRUE));
            }
            if (type.isComparable()) {
                Domain domain2 = Visitor.extractEquatableDomain(comparisonOperator, type, value, complement);
                return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain2)), Booleans.TRUE));
            }
            throw new AssertionError((Object)("Type cannot be used in a comparison expression (should have been caught in analysis): " + String.valueOf(type)));
        }

        private static Optional<Domain> extractOrderableDomain(Comparison.Operator comparisonOperator, Type type, Object value, boolean complement) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            if (!(type instanceof DoubleType) && !(type instanceof RealType)) {
                return switch (comparisonOperator) {
                    default -> throw new MatchException(null, null);
                    case Comparison.Operator.EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    case Comparison.Operator.GREATER_THAN -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    case Comparison.Operator.GREATER_THAN_OR_EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    case Comparison.Operator.LESS_THAN -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    case Comparison.Operator.LESS_THAN_OR_EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    case Comparison.Operator.NOT_EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)value)}), complement), (boolean)false));
                    case Comparison.Operator.IS_DISTINCT_FROM -> Optional.of(Visitor.complementIfNecessary(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)value)}), (boolean)true), complement));
                };
            }
            if (TypeUtils.isFloatingPointNaN((Type)type, (Object)value)) {
                return switch (comparisonOperator) {
                    default -> throw new MatchException(null, null);
                    case Comparison.Operator.EQUAL, Comparison.Operator.LESS_THAN, Comparison.Operator.LESS_THAN_OR_EQUAL, Comparison.Operator.GREATER_THAN, Comparison.Operator.GREATER_THAN_OR_EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.none((Type)type), complement), (boolean)false));
                    case Comparison.Operator.NOT_EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.all((Type)type), complement), (boolean)false));
                    case Comparison.Operator.IS_DISTINCT_FROM -> Optional.empty();
                };
            }
            return switch (comparisonOperator) {
                default -> throw new MatchException(null, null);
                case Comparison.Operator.EQUAL -> {
                    if (complement) {
                        yield Optional.empty();
                    }
                    yield Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case Comparison.Operator.GREATER_THAN -> {
                    if (complement) {
                        yield Optional.empty();
                    }
                    yield Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case Comparison.Operator.GREATER_THAN_OR_EQUAL -> {
                    if (complement) {
                        yield Optional.empty();
                    }
                    yield Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case Comparison.Operator.LESS_THAN -> {
                    if (complement) {
                        yield Optional.empty();
                    }
                    yield Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case Comparison.Operator.LESS_THAN_OR_EQUAL -> {
                    if (complement) {
                        yield Optional.empty();
                    }
                    yield Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case Comparison.Operator.NOT_EQUAL, Comparison.Operator.IS_DISTINCT_FROM -> complement ? Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false)) : Optional.empty();
            };
        }

        private static Domain extractEquatableDomain(Comparison.Operator comparisonOperator, Type type, Object value, boolean complement) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            return switch (comparisonOperator) {
                case Comparison.Operator.EQUAL -> Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]), complement), (boolean)false);
                case Comparison.Operator.NOT_EQUAL -> Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]).complement(), complement), (boolean)false);
                case Comparison.Operator.IS_DISTINCT_FROM -> Visitor.complementIfNecessary(Domain.create((ValueSet)ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]).complement(), (boolean)true), complement);
                default -> throw new IllegalArgumentException("Unhandled operator: " + String.valueOf((Object)comparisonOperator));
            };
        }

        private Optional<Expression> coerceComparisonWithRounding(Type symbolExpressionType, Expression symbolExpression, NullableValue nullableValue, Comparison.Operator comparisonOperator) {
            Optional<Object> floorValueOptional;
            Objects.requireNonNull(nullableValue, "nullableValue is null");
            if (nullableValue.isNull()) {
                return Optional.empty();
            }
            Type valueType = nullableValue.getType();
            Object value = nullableValue.getValue();
            try {
                floorValueOptional = this.floorValue(valueType, symbolExpressionType, value);
            }
            catch (TrinoException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode().equals((Object)errorCode)) {
                    return Optional.of(Booleans.FALSE);
                }
                throw e;
            }
            return floorValueOptional.map(floorValue -> this.rewriteComparisonExpression(symbolExpressionType, symbolExpression, valueType, value, floorValue, comparisonOperator));
        }

        private Expression rewriteComparisonExpression(Type symbolExpressionType, Expression symbolExpression, Type valueType, Object originalValue, Object coercedValue, Comparison.Operator comparisonOperator) {
            int originalComparedToCoerced = this.compareOriginalValueToCoerced(valueType, originalValue, symbolExpressionType, coercedValue);
            boolean coercedValueIsEqualToOriginal = originalComparedToCoerced == 0;
            boolean coercedValueIsLessThanOriginal = originalComparedToCoerced > 0;
            boolean coercedValueIsGreaterThanOriginal = originalComparedToCoerced < 0;
            Constant coercedLiteral = new Constant(symbolExpressionType, coercedValue);
            return switch (comparisonOperator) {
                default -> throw new MatchException(null, null);
                case Comparison.Operator.GREATER_THAN, Comparison.Operator.GREATER_THAN_OR_EQUAL -> {
                    if (coercedValueIsGreaterThanOriginal) {
                        yield new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsEqualToOriginal) {
                        yield new Comparison(comparisonOperator, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsLessThanOriginal) {
                        yield new Comparison(Comparison.Operator.GREATER_THAN, symbolExpression, coercedLiteral);
                    }
                    throw new AssertionError((Object)"Unreachable");
                }
                case Comparison.Operator.LESS_THAN, Comparison.Operator.LESS_THAN_OR_EQUAL -> {
                    if (coercedValueIsLessThanOriginal) {
                        yield new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsEqualToOriginal) {
                        yield new Comparison(comparisonOperator, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsGreaterThanOriginal) {
                        yield new Comparison(Comparison.Operator.LESS_THAN, symbolExpression, coercedLiteral);
                    }
                    throw new AssertionError((Object)"Unreachable");
                }
                case Comparison.Operator.EQUAL -> {
                    if (coercedValueIsEqualToOriginal) {
                        yield new Comparison(Comparison.Operator.EQUAL, symbolExpression, coercedLiteral);
                    }
                    yield IrUtils.and(new Comparison(Comparison.Operator.GREATER_THAN, symbolExpression, coercedLiteral), new Comparison(Comparison.Operator.LESS_THAN, symbolExpression, coercedLiteral));
                }
                case Comparison.Operator.NOT_EQUAL -> {
                    if (coercedValueIsEqualToOriginal) {
                        yield new Comparison(comparisonOperator, symbolExpression, coercedLiteral);
                    }
                    yield IrUtils.or(new Comparison(Comparison.Operator.EQUAL, symbolExpression, coercedLiteral), new Comparison(Comparison.Operator.NOT_EQUAL, symbolExpression, coercedLiteral));
                }
                case Comparison.Operator.IS_DISTINCT_FROM -> coercedValueIsEqualToOriginal ? new Comparison(comparisonOperator, symbolExpression, coercedLiteral) : Booleans.TRUE;
            };
        }

        private Optional<Object> floorValue(Type fromType, Type toType, Object value) {
            return this.getSaturatedFloorCastOperator(fromType, toType).map(operator -> this.functionInvoker.invoke((ResolvedFunction)operator, this.session.toConnectorSession(), value));
        }

        private Optional<ResolvedFunction> getSaturatedFloorCastOperator(Type fromType, Type toType) {
            try {
                return Optional.of(this.plannerContext.getMetadata().getCoercion(OperatorType.SATURATED_FLOOR_CAST, fromType, toType));
            }
            catch (OperatorNotFoundException e) {
                return Optional.empty();
            }
        }

        private int compareOriginalValueToCoerced(Type originalValueType, Object originalValue, Type coercedValueType, Object coercedValue) {
            Objects.requireNonNull(originalValueType, "originalValueType is null");
            Objects.requireNonNull(coercedValue, "coercedValue is null");
            ResolvedFunction castToOriginalTypeOperator = this.plannerContext.getMetadata().getCoercion(coercedValueType, originalValueType);
            Object coercedValueInOriginalType = this.functionInvoker.invoke(castToOriginalTypeOperator, this.session.toConnectorSession(), coercedValue);
            MethodHandle comparisonOperator = this.plannerContext.getTypeOperators().getComparisonUnorderedLastOperator(originalValueType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            try {
                return (int)comparisonOperator.invoke(originalValue, coercedValueInOriginalType);
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
            }
        }

        @Override
        protected ExtractionResult visitIn(In node, Boolean complement) {
            Preconditions.checkState((!node.valueList().isEmpty() ? 1 : 0) != 0, (Object)"InListExpression should never be empty");
            Optional<ExtractionResult> directExtractionResult = this.processSimpleInPredicate(node, complement);
            if (directExtractionResult.isPresent()) {
                return directExtractionResult.get();
            }
            ImmutableList.Builder disjuncts = ImmutableList.builder();
            for (Expression expression : node.valueList()) {
                disjuncts.add((Object)new Comparison(Comparison.Operator.EQUAL, node.value(), expression));
            }
            ExtractionResult extractionResult = (ExtractionResult)this.process(IrUtils.or((Collection<Expression>)disjuncts.build()), complement);
            if (extractionResult.tupleDomain.isAll()) {
                Record originalPredicate = node;
                if (complement.booleanValue()) {
                    originalPredicate = new Not((Expression)((Object)originalPredicate));
                }
                return new ExtractionResult(extractionResult.tupleDomain, (Expression)((Object)originalPredicate));
            }
            return extractionResult;
        }

        private Optional<ExtractionResult> processSimpleInPredicate(In node, Boolean complement) {
            if (!(node.value() instanceof Reference)) {
                return Optional.empty();
            }
            Symbol symbol = Symbol.from(node.value());
            Type type = node.value().type();
            ArrayList<Object> inValues = new ArrayList<Object>(node.valueList().size());
            ArrayList<Expression> excludedExpressions = new ArrayList<Expression>();
            for (Expression expression : node.valueList()) {
                if (expression instanceof Constant) {
                    Constant constant = (Constant)expression;
                    if (constant.value() == null) {
                        if (!complement.booleanValue()) continue;
                        return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), Booleans.TRUE));
                    }
                    if (type instanceof RealType || type instanceof DoubleType) {
                        if (TypeUtils.isFloatingPointNaN((Type)type, (Object)constant.value())) continue;
                        if (complement.booleanValue()) {
                            excludedExpressions.add(expression);
                            continue;
                        }
                        inValues.add(constant.value());
                        continue;
                    }
                    inValues.add(constant.value());
                    continue;
                }
                if (!complement.booleanValue()) {
                    return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.all(), node));
                }
                excludedExpressions.add(expression);
            }
            ValueSet valueSet = ValueSet.copyOf((Type)type, inValues);
            if (complement.booleanValue()) {
                valueSet = valueSet.complement();
            }
            TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)Domain.create((ValueSet)valueSet, (boolean)false)));
            Record remainingExpression = excludedExpressions.isEmpty() ? Booleans.TRUE : (excludedExpressions.size() == 1 ? new Not(new Comparison(Comparison.Operator.EQUAL, node.value(), (Expression)Iterables.getOnlyElement(excludedExpressions))) : new Not(new In(node.value(), excludedExpressions)));
            return Optional.of(new ExtractionResult((TupleDomain<Symbol>)tupleDomain, (Expression)((Object)remainingExpression)));
        }

        @Override
        protected ExtractionResult visitBetween(Between node, Boolean complement) {
            return (ExtractionResult)this.process(IrUtils.and(new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, node.value(), node.min()), new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, node.value(), node.max())), complement);
        }

        private Optional<ExtractionResult> tryVisitLikeFunction(Call node, Boolean complement) {
            Expression value = node.arguments().get(0);
            Expression patternArgument = node.arguments().get(1);
            if (!(value instanceof Reference)) {
                return Optional.empty();
            }
            Type type = value.type();
            if (!(type instanceof VarcharType)) {
                return Optional.empty();
            }
            VarcharType varcharType = (VarcharType)type;
            Symbol symbol = Symbol.from(value);
            if (node.arguments().size() > 2 || !(patternArgument instanceof Constant)) {
                return Optional.empty();
            }
            Constant patternConstant = (Constant)patternArgument;
            LikePattern matcher = (LikePattern)patternConstant.value();
            Slice pattern = Slices.utf8Slice((String)matcher.getPattern());
            Optional<Slice> escape = matcher.getEscape().map(character -> Slices.utf8Slice((String)character.toString()));
            int patternConstantPrefixBytes = LikeFunctions.patternConstantPrefixBytes(pattern, escape);
            if (patternConstantPrefixBytes == pattern.length()) {
                Slice literal = LikeFunctions.unescapeLiteralLikePattern(pattern, escape);
                ValueSet valueSet = varcharType.isUnbounded() || SliceUtf8.countCodePoints((Slice)literal) <= varcharType.getBoundedLength() ? ValueSet.of((Type)type, (Object)literal, (Object[])new Object[0]) : ValueSet.none((Type)type);
                Domain domain2 = Domain.create((ValueSet)Visitor.complementIfNecessary(valueSet, (boolean)complement), (boolean)false);
                return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain2)), Booleans.TRUE));
            }
            if (complement.booleanValue() || patternConstantPrefixBytes == 0) {
                return Optional.empty();
            }
            Slice constantPrefix = LikeFunctions.unescapeLiteralLikePattern(pattern.slice(0, patternConstantPrefixBytes), escape);
            return this.createRangeDomain(type, constantPrefix).map(domain -> new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), node));
        }

        @Override
        protected ExtractionResult visitCall(Call node, Boolean complement) {
            Optional<ExtractionResult> result;
            CatalogSchemaFunctionName name = node.function().name();
            if (name.equals((Object)GlobalFunctionCatalog.builtinFunctionName("starts_with"))) {
                Optional<ExtractionResult> result2 = this.tryVisitStartsWithFunction(node, complement);
                if (result2.isPresent()) {
                    return result2.get();
                }
            } else if (name.equals((Object)GlobalFunctionCatalog.builtinFunctionName("$like")) && (result = this.tryVisitLikeFunction(node, complement)).isPresent()) {
                return result.get();
            }
            return this.visitExpression((Expression)node, complement);
        }

        private Optional<ExtractionResult> tryVisitStartsWithFunction(Call node, Boolean complement) {
            Constant literal;
            List<Expression> args = node.arguments();
            if (args.size() != 2) {
                return Optional.empty();
            }
            Expression target = args.get(0);
            if (!(target instanceof Reference)) {
                return Optional.empty();
            }
            Expression prefix = args.get(1);
            if (!(prefix instanceof Constant) || !(literal = (Constant)prefix).type().equals((Object)VarcharType.VARCHAR)) {
                return Optional.empty();
            }
            Type type = target.type();
            if (!(type instanceof VarcharType)) {
                return Optional.empty();
            }
            if (complement.booleanValue()) {
                return Optional.empty();
            }
            Symbol symbol = Symbol.from(target);
            Slice constantPrefix = (Slice)((Constant)prefix).value();
            return this.createRangeDomain(type, constantPrefix).map(domain -> new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), node));
        }

        private Optional<Domain> createRangeDomain(Type type, Slice constantPrefix) {
            int lastIncrementable = -1;
            for (int position = 0; position < constantPrefix.length(); position += SliceUtf8.lengthOfCodePoint((Slice)constantPrefix, (int)position)) {
                if (SliceUtf8.getCodePointAt((Slice)constantPrefix, (int)position) >= 127) continue;
                lastIncrementable = position;
            }
            if (lastIncrementable == -1) {
                return Optional.empty();
            }
            Slice lowerBound = constantPrefix;
            Slice upperBound = constantPrefix.slice(0, lastIncrementable + SliceUtf8.lengthOfCodePoint((Slice)constantPrefix, (int)lastIncrementable)).copy();
            SliceUtf8.setCodePointAt((int)(SliceUtf8.getCodePointAt((Slice)constantPrefix, (int)lastIncrementable) + 1), (Slice)upperBound, (int)lastIncrementable);
            Domain domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)lowerBound, (boolean)true, (Object)upperBound, (boolean)false), (Range[])new Range[0]), (boolean)false);
            return Optional.of(domain);
        }

        @Override
        protected ExtractionResult visitIsNull(IsNull node, Boolean complement) {
            if (!(node.value() instanceof Reference)) {
                return (ExtractionResult)super.visitIsNull(node, complement);
            }
            Symbol symbol = Symbol.from(node.value());
            Type columnType = symbol.type();
            Domain domain = Visitor.complementIfNecessary(Domain.onlyNull((Type)columnType), (boolean)complement);
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), Booleans.TRUE);
        }

        @Override
        protected ExtractionResult visitConstant(Constant node, Boolean complement) {
            if (node.value() == null) {
                return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), Booleans.TRUE);
            }
            if (node.type().equals((Object)BooleanType.BOOLEAN)) {
                boolean value = (Boolean)node.value();
                value = complement != value;
                return new ExtractionResult((TupleDomain<Symbol>)(value ? TupleDomain.all() : TupleDomain.none()), Booleans.TRUE);
            }
            return (ExtractionResult)super.visitConstant(node, complement);
        }
    }

    public static class ExtractionResult {
        private final TupleDomain<Symbol> tupleDomain;
        private final Expression remainingExpression;

        public ExtractionResult(TupleDomain<Symbol> tupleDomain, Expression remainingExpression) {
            this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
            this.remainingExpression = Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        }

        public TupleDomain<Symbol> getTupleDomain() {
            return this.tupleDomain;
        }

        public Expression getRemainingExpression() {
            return this.remainingExpression;
        }
    }

    private static class NormalizedSimpleComparison {
        private final Expression symbolExpression;
        private final Comparison.Operator comparisonOperator;
        private final NullableValue value;

        public NormalizedSimpleComparison(Expression symbolExpression, Comparison.Operator comparisonOperator, NullableValue value) {
            this.symbolExpression = Objects.requireNonNull(symbolExpression, "symbolExpression is null");
            this.comparisonOperator = Objects.requireNonNull(comparisonOperator, "comparisonOperator is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public Expression getSymbolExpression() {
            return this.symbolExpression;
        }

        public Comparison.Operator getComparisonOperator() {
            return this.comparisonOperator;
        }

        public NullableValue getValue() {
            return this.value;
        }
    }
}

