/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.json.ir.IrJsonPath;
import io.trino.metadata.ResolvedFunction;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalParseResult;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.JsonPathTranslator;
import io.trino.sql.planner.QueryPlanner;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.Symbol;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentDate;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentTimestamp;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.LocalTime;
import io.trino.sql.tree.LocalTimestamp;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TryExpression;
import io.trino.type.FunctionType;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.IntervalYearMonthType;
import io.trino.type.JsonType;
import io.trino.type.LikePatternType;
import io.trino.type.UnknownType;
import io.trino.util.DateTimeUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TranslationMap {
    private final Scope scope;
    private final Analysis analysis;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments;
    private final Optional<TranslationMap> outerContext;
    private final Session session;
    private final PlannerContext plannerContext;
    private final Symbol[] fieldSymbols;
    private final Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> astToSymbols;
    private final Map<NodeRef<io.trino.sql.tree.Expression>, Symbol> substitutions;

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, List<Symbol> fieldSymbols, Session session, PlannerContext plannerContext) {
        this(outerContext, scope, analysis, lambdaArguments, (Symbol[])fieldSymbols.toArray(new Symbol[0]).clone(), (Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol>)ImmutableMap.of(), (Map<NodeRef<io.trino.sql.tree.Expression>, Symbol>)ImmutableMap.of(), session, plannerContext);
    }

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, List<Symbol> fieldSymbols, Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> astToSymbols, Session session, PlannerContext plannerContext) {
        this(outerContext, scope, analysis, lambdaArguments, fieldSymbols.toArray(new Symbol[0]), astToSymbols, (Map<NodeRef<io.trino.sql.tree.Expression>, Symbol>)ImmutableMap.of(), session, plannerContext);
    }

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, Symbol[] fieldSymbols, Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> astToSymbols, Map<NodeRef<io.trino.sql.tree.Expression>, Symbol> substitutions, Session session, PlannerContext plannerContext) {
        this.outerContext = Objects.requireNonNull(outerContext, "outerContext is null");
        this.scope = Objects.requireNonNull(scope, "scope is null");
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.lambdaArguments = Objects.requireNonNull(lambdaArguments, "lambdaArguments is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.substitutions = ImmutableMap.copyOf(substitutions);
        Objects.requireNonNull(fieldSymbols, "fieldSymbols is null");
        this.fieldSymbols = (Symbol[])fieldSymbols.clone();
        Objects.requireNonNull(astToSymbols, "astToSymbols is null");
        this.astToSymbols = ImmutableMap.copyOf(astToSymbols);
        Preconditions.checkArgument((scope.getLocalScopeFieldCount() == fieldSymbols.length ? 1 : 0) != 0, (String)"scope: %s, fields mappings: %s", (int)scope.getRelationType().getAllFieldCount(), (int)fieldSymbols.length);
    }

    public TranslationMap withScope(Scope scope, List<Symbol> fields) {
        return new TranslationMap(this.outerContext, scope, this.analysis, this.lambdaArguments, fields.toArray(new Symbol[0]), this.astToSymbols, this.substitutions, this.session, this.plannerContext);
    }

    public TranslationMap withNewMappings(Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> mappings, List<Symbol> fields) {
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.lambdaArguments, fields, mappings, this.session, this.plannerContext);
    }

    public TranslationMap withAdditionalMappings(Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> mappings) {
        HashMap<ScopeAware<io.trino.sql.tree.Expression>, Symbol> newMappings = new HashMap<ScopeAware<io.trino.sql.tree.Expression>, Symbol>();
        newMappings.putAll(this.astToSymbols);
        newMappings.putAll(mappings);
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.lambdaArguments, this.fieldSymbols, newMappings, this.substitutions, this.session, this.plannerContext);
    }

    public TranslationMap withAdditionalIdentityMappings(Map<NodeRef<io.trino.sql.tree.Expression>, Symbol> mappings) {
        HashMap<NodeRef<io.trino.sql.tree.Expression>, Symbol> newMappings = new HashMap<NodeRef<io.trino.sql.tree.Expression>, Symbol>();
        newMappings.putAll(this.substitutions);
        newMappings.putAll(mappings);
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.lambdaArguments, this.fieldSymbols, this.astToSymbols, newMappings, this.session, this.plannerContext);
    }

    public List<Symbol> getFieldSymbols() {
        return Collections.unmodifiableList(Arrays.asList(this.fieldSymbols));
    }

    public Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> getMappings() {
        return this.astToSymbols;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public boolean canTranslate(io.trino.sql.tree.Expression expression) {
        if (this.astToSymbols.containsKey(ScopeAware.scopeAwareKey(expression, this.analysis, this.scope)) || this.substitutions.containsKey(NodeRef.of((Node)expression)) || expression instanceof FieldReference) {
            return true;
        }
        if (this.analysis.isColumnReference(expression)) {
            ResolvedField field = this.analysis.getColumnReferenceFields().get(NodeRef.of((Node)expression));
            return this.scope.isLocalScope(field.getScope());
        }
        return false;
    }

    public Expression rewrite(io.trino.sql.tree.Expression root) {
        Verify.verify((boolean)this.analysis.isAnalyzed(root), (String)"Expression is not analyzed (%s): %s", (Object)root.getClass().getName(), (Object)root);
        return this.translate(root, true);
    }

    private Expression translateExpression(io.trino.sql.tree.Expression expression) {
        return this.translate(expression, false);
    }

    private Expression translate(io.trino.sql.tree.Expression expr, boolean isRoot) {
        Expression result;
        Optional<Reference> mapped = this.tryGetMapping(expr);
        if (mapped.isPresent()) {
            result = mapped.get();
        } else {
            io.trino.sql.tree.Expression expression = expr;
            Objects.requireNonNull(expression);
            io.trino.sql.tree.Expression expression2 = expression;
            int n = 0;
            result = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FieldReference.class, Identifier.class, FunctionCall.class, DereferenceExpression.class, io.trino.sql.tree.Array.class, CurrentCatalog.class, CurrentSchema.class, CurrentPath.class, CurrentUser.class, CurrentDate.class, CurrentTime.class, CurrentTimestamp.class, LocalTime.class, LocalTimestamp.class, Extract.class, AtTimeZone.class, Format.class, TryExpression.class, LikePredicate.class, Trim.class, SubscriptExpression.class, LambdaExpression.class, Parameter.class, JsonExists.class, JsonValue.class, JsonQuery.class, JsonObject.class, JsonArray.class, LongLiteral.class, DoubleLiteral.class, StringLiteral.class, BooleanLiteral.class, DecimalLiteral.class, GenericLiteral.class, BinaryLiteral.class, IntervalLiteral.class, ArithmeticBinaryExpression.class, ArithmeticUnaryExpression.class, ComparisonExpression.class, io.trino.sql.tree.Cast.class, io.trino.sql.tree.Row.class, NotExpression.class, LogicalExpression.class, NullLiteral.class, CoalesceExpression.class, IsNullPredicate.class, IsNotNullPredicate.class, BetweenPredicate.class, IfExpression.class, InPredicate.class, SimpleCaseExpression.class, SearchedCaseExpression.class, NullIfExpression.class}, (Object)expression2, n)) {
                case 0 -> {
                    FieldReference expression = (FieldReference)expression2;
                    yield this.translate(expression);
                }
                case 1 -> {
                    Identifier expression = (Identifier)expression2;
                    yield this.translate(expression);
                }
                case 2 -> {
                    FunctionCall expression = (FunctionCall)expression2;
                    yield this.translate(expression);
                }
                case 3 -> {
                    DereferenceExpression expression = (DereferenceExpression)expression2;
                    yield this.translate(expression);
                }
                case 4 -> {
                    io.trino.sql.tree.Array expression = (io.trino.sql.tree.Array)expression2;
                    yield this.translate(expression);
                }
                case 5 -> {
                    CurrentCatalog expression = (CurrentCatalog)expression2;
                    yield this.translate(expression);
                }
                case 6 -> {
                    CurrentSchema expression = (CurrentSchema)expression2;
                    yield this.translate(expression);
                }
                case 7 -> {
                    CurrentPath expression = (CurrentPath)expression2;
                    yield this.translate(expression);
                }
                case 8 -> {
                    CurrentUser expression = (CurrentUser)expression2;
                    yield this.translate(expression);
                }
                case 9 -> {
                    CurrentDate expression = (CurrentDate)expression2;
                    yield this.translate(expression);
                }
                case 10 -> {
                    CurrentTime expression = (CurrentTime)expression2;
                    yield this.translate(expression);
                }
                case 11 -> {
                    CurrentTimestamp expression = (CurrentTimestamp)expression2;
                    yield this.translate(expression);
                }
                case 12 -> {
                    LocalTime expression = (LocalTime)expression2;
                    yield this.translate(expression);
                }
                case 13 -> {
                    LocalTimestamp expression = (LocalTimestamp)expression2;
                    yield this.translate(expression);
                }
                case 14 -> {
                    Extract expression = (Extract)expression2;
                    yield this.translate(expression);
                }
                case 15 -> {
                    AtTimeZone expression = (AtTimeZone)expression2;
                    yield this.translate(expression);
                }
                case 16 -> {
                    Format expression = (Format)expression2;
                    yield this.translate(expression);
                }
                case 17 -> {
                    TryExpression expression = (TryExpression)expression2;
                    yield this.translate(expression);
                }
                case 18 -> {
                    LikePredicate expression = (LikePredicate)expression2;
                    yield this.translate(expression);
                }
                case 19 -> {
                    Trim expression = (Trim)expression2;
                    yield this.translate(expression);
                }
                case 20 -> {
                    SubscriptExpression expression = (SubscriptExpression)expression2;
                    yield this.translate(expression);
                }
                case 21 -> {
                    LambdaExpression expression = (LambdaExpression)expression2;
                    yield this.translate(expression);
                }
                case 22 -> {
                    Parameter expression = (Parameter)expression2;
                    yield this.translate(expression);
                }
                case 23 -> {
                    JsonExists expression = (JsonExists)expression2;
                    yield this.translate(expression);
                }
                case 24 -> {
                    JsonValue expression = (JsonValue)expression2;
                    yield this.translate(expression);
                }
                case 25 -> {
                    JsonQuery expression = (JsonQuery)expression2;
                    yield this.translate(expression);
                }
                case 26 -> {
                    JsonObject expression = (JsonObject)expression2;
                    yield this.translate(expression);
                }
                case 27 -> {
                    JsonArray expression = (JsonArray)expression2;
                    yield this.translate(expression);
                }
                case 28 -> {
                    LongLiteral expression = (LongLiteral)expression2;
                    yield this.translate(expression);
                }
                case 29 -> {
                    DoubleLiteral expression = (DoubleLiteral)expression2;
                    yield this.translate(expression);
                }
                case 30 -> {
                    StringLiteral expression = (StringLiteral)expression2;
                    yield this.translate(expression);
                }
                case 31 -> {
                    BooleanLiteral expression = (BooleanLiteral)expression2;
                    yield this.translate(expression);
                }
                case 32 -> {
                    DecimalLiteral expression = (DecimalLiteral)expression2;
                    yield this.translate(expression);
                }
                case 33 -> {
                    GenericLiteral expression = (GenericLiteral)expression2;
                    yield this.translate(expression);
                }
                case 34 -> {
                    BinaryLiteral expression = (BinaryLiteral)expression2;
                    yield this.translate(expression);
                }
                case 35 -> {
                    IntervalLiteral expression = (IntervalLiteral)expression2;
                    yield this.translate(expression);
                }
                case 36 -> {
                    ArithmeticBinaryExpression expression = (ArithmeticBinaryExpression)expression2;
                    yield this.translate(expression);
                }
                case 37 -> {
                    ArithmeticUnaryExpression expression = (ArithmeticUnaryExpression)expression2;
                    yield this.translate(expression);
                }
                case 38 -> {
                    ComparisonExpression expression = (ComparisonExpression)expression2;
                    yield this.translate(expression);
                }
                case 39 -> {
                    io.trino.sql.tree.Cast expression = (io.trino.sql.tree.Cast)expression2;
                    yield this.translate(expression);
                }
                case 40 -> {
                    io.trino.sql.tree.Row expression = (io.trino.sql.tree.Row)expression2;
                    yield this.translate(expression);
                }
                case 41 -> {
                    NotExpression expression = (NotExpression)expression2;
                    yield this.translate(expression);
                }
                case 42 -> {
                    LogicalExpression expression = (LogicalExpression)expression2;
                    yield this.translate(expression);
                }
                case 43 -> {
                    NullLiteral expression = (NullLiteral)expression2;
                    yield new Constant((Type)UnknownType.UNKNOWN, null);
                }
                case 44 -> {
                    CoalesceExpression expression = (CoalesceExpression)expression2;
                    yield this.translate(expression);
                }
                case 45 -> {
                    IsNullPredicate expression = (IsNullPredicate)expression2;
                    yield this.translate(expression);
                }
                case 46 -> {
                    IsNotNullPredicate expression = (IsNotNullPredicate)expression2;
                    yield this.translate(expression);
                }
                case 47 -> {
                    BetweenPredicate expression = (BetweenPredicate)expression2;
                    yield this.translate(expression);
                }
                case 48 -> {
                    IfExpression expression = (IfExpression)expression2;
                    yield this.translate(expression);
                }
                case 49 -> {
                    InPredicate expression = (InPredicate)expression2;
                    yield this.translate(expression);
                }
                case 50 -> {
                    SimpleCaseExpression expression = (SimpleCaseExpression)expression2;
                    yield this.translate(expression);
                }
                case 51 -> {
                    SearchedCaseExpression expression = (SearchedCaseExpression)expression2;
                    yield this.translate(expression);
                }
                case 52 -> {
                    NullIfExpression expression = (NullIfExpression)expression2;
                    yield this.translate(expression);
                }
                default -> throw new IllegalArgumentException("Unsupported expression (%s): %s".formatted(expr.getClass().getName(), expr));
            };
        }
        return isRoot ? result : QueryPlanner.coerceIfNecessary(this.analysis, expr, result);
    }

    private Expression translate(NullIfExpression expression) {
        return new NullIf(this.translateExpression(expression.getFirst()), this.translateExpression(expression.getSecond()));
    }

    private Expression translate(ArithmeticUnaryExpression expression) {
        return switch (expression.getSign()) {
            default -> throw new MatchException(null, null);
            case ArithmeticUnaryExpression.Sign.PLUS -> this.translateExpression(expression.getValue());
            case ArithmeticUnaryExpression.Sign.MINUS -> new Call(this.plannerContext.getMetadata().resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)this.analysis.getType(expression.getValue()))), (List<Expression>)ImmutableList.of((Object)this.translateExpression(expression.getValue())));
        };
    }

    private Expression translate(IntervalLiteral expression) {
        Type type;
        Type type2 = type = this.analysis.getType((io.trino.sql.tree.Expression)expression);
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return new Constant(type, switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntervalYearMonthType.class, IntervalDayTimeType.class}, (Object)type3, n)) {
            case 0 -> {
                IntervalYearMonthType t = (IntervalYearMonthType)type3;
                yield (long)expression.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(expression.getValue(), expression.getStartField(), expression.getEndField());
            }
            case 1 -> {
                IntervalDayTimeType t = (IntervalDayTimeType)type3;
                yield (long)expression.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(expression.getValue(), expression.getStartField(), expression.getEndField());
            }
            default -> throw new IllegalArgumentException("Unexpected type for IntervalLiteral: %s" + String.valueOf(type));
        });
    }

    private Expression translate(SearchedCaseExpression expression) {
        return new Case((List)expression.getWhenClauses().stream().map(clause -> new WhenClause(this.translateExpression(clause.getOperand()), this.translateExpression(clause.getResult()))).collect(ImmutableList.toImmutableList()), expression.getDefaultValue().map(this::translateExpression).orElse(new Constant(this.analysis.getType((io.trino.sql.tree.Expression)expression), null)));
    }

    private Expression translate(SimpleCaseExpression expression) {
        return new Switch(this.translateExpression(expression.getOperand()), (List)expression.getWhenClauses().stream().map(clause -> new WhenClause(this.translateExpression(clause.getOperand()), this.translateExpression(clause.getResult()))).collect(ImmutableList.toImmutableList()), expression.getDefaultValue().map(this::translateExpression).orElse(new Constant(this.analysis.getType((io.trino.sql.tree.Expression)expression), null)));
    }

    private Expression translate(InPredicate expression) {
        return new In(this.translateExpression(expression.getValue()), (List)((InListExpression)expression.getValueList()).getValues().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList()));
    }

    private Expression translate(IfExpression expression) {
        if (expression.getFalseValue().isPresent()) {
            return IrExpressions.ifExpression(this.translateExpression(expression.getCondition()), this.translateExpression(expression.getTrueValue()), this.translateExpression((io.trino.sql.tree.Expression)expression.getFalseValue().get()));
        }
        return IrExpressions.ifExpression(this.translateExpression(expression.getCondition()), this.translateExpression(expression.getTrueValue()));
    }

    private Expression translate(BinaryLiteral expression) {
        return new Constant(this.analysis.getType((io.trino.sql.tree.Expression)expression), Slices.wrappedBuffer((byte[])expression.getValue()));
    }

    private Expression translate(BetweenPredicate expression) {
        return new Between(this.translateExpression(expression.getValue()), this.translateExpression(expression.getMin()), this.translateExpression(expression.getMax()));
    }

    private Expression translate(IsNullPredicate expression) {
        return new IsNull(this.translateExpression(expression.getValue()));
    }

    private Expression translate(IsNotNullPredicate expression) {
        return new Not(new IsNull(this.translateExpression(expression.getValue())));
    }

    private Expression translate(CoalesceExpression expression) {
        return new Coalesce((List)expression.getOperands().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList()));
    }

    private Expression translate(GenericLiteral expression) {
        Type type = this.analysis.getType((io.trino.sql.tree.Expression)expression);
        if (type.equals((Object)JsonType.JSON)) {
            return new Constant(type, JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)expression.getValue())));
        }
        InterpretedFunctionInvoker functionInvoker = new InterpretedFunctionInvoker(this.plannerContext.getFunctionManager());
        ResolvedFunction resolvedFunction = this.plannerContext.getMetadata().getCoercion((Type)VarcharType.VARCHAR, type);
        Object value = functionInvoker.invoke(resolvedFunction, this.session.toConnectorSession(), (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)expression.getValue())));
        return new Constant(type, value);
    }

    private Expression translate(DecimalLiteral expression) {
        DecimalType type = (DecimalType)this.analysis.getType((io.trino.sql.tree.Expression)expression);
        DecimalParseResult parsed = Decimals.parse((String)expression.getValue());
        Preconditions.checkState((boolean)parsed.getType().equals((Object)type));
        return new Constant((Type)type, parsed.getObject());
    }

    private Expression translate(LogicalExpression expression) {
        return new Logical(switch (expression.getOperator()) {
            default -> throw new MatchException(null, null);
            case LogicalExpression.Operator.AND -> Logical.Operator.AND;
            case LogicalExpression.Operator.OR -> Logical.Operator.OR;
        }, (List)expression.getTerms().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList()));
    }

    private Expression translate(BooleanLiteral expression) {
        if (expression.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
            return Booleans.TRUE;
        }
        if (expression.equals((Object)BooleanLiteral.FALSE_LITERAL)) {
            return Booleans.FALSE;
        }
        throw new IllegalArgumentException("Unknown boolean literal: " + String.valueOf(expression));
    }

    private Expression translate(NotExpression expression) {
        return new Not(this.translateExpression(expression.getValue()));
    }

    private Expression translate(io.trino.sql.tree.Row expression) {
        return new Row((List)expression.getItems().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList()));
    }

    private Expression translate(ComparisonExpression expression) {
        return new Comparison(switch (expression.getOperator()) {
            default -> throw new MatchException(null, null);
            case ComparisonExpression.Operator.EQUAL -> Comparison.Operator.EQUAL;
            case ComparisonExpression.Operator.NOT_EQUAL -> Comparison.Operator.NOT_EQUAL;
            case ComparisonExpression.Operator.LESS_THAN -> Comparison.Operator.LESS_THAN;
            case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> Comparison.Operator.LESS_THAN_OR_EQUAL;
            case ComparisonExpression.Operator.GREATER_THAN -> Comparison.Operator.GREATER_THAN;
            case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> Comparison.Operator.GREATER_THAN_OR_EQUAL;
            case ComparisonExpression.Operator.IS_DISTINCT_FROM -> Comparison.Operator.IS_DISTINCT_FROM;
        }, this.translateExpression(expression.getLeft()), this.translateExpression(expression.getRight()));
    }

    private Expression translate(io.trino.sql.tree.Cast expression) {
        return new Cast(this.translateExpression(expression.getExpression()), this.analysis.getType((io.trino.sql.tree.Expression)expression), expression.isSafe());
    }

    private Expression translate(DoubleLiteral expression) {
        return new Constant((Type)DoubleType.DOUBLE, expression.getValue());
    }

    private Expression translate(ArithmeticBinaryExpression expression) {
        OperatorType operatorType = switch (expression.getOperator()) {
            default -> throw new MatchException(null, null);
            case ArithmeticBinaryExpression.Operator.ADD -> OperatorType.ADD;
            case ArithmeticBinaryExpression.Operator.SUBTRACT -> OperatorType.SUBTRACT;
            case ArithmeticBinaryExpression.Operator.MULTIPLY -> OperatorType.MULTIPLY;
            case ArithmeticBinaryExpression.Operator.DIVIDE -> OperatorType.DIVIDE;
            case ArithmeticBinaryExpression.Operator.MODULUS -> OperatorType.MODULUS;
        };
        return new Call(this.plannerContext.getMetadata().resolveOperator(operatorType, (List<? extends Type>)ImmutableList.of((Object)this.getCoercedType(expression.getLeft()), (Object)this.getCoercedType(expression.getRight()))), (List<Expression>)ImmutableList.of((Object)this.translateExpression(expression.getLeft()), (Object)this.translateExpression(expression.getRight())));
    }

    private Type getCoercedType(io.trino.sql.tree.Expression left) {
        Type leftType = this.analysis.getCoercion(left);
        if (leftType == null) {
            leftType = this.analysis.getType(left);
        }
        return leftType;
    }

    private Expression translate(StringLiteral expression) {
        return new Constant(this.analysis.getType((io.trino.sql.tree.Expression)expression), Slices.utf8Slice((String)expression.getValue()));
    }

    private Expression translate(LongLiteral expression) {
        return new Constant(this.analysis.getType((io.trino.sql.tree.Expression)expression), expression.getParsedValue());
    }

    private Expression translate(FieldReference expression) {
        return this.getSymbolForColumn((io.trino.sql.tree.Expression)expression).map(Symbol::toSymbolReference).orElseThrow(() -> new IllegalStateException(String.format("No symbol mapping for node '%s' (%s)", expression, expression.getFieldIndex())));
    }

    private Expression translate(Identifier expression) {
        LambdaArgumentDeclaration referencedLambdaArgumentDeclaration = this.analysis.getLambdaArgumentReference(expression);
        if (referencedLambdaArgumentDeclaration != null) {
            Symbol symbol = this.lambdaArguments.get(NodeRef.of((Node)referencedLambdaArgumentDeclaration));
            return symbol.toSymbolReference();
        }
        return this.getSymbolForColumn((io.trino.sql.tree.Expression)expression).map(Symbol::toSymbolReference).get();
    }

    private Expression translate(FunctionCall expression) {
        if (this.analysis.isPatternNavigationFunction(expression)) {
            return this.translate((io.trino.sql.tree.Expression)expression.getArguments().getFirst(), false);
        }
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)expression);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)expression);
        return new Call(resolvedFunction, (List)expression.getArguments().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList()));
    }

    private Expression translate(DereferenceExpression expression) {
        if (this.analysis.isColumnReference((io.trino.sql.tree.Expression)expression)) {
            return this.getSymbolForColumn((io.trino.sql.tree.Expression)expression).map(Symbol::toSymbolReference).orElseThrow(() -> new IllegalStateException(String.format("No mapping for %s", expression)));
        }
        RowType rowType = (RowType)this.analysis.getType(expression.getBase());
        String fieldName = ((Identifier)expression.getField().orElseThrow()).getValue();
        List fields = rowType.getFields();
        int index = -1;
        for (int i = 0; i < fields.size(); ++i) {
            RowType.Field field = (RowType.Field)fields.get(i);
            if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
            Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
            index = i;
        }
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)fieldName);
        return new io.trino.sql.ir.FieldReference(this.translateExpression(expression.getBase()), index);
    }

    private Expression translate(io.trino.sql.tree.Array expression) {
        List values = (List)expression.getValues().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList());
        Type type = this.analysis.getType((io.trino.sql.tree.Expression)expression);
        return new Array(((ArrayType)type).getElementType(), values);
    }

    private Expression translate(CurrentCatalog unused) {
        return new Call(this.plannerContext.getMetadata().resolveBuiltinFunction("$current_catalog", (List<TypeSignatureProvider>)ImmutableList.of()), (List<Expression>)ImmutableList.of());
    }

    private Expression translate(CurrentSchema unused) {
        return new Call(this.plannerContext.getMetadata().resolveBuiltinFunction("$current_schema", (List<TypeSignatureProvider>)ImmutableList.of()), (List<Expression>)ImmutableList.of());
    }

    private Expression translate(CurrentPath unused) {
        return new Call(this.plannerContext.getMetadata().resolveBuiltinFunction("$current_path", (List<TypeSignatureProvider>)ImmutableList.of()), (List<Expression>)ImmutableList.of());
    }

    private Expression translate(CurrentUser unused) {
        return new Call(this.plannerContext.getMetadata().resolveBuiltinFunction("$current_user", (List<TypeSignatureProvider>)ImmutableList.of()), (List<Expression>)ImmutableList.of());
    }

    private Expression translate(CurrentDate unused) {
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("current_date").build();
    }

    private Expression translate(CurrentTime node) {
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$current_time").setArguments((List<Type>)ImmutableList.of((Object)this.analysis.getType((io.trino.sql.tree.Expression)node)), (List<Expression>)ImmutableList.of((Object)new Constant(this.analysis.getType((io.trino.sql.tree.Expression)node), null))).build();
    }

    private Expression translate(CurrentTimestamp node) {
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$current_timestamp").setArguments((List<Type>)ImmutableList.of((Object)this.analysis.getType((io.trino.sql.tree.Expression)node)), (List<Expression>)ImmutableList.of((Object)new Constant(this.analysis.getType((io.trino.sql.tree.Expression)node), null))).build();
    }

    private Expression translate(LocalTime node) {
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$localtime").setArguments((List<Type>)ImmutableList.of((Object)this.analysis.getType((io.trino.sql.tree.Expression)node)), (List<Expression>)ImmutableList.of((Object)new Constant(this.analysis.getType((io.trino.sql.tree.Expression)node), null))).build();
    }

    private Expression translate(LocalTimestamp node) {
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$localtimestamp").setArguments((List<Type>)ImmutableList.of((Object)this.analysis.getType((io.trino.sql.tree.Expression)node)), (List<Expression>)ImmutableList.of((Object)new Constant(this.analysis.getType((io.trino.sql.tree.Expression)node), null))).build();
    }

    private Expression translate(Extract node) {
        Expression value = this.translateExpression(node.getExpression());
        Type type = this.analysis.getType(node.getExpression());
        return switch (node.getField()) {
            default -> throw new MatchException(null, null);
            case Extract.Field.YEAR -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("year").addArgument(type, value).build();
            case Extract.Field.QUARTER -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("quarter").addArgument(type, value).build();
            case Extract.Field.MONTH -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("month").addArgument(type, value).build();
            case Extract.Field.WEEK -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("week").addArgument(type, value).build();
            case Extract.Field.DAY, Extract.Field.DAY_OF_MONTH -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("day").addArgument(type, value).build();
            case Extract.Field.DAY_OF_WEEK, Extract.Field.DOW -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("day_of_week").addArgument(type, value).build();
            case Extract.Field.DAY_OF_YEAR, Extract.Field.DOY -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("day_of_year").addArgument(type, value).build();
            case Extract.Field.YEAR_OF_WEEK, Extract.Field.YOW -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("year_of_week").addArgument(type, value).build();
            case Extract.Field.HOUR -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("hour").addArgument(type, value).build();
            case Extract.Field.MINUTE -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("minute").addArgument(type, value).build();
            case Extract.Field.SECOND -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("second").addArgument(type, value).build();
            case Extract.Field.TIMEZONE_MINUTE -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("timezone_minute").addArgument(type, value).build();
            case Extract.Field.TIMEZONE_HOUR -> BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("timezone_hour").addArgument(type, value).build();
        };
    }

    private Expression translate(AtTimeZone node) {
        Call call;
        Type valueType = this.analysis.getType(node.getValue());
        Expression value = this.translateExpression(node.getValue());
        Type timeZoneType = this.analysis.getType(node.getTimeZone());
        Expression timeZone = this.translateExpression(node.getTimeZone());
        if (valueType instanceof TimeType) {
            TimeType type = (TimeType)valueType;
            call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$at_timezone").addArgument((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)type.getPrecision()), (Expression)new Cast(value, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)((TimeType)valueType).getPrecision()))).addArgument(timeZoneType, timeZone).build();
        } else if (valueType instanceof TimeWithTimeZoneType) {
            call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$at_timezone").addArgument(valueType, value).addArgument(timeZoneType, timeZone).build();
        } else if (valueType instanceof TimestampType) {
            TimestampType type = (TimestampType)valueType;
            call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("at_timezone").addArgument((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)type.getPrecision()), (Expression)new Cast(value, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)((TimestampType)valueType).getPrecision()))).addArgument(timeZoneType, timeZone).build();
        } else if (valueType instanceof TimestampWithTimeZoneType) {
            call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("at_timezone").addArgument(valueType, value).addArgument(timeZoneType, timeZone).build();
        } else {
            throw new IllegalArgumentException("Unexpected type: " + String.valueOf(valueType));
        }
        return call;
    }

    private Expression translate(Format node) {
        List arguments = (List)node.getArguments().stream().map(this::translateExpression).collect(ImmutableList.toImmutableList());
        List argumentTypes = (List)node.getArguments().stream().map(this.analysis::getType).collect(ImmutableList.toImmutableList());
        Call call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$format").addArgument((Type)VarcharType.VARCHAR, (Expression)new Cast((Expression)arguments.get(0), (Type)VarcharType.VARCHAR)).addArgument((Type)RowType.anonymous(argumentTypes.subList(1, arguments.size())), (Expression)new Row(arguments.subList(1, arguments.size()))).build();
        return call;
    }

    private Expression translate(TryExpression node) {
        Type type = this.analysis.getType((io.trino.sql.tree.Expression)node);
        Expression expression = this.translateExpression(node.getInnerExpression());
        return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$try").addArgument(new FunctionType((List<Type>)ImmutableList.of(), type), (Expression)new Lambda((List<Symbol>)ImmutableList.of(), expression)).build();
    }

    private Expression translate(LikePredicate node) {
        Expression value = this.translateExpression(node.getValue());
        Expression pattern = this.translateExpression(node.getPattern());
        Optional<Expression> escape = node.getEscape().map(this::translateExpression);
        Call patternCall = escape.isPresent() ? BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like_pattern").addArgument((Type)VarcharType.VARCHAR, (Expression)new Cast(pattern, (Type)VarcharType.VARCHAR)).addArgument((Type)VarcharType.VARCHAR, (Expression)new Cast(escape.get(), (Type)VarcharType.VARCHAR)).build() : BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like_pattern").addArgument((Type)VarcharType.VARCHAR, (Expression)new Cast(pattern, (Type)VarcharType.VARCHAR)).build();
        Call call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like").addArgument(value.type(), value).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)patternCall).build();
        return call;
    }

    private Expression translate(Trim node) {
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        ImmutableList.Builder arguments = ImmutableList.builder();
        arguments.add((Object)this.translateExpression(node.getTrimSource()));
        node.getTrimCharacter().map(this::translateExpression).ifPresent(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        return new Call(resolvedFunction, (List<Expression>)arguments.build());
    }

    private Expression translate(SubscriptExpression node) {
        Type baseType = this.analysis.getType(node.getBase());
        if (baseType instanceof RowType) {
            RowType rowType = (RowType)baseType;
            Expression rewrittenBase = this.translateExpression(node.getBase());
            LongLiteral index = (LongLiteral)node.getIndex();
            return new io.trino.sql.ir.FieldReference(rewrittenBase, Math.toIntExact(index.getParsedValue() - 1L));
        }
        ResolvedFunction operator = this.plannerContext.getMetadata().resolveOperator(OperatorType.SUBSCRIPT, (List<? extends Type>)ImmutableList.of((Object)this.getCoercedType(node.getBase()), (Object)this.getCoercedType(node.getIndex())));
        return new Call(operator, (List<Expression>)ImmutableList.of((Object)new Cast(this.translateExpression(node.getBase()), operator.signature().getArgumentType(0)), (Object)new Cast(this.translateExpression(node.getIndex()), operator.signature().getArgumentType(1))));
    }

    private Expression translate(LambdaExpression node) {
        Preconditions.checkState((this.analysis.getCoercion((io.trino.sql.tree.Expression)node) == null ? 1 : 0) != 0, (Object)"cannot coerce a lambda expression");
        ImmutableList.Builder newArguments = ImmutableList.builder();
        for (LambdaArgumentDeclaration argument : node.getArguments()) {
            newArguments.add((Object)this.lambdaArguments.get(NodeRef.of((Node)argument)));
        }
        Expression rewrittenBody = this.translateExpression(node.getBody());
        return new Lambda((List<Symbol>)newArguments.build(), rewrittenBody);
    }

    private Expression translate(Parameter node) {
        Preconditions.checkState((this.analysis.getParameters().size() > node.getId() ? 1 : 0) != 0, (Object)"Too few parameter values");
        return this.translateExpression(this.analysis.getParameters().get(NodeRef.of((Node)node)));
    }

    private Expression translate(JsonExists node) {
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        Constant failOnError = new Constant((Type)BooleanType.BOOLEAN, node.getErrorBehavior() == JsonExists.ErrorBehavior.ERROR);
        ResolvedFunction inputToJson = this.analysis.getJsonInputFunction(node.getJsonPathInvocation().getInputExpression());
        Call input = new Call(inputToJson, (List<Expression>)ImmutableList.of((Object)this.translateExpression(node.getJsonPathInvocation().getInputExpression()), (Object)failOnError));
        ParametersRow orderedParameters = this.getParametersRow(node.getJsonPathInvocation().getPathParameters(), node.getJsonPathInvocation().getPathParameters().stream().map(parameter -> this.translateExpression(parameter.getParameter())).toList(), resolvedFunction.signature().getArgumentType(2), failOnError);
        IrJsonPath path = new JsonPathTranslator(this.session, this.plannerContext).rewriteToIr(this.analysis.getJsonPathAnalysis((Node)node), orderedParameters.getParametersOrder());
        Constant pathExpression = new Constant(this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")), path);
        ImmutableList.Builder arguments = ImmutableList.builder().add((Object)input).add((Object)pathExpression).add((Object)orderedParameters.getParametersRow()).add((Object)new Constant((Type)TinyintType.TINYINT, node.getErrorBehavior().ordinal()));
        return new Call(resolvedFunction, (List<Expression>)arguments.build());
    }

    private Expression translate(JsonValue node) {
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        Constant failOnError = new Constant((Type)BooleanType.BOOLEAN, node.getErrorBehavior() == JsonValue.EmptyOrErrorBehavior.ERROR);
        ResolvedFunction inputToJson = this.analysis.getJsonInputFunction(node.getJsonPathInvocation().getInputExpression());
        Call input = new Call(inputToJson, (List<Expression>)ImmutableList.of((Object)this.translateExpression(node.getJsonPathInvocation().getInputExpression()), (Object)failOnError));
        ParametersRow orderedParameters = this.getParametersRow(node.getJsonPathInvocation().getPathParameters(), node.getJsonPathInvocation().getPathParameters().stream().map(parameter -> this.translateExpression(parameter.getParameter())).toList(), resolvedFunction.signature().getArgumentType(2), failOnError);
        IrJsonPath path = new JsonPathTranslator(this.session, this.plannerContext).rewriteToIr(this.analysis.getJsonPathAnalysis((Node)node), orderedParameters.getParametersOrder());
        Constant pathExpression = new Constant(this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")), path);
        ImmutableList.Builder arguments = ImmutableList.builder().add((Object)input).add((Object)pathExpression).add((Object)orderedParameters.getParametersRow()).add((Object)new Constant((Type)TinyintType.TINYINT, node.getEmptyBehavior().ordinal())).add((Object)node.getEmptyDefault().map(this::translateExpression).orElseGet(() -> new Constant(resolvedFunction.signature().getReturnType(), null))).add((Object)new Constant((Type)TinyintType.TINYINT, node.getErrorBehavior().ordinal())).add((Object)node.getErrorDefault().map(this::translateExpression).orElseGet(() -> new Constant(resolvedFunction.signature().getReturnType(), null)));
        return new Call(resolvedFunction, (List<Expression>)arguments.build());
    }

    private Expression translate(JsonQuery node) {
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        Constant failOnError = new Constant((Type)BooleanType.BOOLEAN, node.getErrorBehavior() == JsonQuery.EmptyOrErrorBehavior.ERROR);
        ResolvedFunction inputToJson = this.analysis.getJsonInputFunction(node.getJsonPathInvocation().getInputExpression());
        Call input = new Call(inputToJson, (List<Expression>)ImmutableList.of((Object)this.translateExpression(node.getJsonPathInvocation().getInputExpression()), (Object)failOnError));
        ParametersRow orderedParameters = this.getParametersRow(node.getJsonPathInvocation().getPathParameters(), node.getJsonPathInvocation().getPathParameters().stream().map(parameter -> this.translateExpression(parameter.getParameter())).toList(), resolvedFunction.signature().getArgumentType(2), failOnError);
        IrJsonPath path = new JsonPathTranslator(this.session, this.plannerContext).rewriteToIr(this.analysis.getJsonPathAnalysis((Node)node), orderedParameters.getParametersOrder());
        Constant pathExpression = new Constant(this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")), path);
        ImmutableList.Builder arguments = ImmutableList.builder().add((Object)input).add((Object)pathExpression).add((Object)orderedParameters.getParametersRow()).add((Object)new Constant((Type)TinyintType.TINYINT, node.getWrapperBehavior().ordinal())).add((Object)new Constant((Type)TinyintType.TINYINT, node.getEmptyBehavior().ordinal())).add((Object)new Constant((Type)TinyintType.TINYINT, node.getErrorBehavior().ordinal()));
        Call function = new Call(resolvedFunction, (List<Expression>)arguments.build());
        Constant errorBehavior = new Constant((Type)TinyintType.TINYINT, node.getErrorBehavior().ordinal());
        Constant omitQuotes = new Constant((Type)BooleanType.BOOLEAN, node.getQuotesBehavior().orElse(JsonQuery.QuotesBehavior.KEEP) == JsonQuery.QuotesBehavior.OMIT);
        ResolvedFunction outputFunction = this.analysis.getJsonOutputFunction((Node)node);
        Record result = new Call(outputFunction, (List<Expression>)ImmutableList.of((Object)function, (Object)errorBehavior, (Object)omitQuotes));
        Type returnedType = node.getReturnedType().map(TypeSignatureTranslator::toTypeSignature).map(arg_0 -> ((TypeManager)this.plannerContext.getTypeManager()).getType(arg_0)).orElse((Type)VarcharType.VARCHAR);
        Type resultType = outputFunction.signature().getReturnType();
        if (!resultType.equals((Object)returnedType)) {
            result = new Cast((Expression)((Object)result), returnedType);
        }
        return result;
    }

    private Expression translate(JsonObject node) {
        Record valuesRow;
        Record keysRow;
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        if (node.getMembers().isEmpty()) {
            Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)resolvedFunction.signature().getArgumentType(0)));
            Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)resolvedFunction.signature().getArgumentType(1)));
            keysRow = new Constant((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, null);
            valuesRow = new Constant((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, null);
        } else {
            ImmutableList.Builder keys = ImmutableList.builder();
            ImmutableList.Builder values = ImmutableList.builder();
            for (JsonObjectMember member : node.getMembers()) {
                io.trino.sql.tree.Expression value = member.getValue();
                Expression rewrittenKey = this.translateExpression(member.getKey());
                keys.add((Object)rewrittenKey);
                Expression rewrittenValue = this.translateExpression(value);
                ResolvedFunction valueToJson = this.analysis.getJsonInputFunction(value);
                if (valueToJson != null) {
                    values.add((Object)new Call(valueToJson, (List<Expression>)ImmutableList.of((Object)rewrittenValue, (Object)Booleans.TRUE)));
                    continue;
                }
                values.add((Object)rewrittenValue);
            }
            keysRow = new Row((List<Expression>)keys.build());
            valuesRow = new Row((List<Expression>)values.build());
        }
        ImmutableList arguments = ImmutableList.builder().add((Object)keysRow).add((Object)valuesRow).add((Object)(node.isNullOnNull() ? Booleans.TRUE : Booleans.FALSE)).add((Object)(node.isUniqueKeys() ? Booleans.TRUE : Booleans.FALSE)).build();
        Call function = new Call(resolvedFunction, (List<Expression>)arguments);
        ResolvedFunction outputFunction = this.analysis.getJsonOutputFunction((Node)node);
        Record result = new Call(outputFunction, (List<Expression>)ImmutableList.of((Object)function, (Object)new Constant((Type)TinyintType.TINYINT, JsonQuery.EmptyOrErrorBehavior.ERROR.ordinal()), (Object)Booleans.FALSE));
        Type returnedType = node.getReturnedType().map(TypeSignatureTranslator::toTypeSignature).map(arg_0 -> ((TypeManager)this.plannerContext.getTypeManager()).getType(arg_0)).orElse((Type)VarcharType.VARCHAR);
        Type resultType = outputFunction.signature().getReturnType();
        if (!resultType.equals((Object)returnedType)) {
            result = new Cast((Expression)((Object)result), returnedType);
        }
        return result;
    }

    private Expression translate(JsonArray node) {
        Record elementsRow;
        ResolvedFunction resolvedFunction = this.analysis.getResolvedFunction((Node)node);
        Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
        if (node.getElements().isEmpty()) {
            Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)resolvedFunction.signature().getArgumentType(0)));
            elementsRow = new Constant((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, null);
        } else {
            ImmutableList.Builder elements = ImmutableList.builder();
            for (JsonArrayElement arrayElement : node.getElements()) {
                io.trino.sql.tree.Expression element = arrayElement.getValue();
                Expression rewrittenElement = this.translateExpression(element);
                ResolvedFunction elementToJson = this.analysis.getJsonInputFunction(element);
                if (elementToJson != null) {
                    elements.add((Object)new Call(elementToJson, (List<Expression>)ImmutableList.of((Object)rewrittenElement, (Object)Booleans.TRUE)));
                    continue;
                }
                elements.add((Object)rewrittenElement);
            }
            elementsRow = new Row((List<Expression>)elements.build());
        }
        ImmutableList arguments = ImmutableList.builder().add((Object)elementsRow).add((Object)(node.isNullOnNull() ? Booleans.TRUE : Booleans.FALSE)).build();
        Call function = new Call(resolvedFunction, (List<Expression>)arguments);
        ResolvedFunction outputFunction = this.analysis.getJsonOutputFunction((Node)node);
        Record result = new Call(outputFunction, (List<Expression>)ImmutableList.of((Object)function, (Object)new Constant((Type)TinyintType.TINYINT, JsonQuery.EmptyOrErrorBehavior.ERROR.ordinal()), (Object)Booleans.FALSE));
        Type returnedType = node.getReturnedType().map(TypeSignatureTranslator::toTypeSignature).map(arg_0 -> ((TypeManager)this.plannerContext.getTypeManager()).getType(arg_0)).orElse((Type)VarcharType.VARCHAR);
        Type resultType = outputFunction.signature().getReturnType();
        if (!resultType.equals((Object)returnedType)) {
            result = new Cast((Expression)((Object)result), returnedType);
        }
        return result;
    }

    private Optional<Reference> tryGetMapping(io.trino.sql.tree.Expression expression) {
        Symbol symbol = this.substitutions.get(NodeRef.of((Node)expression));
        if (symbol == null) {
            symbol = this.astToSymbols.get(ScopeAware.scopeAwareKey(expression, this.analysis, this.scope));
        }
        return Optional.ofNullable(symbol).map(Symbol::toSymbolReference);
    }

    private Optional<Symbol> getSymbolForColumn(io.trino.sql.tree.Expression expression) {
        if (!this.analysis.isColumnReference(expression)) {
            return Optional.empty();
        }
        ResolvedField field = this.analysis.getColumnReferenceFields().get(NodeRef.of((Node)expression));
        if (this.scope.isLocalScope(field.getScope())) {
            return Optional.of(this.fieldSymbols[field.getHierarchyFieldIndex()]);
        }
        if (this.outerContext.isPresent()) {
            return Optional.of(Symbol.from(this.outerContext.get().rewrite(expression)));
        }
        return Optional.empty();
    }

    public Scope getScope() {
        return this.scope;
    }

    public ParametersRow getParametersRow(List<JsonPathParameter> pathParameters, List<Expression> rewrittenPathParameters, Type parameterRowType, Constant failOnError) {
        Object parametersOrder;
        Record parametersRow;
        if (!pathParameters.isEmpty()) {
            ImmutableList.Builder parameters = ImmutableList.builder();
            for (int i = 0; i < pathParameters.size(); ++i) {
                ResolvedFunction parameterToJson = this.analysis.getJsonInputFunction(pathParameters.get(i).getParameter());
                Expression rewrittenParameter = rewrittenPathParameters.get(i);
                if (parameterToJson != null) {
                    parameters.add((Object)new Call(parameterToJson, (List<Expression>)ImmutableList.of((Object)rewrittenParameter, (Object)failOnError)));
                    continue;
                }
                parameters.add((Object)rewrittenParameter);
            }
            parametersRow = new Cast(new Row((List<Expression>)parameters.build()), parameterRowType);
            parametersOrder = (List)pathParameters.stream().map(parameter -> parameter.getName().getCanonicalValue()).collect(ImmutableList.toImmutableList());
        } else {
            Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)parameterRowType), (Object)"invalid type of parameters row when no parameters are passed");
            parametersRow = new Constant((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, null);
            parametersOrder = ImmutableList.of();
        }
        return new ParametersRow((Expression)((Object)parametersRow), (List<String>)parametersOrder);
    }

    public static class ParametersRow {
        private final Expression parametersRow;
        private final List<String> parametersOrder;

        public ParametersRow(Expression parametersRow, List<String> parametersOrder) {
            this.parametersRow = Objects.requireNonNull(parametersRow, "parametersRow is null");
            this.parametersOrder = Objects.requireNonNull(parametersOrder, "parametersOrder is null");
        }

        public Expression getParametersRow() {
            return this.parametersRow;
        }

        public List<String> getParametersOrder() {
            return this.parametersOrder;
        }
    }
}

