/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.type.UnknownType;
import java.util.List;

public class PushCastIntoRow
extends ExpressionRewriteRuleSet {
    public PushCastIntoRow() {
        super((expression, context) -> ExpressionTreeRewriter.rewriteWith(new Rewriter(), expression, false));
    }

    private static class Rewriter
    extends ExpressionRewriter<Boolean> {
        private Rewriter() {
        }

        @Override
        public Expression rewriteCast(Cast node, Boolean inRowCast, ExpressionTreeRewriter<Boolean> treeRewriter) {
            Expression value;
            Type type = node.type();
            if (!(type instanceof RowType)) {
                return treeRewriter.defaultRewrite(node, false);
            }
            RowType type2 = (RowType)type;
            if ((inRowCast.booleanValue() || type2.getFields().stream().allMatch(field -> field.getName().isEmpty())) && (value = treeRewriter.rewrite(node.expression(), true)) instanceof Row) {
                Row row = (Row)value;
                ImmutableList.Builder items = ImmutableList.builder();
                for (int i = 0; i < row.items().size(); ++i) {
                    Expression item = row.items().get(i);
                    Type itemType = ((RowType.Field)type2.getFields().get(i)).getType();
                    if (!(itemType instanceof UnknownType)) {
                        item = new Cast(item, itemType, node.safe());
                    }
                    items.add((Object)item);
                }
                return new Row((List<Expression>)items.build());
            }
            return treeRewriter.defaultRewrite(node, true);
        }
    }
}

