/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import java.util.List;

public final class PushDownNegationsExpressionRewriter {
    public static Expression pushDownNegations(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(), expression);
    }

    private PushDownNegationsExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        @Override
        public Expression rewriteNot(Not node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Record child;
            Object predicates;
            Expression expression = node.value();
            if (expression instanceof Logical) {
                Logical child2 = (Logical)expression;
                predicates = IrUtils.extractPredicates(child2);
                List negatedPredicates = (List)predicates.stream().map(predicate -> treeRewriter.rewrite(new Not((Expression)predicate), context)).collect(ImmutableList.toImmutableList());
                return IrUtils.combinePredicates(child2.operator().flip(), negatedPredicates);
            }
            predicates = node.value();
            if (predicates instanceof Comparison && ((Comparison)(child = (Comparison)predicates)).operator() != Comparison.Operator.IS_DISTINCT_FROM) {
                Comparison.Operator operator = ((Comparison)child).operator();
                Expression left = ((Comparison)child).left();
                Expression right = ((Comparison)child).right();
                Type leftType = left.type();
                Type rightType = right.type();
                if ((this.typeHasNaN(leftType) || this.typeHasNaN(rightType)) && (operator == Comparison.Operator.GREATER_THAN_OR_EQUAL || operator == Comparison.Operator.GREATER_THAN || operator == Comparison.Operator.LESS_THAN_OR_EQUAL || operator == Comparison.Operator.LESS_THAN)) {
                    return new Not(new Comparison(operator, treeRewriter.rewrite(left, context), treeRewriter.rewrite(right, context)));
                }
                return new Comparison(operator.negate(), treeRewriter.rewrite(left, context), treeRewriter.rewrite(right, context));
            }
            expression = node.value();
            if (expression instanceof Not) {
                child = (Not)expression;
                return treeRewriter.rewrite(((Not)child).value(), context);
            }
            return new Not(treeRewriter.rewrite(node.value(), context));
        }

        private boolean typeHasNaN(Type type) {
            return type instanceof DoubleType || type instanceof RealType;
        }
    }
}

