/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.PlanNodeDecorrelator;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformExistsApplyToCorrelatedJoin
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode();
    private final PlannerContext plannerContext;

    public TransformExistsApplyToCorrelatedJoin(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode parent, Captures captures, Rule.Context context) {
        if (parent.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        ApplyNode.SetExpression expression = (ApplyNode.SetExpression)Iterables.getOnlyElement(parent.getSubqueryAssignments().values());
        if (!(expression instanceof ApplyNode.Exists)) {
            return Rule.Result.empty();
        }
        if (parent.getCorrelation().isEmpty()) {
            return Rule.Result.ofPlanNode(this.rewriteToDefaultAggregation(parent, context));
        }
        Optional<PlanNode> nonDefaultAggregation = this.rewriteToNonDefaultAggregation(parent, context);
        return nonDefaultAggregation.map(Rule.Result::ofPlanNode).orElseGet(() -> Rule.Result.ofPlanNode(this.rewriteToDefaultAggregation(parent, context)));
    }

    private Optional<PlanNode> rewriteToNonDefaultAggregation(ApplyNode applyNode, Rule.Context context) {
        Preconditions.checkState((boolean)applyNode.getSubquery().getOutputSymbols().isEmpty(), (Object)"Expected subquery output symbols to be pruned");
        Symbol subqueryTrue = context.getSymbolAllocator().newSymbol("subqueryTrue", (Type)BooleanType.BOOLEAN);
        ProjectNode subquery = new ProjectNode(context.getIdAllocator().getNextId(), new LimitNode(context.getIdAllocator().getNextId(), applyNode.getSubquery(), 1L, false), Assignments.of(subqueryTrue, Booleans.TRUE));
        PlanNodeDecorrelator decorrelator = new PlanNodeDecorrelator(this.plannerContext, context.getSymbolAllocator(), context.getLookup());
        if (decorrelator.decorrelateFilters(subquery, applyNode.getCorrelation()).isEmpty()) {
            return Optional.empty();
        }
        Symbol exists = (Symbol)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().keySet());
        Assignments.Builder assignments = Assignments.builder().putIdentities(applyNode.getInput().getOutputSymbols()).put(exists, new Coalesce((List<Expression>)ImmutableList.of((Object)subqueryTrue.toSymbolReference(), (Object)Booleans.FALSE)));
        return Optional.of(new ProjectNode(context.getIdAllocator().getNextId(), new CorrelatedJoinNode(applyNode.getId(), applyNode.getInput(), subquery, applyNode.getCorrelation(), JoinType.LEFT, Booleans.TRUE, applyNode.getOriginSubquery()), assignments.build()));
    }

    private PlanNode rewriteToDefaultAggregation(ApplyNode applyNode, Rule.Context context) {
        ResolvedFunction countFunction = this.plannerContext.getMetadata().resolveBuiltinFunction("count", (List<TypeSignatureProvider>)ImmutableList.of());
        Symbol count = context.getSymbolAllocator().newSymbol("count", (Type)BigintType.BIGINT);
        Symbol exists = (Symbol)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().keySet());
        return new CorrelatedJoinNode(applyNode.getId(), applyNode.getInput(), new ProjectNode(context.getIdAllocator().getNextId(), AggregationNode.singleAggregation(context.getIdAllocator().getNextId(), applyNode.getSubquery(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of((Object)count, (Object)new AggregationNode.Aggregation(countFunction, (List<Expression>)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty())), AggregationNode.globalAggregation()), Assignments.of(exists, new Comparison(Comparison.Operator.GREATER_THAN, count.toSymbolReference(), new Constant((Type)BigintType.BIGINT, 0L)))), applyNode.getCorrelation(), JoinType.INNER, Booleans.TRUE, applyNode.getOriginSubquery());
    }
}

