/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.type.UnknownType;
import java.util.ArrayDeque;

public class UnwrapRowSubscript
extends ExpressionRewriteRuleSet {
    public UnwrapRowSubscript() {
        super((expression, context) -> ExpressionTreeRewriter.rewriteWith(new Rewriter(), expression));
    }

    private static class Rewriter
    extends ExpressionRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public Expression rewriteSubscript(FieldReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Cast cast;
            Type type;
            Expression base = treeRewriter.rewrite(node.base(), context);
            ArrayDeque<Coercion> coercions = new ArrayDeque<Coercion>();
            while (base instanceof Cast && (type = (cast = (Cast)base).type()) instanceof RowType) {
                RowType rowType = (RowType)type;
                Type type2 = ((RowType.Field)rowType.getFields().get(node.field())).getType();
                if (!(type2 instanceof UnknownType)) {
                    coercions.push(new Coercion(type2, cast.safe()));
                }
                base = cast.expression();
            }
            if (base instanceof Row) {
                Row row = (Row)base;
                Expression result = row.items().get(node.field());
                while (!coercions.isEmpty()) {
                    Coercion coercion = (Coercion)coercions.pop();
                    result = new Cast(result, coercion.getType(), coercion.isSafe());
                }
                return result;
            }
            return treeRewriter.defaultRewrite(node, context);
        }
    }

    private static class Coercion {
        private final Type type;
        private final boolean safe;

        public Coercion(Type type, boolean safe) {
            this.type = type;
            this.safe = safe;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isSafe() {
            return this.safe;
        }
    }
}

