/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.connector.SortOrder;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MergeProcessorNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.StatisticAggregations;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.ClassifierValuePointer;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointers;
import io.trino.sql.planner.rowpattern.MatchNumberValuePointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class SymbolMapper {
    private final Function<Symbol, Symbol> mappingFunction;

    public SymbolMapper(Function<Symbol, Symbol> mappingFunction) {
        this.mappingFunction = Objects.requireNonNull(mappingFunction, "mappingFunction is null");
    }

    public static SymbolMapper symbolMapper(Map<Symbol, Symbol> mapping) {
        return new SymbolMapper(symbol -> {
            while (mapping.containsKey(symbol) && !((Symbol)mapping.get(symbol)).equals(symbol)) {
                symbol = (Symbol)mapping.get(symbol);
            }
            return symbol;
        });
    }

    public static SymbolMapper symbolReallocator(Map<Symbol, Symbol> mapping, SymbolAllocator symbolAllocator) {
        return new SymbolMapper(symbol -> {
            if (mapping.containsKey(symbol)) {
                while (mapping.containsKey(symbol) && !((Symbol)mapping.get(symbol)).equals(symbol)) {
                    symbol = (Symbol)mapping.get(symbol);
                }
                mapping.put((Symbol)symbol, (Symbol)symbol);
                return symbol;
            }
            Symbol newSymbol = symbolAllocator.newSymbol((Symbol)symbol);
            mapping.put((Symbol)symbol, newSymbol);
            mapping.put(newSymbol, newSymbol);
            return newSymbol;
        });
    }

    public Symbol map(Symbol symbol) {
        return this.mappingFunction.apply(symbol);
    }

    public ApplyNode.SetExpression map(ApplyNode.SetExpression expression) {
        ApplyNode.SetExpression setExpression = expression;
        Objects.requireNonNull(setExpression);
        ApplyNode.SetExpression setExpression2 = setExpression;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ApplyNode.Exists.class, ApplyNode.In.class, ApplyNode.QuantifiedComparison.class}, (Object)setExpression2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ApplyNode.Exists exists;
                yield exists = (ApplyNode.Exists)setExpression2;
            }
            case 1 -> {
                ApplyNode.In in = (ApplyNode.In)setExpression2;
                yield new ApplyNode.In(this.map(in.value()), this.map(in.reference()));
            }
            case 2 -> {
                ApplyNode.QuantifiedComparison comparison = (ApplyNode.QuantifiedComparison)setExpression2;
                yield new ApplyNode.QuantifiedComparison(comparison.operator(), comparison.quantifier(), this.map(comparison.value()), this.map(comparison.reference()));
            }
        };
    }

    public List<Symbol> map(List<Symbol> symbols) {
        return (List)symbols.stream().map(this::map).collect(ImmutableList.toImmutableList());
    }

    public List<Symbol> mapAndDistinct(List<Symbol> symbols) {
        return (List)symbols.stream().map(this::map).distinct().collect(ImmutableList.toImmutableList());
    }

    public Expression map(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new ExpressionRewriter<Void>(){

            @Override
            public Expression rewriteReference(Reference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Symbol canonical = SymbolMapper.this.map(Symbol.from(node));
                return canonical.toSymbolReference();
            }

            @Override
            public Expression rewriteLambda(Lambda node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                List arguments = (List)node.arguments().stream().map(symbol -> SymbolMapper.this.map(new Symbol(symbol.type(), symbol.name()))).collect(ImmutableList.toImmutableList());
                Expression body = treeRewriter.rewrite(node.body(), context);
                if (body != node.body()) {
                    return new Lambda(arguments, body);
                }
                return node;
            }
        }, expression);
    }

    public AggregationNode map(AggregationNode node, PlanNode source) {
        return this.map(node, source, node.getId());
    }

    public AggregationNode map(AggregationNode node, PlanNode source, PlanNodeId newNodeId) {
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            aggregations.put((Object)this.map(entry.getKey()), (Object)this.map(entry.getValue()));
        }
        return new AggregationNode(newNodeId, source, (Map<Symbol, AggregationNode.Aggregation>)aggregations.buildOrThrow(), AggregationNode.groupingSets(this.mapAndDistinct(node.getGroupingKeys()), node.getGroupingSetCount(), node.getGlobalGroupingSets()), (List<Symbol>)ImmutableList.of(), node.getStep(), node.getHashSymbol().map(this::map), node.getGroupIdSymbol().map(this::map));
    }

    public AggregationNode.Aggregation map(AggregationNode.Aggregation aggregation) {
        return new AggregationNode.Aggregation(aggregation.getResolvedFunction(), (List)aggregation.getArguments().stream().map(this::map).collect(ImmutableList.toImmutableList()), aggregation.isDistinct(), aggregation.getFilter().map(this::map), aggregation.getOrderingScheme().map(this::map), aggregation.getMask().map(this::map));
    }

    public GroupIdNode map(GroupIdNode node, PlanNode source) {
        HashMap<Symbol, Symbol> newGroupingMappings = new HashMap<Symbol, Symbol>();
        ImmutableList.Builder newGroupingSets = ImmutableList.builder();
        for (List<Symbol> groupingSet : node.getGroupingSets()) {
            LinkedHashSet<Symbol> newGroupingSet = new LinkedHashSet<Symbol>();
            for (Symbol output : groupingSet) {
                Symbol newOutput = this.map(output);
                newGroupingMappings.putIfAbsent(newOutput, this.map(node.getGroupingColumns().get(output)));
                newGroupingSet.add(newOutput);
            }
            newGroupingSets.add((Object)ImmutableList.copyOf(newGroupingSet));
        }
        return new GroupIdNode(node.getId(), source, (List<List<Symbol>>)newGroupingSets.build(), newGroupingMappings, this.mapAndDistinct(node.getAggregationArguments()), this.map(node.getGroupIdSymbol()));
    }

    public WindowNode map(WindowNode node, PlanNode source) {
        ImmutableMap.Builder newFunctions = ImmutableMap.builder();
        node.getWindowFunctions().forEach((symbol, function) -> {
            List newArguments = (List)function.getArguments().stream().map(this::map).collect(ImmutableList.toImmutableList());
            WindowNode.Frame newFrame = this.map(function.getFrame());
            newFunctions.put((Object)this.map((Symbol)symbol), (Object)new WindowNode.Function(function.getResolvedFunction(), newArguments, newFrame, function.isIgnoreNulls()));
        });
        SpecificationWithPreSortedPrefix newSpecification = this.mapAndDistinct(node.getSpecification(), node.getPreSortedOrderPrefix());
        return new WindowNode(node.getId(), source, newSpecification.specification(), (Map<Symbol, WindowNode.Function>)newFunctions.buildOrThrow(), node.getHashSymbol().map(this::map), (Set)node.getPrePartitionedInputs().stream().map(this::map).collect(ImmutableSet.toImmutableSet()), newSpecification.preSorted());
    }

    private WindowNode.Frame map(WindowNode.Frame frame) {
        return new WindowNode.Frame(frame.getType(), frame.getStartType(), frame.getStartValue().map(this::map), frame.getSortKeyCoercedForFrameStartComparison().map(this::map), frame.getEndType(), frame.getEndValue().map(this::map), frame.getSortKeyCoercedForFrameEndComparison().map(this::map));
    }

    private SpecificationWithPreSortedPrefix mapAndDistinct(DataOrganizationSpecification specification, int preSorted) {
        Optional<OrderingSchemeWithPreSortedPrefix> newOrderingScheme = specification.orderingScheme().map((? super T orderingScheme) -> this.map((OrderingScheme)orderingScheme, preSorted));
        return new SpecificationWithPreSortedPrefix(new DataOrganizationSpecification(this.mapAndDistinct(specification.partitionBy()), newOrderingScheme.map(OrderingSchemeWithPreSortedPrefix::orderingScheme)), newOrderingScheme.map(OrderingSchemeWithPreSortedPrefix::preSorted).orElse(preSorted));
    }

    public DataOrganizationSpecification mapAndDistinct(DataOrganizationSpecification specification) {
        return new DataOrganizationSpecification(this.mapAndDistinct(specification.partitionBy()), specification.orderingScheme().map(this::map));
    }

    public PatternRecognitionNode map(PatternRecognitionNode node, PlanNode source) {
        SpecificationWithPreSortedPrefix newSpecification = this.mapAndDistinct(node.getSpecification(), node.getPreSortedOrderPrefix());
        ImmutableMap.Builder newFunctions = ImmutableMap.builder();
        node.getWindowFunctions().forEach((symbol, function) -> {
            List newArguments = (List)function.getArguments().stream().map(this::map).collect(ImmutableList.toImmutableList());
            WindowNode.Frame newFrame = this.map(function.getFrame());
            newFunctions.put((Object)this.map((Symbol)symbol), (Object)new WindowNode.Function(function.getResolvedFunction(), newArguments, newFrame, function.isIgnoreNulls()));
        });
        ImmutableMap.Builder newMeasures = ImmutableMap.builder();
        node.getMeasures().forEach((symbol, measure) -> {
            ExpressionAndValuePointers newExpression = this.map(measure.getExpressionAndValuePointers());
            newMeasures.put((Object)this.map((Symbol)symbol), (Object)new PatternRecognitionNode.Measure(newExpression, measure.getType()));
        });
        ImmutableMap.Builder newVariableDefinitions = ImmutableMap.builder();
        node.getVariableDefinitions().forEach((label, expression) -> newVariableDefinitions.put(label, (Object)this.map((ExpressionAndValuePointers)expression)));
        return new PatternRecognitionNode(node.getId(), source, newSpecification.specification(), node.getHashSymbol().map(this::map), (Set)node.getPrePartitionedInputs().stream().map(this::map).collect(ImmutableSet.toImmutableSet()), newSpecification.preSorted(), (Map<Symbol, WindowNode.Function>)newFunctions.buildOrThrow(), (Map<Symbol, PatternRecognitionNode.Measure>)newMeasures.buildOrThrow(), node.getCommonBaseFrame().map(this::map), node.getRowsPerMatch(), node.getSkipToLabels(), node.getSkipToPosition(), node.isInitial(), node.getPattern(), (Map<IrLabel, ExpressionAndValuePointers>)newVariableDefinitions.buildOrThrow());
    }

    private ExpressionAndValuePointers map(ExpressionAndValuePointers expressionAndValuePointers) {
        ImmutableList.Builder newAssignments = ImmutableList.builder();
        for (ExpressionAndValuePointers.Assignment assignment : expressionAndValuePointers.getAssignments()) {
            ValuePointer valuePointer;
            Objects.requireNonNull(assignment.valuePointer());
            int n = 0;
            ValuePointer newPointer = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassifierValuePointer.class, MatchNumberValuePointer.class, ScalarValuePointer.class, AggregationValuePointer.class}, (Object)valuePointer, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ClassifierValuePointer pointer;
                    yield pointer = (ClassifierValuePointer)valuePointer;
                }
                case 1 -> {
                    MatchNumberValuePointer pointer = (MatchNumberValuePointer)valuePointer;
                    yield pointer;
                }
                case 2 -> {
                    ScalarValuePointer pointer = (ScalarValuePointer)valuePointer;
                    yield new ScalarValuePointer(pointer.getLogicalIndexPointer(), this.map(pointer.getInputSymbol()));
                }
                case 3 -> {
                    final AggregationValuePointer pointer = (AggregationValuePointer)valuePointer;
                    List newArguments = (List)pointer.getArguments().stream().map((? super T expression) -> ExpressionTreeRewriter.rewriteWith(new ExpressionRewriter<Void>(){

                        @Override
                        public Expression rewriteReference(Reference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                            if (pointer.getClassifierSymbol().isPresent() && Symbol.from(node).equals(pointer.getClassifierSymbol().get()) || pointer.getMatchNumberSymbol().isPresent() && Symbol.from(node).equals(pointer.getMatchNumberSymbol().get())) {
                                return node;
                            }
                            return SymbolMapper.this.map(node);
                        }
                    }, expression)).collect(ImmutableList.toImmutableList());
                    yield new AggregationValuePointer(pointer.getFunction(), pointer.getSetDescriptor(), newArguments, pointer.getClassifierSymbol(), pointer.getMatchNumberSymbol());
                }
            };
            newAssignments.add((Object)new ExpressionAndValuePointers.Assignment(assignment.symbol(), newPointer));
        }
        return new ExpressionAndValuePointers(expressionAndValuePointers.getExpression(), (List<ExpressionAndValuePointers.Assignment>)newAssignments.build());
    }

    public TableFunctionProcessorNode map(TableFunctionProcessorNode node, PlanNode source) {
        ImmutableList.Builder newPassThroughSpecifications = ImmutableList.builder();
        HashSet<Symbol> newPassThroughSymbols = new HashSet<Symbol>();
        for (TableFunctionNode.PassThroughSpecification specification2 : node.getPassThroughSpecifications()) {
            ImmutableList.Builder newColumns = ImmutableList.builder();
            for (TableFunctionNode.PassThroughColumn column : specification2.columns()) {
                Symbol newSymbol = this.map(column.symbol());
                if (!newPassThroughSymbols.add(newSymbol)) continue;
                newColumns.add((Object)new TableFunctionNode.PassThroughColumn(newSymbol, column.isPartitioningColumn()));
            }
            newPassThroughSpecifications.add((Object)new TableFunctionNode.PassThroughSpecification(specification2.declaredAsPassThrough(), (List<TableFunctionNode.PassThroughColumn>)newColumns.build()));
        }
        List newRequiredSymbols = (List)node.getRequiredSymbols().stream().map(this::map).collect(ImmutableList.toImmutableList());
        Optional<Map<Symbol, Symbol>> newMarkerSymbols = node.getMarkerSymbols().map((? super T mapping) -> (Map)mapping.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> this.map((Symbol)entry.getKey()), entry -> this.map((Symbol)entry.getValue()), (first, second) -> {
            Preconditions.checkState((boolean)first.equals(second), (String)"Ambiguous marker symbols: %s and %s", (Object)first, (Object)second);
            return first;
        })));
        Optional<SpecificationWithPreSortedPrefix> newSpecification = node.getSpecification().map((? super T specification) -> this.mapAndDistinct((DataOrganizationSpecification)specification, node.getPreSorted()));
        return new TableFunctionProcessorNode(node.getId(), node.getName(), this.map(node.getProperOutputs()), Optional.of(source), node.isPruneWhenEmpty(), (List<TableFunctionNode.PassThroughSpecification>)newPassThroughSpecifications.build(), newRequiredSymbols, newMarkerSymbols, newSpecification.map(SpecificationWithPreSortedPrefix::specification), (Set)node.getPrePartitioned().stream().map(this::map).collect(ImmutableSet.toImmutableSet()), newSpecification.map(SpecificationWithPreSortedPrefix::preSorted).orElse(node.getPreSorted()), node.getHashSymbol().map(this::map), node.getHandle());
    }

    public LimitNode map(LimitNode node, PlanNode source) {
        return new LimitNode(node.getId(), source, node.getCount(), node.getTiesResolvingScheme().map(this::map), node.isPartial(), (List)node.getPreSortedInputs().stream().map(this::map).collect(ImmutableList.toImmutableList()));
    }

    public OrderingSchemeWithPreSortedPrefix map(OrderingScheme orderingScheme, int preSorted) {
        ImmutableList.Builder newSymbols = ImmutableList.builder();
        ImmutableMap.Builder newOrderings = ImmutableMap.builder();
        int newPreSorted = preSorted;
        HashSet<Symbol> added = new HashSet<Symbol>(orderingScheme.orderBy().size());
        for (int i = 0; i < orderingScheme.orderBy().size(); ++i) {
            Symbol symbol = orderingScheme.orderBy().get(i);
            Symbol canonical = this.map(symbol);
            if (added.add(canonical)) {
                newSymbols.add((Object)canonical);
                newOrderings.put((Object)canonical, (Object)orderingScheme.ordering(symbol));
                continue;
            }
            if (i >= preSorted) continue;
            --newPreSorted;
        }
        return new OrderingSchemeWithPreSortedPrefix(new OrderingScheme((List<Symbol>)newSymbols.build(), (Map<Symbol, SortOrder>)newOrderings.buildOrThrow()), newPreSorted);
    }

    public OrderingScheme map(OrderingScheme orderingScheme) {
        ImmutableList.Builder newSymbols = ImmutableList.builder();
        ImmutableMap.Builder newOrderings = ImmutableMap.builder();
        HashSet<Symbol> added = new HashSet<Symbol>(orderingScheme.orderBy().size());
        for (Symbol symbol : orderingScheme.orderBy()) {
            Symbol canonical = this.map(symbol);
            if (!added.add(canonical)) continue;
            newSymbols.add((Object)canonical);
            newOrderings.put((Object)canonical, (Object)orderingScheme.ordering(symbol));
        }
        return new OrderingScheme((List<Symbol>)newSymbols.build(), (Map<Symbol, SortOrder>)newOrderings.buildOrThrow());
    }

    public DistinctLimitNode map(DistinctLimitNode node, PlanNode source) {
        return new DistinctLimitNode(node.getId(), source, node.getLimit(), node.isPartial(), this.mapAndDistinct(node.getDistinctSymbols()), node.getHashSymbol().map(this::map));
    }

    public StatisticsWriterNode map(StatisticsWriterNode node, PlanNode source) {
        return new StatisticsWriterNode(node.getId(), source, node.getTarget(), this.map(node.getRowCountSymbol()), node.isRowCountEnabled(), node.getDescriptor().map(this::map));
    }

    public TableWriterNode map(TableWriterNode node, PlanNode source) {
        return this.map(node, source, node.getId());
    }

    public TableWriterNode map(TableWriterNode node, PlanNode source, PlanNodeId newId) {
        return new TableWriterNode(newId, source, node.getTarget(), this.map(node.getRowCountSymbol()), this.map(node.getFragmentSymbol()), this.map(node.getColumns()), node.getColumnNames(), node.getPartitioningScheme().map((? super T partitioningScheme) -> this.map((PartitioningScheme)partitioningScheme, source.getOutputSymbols())), node.getStatisticsAggregation().map(this::map), node.getStatisticsAggregationDescriptor().map((? super T descriptor) -> descriptor.map(this::map)));
    }

    public TableExecuteNode map(TableExecuteNode node, PlanNode source) {
        return this.map(node, source, node.getId());
    }

    public TableExecuteNode map(TableExecuteNode node, PlanNode source, PlanNodeId newId) {
        return new TableExecuteNode(newId, source, node.getTarget(), this.map(node.getRowCountSymbol()), this.map(node.getFragmentSymbol()), this.map(node.getColumns()), node.getColumnNames(), node.getPartitioningScheme().map((? super T partitioningScheme) -> this.map((PartitioningScheme)partitioningScheme, source.getOutputSymbols())));
    }

    public MergeWriterNode map(MergeWriterNode node, PlanNode source) {
        List<Symbol> newOutputs = this.map(node.getOutputSymbols());
        return new MergeWriterNode(node.getId(), source, node.getTarget(), this.map(node.getProjectedSymbols()), node.getPartitioningScheme().map((? super T partitioningScheme) -> this.map((PartitioningScheme)partitioningScheme, source.getOutputSymbols())), newOutputs);
    }

    public MergeWriterNode map(MergeWriterNode node, PlanNode source, PlanNodeId newId) {
        List<Symbol> newOutputs = this.map(node.getOutputSymbols());
        return new MergeWriterNode(newId, source, node.getTarget(), this.map(node.getProjectedSymbols()), node.getPartitioningScheme().map((? super T partitioningScheme) -> this.map((PartitioningScheme)partitioningScheme, source.getOutputSymbols())), newOutputs);
    }

    public MergeProcessorNode map(MergeProcessorNode node, PlanNode source) {
        List<Symbol> newOutputs = this.map(node.getOutputSymbols());
        return new MergeProcessorNode(node.getId(), source, node.getTarget(), this.map(node.getRowIdSymbol()), this.map(node.getMergeRowSymbol()), this.map(node.getDataColumnSymbols()), this.map(node.getRedistributionColumnSymbols()), newOutputs);
    }

    public PartitioningScheme map(PartitioningScheme scheme, List<Symbol> sourceLayout) {
        return new PartitioningScheme(scheme.getPartitioning().translate(this::map), this.mapAndDistinct(sourceLayout), scheme.getHashColumn().map(this::map), scheme.isReplicateNullsAndAny(), scheme.getBucketToPartition(), scheme.getPartitionCount());
    }

    public TableFinishNode map(TableFinishNode node, PlanNode source) {
        return new TableFinishNode(node.getId(), source, node.getTarget(), this.map(node.getRowCountSymbol()), node.getStatisticsAggregation().map(this::map), node.getStatisticsAggregationDescriptor().map((? super T descriptor) -> descriptor.map(this::map)));
    }

    private StatisticAggregations map(StatisticAggregations statisticAggregations) {
        Map aggregations = (Map)statisticAggregations.getAggregations().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> this.map((Symbol)entry.getKey()), entry -> this.map((AggregationNode.Aggregation)entry.getValue())));
        return new StatisticAggregations(aggregations, this.mapAndDistinct(statisticAggregations.getGroupingSymbols()));
    }

    public RowNumberNode map(RowNumberNode node, PlanNode source) {
        return new RowNumberNode(node.getId(), source, this.mapAndDistinct(node.getPartitionBy()), node.isOrderSensitive(), this.map(node.getRowNumberSymbol()), node.getMaxRowCountPerPartition(), node.getHashSymbol().map(this::map));
    }

    public TopNRankingNode map(TopNRankingNode node, PlanNode source) {
        return new TopNRankingNode(node.getId(), source, this.mapAndDistinct(node.getSpecification()), node.getRankingType(), this.map(node.getRankingSymbol()), node.getMaxRankingPerPartition(), node.isPartial(), node.getHashSymbol().map(this::map));
    }

    public TopNNode map(TopNNode node, PlanNode source) {
        return this.map(node, source, node.getId());
    }

    public TopNNode map(TopNNode node, PlanNode source, PlanNodeId nodeId) {
        return new TopNNode(nodeId, source, node.getCount(), this.map(node.getOrderingScheme()), node.getStep());
    }

    public static Builder builder() {
        return new Builder();
    }

    private record SpecificationWithPreSortedPrefix(DataOrganizationSpecification specification, int preSorted) {
        private SpecificationWithPreSortedPrefix(DataOrganizationSpecification specification, int preSorted) {
            this.specification = Objects.requireNonNull(specification, "specification is null");
            this.preSorted = preSorted;
        }
    }

    private record OrderingSchemeWithPreSortedPrefix(OrderingScheme orderingScheme, int preSorted) {
        private OrderingSchemeWithPreSortedPrefix(OrderingScheme orderingScheme, int preSorted) {
            this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
            this.preSorted = preSorted;
        }
    }

    public static class Builder {
        private final ImmutableMap.Builder<Symbol, Symbol> mappings = ImmutableMap.builder();

        public void put(Symbol from, Symbol to) {
            this.mappings.put((Object)from, (Object)to);
        }

        public SymbolMapper build() {
            return SymbolMapper.symbolMapper((Map<Symbol, Symbol>)this.mappings.buildOrThrow());
        }
    }
}

