/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Comparison;
import java.util.List;
import java.util.Objects;

public final class StandardFunctionResolution {
    private final Metadata metadata;

    public StandardFunctionResolution(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public ResolvedFunction comparisonFunction(Comparison.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType = switch (operator) {
            case Comparison.Operator.EQUAL -> OperatorType.EQUAL;
            case Comparison.Operator.LESS_THAN -> OperatorType.LESS_THAN;
            case Comparison.Operator.LESS_THAN_OR_EQUAL -> OperatorType.LESS_THAN_OR_EQUAL;
            case Comparison.Operator.IS_DISTINCT_FROM -> OperatorType.IS_DISTINCT_FROM;
            default -> throw new IllegalStateException("Unsupported comparison operator type: " + String.valueOf((Object)operator));
        };
        return this.metadata.resolveOperator(operatorType, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
    }
}

