/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsAssertion;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestRowNumberStatsRule
extends BaseStatsCalculatorTest {
    private final SymbolStatsEstimate xStats = SymbolStatsEstimate.builder().setDistinctValuesCount(5.0).setNullsFraction(0.0).build();
    private final SymbolStatsEstimate yStats = SymbolStatsEstimate.builder().setDistinctValuesCount(5.0).setNullsFraction(0.5).build();

    @Test
    public void testSingleGroupingKey() {
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<Symbol>)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE)), Optional.empty(), pb.symbol("z", (Type)DoubleType.DOUBLE), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).build()).check(check -> check.outputRowsCount(10.0).symbolStats("x", assertion -> assertion.isEqualTo(this.xStats)).symbolStats("y", assertion -> assertion.isEqualTo(this.yStats)).symbolStats("z", assertion -> assertion.lowValue(1.0).distinctValuesCount(2.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<Symbol>)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE)), Optional.of(1), pb.symbol("z", (Type)DoubleType.DOUBLE), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).build()).check(check -> check.outputRowsCount(5.0).symbolStats("z", assertion -> assertion.lowValue(1.0).distinctValuesCount(1.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<Symbol>)ImmutableList.of((Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), Optional.empty(), pb.symbol("z", (Type)DoubleType.DOUBLE), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(60.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).build()).check(check -> check.outputRowsCount(60.0).symbolStats("z", assertion -> assertion.lowValue(1.0).distinctValuesCount(10.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<Symbol>)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE)), Optional.of(1), pb.symbol("z", (Type)DoubleType.DOUBLE), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).build()).check(PlanNodeStatsAssertion::outputRowsCountUnknown);
    }

    @Test
    public void testMultipleGroupingKeys() {
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<Symbol>)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE), (Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), Optional.empty(), pb.symbol("z", (Type)DoubleType.DOUBLE), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(60.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).build()).check(check -> check.outputRowsCount(60.0).symbolStats("z", assertion -> assertion.lowValue(1.0).distinctValuesCount(2.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<Symbol>)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE), (Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), Optional.empty(), pb.symbol("z", (Type)DoubleType.DOUBLE), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), this.yStats).build()).check(check -> check.outputRowsCount(20.0).symbolStats("z", assertion -> assertion.lowValue(1.0).distinctValuesCount(1.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<Symbol>)ImmutableList.of((Object)pb.symbol("x", (Type)DoubleType.DOUBLE), (Object)pb.symbol("y", (Type)DoubleType.DOUBLE)), Optional.empty(), pb.symbol("z", (Type)DoubleType.DOUBLE), (PlanNode)pb.values(pb.symbol("x", (Type)DoubleType.DOUBLE), pb.symbol("y", (Type)DoubleType.DOUBLE)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "y"), SymbolStatsEstimate.unknown()).build()).check(PlanNodeStatsAssertion::outputRowsCountUnknown);
    }
}

