/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.tracing.Tracing;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.cost.StatsAndCosts;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.PartitionedSplitsInfo;
import io.trino.execution.RemoteTask;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.TaskStatus;
import io.trino.execution.buffer.LazyOutputBuffer;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.buffer.SpoolingOutputStats;
import io.trino.memory.MemoryPool;
import io.trino.memory.QueryContext;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.operator.TaskContext;
import io.trino.operator.TaskStats;
import io.trino.spi.type.Type;
import io.trino.spiller.SpillSpaceTracker;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.type.UnknownType;
import io.trino.util.Failures;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.joda.time.DateTime;

public class MockRemoteTaskFactory
implements RemoteTaskFactory {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private final Executor executor;
    private final ScheduledExecutorService scheduledExecutor;

    public MockRemoteTaskFactory(Executor executor, ScheduledExecutorService scheduledExecutor) {
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
    }

    public MockRemoteTask createTableScanTask(TaskId taskId, InternalNode newNode, List<Split> splits, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker) {
        Symbol symbol = new Symbol((Type)UnknownType.UNKNOWN, "column");
        PlanNodeId sourceId = new PlanNodeId("sourceId");
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId("test"), (PlanNode)TableScanNode.newInstance((PlanNodeId)sourceId, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), (boolean)false, Optional.empty()), (Set)ImmutableSet.of((Object)symbol), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)sourceId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StatsAndCosts.empty(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty());
        ImmutableMultimap.Builder initialSplits = ImmutableMultimap.builder();
        for (Split sourceSplit : splits) {
            initialSplits.put((Object)sourceId, (Object)sourceSplit);
        }
        return this.createRemoteTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), taskId, newNode, false, testFragment, (Multimap)initialSplits.build(), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.BROADCAST), partitionedSplitCountTracker, (Set)ImmutableSet.of(), Optional.empty(), true);
    }

    public MockRemoteTask createRemoteTask(Session session, Span stageSpan, TaskId taskId, InternalNode node, boolean speculative, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker, Set<DynamicFilterId> outboundDynamicFilterIds, Optional<DataSize> estimatedMemory, boolean summarizeTaskInfo) {
        return new MockRemoteTask(taskId, fragment, node.getNodeIdentifier(), this.executor, this.scheduledExecutor, initialSplits, partitionedSplitCountTracker);
    }

    public static final class MockRemoteTask
    implements RemoteTask {
        private final AtomicLong nextTaskInfoVersion = new AtomicLong(0L);
        private final URI location;
        private final TaskStateMachine taskStateMachine;
        private final TaskContext taskContext;
        private final OutputBuffer outputBuffer;
        private final String nodeId;
        private final PlanFragment fragment;
        @GuardedBy(value="this")
        private final Set<PlanNodeId> noMoreSplits = new HashSet<PlanNodeId>();
        @GuardedBy(value="this")
        private final Multimap<PlanNodeId, Split> splits = HashMultimap.create();
        @GuardedBy(value="this")
        private int runningDrivers;
        @GuardedBy(value="this")
        private int maxUnacknowledgedSplits = Integer.MAX_VALUE;
        @GuardedBy(value="this")
        private int unacknowledgedSplits;
        @GuardedBy(value="this")
        private SettableFuture<Void> whenSplitQueueHasSpace = SettableFuture.create();
        private final NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker;

        public MockRemoteTask(TaskId taskId, PlanFragment fragment, String nodeId, Executor executor, ScheduledExecutorService scheduledExecutor, Multimap<PlanNodeId, Split> initialSplits, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker) {
            this.taskStateMachine = new TaskStateMachine(Objects.requireNonNull(taskId, "taskId is null"), Objects.requireNonNull(executor, "executor is null"));
            MemoryPool memoryPool = new MemoryPool(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
            SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
            QueryContext queryContext = new QueryContext(taskId.getQueryId(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), executor, scheduledExecutor, scheduledExecutor, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), spillSpaceTracker);
            this.taskContext = queryContext.addTaskContext(this.taskStateMachine, SessionTestUtils.TEST_SESSION, () -> {}, true, true);
            this.location = URI.create("fake://task/" + String.valueOf(taskId));
            this.outputBuffer = new LazyOutputBuffer(taskId, MockRemoteTaskFactory.TASK_INSTANCE_ID, executor, DataSize.ofBytes((long)1L), DataSize.ofBytes((long)1L), () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), () -> {}, new ExchangeManagerRegistry(OpenTelemetry.noop(), Tracing.noopTracer()));
            this.fragment = Objects.requireNonNull(fragment, "fragment is null");
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
            this.splits.putAll(initialSplits);
            this.partitionedSplitCountTracker = Objects.requireNonNull(partitionedSplitCountTracker, "partitionedSplitCountTracker is null");
            partitionedSplitCountTracker.setPartitionedSplits(this.getPartitionedSplitsInfo());
            this.updateSplitQueueSpace();
        }

        public TaskId getTaskId() {
            return this.taskStateMachine.getTaskId();
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public TaskInfo getTaskInfo() {
            return new TaskInfo(this.getTaskStatus(), DateTime.now(), this.outputBuffer.getInfo(), (Set)ImmutableSet.of(), this.taskContext.getTaskStats(), Optional.empty(), true);
        }

        public synchronized TaskStatus getTaskStatus() {
            TaskState state = this.taskStateMachine.getState();
            Object failures = ImmutableList.of();
            if (state == TaskState.FAILED || state == TaskState.FAILING) {
                failures = Failures.toFailures((Collection)this.taskStateMachine.getFailureCauses());
            }
            TaskStats stats = this.taskContext.getTaskStats();
            PartitionedSplitsInfo combinedSplitsInfo = this.getPartitionedSplitsInfo();
            PartitionedSplitsInfo queuedSplitsInfo = this.getQueuedPartitionedSplitsInfo();
            return new TaskStatus(this.taskStateMachine.getTaskId(), MockRemoteTaskFactory.TASK_INSTANCE_ID, this.nextTaskInfoVersion.get(), state, this.location, this.nodeId, false, (List)failures, queuedSplitsInfo.getCount(), combinedSplitsInfo.getCount() - queuedSplitsInfo.getCount(), this.outputBuffer.getStatus(), stats.getOutputDataSize(), stats.getWriterInputDataSize(), stats.getPhysicalWrittenDataSize(), stats.getMaxWriterCount(), stats.getUserMemoryReservation(), stats.getPeakUserMemoryReservation(), stats.getRevocableMemoryReservation(), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), 0L, queuedSplitsInfo.getWeightSum(), combinedSplitsInfo.getWeightSum() - queuedSplitsInfo.getWeightSum());
        }

        private synchronized void updateSplitQueueSpace() {
            if (this.runningDrivers == 0 && this.taskStateMachine.getState().isTerminating()) {
                this.taskStateMachine.terminationComplete();
            }
            if (this.unacknowledgedSplits < this.maxUnacknowledgedSplits && this.getQueuedPartitionedSplitsInfo().getWeightSum() < 900L) {
                if (!this.whenSplitQueueHasSpace.isDone()) {
                    this.whenSplitQueueHasSpace.set(null);
                }
            } else if (this.whenSplitQueueHasSpace.isDone()) {
                this.whenSplitQueueHasSpace = SettableFuture.create();
            }
        }

        public synchronized void finishSplits(int splits) {
            ArrayList<Map.Entry> toRemove = new ArrayList<Map.Entry>();
            Iterator iterator = this.splits.entries().iterator();
            while (toRemove.size() < splits && iterator.hasNext()) {
                toRemove.add((Map.Entry)iterator.next());
            }
            for (Map.Entry entry : toRemove) {
                this.splits.remove(entry.getKey(), entry.getValue());
            }
            this.updateSplitQueueSpace();
        }

        public synchronized void clearSplits() {
            this.unacknowledgedSplits = 0;
            this.splits.clear();
            this.partitionedSplitCountTracker.setPartitionedSplits(PartitionedSplitsInfo.forZeroSplits());
            this.runningDrivers = 0;
            this.updateSplitQueueSpace();
        }

        public synchronized void setMaxUnacknowledgedSplits(int maxUnacknowledgedSplits) {
            Preconditions.checkArgument((maxUnacknowledgedSplits > 0 ? 1 : 0) != 0);
            this.maxUnacknowledgedSplits = maxUnacknowledgedSplits;
            this.updateSplitQueueSpace();
        }

        public synchronized void setUnacknowledgedSplits(int unacknowledgedSplits) {
            Preconditions.checkArgument((unacknowledgedSplits >= 0 ? 1 : 0) != 0);
            this.unacknowledgedSplits = unacknowledgedSplits;
            this.updateSplitQueueSpace();
        }

        public synchronized void startSplits(int maxRunning) {
            if (!this.taskStateMachine.getState().isTerminatingOrDone()) {
                this.runningDrivers = Math.min(this.splits.size(), maxRunning);
            }
            this.updateSplitQueueSpace();
        }

        public void start() {
            this.taskStateMachine.addStateChangeListener(newValue -> {
                if (newValue.isTerminating()) {
                    this.updateSplitQueueSpace();
                } else if (newValue.isDone()) {
                    this.clearSplits();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSplits(Multimap<PlanNodeId, Split> splits) {
            MockRemoteTask mockRemoteTask = this;
            synchronized (mockRemoteTask) {
                this.splits.putAll(splits);
            }
            this.partitionedSplitCountTracker.setPartitionedSplits(this.getPartitionedSplitsInfo());
            this.updateSplitQueueSpace();
        }

        public synchronized void noMoreSplits(PlanNodeId sourceId) {
            this.noMoreSplits.add(sourceId);
            boolean allSourcesComplete = Stream.concat(this.fragment.getPartitionedSourceNodes().stream(), this.fragment.getRemoteSourceNodes().stream()).filter(Objects::nonNull).map(PlanNode::getId).allMatch(this.noMoreSplits::contains);
            if (allSourcesComplete) {
                this.taskStateMachine.finished();
            }
        }

        public void setOutputBuffers(OutputBuffers outputBuffers) {
            this.outputBuffer.setOutputBuffers(outputBuffers);
        }

        public void setSpeculative(boolean speculative) {
        }

        public void addStateChangeListener(StateMachine.StateChangeListener<TaskStatus> stateChangeListener) {
            this.taskStateMachine.addStateChangeListener(newValue -> stateChangeListener.stateChanged((Object)this.getTaskStatus()));
        }

        public void addFinalTaskInfoListener(StateMachine.StateChangeListener<TaskInfo> stateChangeListener) {
            AtomicBoolean done = new AtomicBoolean();
            StateMachine.StateChangeListener fireOnceStateChangeListener = state -> {
                if (state.isDone() && done.compareAndSet(false, true)) {
                    stateChangeListener.stateChanged((Object)this.getTaskInfo());
                }
            };
            this.taskStateMachine.addStateChangeListener(fireOnceStateChangeListener);
            fireOnceStateChangeListener.stateChanged((Object)this.taskStateMachine.getState());
        }

        public synchronized ListenableFuture<Void> whenSplitQueueHasSpace(long weightThreshold) {
            return Futures.nonCancellationPropagating(this.whenSplitQueueHasSpace);
        }

        public void cancel() {
            this.taskStateMachine.cancel();
        }

        public void abort() {
            this.taskStateMachine.abort();
            this.clearSplits();
        }

        public void failRemotely(Throwable cause) {
            this.taskStateMachine.failed(cause);
            this.clearSplits();
        }

        public void failLocallyImmediately(Throwable cause) {
            this.taskStateMachine.failed(cause);
            this.clearSplits();
        }

        public synchronized PartitionedSplitsInfo getPartitionedSplitsInfo() {
            if (this.taskStateMachine.getState().isDone()) {
                return PartitionedSplitsInfo.forZeroSplits();
            }
            boolean countQueued = !this.taskStateMachine.getState().isTerminating();
            int remainingRunning = this.runningDrivers;
            int splitCount = 0;
            long splitWeight = 0L;
            for (PlanNodeId tableScanPlanNodeId : this.fragment.getPartitionedSources()) {
                for (Split split : this.splits.get((Object)tableScanPlanNodeId)) {
                    if (!countQueued && remainingRunning <= 0) continue;
                    if (remainingRunning > 0) {
                        --remainingRunning;
                    }
                    ++splitCount;
                    splitWeight = Math.addExact(splitWeight, split.getSplitWeight().getRawValue());
                }
            }
            return PartitionedSplitsInfo.forSplitCountAndWeightSum((int)splitCount, (long)splitWeight);
        }

        public synchronized PartitionedSplitsInfo getQueuedPartitionedSplitsInfo() {
            if (this.taskStateMachine.getState().isTerminatingOrDone()) {
                return PartitionedSplitsInfo.forZeroSplits();
            }
            int remainingRunning = this.runningDrivers;
            int queuedCount = 0;
            long queuedWeight = 0L;
            for (PlanNodeId tableScanPlanNodeId : this.fragment.getPartitionedSources()) {
                for (Split split : this.splits.get((Object)tableScanPlanNodeId)) {
                    if (remainingRunning > 0) {
                        --remainingRunning;
                        continue;
                    }
                    ++queuedCount;
                    queuedWeight = Math.addExact(queuedWeight, split.getSplitWeight().getRawValue());
                }
            }
            return PartitionedSplitsInfo.forSplitCountAndWeightSum((int)queuedCount, (long)queuedWeight);
        }

        public synchronized int getUnacknowledgedPartitionedSplitCount() {
            return this.unacknowledgedSplits;
        }

        public SpoolingOutputStats.Snapshot retrieveAndDropSpoolingOutputStats() {
            throw new UnsupportedOperationException();
        }
    }
}

