/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Key;
import io.airlift.concurrent.MoreFutures;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.execution.CreateTableTask;
import io.trino.execution.DataDefinitionTask;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LikeClause;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SaveMode;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
class TestCreateTableTask {
    private static final String OTHER_CATALOG_NAME = "other_catalog";
    private static final ConnectorTableMetadata PARENT_TABLE = new ConnectorTableMetadata(new SchemaTableName("schema", "parent_table"), List.of(new ColumnMetadata("a", (Type)SmallintType.SMALLINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)), Map.of("baz", "property_value"));
    private static final ConnectorTableMetadata PARENT_TABLE_WITH_COERCED_TYPE = new ConnectorTableMetadata(new SchemaTableName("schema", "parent_table_with_coerced_type"), List.of(new ColumnMetadata("a", (Type)TimestampType.TIMESTAMP_NANOS)));
    private QueryRunner queryRunner;
    private MockMetadata metadata;
    private CreateTableTask createTableTask;

    TestCreateTableTask() {
    }

    @BeforeEach
    void setUp() {
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(TestingSession.testSessionBuilder().setCatalog("test_catalog").build());
        this.metadata = new MockMetadata();
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withMetadataWrapper(ignored -> this.metadata).withTableProperties(() -> ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"baz", (String)"test property", null, (boolean)false))).withCapabilities(() -> ImmutableSet.of((Object)ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)).build()));
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withMetadataWrapper(ignored -> this.metadata).withName("other_mock").build()));
        queryRunner.createCatalog("test_catalog", "mock", (Map)ImmutableMap.of());
        queryRunner.createCatalog(OTHER_CATALOG_NAME, "other_mock", (Map)ImmutableMap.of());
        Map tasks = (Map)queryRunner.getCoordinator().getInstance(new Key<Map<Class<? extends Statement>, DataDefinitionTask<?>>>(this){});
        this.createTableTask = (CreateTableTask)tasks.get(CreateTable.class);
        this.queryRunner = queryRunner;
    }

    @AfterEach
    void tearDown() throws IOException {
        if (this.queryRunner != null) {
            this.queryRunner.close();
        }
    }

    @Test
    void testCreateTableNotExistsTrue() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table_if_not_exists"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, Collections.emptyList(), output -> {}));
            Assertions.assertThat((int)this.metadata.getCreateTableCallCount()).isEqualTo(1);
            return null;
        });
    }

    @Test
    void testCreateTableNotExistsFalse() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table_fail_if_exists"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), SaveMode.FAIL, (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, Collections.emptyList(), output -> {}))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("Table already exists");
            Assertions.assertThat((int)this.metadata.getCreateTableCallCount()).isEqualTo(1);
            return null;
        });
    }

    @Test
    void testReplaceTable() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table_replace"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), SaveMode.REPLACE, (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, Collections.emptyList(), output -> {}));
            Assertions.assertThat((int)this.metadata.getCreateTableCallCount()).isEqualTo(1);
            Assertions.assertThat((List)this.metadata.getReceivedTableMetadata().get(0).getColumns()).isEqualTo((Object)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT)));
            return null;
        });
    }

    @Test
    void testCreateTableWithMaterializedViewPropertyFails() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table_with_materialized_view_property"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new StringLiteral("bar"))), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, Collections.emptyList(), output -> {}))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_TABLE_PROPERTY}).hasMessage("Catalog 'test_catalog' table property 'foo' does not exist");
            Assertions.assertThat((int)this.metadata.getCreateTableCallCount()).isEqualTo(0);
            return null;
        });
    }

    @Test
    void testCreateWithNotNullColumns() {
        ImmutableList inputColumns = ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"a"), TypeSignatureTranslator.toSqlType((Type)DateType.DATE), true, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QualifiedName.of((String)"b"), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR), false, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QualifiedName.of((String)"c"), TypeSignatureTranslator.toSqlType((Type)VarbinaryType.VARBINARY), false, Collections.emptyList(), Optional.empty()));
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table_not_null_columns"), (List)inputColumns, SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, Collections.emptyList(), output -> {}));
            Assertions.assertThat((int)this.metadata.getCreateTableCallCount()).isEqualTo(1);
            List columns = this.metadata.getReceivedTableMetadata().get(0).getColumns();
            Assertions.assertThat((int)columns.size()).isEqualTo(3);
            Assertions.assertThat((String)((ColumnMetadata)columns.get(0)).getName()).isEqualTo("a");
            Assertions.assertThat((String)((ColumnMetadata)columns.get(0)).getType().getDisplayName().toUpperCase(Locale.ROOT)).isEqualTo("DATE");
            Assertions.assertThat((boolean)((ColumnMetadata)columns.get(0)).isNullable()).isTrue();
            Assertions.assertThat((String)((ColumnMetadata)columns.get(1)).getName()).isEqualTo("b");
            Assertions.assertThat((String)((ColumnMetadata)columns.get(1)).getType().getDisplayName().toUpperCase(Locale.ROOT)).isEqualTo("VARCHAR");
            Assertions.assertThat((boolean)((ColumnMetadata)columns.get(1)).isNullable()).isFalse();
            Assertions.assertThat((String)((ColumnMetadata)columns.get(2)).getName()).isEqualTo("c");
            Assertions.assertThat((String)((ColumnMetadata)columns.get(2)).getType().getDisplayName().toUpperCase(Locale.ROOT)).isEqualTo("VARBINARY");
            Assertions.assertThat((boolean)((ColumnMetadata)columns.get(2)).isNullable()).isFalse();
            return null;
        });
    }

    @Test
    void testCreateWithUnsupportedConnectorThrowsWhenNotNull() {
        ImmutableList inputColumns = ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"a"), TypeSignatureTranslator.toSqlType((Type)DateType.DATE), true, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QualifiedName.of((String)"b"), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR), false, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QualifiedName.of((String)"c"), TypeSignatureTranslator.toSqlType((Type)VarbinaryType.VARBINARY), false, Collections.emptyList(), Optional.empty()));
        CreateTable statement = new CreateTable(QualifiedName.of((String)OTHER_CATALOG_NAME, (String[])new String[]{"other_schema", "test_table_unsupported_connector"}), (List)inputColumns, SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, Collections.emptyList(), output -> {}))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("Catalog 'other_catalog' does not support non-null column for column name 'b'");
            return null;
        });
    }

    @Test
    void testCreateLike() {
        CreateTable statement = TestCreateTableTask.getCreateLikeStatement(false);
        this.queryRunner.inTransaction(transactionSession -> {
            MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, List.of(), output -> {}));
            Assertions.assertThat((int)this.metadata.getCreateTableCallCount()).isEqualTo(1);
            Assertions.assertThat((List)this.metadata.getReceivedTableMetadata().get(0).getColumns()).isEqualTo((Object)PARENT_TABLE.getColumns());
            Assertions.assertThat((Map)this.metadata.getReceivedTableMetadata().get(0).getProperties()).isEmpty();
            return null;
        });
    }

    @Test
    void testCreateLikeIncludingProperties() {
        CreateTable statement = TestCreateTableTask.getCreateLikeStatement(true);
        this.queryRunner.inTransaction(transactionSession -> {
            MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, List.of(), output -> {}));
            Assertions.assertThat((int)this.metadata.getCreateTableCallCount()).isEqualTo(1);
            Assertions.assertThat((List)this.metadata.getReceivedTableMetadata().get(0).getColumns()).isEqualTo((Object)PARENT_TABLE.getColumns());
            Assertions.assertThat((Map)this.metadata.getReceivedTableMetadata().get(0).getProperties()).isEqualTo((Object)PARENT_TABLE.getProperties());
            return null;
        });
    }

    @Test
    void testCreateLikeExcludingPropertiesAcrossCatalogs() {
        CreateTable statement = TestCreateTableTask.getCreateLikeStatement(QualifiedName.of((String)OTHER_CATALOG_NAME, (String[])new String[]{"other_schema", "test_table_excluding"}), false);
        this.queryRunner.inTransaction(transactionSession -> {
            MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, List.of(), output -> {}));
            Assertions.assertThat((int)this.metadata.getCreateTableCallCount()).isEqualTo(1);
            Assertions.assertThat((List)this.metadata.getReceivedTableMetadata().get(0).getColumns()).isEqualTo((Object)PARENT_TABLE.getColumns());
            return null;
        });
    }

    @Test
    void testCreateLikeIncludingPropertiesAcrossCatalogs() {
        CreateTable failingStatement = TestCreateTableTask.getCreateLikeStatement(QualifiedName.of((String)OTHER_CATALOG_NAME, (String[])new String[]{"other_schema", "test_table_including"}), true);
        this.queryRunner.inTransaction(transactionSession -> {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(failingStatement, transactionSession, List.of(), output -> {}))).isInstanceOf(TrinoException.class)).hasMessageContaining("CREATE TABLE LIKE table INCLUDING PROPERTIES across catalogs is not supported");
            return null;
        });
    }

    @Test
    void testCreateLikeDenyPermission() {
        CreateTable statement = TestCreateTableTask.getCreateLikeStatement(false);
        this.queryRunner.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"parent_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.queryRunner.inTransaction(transactionSession -> {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, List.of(), output -> {}))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessageContaining("Cannot reference columns of table");
            return null;
        });
        this.queryRunner.getAccessControl().reset();
    }

    @Test
    void testCreateLikeIncludingPropertiesDenyPermission() {
        CreateTable statement = TestCreateTableTask.getCreateLikeStatement(true);
        this.queryRunner.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"parent_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_CREATE_TABLE)});
        this.queryRunner.inTransaction(transactionSession -> {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, List.of(), output -> {}))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessageContaining("Cannot reference properties of table");
            return null;
        });
        this.queryRunner.getAccessControl().reset();
    }

    @Test
    void testUnsupportedCreateTableWithField() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table_unsupported_field_123"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"a", (String[])new String[]{"b"}), TypeSignatureTranslator.toSqlType((Type)DateType.DATE), true, Collections.emptyList(), Optional.empty())), SaveMode.FAIL, (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, Collections.emptyList(), output -> {}))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("Column name 'a.b' must not be qualified");
            return null;
        });
    }

    @Test
    void testCreateTableWithCoercedType() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table_coerced_type"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"a"), TypeSignatureTranslator.toSqlType((Type)TimestampType.TIMESTAMP_NANOS), true, Collections.emptyList(), Optional.empty())), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, List.of(), output -> {}));
            Assertions.assertThat((Object)((ColumnMetadata)this.metadata.getReceivedTableMetadata().get(0).getColumns().get(0)).getType()).isEqualTo((Object)TimestampType.TIMESTAMP_MILLIS);
            return null;
        });
    }

    @Test
    void testCreateTableLikeWithCoercedType() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table_like_coerced_type"), List.of(new LikeClause(QualifiedName.of((String)PARENT_TABLE_WITH_COERCED_TYPE.getTable().getTableName()), Optional.of(LikeClause.PropertiesOption.INCLUDING))), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty());
        this.queryRunner.inTransaction(transactionSession -> {
            MoreFutures.getFutureValue((Future)this.createTableTask.internalExecute(statement, transactionSession, List.of(), output -> {}));
            Assertions.assertThat((int)this.metadata.getCreateTableCallCount()).isEqualTo(1);
            Assertions.assertThat((List)this.metadata.getReceivedTableMetadata().get(0).getColumns()).isEqualTo((Object)ImmutableList.of((Object)new ColumnMetadata("a", (Type)TimestampType.TIMESTAMP_MILLIS)));
            Assertions.assertThat((Map)this.metadata.getReceivedTableMetadata().get(0).getProperties()).isEmpty();
            return null;
        });
    }

    private static CreateTable getCreateLikeStatement(boolean includingProperties) {
        return TestCreateTableTask.getCreateLikeStatement(QualifiedName.of((String)("test_table_" + String.valueOf(ThreadLocalRandom.current().longs(Long.MAX_VALUE)))), includingProperties);
    }

    private static CreateTable getCreateLikeStatement(QualifiedName name, boolean includingProperties) {
        return new CreateTable(name, List.of(new LikeClause(QualifiedName.of((String)PARENT_TABLE.getTable().getTableName()), includingProperties ? Optional.of(LikeClause.PropertiesOption.INCLUDING) : Optional.empty())), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty());
    }

    private static class MockMetadata
    implements ConnectorMetadata {
        private final List<ConnectorTableMetadata> tables = new CopyOnWriteArrayList<ConnectorTableMetadata>();

        private MockMetadata() {
        }

        public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, io.trino.spi.connector.SaveMode saveMode) {
            if (saveMode == io.trino.spi.connector.SaveMode.REPLACE) {
                this.tables.removeIf(table -> table.getTable().equals((Object)tableMetadata.getTable()));
            }
            this.tables.add(tableMetadata);
            if (saveMode == io.trino.spi.connector.SaveMode.FAIL) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table already exists");
            }
        }

        public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
            if (tableName.equals((Object)PARENT_TABLE.getTable()) || tableName.equals((Object)PARENT_TABLE_WITH_COERCED_TYPE.getTable())) {
                return new TestingMetadata.TestingTableHandle(tableName);
            }
            return null;
        }

        public Optional<Type> getSupportedType(ConnectorSession session, Map<String, Object> tableProperties, Type type) {
            if (type instanceof TimestampType) {
                return Optional.of(TimestampType.TIMESTAMP_MILLIS);
            }
            return Optional.empty();
        }

        public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
            if (tableHandle instanceof TestingMetadata.TestingTableHandle) {
                TestingMetadata.TestingTableHandle handle = (TestingMetadata.TestingTableHandle)tableHandle;
                if (handle.getTableName().equals((Object)PARENT_TABLE.getTable())) {
                    return PARENT_TABLE;
                }
                if (handle.getTableName().equals((Object)PARENT_TABLE_WITH_COERCED_TYPE.getTable())) {
                    return PARENT_TABLE_WITH_COERCED_TYPE;
                }
            }
            return super.getTableMetadata(session, tableHandle);
        }

        public int getCreateTableCallCount() {
            return this.tables.size();
        }

        public List<ConnectorTableMetadata> getReceivedTableMetadata() {
            return this.tables;
        }
    }
}

