/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.QueryManagerConfig;
import io.trino.operator.RetryPolicy;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestQueryManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((QueryManagerConfig)ConfigAssertions.recordDefaults(QueryManagerConfig.class)).setMinQueryExpireAge(new Duration(15.0, TimeUnit.MINUTES)).setMaxQueryHistory(100).setMaxQueryLength(1000000).setMaxStageCount(150).setStageCountWarningThreshold(50).setClientTimeout(new Duration(5.0, TimeUnit.MINUTES)).setScheduleSplitBatchSize(1000).setMinScheduleSplitBatchSize(100).setMaxConcurrentQueries(1000).setMaxQueuedQueries(5000).setDeterminePartitionCountForWriteEnabled(false).setMaxHashPartitionCount(100).setMinHashPartitionCount(4).setMinHashPartitionCountForWrite(50).setQueryManagerExecutorPoolSize(5).setQueryExecutorPoolSize(1000).setMaxStateMachineCallbackThreads(5).setMaxSplitManagerCallbackThreads(100).setRemoteTaskMaxErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setRemoteTaskMaxCallbackThreads(1000).setQueryExecutionPolicy("phased").setQueryMaxRunTime(new Duration(100.0, TimeUnit.DAYS)).setQueryMaxExecutionTime(new Duration(100.0, TimeUnit.DAYS)).setQueryMaxPlanningTime(new Duration(10.0, TimeUnit.MINUTES)).setQueryMaxCpuTime(new Duration(1.0E9, TimeUnit.DAYS)).setQueryReportedRuleStatsLimit(10).setDispatcherQueryPoolSize(Math.max(50, Runtime.getRuntime().availableProcessors() * 10)).setQueryMaxScanPhysicalBytes(null).setRequiredWorkers(1).setRequiredWorkersMaxWait(new Duration(5.0, TimeUnit.MINUTES)).setRetryPolicy(RetryPolicy.NONE).setQueryRetryAttempts(4).setTaskRetryAttemptsPerTask(4).setRetryInitialDelay(new Duration(10.0, TimeUnit.SECONDS)).setRetryMaxDelay(new Duration(1.0, TimeUnit.MINUTES)).setRetryDelayScaleFactor(2.0).setMaxTasksWaitingForExecutionPerQuery(10).setMaxTasksWaitingForNodePerStage(5).setEnabledAdaptiveTaskRequestSize(true).setMaxRemoteTaskRequestSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setRemoteTaskRequestSizeHeadroom(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setRemoteTaskGuaranteedSplitPerTask(3).setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthPeriod(64).setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthFactor(1.26).setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMin(DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMax(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthPeriod(64).setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthFactor(1.26).setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMin(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMax(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionHashDistributionComputeTaskTargetSize(DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setFaultTolerantExecutionHashDistributionComputeTasksToNodesMinRatio(2.0).setFaultTolerantExecutionHashDistributionWriteTaskTargetSize(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionHashDistributionWriteTasksToNodesMinRatio(2.0).setFaultTolerantExecutionHashDistributionWriteTaskTargetMaxCount(2000).setFaultTolerantExecutionStandardSplitSize(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setFaultTolerantExecutionMaxTaskSplitCount(256).setFaultTolerantExecutionTaskDescriptorStorageMaxMemory(DataSize.ofBytes((long)Math.round((double)QueryManagerConfig.AVAILABLE_HEAP_MEMORY * 0.15))).setFaultTolerantExecutionMaxPartitionCount(50).setFaultTolerantExecutionMinPartitionCount(4).setFaultTolerantExecutionMinPartitionCountForWrite(50).setFaultTolerantExecutionRuntimeAdaptivePartitioningEnabled(false).setFaultTolerantExecutionRuntimeAdaptivePartitioningMaxTaskSize(DataSize.of((long)12L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionRuntimeAdaptivePartitioningPartitionCount(1000).setFaultTolerantExecutionMinSourceStageProgress(0.2).setFaultTolerantExecutionSmallStageEstimationEnabled(true).setFaultTolerantExecutionSmallStageEstimationThreshold(DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionSmallStageSourceSizeMultiplier(1.2).setFaultTolerantExecutionSmallStageRequireNoMorePartitions(false).setFaultTolerantExecutionStageEstimationForEagerParentEnabled(true).setFaultTolerantExecutionAdaptiveQueryPlanningEnabled(false).setMaxWriterTaskCount(100));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10s").put((Object)"query.min-expire-age", (Object)"30s").put((Object)"query.max-history", (Object)"10").put((Object)"query.max-length", (Object)"10000").put((Object)"query.max-stage-count", (Object)"12345").put((Object)"query.stage-count-warning-threshold", (Object)"12300").put((Object)"query.schedule-split-batch-size", (Object)"99").put((Object)"query.min-schedule-split-batch-size", (Object)"9").put((Object)"query.max-concurrent-queries", (Object)"10").put((Object)"query.max-queued-queries", (Object)"15").put((Object)"query.determine-partition-count-for-write-enabled", (Object)"true").put((Object)"query.max-hash-partition-count", (Object)"16").put((Object)"query.min-hash-partition-count", (Object)"2").put((Object)"query.min-hash-partition-count-for-write", (Object)"88").put((Object)"query.manager-executor-pool-size", (Object)"11").put((Object)"query.executor-pool-size", (Object)"111").put((Object)"query.max-state-machine-callback-threads", (Object)"112").put((Object)"query.max-split-manager-callback-threads", (Object)"113").put((Object)"query.remote-task.max-error-duration", (Object)"60s").put((Object)"query.remote-task.max-callback-threads", (Object)"10").put((Object)"query.execution-policy", (Object)"foo-bar-execution-policy").put((Object)"query.max-run-time", (Object)"2h").put((Object)"query.max-execution-time", (Object)"3h").put((Object)"query.max-planning-time", (Object)"1h").put((Object)"query.max-cpu-time", (Object)"2d").put((Object)"query.reported-rule-stats-limit", (Object)"50").put((Object)"query.dispatcher-query-pool-size", (Object)"151").put((Object)"query.max-scan-physical-bytes", (Object)"1kB").put((Object)"query-manager.required-workers", (Object)"333").put((Object)"query-manager.required-workers-max-wait", (Object)"33m").put((Object)"retry-policy", (Object)"QUERY").put((Object)"query-retry-attempts", (Object)"0").put((Object)"task-retry-attempts-per-task", (Object)"9").put((Object)"retry-initial-delay", (Object)"1m").put((Object)"retry-max-delay", (Object)"1h").put((Object)"retry-delay-scale-factor", (Object)"2.3").put((Object)"max-tasks-waiting-for-execution-per-query", (Object)"22").put((Object)"max-tasks-waiting-for-node-per-stage", (Object)"3").put((Object)"query.remote-task.enable-adaptive-request-size", (Object)"false").put((Object)"query.remote-task.max-request-size", (Object)"10MB").put((Object)"query.remote-task.request-size-headroom", (Object)"1MB").put((Object)"query.remote-task.guaranteed-splits-per-task", (Object)"5").put((Object)"fault-tolerant-execution-arbitrary-distribution-compute-task-target-size-growth-period", (Object)"11").put((Object)"fault-tolerant-execution-arbitrary-distribution-compute-task-target-size-growth-factor", (Object)"2.2").put((Object)"fault-tolerant-execution-arbitrary-distribution-compute-task-target-size-min", (Object)"555MB").put((Object)"fault-tolerant-execution-arbitrary-distribution-compute-task-target-size-max", (Object)"5GB").put((Object)"fault-tolerant-execution-arbitrary-distribution-write-task-target-size-growth-period", (Object)"25").put((Object)"fault-tolerant-execution-arbitrary-distribution-write-task-target-size-growth-factor", (Object)"2.5").put((Object)"fault-tolerant-execution-arbitrary-distribution-write-task-target-size-min", (Object)"6GB").put((Object)"fault-tolerant-execution-arbitrary-distribution-write-task-target-size-max", (Object)"10GB").put((Object)"fault-tolerant-execution-hash-distribution-compute-task-target-size", (Object)"1GB").put((Object)"fault-tolerant-execution-hash-distribution-compute-task-to-node-min-ratio", (Object)"1.1").put((Object)"fault-tolerant-execution-hash-distribution-write-task-target-size", (Object)"7GB").put((Object)"fault-tolerant-execution-hash-distribution-write-task-to-node-min-ratio", (Object)"1.2").put((Object)"fault-tolerant-execution-hash-distribution-write-task-target-max-count", (Object)"5000").put((Object)"fault-tolerant-execution-standard-split-size", (Object)"33MB").put((Object)"fault-tolerant-execution-max-task-split-count", (Object)"22").put((Object)"fault-tolerant-execution-task-descriptor-storage-max-memory", (Object)"3GB").put((Object)"fault-tolerant-execution-max-partition-count", (Object)"123").put((Object)"fault-tolerant-execution-min-partition-count", (Object)"12").put((Object)"fault-tolerant-execution-min-partition-count-for-write", (Object)"99").put((Object)"fault-tolerant-execution-runtime-adaptive-partitioning-enabled", (Object)"true").put((Object)"fault-tolerant-execution-runtime-adaptive-partitioning-partition-count", (Object)"888").put((Object)"fault-tolerant-execution-runtime-adaptive-partitioning-max-task-size", (Object)"18GB").put((Object)"fault-tolerant-execution-min-source-stage-progress", (Object)"0.3").put((Object)"query.max-writer-task-count", (Object)"101").put((Object)"fault-tolerant-execution-small-stage-estimation-enabled", (Object)"false").put((Object)"fault-tolerant-execution-small-stage-estimation-threshold", (Object)"6GB").put((Object)"fault-tolerant-execution-small-stage-source-size-multiplier", (Object)"1.6").put((Object)"fault-tolerant-execution-small-stage-require-no-more-partitions", (Object)"true").put((Object)"fault-tolerant-execution-stage-estimation-for-eager-parent-enabled", (Object)"false").put((Object)"fault-tolerant-execution-adaptive-query-planning-enabled", (Object)"true").buildOrThrow();
        QueryManagerConfig expected = new QueryManagerConfig().setMinQueryExpireAge(new Duration(30.0, TimeUnit.SECONDS)).setMaxQueryHistory(10).setMaxQueryLength(10000).setMaxStageCount(12345).setStageCountWarningThreshold(12300).setClientTimeout(new Duration(10.0, TimeUnit.SECONDS)).setScheduleSplitBatchSize(99).setMinScheduleSplitBatchSize(9).setMaxConcurrentQueries(10).setMaxQueuedQueries(15).setDeterminePartitionCountForWriteEnabled(true).setMaxHashPartitionCount(16).setMinHashPartitionCount(2).setMinHashPartitionCountForWrite(88).setQueryManagerExecutorPoolSize(11).setQueryExecutorPoolSize(111).setMaxStateMachineCallbackThreads(112).setMaxSplitManagerCallbackThreads(113).setRemoteTaskMaxErrorDuration(new Duration(60.0, TimeUnit.SECONDS)).setRemoteTaskMaxCallbackThreads(10).setQueryExecutionPolicy("foo-bar-execution-policy").setQueryMaxRunTime(new Duration(2.0, TimeUnit.HOURS)).setQueryMaxExecutionTime(new Duration(3.0, TimeUnit.HOURS)).setQueryMaxPlanningTime(new Duration(1.0, TimeUnit.HOURS)).setQueryMaxCpuTime(new Duration(2.0, TimeUnit.DAYS)).setQueryReportedRuleStatsLimit(50).setDispatcherQueryPoolSize(151).setQueryMaxScanPhysicalBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setRequiredWorkers(333).setRequiredWorkersMaxWait(new Duration(33.0, TimeUnit.MINUTES)).setRetryPolicy(RetryPolicy.QUERY).setQueryRetryAttempts(0).setTaskRetryAttemptsPerTask(9).setRetryInitialDelay(new Duration(1.0, TimeUnit.MINUTES)).setRetryMaxDelay(new Duration(1.0, TimeUnit.HOURS)).setRetryDelayScaleFactor(2.3).setMaxTasksWaitingForExecutionPerQuery(22).setMaxTasksWaitingForNodePerStage(3).setEnabledAdaptiveTaskRequestSize(false).setMaxRemoteTaskRequestSize(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setRemoteTaskRequestSizeHeadroom(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setRemoteTaskGuaranteedSplitPerTask(5).setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthPeriod(11).setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthFactor(2.2).setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMin(DataSize.of((long)555L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMax(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthPeriod(25).setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthFactor(2.5).setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMin(DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMax(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionHashDistributionComputeTaskTargetSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionHashDistributionComputeTasksToNodesMinRatio(1.1).setFaultTolerantExecutionHashDistributionWriteTaskTargetSize(DataSize.of((long)7L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionHashDistributionWriteTasksToNodesMinRatio(1.2).setFaultTolerantExecutionHashDistributionWriteTaskTargetMaxCount(5000).setFaultTolerantExecutionStandardSplitSize(DataSize.of((long)33L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setFaultTolerantExecutionMaxTaskSplitCount(22).setFaultTolerantExecutionTaskDescriptorStorageMaxMemory(DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionMaxPartitionCount(123).setFaultTolerantExecutionMinPartitionCount(12).setFaultTolerantExecutionMinPartitionCountForWrite(99).setFaultTolerantExecutionRuntimeAdaptivePartitioningEnabled(true).setFaultTolerantExecutionRuntimeAdaptivePartitioningPartitionCount(888).setFaultTolerantExecutionRuntimeAdaptivePartitioningMaxTaskSize(DataSize.of((long)18L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionMinSourceStageProgress(0.3).setFaultTolerantExecutionSmallStageEstimationEnabled(false).setFaultTolerantExecutionSmallStageEstimationThreshold(DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionSmallStageSourceSizeMultiplier(1.6).setFaultTolerantExecutionSmallStageRequireNoMorePartitions(true).setFaultTolerantExecutionStageEstimationForEagerParentEnabled(false).setFaultTolerantExecutionAdaptiveQueryPlanningEnabled(true).setMaxWriterTaskCount(101);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

