/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.scheduler;

import io.trino.execution.executor.scheduler.SchedulingQueue;
import io.trino.execution.executor.scheduler.State;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchedulingQueue {
    @Test
    public void testEmpty() {
        SchedulingQueue queue = new SchedulingQueue();
        Assertions.assertThat((Integer)((Integer)queue.dequeue(1L))).isNull();
    }

    @Test
    public void testSingleGroup() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        queue.enqueue((Object)"G1", (Object)"T1", 1L);
        queue.enqueue((Object)"G1", (Object)"T2", 3L);
        queue.enqueue((Object)"G1", (Object)"T3", 5L);
        queue.enqueue((Object)"G1", (Object)"T4", 7L);
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T2");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T3");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T4");
        queue.enqueue((Object)"G1", (Object)"T1", 10L);
        queue.enqueue((Object)"G1", (Object)"T2", 10L);
        queue.enqueue((Object)"G1", (Object)"T3", 10L);
        queue.enqueue((Object)"G1", (Object)"T4", 10L);
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T2");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T3");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T4");
        queue.enqueue((Object)"G1", (Object)"T1", 16L);
        queue.enqueue((Object)"G1", (Object)"T2", 12L);
        queue.enqueue((Object)"G1", (Object)"T3", 8L);
        queue.enqueue((Object)"G1", (Object)"T4", 4L);
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T4");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T3");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T2");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1");
        queue.finish((Object)"G1", (Object)"T1");
        queue.finish((Object)"G1", (Object)"T2");
        queue.finish((Object)"G1", (Object)"T3");
        queue.finish((Object)"G1", (Object)"T4");
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.BLOCKED);
    }

    @Test
    public void testBasic() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        queue.startGroup((Object)"G2");
        queue.enqueue((Object)"G1", (Object)"T1.0", 1L);
        queue.enqueue((Object)"G1", (Object)"T1.1", 2L);
        queue.enqueue((Object)"G2", (Object)"T2.0", 3L);
        queue.enqueue((Object)"G2", (Object)"T2.1", 4L);
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1.0");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1.1");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T2.0");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T2.1");
        queue.enqueue((Object)"G1", (Object)"T1.0", 10L);
        queue.enqueue((Object)"G1", (Object)"T1.1", 20L);
        queue.enqueue((Object)"G2", (Object)"T2.0", 15L);
        queue.enqueue((Object)"G2", (Object)"T2.1", 5L);
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T2.1");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T2.0");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1.0");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1.1");
        queue.enqueue((Object)"G1", (Object)"T1.0", 100L);
        queue.enqueue((Object)"G2", (Object)"T2.0", 90L);
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T2.0");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1.0");
    }

    @Test
    public void testSomeEmptyGroups() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        queue.startGroup((Object)"G2");
        queue.enqueue((Object)"G2", (Object)"T1", 0L);
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1");
    }

    @Test
    public void testDelayedCreation() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        queue.startGroup((Object)"G2");
        queue.enqueue((Object)"G1", (Object)"T1.0", 100L);
        queue.enqueue((Object)"G2", (Object)"T2.0", 200L);
        queue.startGroup((Object)"G3");
        queue.enqueue((Object)"G3", (Object)"T3.0", 50L);
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1.0");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T3.0");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T2.0");
    }

    @Test
    public void testDelayedCreationWhileAllRunning() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        queue.startGroup((Object)"G2");
        queue.enqueue((Object)"G1", (Object)"T1.0", 0L);
        queue.enqueue((Object)"G2", (Object)"T2.0", 100L);
        queue.dequeue(50L);
        queue.dequeue(50L);
        queue.startGroup((Object)"G3");
        queue.enqueue((Object)"G3", (Object)"T3.0", 10L);
        queue.enqueue((Object)"G1", (Object)"T1.0", 50L);
        queue.enqueue((Object)"G2", (Object)"T2.0", 50L);
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T1.0");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T3.0");
        Assertions.assertThat((String)((String)queue.dequeue(1L))).isEqualTo("T2.0");
    }

    @Test
    public void testGroupState() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.BLOCKED);
        queue.enqueue((Object)"G1", (Object)"T1", 0L);
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNABLE);
        queue.enqueue((Object)"G1", (Object)"T2", 0L);
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNABLE);
        queue.dequeue(1L);
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNABLE);
        queue.dequeue(1L);
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNING);
        queue.block((Object)"G1", (Object)"T1", 1L);
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNING);
        queue.enqueue((Object)"G1", (Object)"T1", 1L);
        queue.block((Object)"G1", (Object)"T2", 1L);
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNABLE);
        queue.dequeue(1L);
        queue.block((Object)"G1", (Object)"T1", 1L);
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.BLOCKED);
        queue.enqueue((Object)"G1", (Object)"T1", 1L);
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNABLE);
    }

    @Test
    public void testNonGreedyDeque() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        queue.startGroup((Object)"G2");
        queue.enqueue((Object)"G1", (Object)"T1.0", 0L);
        queue.enqueue((Object)"G2", (Object)"T2.0", 1L);
        queue.enqueue((Object)"G1", (Object)"T1.1", 2L);
        queue.enqueue((Object)"G1", (Object)"T1.2", 3L);
        queue.enqueue((Object)"G2", (Object)"T2.1", 2L);
        queue.enqueue((Object)"G2", (Object)"T2.2", 3L);
        Assertions.assertThat((String)((String)queue.dequeue(2L))).isEqualTo("T1.0");
        Assertions.assertThat((String)((String)queue.dequeue(2L))).isEqualTo("T2.0");
        Assertions.assertThat((String)((String)queue.dequeue(2L))).isEqualTo("T1.1");
        Assertions.assertThat((String)((String)queue.dequeue(2L))).isEqualTo("T2.1");
        Assertions.assertThat((String)((String)queue.dequeue(2L))).isEqualTo("T1.2");
        Assertions.assertThat((String)((String)queue.dequeue(2L))).isEqualTo("T2.2");
        Assertions.assertThat((String)((String)queue.dequeue(2L))).isNull();
    }

    @Test
    public void testFinishTask() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        queue.enqueue((Object)"G1", (Object)"T1", 0L);
        queue.enqueue((Object)"G1", (Object)"T2", 1L);
        queue.enqueue((Object)"G1", (Object)"T3", 2L);
        Assertions.assertThat((String)((String)queue.peek())).isEqualTo("T1");
        queue.finish((Object)"G1", (Object)"T1");
        Assertions.assertThat((String)((String)queue.peek())).isEqualTo("T2");
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNABLE);
        queue.finish((Object)"G1", (Object)"T2");
        queue.finish((Object)"G1", (Object)"T3");
        Assertions.assertThat((String)((String)queue.peek())).isNull();
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.BLOCKED);
        queue.enqueue((Object)"G1", (Object)"T4", 0L);
        Assertions.assertThat((String)((String)queue.peek())).isEqualTo("T4");
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNABLE);
    }

    @Test
    public void testFinishTaskWhileRunning() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        queue.enqueue((Object)"G1", (Object)"T1", 0L);
        queue.enqueue((Object)"G1", (Object)"T2", 1L);
        queue.enqueue((Object)"G1", (Object)"T3", 2L);
        Assertions.assertThat((String)((String)queue.dequeue(0L))).isEqualTo("T1");
        Assertions.assertThat((String)((String)queue.dequeue(0L))).isEqualTo("T2");
        Assertions.assertThat((String)((String)queue.peek())).isEqualTo("T3");
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNABLE);
        queue.finish((Object)"G1", (Object)"T3");
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNING);
        queue.finish((Object)"G1", (Object)"T1");
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.RUNNING);
        queue.finish((Object)"G1", (Object)"T2");
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.BLOCKED);
    }

    @Test
    public void testFinishTaskWhileBlocked() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        queue.enqueue((Object)"G1", (Object)"T1", 0L);
        queue.enqueue((Object)"G1", (Object)"T2", 1L);
        Assertions.assertThat((String)((String)queue.dequeue(0L))).isEqualTo("T1");
        Assertions.assertThat((String)((String)queue.dequeue(0L))).isEqualTo("T2");
        queue.block((Object)"G1", (Object)"T1", 0L);
        queue.block((Object)"G1", (Object)"T2", 0L);
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.BLOCKED);
        queue.finish((Object)"G1", (Object)"T1");
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.BLOCKED);
        queue.finish((Object)"G1", (Object)"T2");
        Assertions.assertThat((Comparable)queue.state((Object)"G1")).isEqualTo((Object)State.BLOCKED);
    }

    @Test
    public void testFinishGroup() {
        SchedulingQueue queue = new SchedulingQueue();
        queue.startGroup((Object)"G1");
        queue.enqueue((Object)"G1", (Object)"T1.1", 0L);
        Assertions.assertThat((String)((String)queue.peek())).isEqualTo("T1.1");
        queue.startGroup((Object)"G2");
        queue.enqueue((Object)"G2", (Object)"T2.1", 1L);
        Assertions.assertThat((String)((String)queue.peek())).isEqualTo("T1.1");
        queue.finishGroup((Object)"G1");
        Assertions.assertThat((boolean)queue.containsGroup((Object)"G1")).isFalse();
        Assertions.assertThat((String)((String)queue.peek())).isEqualTo("T2.1");
    }
}

