/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestIsNullAnnotation {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalars(TestIsNullAnnotation.class).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @ScalarFunction(value="test_is_null_simple")
    @SqlType(value="bigint")
    public static long testIsNullSimple(@SqlType(value="bigint") long value, @IsNull boolean isNull) {
        if (isNull) {
            return 100L;
        }
        return 2L * value;
    }

    @ScalarFunction(value="test_is_null")
    @SqlType(value="varchar")
    public static Slice testIsNull(ConnectorSession session, @SqlType(value="integer") long longValue, @IsNull boolean isNullLong, @SqlType(value="varchar") Slice varcharNotNullable, @SqlType(value="varchar") @SqlNullable Slice varcharNullable, @SqlType(value="varchar") Slice varcharIsNull, @IsNull boolean isNullVarchar) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"session is null");
        StringBuilder builder = new StringBuilder();
        if (!isNullLong) {
            builder.append(longValue);
        }
        builder.append(":");
        Preconditions.checkArgument((varcharNotNullable != null ? 1 : 0) != 0, (Object)"varcharNotNullable is null while it doesn't has @SqlNullable");
        builder.append(varcharNotNullable.toStringUtf8()).append(":");
        if (varcharNullable != null) {
            builder.append(varcharNullable.toStringUtf8());
        }
        builder.append(":");
        if (!isNullVarchar) {
            builder.append(varcharIsNull.toStringUtf8());
        }
        return Slices.utf8Slice((String)builder.toString());
    }

    @ScalarFunction(value="test_is_null_void")
    @SqlType(value="boolean")
    public static boolean testIsNullVoid(@SqlType(value="unknown") boolean value, @IsNull boolean isNull) {
        return isNull;
    }

    @Test
    public void testIsNull() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_is_null_simple", "-100")))).isEqualTo(-200L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_is_null_simple", "23")))).isEqualTo(46L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_is_null_simple", "null")))).isEqualTo(100L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_is_null_simple", "cast(null as bigint)")))).isEqualTo(100L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_is_null", "23", "'aaa'", "'bbb'", "'ccc'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("23:aaa:bbb:ccc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_is_null", "null", "'aaa'", "'bbb'", "'ccc'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(":aaa:bbb:ccc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_is_null", "null", "'aaa'", "null", "'ccc'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(":aaa::ccc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_is_null", "23", "'aaa'", "null", "null")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("23:aaa::");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_is_null", "23", "null", "'bbb'", "'ccc'")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_is_null_void", "null")))).isEqualTo(true);
    }
}

