/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.trino.SessionTestUtils;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolResolver;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.TestingTransactionManager;
import io.trino.type.UnknownType;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionInterpreter {
    private static final Set<Symbol> SYMBOLS = ImmutableSet.of((Object)new Symbol((Type)IntegerType.INTEGER, "bound_value"), (Object)new Symbol((Type)IntegerType.INTEGER, "unbound_value"));
    private static final SymbolResolver INPUTS = symbol -> {
        if (symbol.name().toLowerCase(Locale.ENGLISH).equals("bound_value")) {
            return Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)1234L));
        }
        return Optional.empty();
    };
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ABS = FUNCTIONS.resolveFunction("abs", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction SUBTRACT_INTEGER = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MULTIPLY_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction DIVIDE_INTEGER = FUNCTIONS.resolveOperator(OperatorType.DIVIDE, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction NEGATION_INTEGER = FUNCTIONS.resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER));

    @Test
    public void testAnd() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)Booleans.TRUE)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)Booleans.FALSE)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)new Constant((Type)BooleanType.BOOLEAN, null))), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)new Constant((Type)BooleanType.BOOLEAN, null))), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)Booleans.TRUE)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)Booleans.FALSE)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null))), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
    }

    @Test
    public void testOr() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.TRUE)), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)Booleans.TRUE)), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)Booleans.FALSE)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)new Constant((Type)BooleanType.BOOLEAN, null))), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)Booleans.TRUE)), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null))), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)new Constant((Type)BooleanType.BOOLEAN, null))), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)Booleans.FALSE)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
    }

    @Test
    public void testComparison() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, null)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.VARCHAR, null), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L)), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)Booleans.FALSE);
    }

    @Test
    public void testIdentical() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new IsNull((Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value")));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value")), (Expression)new IsNull((Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value")));
    }

    @Test
    public void testIsNull() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNull((Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNull((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNull((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (Expression)Booleans.TRUE);
    }

    @Test
    public void testIsNotNull() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Not((Expression)new IsNull((Expression)new Constant((Type)UnknownType.UNKNOWN, null))), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Not((Expression)new IsNull((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Not((Expression)new IsNull((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), (Expression)Booleans.FALSE);
    }

    @Test
    public void testNullIf() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIf((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Expression)new Constant((Type)VarcharType.VARCHAR, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIf((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIf((Expression)new Constant((Type)VarcharType.VARCHAR, null), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))), (Expression)new Constant((Type)VarcharType.VARCHAR, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIf((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, null)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIf((Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new NullIf((Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
    }

    @Test
    public void testNegative() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Call(NEGATION_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)-1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Call(NEGATION_INTEGER, (List)ImmutableList.of((Object)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), (Expression)new Call(NEGATION_INTEGER, (List)ImmutableList.of((Object)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))));
    }

    @Test
    public void testNot() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Not((Expression)Booleans.TRUE), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Not((Expression)Booleans.FALSE), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Not((Expression)new Constant((Type)BooleanType.BOOLEAN, null)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Not((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Not((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))));
    }

    @Test
    public void testFunctionCall() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Call(ABS, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)5L))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Call(ABS, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "unbound_value"))), (Expression)new Call(ABS, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "unbound_value"))));
    }

    @Test
    public void testNonDeterministicFunctionCall() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Call(RANDOM, (List)ImmutableList.of()));
    }

    @Test
    public void testBetween() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Between((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Between((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Between((Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Between((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Between((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Between((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Between((Expression)new Constant((Type)IntegerType.INTEGER, (Object)8L), (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Between((Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1000L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2000L)), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Between((Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Between((Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), IrExpressions.ifExpression((Expression)new Not((Expression)new IsNull((Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"))), (Expression)Booleans.FALSE));
    }

    @Test
    public void testIn() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)9L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, null))), (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)99L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)Booleans.FALSE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new In((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)new In((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L))), (Expression)new In((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new In((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)));
    }

    @Test
    public void testCastOptimization() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Type)VarcharType.VARCHAR), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1234")));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new Cast((Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Type)IntegerType.INTEGER), (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"));
    }

    @Test
    public void testTryCast() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Type)BigintType.BIGINT), (Expression)new Constant((Type)BigintType.BIGINT, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)123L), (Type)BigintType.BIGINT), (Expression)new Constant((Type)BigintType.BIGINT, (Object)123L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Type)IntegerType.INTEGER), (Expression)new Constant((Type)IntegerType.INTEGER, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)123L), (Type)IntegerType.INTEGER), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)123L));
    }

    @Test
    public void testSearchCase() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Reference((Type)IntegerType.INTEGER, "bound_value")), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value")), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")))), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c"))), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")))), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c"))), (Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")))), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c"))), (Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c"))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")))), (Expression)new Constant((Type)VarcharType.VARCHAR, null)), (Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), (Expression)new Constant((Type)VarcharType.VARCHAR, null)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
    }

    @Test
    public void testSimpleCase() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L)), (Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)34L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, null));
        for (Switch aSwitch : Arrays.asList(new Switch((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L)), new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L)), new Switch((Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)))) {
            TestExpressionInterpreter.assertOptimizedEquals((Expression)aSwitch, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        }
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)Booleans.TRUE, (List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Reference((Type)IntegerType.INTEGER, "bound_value"))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)Booleans.TRUE, (List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Reference((Type)IntegerType.INTEGER, "bound_value")), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)Booleans.TRUE, (List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L)), (Expression)new Switch((Expression)Booleans.TRUE, (List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L)));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Expression)new Switch((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, null));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new Switch((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L));
    }

    @Test
    public void testCoalesce() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Coalesce((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Object)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L))))), (Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), new Expression[]{new Constant((Type)IntegerType.INTEGER, null)}), (Expression)new Coalesce((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)6L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new Coalesce((Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), new Expression[0]), (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Coalesce((Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"), new Expression[0]), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new Coalesce((Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Call(RANDOM, (List)ImmutableList.of()), new Expression[]{new Constant((Type)DoubleType.DOUBLE, (Object)5.0)}), (Expression)new Coalesce((Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Call(RANDOM, (List)ImmutableList.of()), new Expression[]{new Constant((Type)DoubleType.DOUBLE, (Object)5.0)}));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Coalesce((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Coalesce((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)UnknownType.UNKNOWN, null), new Expression[0]), new Expression[0]), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Coalesce((Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Coalesce((Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Coalesce((Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, null), new Expression[]{new Constant((Type)IntegerType.INTEGER, (Object)1L)}), new Expression[0]), new Expression[0]), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Coalesce((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), new Expression[0]), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Coalesce((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), new Expression[0]), (Expression)new Coalesce((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Coalesce((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), new Expression[]{new Constant((Type)IntegerType.INTEGER, null)}), (Expression)new Coalesce((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Coalesce((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Coalesce((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), new Expression[0]), new Expression[0]), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Coalesce((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, null), new Expression[]{new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), new Constant((Type)IntegerType.INTEGER, null), new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))}), (Expression)new Coalesce((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Coalesce((Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Call(RANDOM, (List)ImmutableList.of()), new Expression[]{new Constant((Type)DoubleType.DOUBLE, (Object)1.0), new Call(RANDOM, (List)ImmutableList.of())}), (Expression)new Coalesce((Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Call(RANDOM, (List)ImmutableList.of()), new Expression[]{new Constant((Type)DoubleType.DOUBLE, (Object)1.0)}));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new Coalesce((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), new Expression[0]), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new Coalesce((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), new Expression[0]))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testIf() {
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, null));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, null));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, null));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, null));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.TRUE, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.FALSE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)Booleans.FALSE, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)));
        TestExpressionInterpreter.assertEvaluatedEquals(IrExpressions.ifExpression((Expression)Booleans.TRUE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertEvaluatedEquals(IrExpressions.ifExpression((Expression)Booleans.FALSE, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testOptimizeDivideByZero() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testRowSubscript() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Object)Booleans.TRUE)), 2), (Expression)Booleans.TRUE);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FieldReference((Expression)new FieldReference((Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c")))))))), 2), 2), 1), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c")));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)UnknownType.UNKNOWN, null))), 1), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), 0), (Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), 0));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), 1), (Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), 1));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), 1))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), 1))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "unbound_value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), 0), (Expression)new Reference((Type)IntegerType.INTEGER, "unbound_value"));
    }

    private static void assertOptimizedEquals(Expression actual, Expression expected) {
        Assertions.assertThat((Object)TestExpressionInterpreter.optimize(actual)).isEqualTo(TestExpressionInterpreter.optimize(expected));
    }

    private static void assertOptimizedMatches(Expression actual, Expression expected) {
        Expression actualOptimized = (Expression)TestExpressionInterpreter.optimize(actual);
        SymbolAliases.Builder aliases = SymbolAliases.builder();
        for (Symbol symbol : SYMBOLS) {
            aliases.put(symbol.name(), symbol.toSymbolReference());
        }
        ExpressionTestUtils.assertExpressionEquals(actualOptimized, expected, aliases.build());
    }

    static Object optimize(Expression parsedExpression) {
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(parsedExpression, PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION);
        return interpreter.optimize(INPUTS);
    }

    private static void assertEvaluatedEquals(Expression actual, Expression expected) {
        Assertions.assertThat((Object)TestExpressionInterpreter.evaluate(actual)).isEqualTo(TestExpressionInterpreter.evaluate(expected));
    }

    private static Object evaluate(Expression expression) {
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(expression, PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION);
        return interpreter.evaluate();
    }
}

