/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.DynamicFilters;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestDynamicFilter
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction MOD_BIGINT = FUNCTIONS.resolveFunction("mod", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction SUBTRACT_BIGINT = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));

    public TestDynamicFilter() {
        super((Map<String, String>)ImmutableMap.of((Object)"enable_dynamic_filtering", (Object)"true", (Object)"join_reordering_strategy", (Object)OptimizerConfig.JoinReorderingStrategy.NONE.name(), (Object)"join_distribution_type", (Object)OptimizerConfig.JoinDistributionType.BROADCAST.name()));
    }

    @Test
    public void testLeftEquiJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o LEFT JOIN lineitem l ON l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testFullEquiJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o FULL JOIN lineitem l ON l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.FULL, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testRightEquiJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o RIGHT JOIN lineitem l ON l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.RIGHT, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").dynamicFilter((Type)BigintType.BIGINT, "ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testRightEquiJoinWithLeftExpression() {
        this.assertPlan("SELECT o.orderkey FROM orders o RIGHT JOIN lineitem l ON l.orderkey + 1 = o.orderkey", PlanMatchPattern.output(PlanMatchPattern.join(JoinType.RIGHT, builder -> builder.equiCriteria("ORDERS_OK", "expr").dynamicFilter((Type)BigintType.BIGINT, "ORDERS_OK", "expr").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "LINEITEM_OK"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))))));
    }

    @Test
    public void testRightNonEquiJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o RIGHT JOIN lineitem l ON l.orderkey < o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.RIGHT, builder -> builder.left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))).filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "LINEITEM_OK"), (Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"))).dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), Comparison.Operator.GREATER_THAN, "LINEITEM_OK"))))));
    }

    @Test
    public void testEmptyJoinCriteria() {
        this.assertPlan("SELECT o.orderkey FROM orders o CROSS JOIN lineitem l", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.tableScan("orders")).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem"))))));
    }

    @Test
    public void testCrossJoinInequalityDF() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey > l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), Comparison.Operator.GREATER_THAN, "L_ORDERKEY"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testCrossJoinInequalityDFWithConditionReversed() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey < o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), Comparison.Operator.GREATER_THAN, "L_ORDERKEY"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testCrossJoinBetweenDF() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey BETWEEN l.orderkey AND l.partkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_PARTKEY")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), Comparison.Operator.GREATER_THAN_OR_EQUAL, "L_ORDERKEY"), (Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), Comparison.Operator.LESS_THAN_OR_EQUAL, "L_PARTKEY"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_PARTKEY", (Object)"partkey"))))))));
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey BETWEEN l.orderkey AND l.partkey - 1", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY"), (Expression)new Call(SUBTRACT_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "L_PARTKEY"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), Comparison.Operator.GREATER_THAN_OR_EQUAL, "L_ORDERKEY"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_PARTKEY", (Object)"partkey"))))))));
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey BETWEEN l.orderkey + 1 AND l.partkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Expression)new Reference((Type)BigintType.BIGINT, "L_PARTKEY")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), Comparison.Operator.LESS_THAN_OR_EQUAL, "L_PARTKEY"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_PARTKEY", (Object)"partkey"))))))));
    }

    @Test
    public void testCrossJoinInequalityWithCastOnTheLeft() {
        this.assertPlan("SELECT o.comment, l.comment FROM lineitem l, orders o WHERE o.comment < l.comment", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Cast((Expression)new Reference((Type)VarcharType.VARCHAR, "L_COMMENT"), (Type)VarcharType.createVarcharType((int)79)), (Expression)new Reference((Type)VarcharType.createVarcharType((int)79), "O_COMMENT")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern(this.typeOnlyCast("L_COMMENT", (Type)VarcharType.createVarcharType((int)79)), Comparison.Operator.GREATER_THAN, "O_COMMENT", false))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_COMMENT", (Object)"comment")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_COMMENT", (Object)"comment"))))))));
    }

    private Expression typeOnlyCast(String symbol, Type asDataType) {
        return new Cast((Expression)new Symbol((Type)UnknownType.UNKNOWN, symbol).toSymbolReference(), asDataType);
    }

    @Test
    public void testCrossJoinInequalityWithCastOnTheRight() {
        this.assertPlan("SELECT o.comment, l.comment FROM orders o, lineitem l WHERE o.comment < l.comment", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)VarcharType.VARCHAR, "O_COMMENT"), (Expression)new Reference((Type)VarcharType.VARCHAR, "expr")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)VarcharType.VARCHAR, "O_COMMENT"), Comparison.Operator.LESS_THAN, "expr"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_COMMENT", (Object)"comment")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)VarcharType.VARCHAR, "L_COMMENT"), (Type)VarcharType.createVarcharType((int)79)))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_COMMENT", (Object)"comment"))))))))));
    }

    @Test
    public void testJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").dynamicFilter((Type)BigintType.BIGINT, "ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testInnerJoinWithConditionReversed() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey = l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").dynamicFilter((Type)BigintType.BIGINT, "ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testIsNotDistinctFromJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey IS NOT DISTINCT FROM o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), Comparison.Operator.EQUAL, "L_ORDERKEY", true))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))))));
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey IS DISTINCT FROM o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Not((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY"))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))))));
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.extendedprice IS NOT DISTINCT FROM o.totalprice", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "O_TOTALPRICE"), (Expression)new Reference((Type)DoubleType.DOUBLE, "L_EXTENDEDPRICE")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_TOTALPRICE", (Object)"totalprice"))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_EXTENDEDPRICE", (Object)"extendedprice"))))))));
    }

    @Test
    public void testNotDistinctFromLeftJoin() {
        this.assertPlan("SELECT 1 FROM (SELECT o.orderkey FROM nation n LEFT JOIN orders o ON n.nationkey = o.orderkey) o JOIN lineitem l ON o.orderkey IS NOT DISTINCT FROM l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.join(JoinType.LEFT, leftJoinBuilder -> leftJoinBuilder.equiCriteria("nationkey", "ORDERS_OK").left(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
        this.assertPlan("SELECT 1 FROM (SELECT o.orderkey FROM nation n LEFT JOIN orders o ON n.nationkey = o.orderkey) o JOIN lineitem l ON o.orderkey = l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("nationkey", "LINEITEM_OK").left(PlanMatchPattern.join(JoinType.INNER, leftJoinBuilder -> leftJoinBuilder.equiCriteria("nationkey", "ORDERS_OK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testJoinOnCast() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE cast(l.orderkey as int) = cast(o.orderkey as int)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("expr_orders", "expr_lineitem").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_orders", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), (Type)IntegerType.INTEGER))), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_lineitem", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "LINEITEM_OK"), (Type)IntegerType.INTEGER))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))))));
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = cast(o.orderkey as int)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("expr_orders", "LINEITEM_OK").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_orders", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), (Type)IntegerType.INTEGER), (Type)BigintType.BIGINT))), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testJoinImplicitCoercions() {
        this.assertPlan("SELECT o.orderkey FROM lineitem l, orders o WHERE l.linenumber = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("expr_linenumber", "ORDERS_OK").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_linenumber", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)IntegerType.INTEGER, "LINEITEM_LN"), (Type)BigintType.BIGINT))), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_LN", (Object)"linenumber"))).with(this.numberOfDynamicFilters(1)))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testJoinMultipleEquiJoinClauses() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey AND l.partkey = o.custkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK"), PlanMatchPattern.equiJoinClause("ORDERS_CK", "LINEITEM_PK"))).dynamicFilter((Map<Expression, String>)ImmutableMap.of((Object)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), (Object)"LINEITEM_OK", (Object)new Reference((Type)BigintType.BIGINT, "ORDERS_CK"), (Object)"LINEITEM_PK")).left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey", (Object)"ORDERS_CK", (Object)"custkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey", (Object)"LINEITEM_PK", (Object)"partkey")))))));
    }

    @Test
    public void testJoinWithOrderBySameKey() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey ORDER BY l.orderkey ASC, o.orderkey ASC", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDERS_OK", "LINEITEM_OK").dynamicFilter((Type)BigintType.BIGINT, "ORDERS_OK", "LINEITEM_OK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testUncorrelatedSubqueries() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey = (SELECT orderkey FROM lineitem ORDER BY orderkey LIMIT 1)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("X", "Y").dynamicFilter((Type)BigintType.BIGINT, "X", "Y").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")))).right(PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
    }

    @Test
    public void testInnerInequalityJoinWithEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("O_SHIPPRIORITY", "L_LINENUMBER").filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY"))).dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)VarcharType.createVarcharType((int)1), "O_SHIPPRIORITY"), Comparison.Operator.EQUAL, "L_LINENUMBER"), (Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), Comparison.Operator.LESS_THAN, "L_ORDERKEY"))).left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testSubTreeJoinDFOnProbeSide() {
        this.assertPlan("SELECT part.partkey from part JOIN (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) ON part.partkey = lineitem.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("PART_PK", "LINEITEM_OK").dynamicFilter((Type)BigintType.BIGINT, "PART_PK", "LINEITEM_OK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"partkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, rightJoinBuilder -> rightJoinBuilder.equiCriteria("LINEITEM_OK", "ORDERS_OK").dynamicFilter((Type)BigintType.BIGINT, "LINEITEM_OK", "ORDERS_OK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))))))))));
    }

    @Test
    public void testSubTreeJoinDFOnBuildSide() {
        this.assertPlan("SELECT part.partkey from (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) JOIN part ON lineitem.orderkey = part.partkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("LINEITEM_OK", "PART_PK").dynamicFilter((Map<Expression, String>)ImmutableMap.of((Object)new Reference((Type)BigintType.BIGINT, "LINEITEM_OK"), (Object)"PART_PK", (Object)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), (Object)"PART_PK")).left(PlanMatchPattern.join(JoinType.INNER, leftJoinBuilder -> leftJoinBuilder.equiCriteria("LINEITEM_OK", "ORDERS_OK").dynamicFilter((Type)BigintType.BIGINT, "LINEITEM_OK", "ORDERS_OK").left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))).with(this.numberOfDynamicFilters(2))).right(PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).with(this.numberOfDynamicFilters(1)))))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"partkey")))))));
    }

    @Test
    public void testNestedDynamicFiltersRemoval() {
        this.assertPlan("WITH t AS (  SELECT o.clerk FROM (    (orders o LEFT JOIN orders o1 ON o1.clerk = o.clerk)       LEFT JOIN orders o2 ON o2.clerk = o1.clerk)) SELECT t.clerk FROM orders o3 JOIN t ON t.clerk = o3.clerk", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDERS_CK", "ORDERS_CK6").dynamicFilter((Type)BigintType.BIGINT, "ORDERS_CK", "ORDERS_CK6").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_CK", (Object)"clerk")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, rightJoinBuilder -> rightJoinBuilder.equiCriteria("ORDERS_CK16", "ORDERS_CK27").left(PlanMatchPattern.join(JoinType.LEFT, leftJoinBuilder -> leftJoinBuilder.equiCriteria("ORDERS_CK6", "ORDERS_CK16").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_CK6", (Object)"clerk"))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_CK16", (Object)"clerk")))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_CK27", (Object)"clerk"))))))))));
    }

    @Test
    public void testNonPushedDownJoinFilterRemoval() {
        this.assertPlan("SELECT 1 FROM part t0, part t1, part t2 WHERE t0.partkey = t1.partkey AND t0.partkey = t2.partkey AND t0.size + t1.size = t2.size", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("K0", "K2"), PlanMatchPattern.equiJoinClause("S", "V2"))).left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"S", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "V0"), (Object)new Reference((Type)BigintType.BIGINT, "V1"))))), PlanMatchPattern.join(JoinType.INNER, leftJoinBuilder -> leftJoinBuilder.equiCriteria("K0", "K1").dynamicFilter((Type)BigintType.BIGINT, "K0", "K1").left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"K0", (Object)"partkey", (Object)"V0", (Object)"size"))).with(this.numberOfDynamicFilters(2))).right(PlanMatchPattern.exchange(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"K1", (Object)"partkey", (Object)"V1", (Object)"size"))).with(this.numberOfDynamicFilters(1))))))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"K2", (Object)"partkey", (Object)"V2", (Object)"size")))))));
    }

    @Test
    public void testSemiJoin() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "S"), PlanMatchPattern.semiJoin("X", "Y", "S", true, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey")))))));
    }

    @Test
    public void testNonFilteringSemiJoin() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey NOT IN (SELECT orderkey FROM lineitem WHERE linenumber < 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Not((Expression)new Reference((Type)BooleanType.BOOLEAN, "S")), PlanMatchPattern.semiJoin("X", "Y", "S", false, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey")))))));
        this.assertPlan("SELECT orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber < 0) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("X", "Y", "S", false, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))));
    }

    @Test
    public void testSemiJoinWithStaticFiltering() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0) AND orderkey > 0", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "S"), PlanMatchPattern.semiJoin("X", "Y", "S", true, PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "X"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey")))))));
    }

    @Test
    public void testMultiSemiJoin() {
        this.assertPlan("SELECT part.partkey FROM part WHERE part.partkey IN (SELECT lineitem.partkey FROM lineitem WHERE lineitem.orderkey IN (SELECT orders.orderkey FROM orders))", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "S0"), PlanMatchPattern.semiJoin("PART_PK", "LINEITEM_PK", "S0", true, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "S1"), PlanMatchPattern.project(PlanMatchPattern.semiJoin("LINEITEM_OK", "ORDERS_OK", "S1", true, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_PK", (Object)"partkey", (Object)"LINEITEM_OK", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))))))));
    }

    @Test
    public void testSemiJoinUnsupportedDynamicFilterRemoval() {
        this.assertPlan("WITH t AS (SELECT lineitem.partkey + 1000 partkey FROM lineitem) SELECT t.partkey FROM t WHERE t.partkey IN (SELECT part.partkey FROM part)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "S0"), PlanMatchPattern.semiJoin("LINEITEM_PK_PLUS_1000", "PART_PK", "S0", false, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"LINEITEM_PK_PLUS_1000", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "LINEITEM_PK"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1000L))))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_PK", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"partkey")))))));
    }

    @Test
    public void testExpressionPushedDownToLeftJoinSourceWhenUsingOn() {
        this.assertPlan("SELECT o.orderkey FROM orders o JOIN lineitem l ON o.orderkey + 1 < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "expr"), (Expression)new Reference((Type)BigintType.BIGINT, "LINEITEM_OK")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))))));
    }

    @Test
    public void testExpressionPushedDownToRightJoinSourceWhenUsingOn() {
        this.assertPlan("SELECT o.orderkey FROM orders o JOIN lineitem l ON o.orderkey < l.orderkey + 1", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), (Expression)new Reference((Type)BigintType.BIGINT, "expr")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), Comparison.Operator.LESS_THAN, "expr"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "LINEITEM_OK"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))))));
    }

    @Test
    public void testExpressionNotPushedDownToLeftJoinSource() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey + 1 < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Expression)new Reference((Type)BigintType.BIGINT, "LINEITEM_OK")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))))));
    }

    @Test
    public void testExpressionPushedDownToRightJoinSource() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey < l.orderkey + 1", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), (Expression)new Reference((Type)BigintType.BIGINT, "expr")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_OK"), Comparison.Operator.LESS_THAN, "expr"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "LINEITEM_OK"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))))));
    }

    @Test
    public void testDynamicFilterAliasDeDuplicated() {
        this.assertPlan("SELECT f.name FROM supplier f, nation d WHERE f.nationkey >= mod(d.nationkey, 2) AND f.suppkey >= mod(d.nationkey, 2)", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), (Expression)new Reference((Type)BigintType.BIGINT, "mod")), (Object)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "suppkey"), (Expression)new Reference((Type)BigintType.BIGINT, "mod")))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "nationkey"), Comparison.Operator.GREATER_THAN_OR_EQUAL, "mod"), (Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "suppkey"), Comparison.Operator.GREATER_THAN_OR_EQUAL, "mod"))).left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey", (Object)"suppkey", (Object)"suppkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mod", (Object)PlanMatchPattern.expression((Expression)new Call(MOD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "n_nationkey"), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_nationkey", (Object)"nationkey")))))))));
    }

    private Matcher numberOfDynamicFilters(final int numberOfDynamicFilters) {
        return new Matcher(){

            @Override
            public boolean shapeMatches(PlanNode node) {
                return node instanceof FilterNode;
            }

            @Override
            public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
                FilterNode filterNode = (FilterNode)node;
                return new MatchResult(DynamicFilters.extractDynamicFilters((Expression)filterNode.getPredicate()).getDynamicConjuncts().size() == numberOfDynamicFilters);
            }
        };
    }

    private Session noSemiJoinRewrite() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("rewrite_filtering_semi_join_to_inner_join", "false").build();
    }
}

