/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.SymbolAliases;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionVerifier {
    @Test
    public void test() {
        Not actual = new Not((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "orderkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "custkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "orderkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)10L)))));
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new Reference((Type)IntegerType.INTEGER, "orderkey")).put("Y", new Reference((Type)IntegerType.INTEGER, "custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)actual, new Not((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "Y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)10L)))))))).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestExpressionVerifier.lambda$test$0(verifier, (Expression)actual)).isInstanceOf(IllegalStateException.class)).hasMessage("missing expression for alias Z");
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)actual, new Not((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)10L)))))))).isFalse();
    }

    @Test
    public void testCast() {
        SymbolAliases aliases = SymbolAliases.builder().put("X", new Reference((Type)BigintType.BIGINT, "orderkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(aliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2")), new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2")), new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2")), (Type)BigintType.BIGINT)))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "orderkey"), (Type)VarcharType.VARCHAR), new Cast((Expression)new Reference((Type)BigintType.BIGINT, "X"), (Type)VarcharType.VARCHAR)))).isTrue();
    }

    @Test
    public void testBetween() {
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new Reference((Type)BigintType.BIGINT, "orderkey")).put("Y", new Reference((Type)BigintType.BIGINT, "custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), new Between((Expression)new Reference((Type)BigintType.BIGINT, "X"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), new Between((Expression)new Reference((Type)BigintType.BIGINT, "Y"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "custkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), new Between((Expression)new Reference((Type)BigintType.BIGINT, "X"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L))))).isFalse();
    }

    @Test
    public void testSymmetry() {
        SymbolAliases symbolAliases = SymbolAliases.builder().put("a", new Reference((Type)BigintType.BIGINT, "x")).put("b", new Reference((Type)BigintType.BIGINT, "y")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")), new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isTrue();
    }

    private static /* synthetic */ void lambda$test$0(ExpressionVerifier verifier, Expression actual) throws Throwable {
        verifier.process(actual, new Not((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "Y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "Z"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)10L))))));
    }
}

