/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ExtractDereferencesFromFilterAboveScan;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughFilter;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughJoin;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughProject;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughSemiJoin;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughUnnest;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughAssignUniqueId;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughLimit;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughMarkDistinct;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughRowNumber;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughSort;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughTopN;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughTopNRanking;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughWindow;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.SortItem;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingTransactionHandle;
import io.trino.type.JsonType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;

public class TestPushDownDereferencesRules
extends BaseRuleTest {
    private static final RowType ROW_TYPE = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));

    public TestPushDownDereferencesRules() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughFilter()).on(p -> p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (PlanNode)p.values(p.symbol("x")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughProject()).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr_1", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)BigintType.BIGINT), RowType.field((String)"y", (Type)BigintType.BIGINT)})), (Expression)new FieldReference((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Reference((Type)ROW_TYPE, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"f1", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)BigintType.BIGINT), RowType.field((String)"y", (Type)BigintType.BIGINT)})), RowType.field((String)"f2", (Type)BigintType.BIGINT)})), 0), (Symbol)p.symbol("expr_2"), (Expression)new FieldReference((Expression)new FieldReference((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Reference((Type)ROW_TYPE, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"f1", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)BigintType.BIGINT), RowType.field((String)"y", (Type)BigintType.BIGINT)})), RowType.field((String)"f2", (Type)BigintType.BIGINT)})), 0), 1)), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a", (Type)ROW_TYPE), (Expression)new Reference((Type)ROW_TYPE, "a"), (Symbol)p.symbol("b"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), (PlanNode)p.values(p.symbol("a", (Type)ROW_TYPE), p.symbol("b"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughProject()).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr", (Type)ROW_TYPE), (Expression)new Reference((Type)ROW_TYPE, "a"), (Symbol)p.symbol("a_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "a"), 0)), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a", (Type)ROW_TYPE), (Expression)new Reference((Type)ROW_TYPE, "a")), (PlanNode)p.values(p.symbol("a", (Type)ROW_TYPE))))).doesNotFire();
    }

    @Test
    public void testPushdownDereferenceThroughProject() {
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughProject()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 0)), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("y"), (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Symbol)p.symbol("msg", (Type)ROW_TYPE), (Expression)new Reference((Type)ROW_TYPE, "msg")), (PlanNode)p.values(p.symbol("msg", (Type)ROW_TYPE), p.symbol("y"))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "msg_x"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 0)), (Object)"y", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "y")), (Object)"msg", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "msg"))), PlanMatchPattern.values("msg", "y"))));
    }

    @Test
    public void testPushDownDereferenceThroughJoin() {
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughJoin()).on(p -> p.project(Assignments.builder().put(p.symbol("left_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)).put(p.symbol("right_y"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 1)).put(p.symbol("z"), (Expression)new Reference((Type)BigintType.BIGINT, "z")).build(), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("unreferenced_symbol")), (PlanNode)p.values(p.symbol("msg2", (Type)ROW_TYPE), p.symbol("z")), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"left_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "x"))).put((Object)"right_y", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "y"))).put((Object)"z", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "z"))).buildOrThrow(), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)), (Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1")), (Object)"unreferenced_symbol", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "unreferenced_symbol"))), PlanMatchPattern.values("msg1", "unreferenced_symbol"))).right(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"y", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 1))).put((Object)"z", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "z"))).put((Object)"msg2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))).buildOrThrow(), PlanMatchPattern.values("msg2", "z"))))));
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughJoin()).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr", ((RowType.Field)ROW_TYPE.getFields().get(0)).getType()), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0), (Symbol)p.symbol("expr_2", (Type)ROW_TYPE), (Expression)new Reference((Type)ROW_TYPE, "msg2")), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg2", (Type)ROW_TYPE)), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0), (Object)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 1))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)), new JoinNode.EquiJoinClause[0]))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "msg1_x")), (Object)"expr_2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "msg1_x"), (Object)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 1))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L))).left(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg1_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)), (Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1"))), PlanMatchPattern.values("msg1"))).right(PlanMatchPattern.values("msg2")))));
    }

    @Test
    public void testPushdownDereferencesThroughSemiJoin() {
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughSemiJoin()).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)).put(p.symbol("msg2_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0)).build(), (PlanNode)p.semiJoin(p.symbol("msg2", (Type)ROW_TYPE), p.symbol("filtering_msg", (Type)ROW_TYPE), p.symbol("match"), Optional.empty(), Optional.empty(), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("filtering_msg", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expr"))).put((Object)"msg2_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0))).buildOrThrow(), PlanMatchPattern.semiJoin("msg2", "filtering_msg", "match", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)), (Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1")), (Object)"msg2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))), PlanMatchPattern.values("msg1", "msg2")), PlanMatchPattern.values("filtering_msg"))));
    }

    @Test
    public void testPushdownDereferencesThroughUnnest() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughUnnest()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 0)), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)p.symbol("msg", (Type)ROW_TYPE)), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("arr", (Type)arrayType), (List)ImmutableList.of((Object)p.symbol("field")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values(p.symbol("msg", (Type)ROW_TYPE), p.symbol("arr", (Type)arrayType))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "msg_x"))), PlanMatchPattern.unnest(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 0)), (Object)"msg", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg")), (Object)"arr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)arrayType, "arr"))), PlanMatchPattern.values("msg", "arr")))));
        RowType rowType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"f1", (Type)BigintType.BIGINT), RowType.field((String)"f2", (Type)BigintType.BIGINT)});
        ArrayType nestedColumnType = new ArrayType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"f1", (Type)BigintType.BIGINT), RowType.field((String)"f2", (Type)rowType)}));
        ResolvedFunction subscript = FUNCTIONS.resolveOperator(OperatorType.SUBSCRIPT, (List<? extends Type>)ImmutableList.of((Object)nestedColumnType, (Object)BigintType.BIGINT));
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughUnnest()).on(p -> p.project(Assignments.of((Symbol)p.symbol("deref_replicate", ((RowType.Field)rowType.getFields().get(1)).getType()), (Expression)new FieldReference((Expression)new Reference((Type)rowType, "replicate"), 1), (Symbol)p.symbol("deref_unnest", nestedColumnType.getElementType()), (Expression)new Call(subscript, (List)ImmutableList.of((Object)new Reference((Type)nestedColumnType, "unnested_row"), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L)))), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)p.symbol("replicate", (Type)rowType)), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("nested", (Type)nestedColumnType), (List)ImmutableList.of((Object)p.symbol("unnested_bigint", (Type)BigintType.BIGINT), (Object)p.symbol("unnested_row", (Type)rowType)))), (PlanNode)p.values(p.symbol("replicate", (Type)rowType), p.symbol("nested", (Type)nestedColumnType))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"deref_replicate", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "symbol")), (Object)"deref_unnest", (Object)PlanMatchPattern.expression((Expression)new Call(subscript, (List)ImmutableList.of((Object)new Reference((Type)nestedColumnType, "unnested_row"), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"replicate", (Object)"symbol"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("nested", (List<String>)ImmutableList.of((Object)"unnested_bigint", (Object)"unnested_row"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"symbol", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)rowType, "replicate"), 1)), (Object)"replicate", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)rowType, "replicate")), (Object)"nested", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)nestedColumnType, "nested"))), PlanMatchPattern.values("replicate", "nested")))));
    }

    @Test
    public void testExtractDereferencesFromFilterAboveScan() {
        TableHandle testTable = new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new TpchTableHandle("sf1", "orders", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        RowType nestedRowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("nested"), (Type)ROW_TYPE)));
        this.tester().assertThat((Rule<?>)new ExtractDereferencesFromFilterAboveScan()).on(p -> p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new FieldReference((Expression)new FieldReference((Expression)new Reference((Type)nestedRowType, "a"), 0), 0), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "b"), 1), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), (Object)new Not((Expression)new IsNull((Expression)new Cast((Expression)new FieldReference((Expression)new Reference((Type)nestedRowType, "a"), 0), (Type)JsonType.JSON))))), (PlanNode)p.tableScan(testTable, (List<Symbol>)ImmutableList.of((Object)p.symbol("a", (Type)nestedRowType), (Object)p.symbol("b", (Type)ROW_TYPE)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("a", (Type)nestedRowType), (Object)new TpchColumnHandle("a", (Type)nestedRowType), (Object)p.symbol("b", (Type)ROW_TYPE), (Object)new TpchColumnHandle("b", (Type)ROW_TYPE))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "expr"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "expr_0"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), (Object)new Not((Expression)new IsNull((Expression)new Cast((Expression)new Reference((Type)ROW_TYPE, "expr_1"), (Type)JsonType.JSON))))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new FieldReference((Expression)new Reference((Type)nestedRowType, "a"), 0), 0)), (Object)"expr_0", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "b"), 1)), (Object)"expr_1", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)nestedRowType, "a"), 0)), (Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)nestedRowType, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "b"))), PlanMatchPattern.tableScan(arg_0 -> ((ConnectorTableHandle)testTable.connectorHandle()).equals(arg_0), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"a", arg_0 -> ((TpchColumnHandle)new TpchColumnHandle("a", (Type)nestedRowType)).equals(arg_0), (Object)"b", arg_0 -> ((TpchColumnHandle)new TpchColumnHandle("b", (Type)ROW_TYPE)).equals(arg_0)))))));
    }

    @Test
    public void testPushdownDereferenceThroughFilter() {
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughFilter()).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr", (Type)BigintType.BIGINT), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 0), (Symbol)p.symbol("expr_2", (Type)BigintType.BIGINT), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0)), (PlanNode)p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 0), (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L)), (Object)new Not((Expression)new IsNull((Expression)new Reference((Type)ROW_TYPE, "msg2"))))), (PlanNode)p.values(p.symbol("msg", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "msg_x")), (Object)"expr_2", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0))), PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "msg_x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L)), (Object)new Not((Expression)new IsNull((Expression)new Reference((Type)ROW_TYPE, "msg2"))))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 0)), (Object)"msg", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg")), (Object)"msg2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))), PlanMatchPattern.values("msg", "msg2")))));
    }

    @Test
    public void testPushDownDereferenceThroughLimit() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughLimit()).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)).put(p.symbol("msg2_y"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 1)).put(p.symbol("z"), (Expression)new Reference((Type)BigintType.BIGINT, "z")).build(), (PlanNode)p.limit(10L, (List<Symbol>)ImmutableList.of((Object)p.symbol("msg2", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE), p.symbol("z"))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "x"))).put((Object)"msg2_y", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 1))).put((Object)"z", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "z"))).buildOrThrow(), PlanMatchPattern.limit(10L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("msg2", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0))).put((Object)"z", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "z"))).put((Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1"))).put((Object)"msg2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))).buildOrThrow(), PlanMatchPattern.values("msg1", "msg2", "z")))));
    }

    @Test
    public void testPushDownDereferenceThroughLimitWithPreSortedInputs() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughLimit()).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)).put(p.symbol("msg2_y"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 1)).put(p.symbol("z"), (Expression)new Reference((Type)BigintType.BIGINT, "z")).build(), (PlanNode)p.limit(10L, false, (List<Symbol>)ImmutableList.of((Object)p.symbol("msg2", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE), p.symbol("z"))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "x"))).put((Object)"msg2_y", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 1))).put((Object)"z", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "z"))).buildOrThrow(), PlanMatchPattern.limit(10L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), false, (List<String>)ImmutableList.of((Object)"msg2"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0))).put((Object)"z", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "z"))).put((Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1"))).put((Object)"msg2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))).buildOrThrow(), PlanMatchPattern.values("msg1", "msg2", "z")))));
    }

    @Test
    public void testPushDownDereferenceThroughSort() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughSort()).on(p -> p.project(Assignments.builder().put(p.symbol("msg_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 0)).put(p.symbol("msg_y"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 1)).put(p.symbol("z"), (Expression)new Reference((Type)BigintType.BIGINT, "z")).build(), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)p.symbol("z"), (Object)p.symbol("msg", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg", (Type)ROW_TYPE), p.symbol("z"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughSort()).on(p -> p.project(Assignments.builder().put(p.symbol("msg_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 0)).put(p.symbol("z"), (Expression)new Reference((Type)BigintType.BIGINT, "z")).build(), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)p.symbol("z")), (PlanNode)p.values(p.symbol("msg", (Type)ROW_TYPE), p.symbol("z"))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "x"))).put((Object)"z", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "z"))).buildOrThrow(), PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("z", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg"), 0))).put((Object)"z", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "z"))).put((Object)"msg", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg"))).buildOrThrow(), PlanMatchPattern.values("msg", "z")))));
    }

    @Test
    public void testPushdownDereferenceThroughRowNumber() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughRowNumber()).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)).put(p.symbol("msg2_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0)).build(), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)p.symbol("msg1", (Type)ROW_TYPE)), Optional.empty(), p.symbol("row_number"), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0))).put((Object)"msg2_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expr"))).buildOrThrow(), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"msg1")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0))).put((Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1"))).put((Object)"msg2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))).buildOrThrow(), PlanMatchPattern.values("msg1", "msg2")))));
    }

    @Test
    public void testPushdownDereferenceThroughTopNRanking() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughTopNRanking()).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)).put(p.symbol("msg2_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0)).put(p.symbol("msg3_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg3"), 0)).build(), (PlanNode)p.topNRanking(new DataOrganizationSpecification((List)ImmutableList.of((Object)p.symbol("msg1", (Type)ROW_TYPE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("msg2", (Type)ROW_TYPE)), (Map)ImmutableMap.of((Object)p.symbol("msg2", (Type)ROW_TYPE), (Object)SortOrder.ASC_NULLS_FIRST)))), TopNRankingNode.RankingType.ROW_NUMBER, 5, p.symbol("ranking"), Optional.empty(), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE), p.symbol("msg3", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0))).put((Object)"msg2_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0))).put((Object)"msg3_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expr"))).buildOrThrow(), PlanMatchPattern.topNRanking(pattern -> pattern.specification(Collections.singletonList("msg1"), Collections.singletonList("msg2"), (Map<String, SortOrder>)ImmutableMap.of((Object)"msg2", (Object)SortOrder.ASC_NULLS_FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg3"), 0))).put((Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1"))).put((Object)"msg2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))).put((Object)"msg3", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg3"))).buildOrThrow(), PlanMatchPattern.values("msg1", "msg2", "msg3")))));
    }

    @Test
    public void testPushdownDereferenceThroughTopN() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughTopN()).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)).put(p.symbol("msg2_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0)).build(), (PlanNode)p.topN(5L, (List<Symbol>)ImmutableList.of((Object)p.symbol("msg1", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0))).put((Object)"msg2_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expr"))).buildOrThrow(), PlanMatchPattern.topN(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("msg1", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0))).put((Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1"))).put((Object)"msg2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))).buildOrThrow(), PlanMatchPattern.values("msg1", "msg2")))));
    }

    @Test
    public void testPushdownDereferenceThroughWindow() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughWindow()).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)).put(p.symbol("msg2_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0)).put(p.symbol("msg3_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg3"), 0)).put(p.symbol("msg4_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg4"), 0)).put(p.symbol("msg5_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg5"), 0)).build(), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)p.symbol("msg1", (Type)ROW_TYPE)), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("msg2", (Type)ROW_TYPE)), (Map)ImmutableMap.of((Object)p.symbol("msg2", (Type)ROW_TYPE), (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("msg6", (Type)ROW_TYPE), (Object)new WindowNode.Function(MetadataManager.createTestMetadataManager().resolveBuiltinFunction("min", TypeSignatureProvider.fromTypes((Type[])new Type[]{ROW_TYPE})), (List)ImmutableList.of((Object)p.symbol("msg3", (Type)ROW_TYPE).toSymbolReference()), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty()), true)), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE), p.symbol("msg3", (Type)ROW_TYPE), p.symbol("msg4", (Type)ROW_TYPE), p.symbol("msg5", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0))).put((Object)"msg2_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0))).put((Object)"msg3_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg3"), 0))).put((Object)"msg4_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expr"))).put((Object)"msg5_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expr2"))).buildOrThrow(), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(Collections.singletonList("msg1"), Collections.singletonList("msg2"), (Map<String, SortOrder>)ImmutableMap.of((Object)"msg2", (Object)SortOrder.ASC_NULLS_FIRST)).addFunction(PlanMatchPattern.windowFunction("min", Collections.singletonList("msg3"), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1"))).put((Object)"msg2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))).put((Object)"msg3", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg3"))).put((Object)"msg4", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg4"))).put((Object)"msg5", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg5"))).put((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg4"), 0))).put((Object)"expr2", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg5"), 0))).buildOrThrow(), PlanMatchPattern.values("msg1", "msg2", "msg3", "msg4", "msg5")))));
    }

    @Test
    public void testPushdownDereferenceThroughAssignUniqueId() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughAssignUniqueId()).on(p -> p.project(Assignments.builder().put(p.symbol("expr"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)).build(), (PlanNode)p.assignUniqueId(p.symbol("unique"), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "msg1_x"))), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1"))).put((Object)"msg1_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0))).buildOrThrow(), PlanMatchPattern.values("msg1")))));
    }

    @Test
    public void testPushdownDereferenceThroughMarkDistinct() {
        this.tester().assertThat((Rule<?>)new PushDownDereferencesThroughMarkDistinct()).on(p -> p.project(Assignments.builder().put(p.symbol("msg1_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0)).put(p.symbol("msg2_x"), (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0)).build(), (PlanNode)p.markDistinct(p.symbol("is_distinct", (Type)BooleanType.BOOLEAN), Collections.singletonList(p.symbol("msg2", (Type)ROW_TYPE)), (PlanNode)p.values(p.symbol("msg1", (Type)ROW_TYPE), p.symbol("msg2", (Type)ROW_TYPE))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg1_x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expr")), (Object)"msg2_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg2"), 0))), PlanMatchPattern.markDistinct("is_distinct", Collections.singletonList("msg2"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"msg1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg1"))).put((Object)"msg2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)ROW_TYPE, "msg2"))).put((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "msg1"), 0))).buildOrThrow(), PlanMatchPattern.values("msg1", "msg2")))));
    }

    @Test
    public void testMultiLevelPushdown() {
        RowType complexType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"f1", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"f1", (Type)BigintType.BIGINT), RowType.field((String)"f2", (Type)BigintType.BIGINT)})), RowType.field((String)"f2", (Type)BigintType.BIGINT)});
        this.tester().assertThat((Rule<?>)new PushDownDereferenceThroughProject()).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr_1", ((RowType.Field)complexType.getFields().get(0)).getType()), (Expression)new FieldReference((Expression)new Reference((Type)complexType, "a"), 0), (Symbol)p.symbol("expr_2"), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new FieldReference((Expression)new FieldReference((Expression)new Reference((Type)complexType, "a"), 0), 0), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))), (Object)new FieldReference((Expression)new FieldReference((Expression)new Reference((Type)complexType, "b"), 0), 0))), (Object)new FieldReference((Expression)new FieldReference((Expression)new Reference((Type)complexType, "b"), 0), 1)))), (PlanNode)p.project(Assignments.identity((Iterable)ImmutableList.of((Object)p.symbol("a", (Type)complexType), (Object)p.symbol("b", (Type)complexType))), (PlanNode)p.values(p.symbol("a", (Type)complexType), p.symbol("b", (Type)complexType))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_1", (Object)PlanMatchPattern.expression((Expression)new Reference(((RowType.Field)complexType.getFields().get(0)).getType(), "a_f1")), (Object)"expr_2", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new FieldReference((Expression)new Reference(((RowType.Field)complexType.getFields().get(0)).getType(), "a_f1"), 0), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))), (Object)new Reference((Type)BigintType.BIGINT, "b_f1_f1"))), (Object)new Reference((Type)BigintType.BIGINT, "b_f1_f2"))))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)complexType, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)complexType, "b")), (Object)"a_f1", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)complexType, "a"), 0)), (Object)"b_f1_f1", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new FieldReference((Expression)new Reference((Type)complexType, "b"), 0), 0)), (Object)"b_f1_f2", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new FieldReference((Expression)new Reference((Type)complexType, "b"), 0), 1))), PlanMatchPattern.values("a", "b"))));
    }
}

